/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.expr.ArithmeticExpression;
import com.icl.saxon.expr.BooleanExpression;
import com.icl.saxon.expr.BooleanValue;
import com.icl.saxon.expr.ContextNodeExpression;
import com.icl.saxon.expr.ErrorExpression;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.FilterExpression;
import com.icl.saxon.expr.Function;
import com.icl.saxon.expr.FunctionProxy;
import com.icl.saxon.expr.NumericValue;
import com.icl.saxon.expr.ParentNodeExpression;
import com.icl.saxon.expr.PathExpression;
import com.icl.saxon.expr.RelationalExpression;
import com.icl.saxon.expr.RootExpression;
import com.icl.saxon.expr.StaticContext;
import com.icl.saxon.expr.Step;
import com.icl.saxon.expr.StringValue;
import com.icl.saxon.expr.Tokenizer;
import com.icl.saxon.expr.UnionExpression;
import com.icl.saxon.expr.VariableReference;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.functions.BooleanFn;
import com.icl.saxon.functions.Ceiling;
import com.icl.saxon.functions.Concat;
import com.icl.saxon.functions.Contains;
import com.icl.saxon.functions.Count;
import com.icl.saxon.functions.Current;
import com.icl.saxon.functions.Document;
import com.icl.saxon.functions.ElementAvailable;
import com.icl.saxon.functions.Floor;
import com.icl.saxon.functions.FormatNumber;
import com.icl.saxon.functions.FunctionAvailable;
import com.icl.saxon.functions.GenerateId;
import com.icl.saxon.functions.Id;
import com.icl.saxon.functions.Key;
import com.icl.saxon.functions.Lang;
import com.icl.saxon.functions.Last;
import com.icl.saxon.functions.LocalName;
import com.icl.saxon.functions.NameFn;
import com.icl.saxon.functions.NamespaceURI;
import com.icl.saxon.functions.NormalizeSpace;
import com.icl.saxon.functions.Not;
import com.icl.saxon.functions.NumberFn;
import com.icl.saxon.functions.Position;
import com.icl.saxon.functions.Round;
import com.icl.saxon.functions.StartsWith;
import com.icl.saxon.functions.StringFn;
import com.icl.saxon.functions.StringLength;
import com.icl.saxon.functions.Substring;
import com.icl.saxon.functions.SubstringAfter;
import com.icl.saxon.functions.SubstringBefore;
import com.icl.saxon.functions.Sum;
import com.icl.saxon.functions.SystemProperty;
import com.icl.saxon.functions.Translate;
import com.icl.saxon.functions.UnparsedEntityURI;
import com.icl.saxon.om.Axis;
import com.icl.saxon.om.Name;
import com.icl.saxon.pattern.AnyChildNodePattern;
import com.icl.saxon.pattern.AnyNodeTest;
import com.icl.saxon.pattern.IDPattern;
import com.icl.saxon.pattern.KeyPattern;
import com.icl.saxon.pattern.LocationPathPattern;
import com.icl.saxon.pattern.NamespaceTest;
import com.icl.saxon.pattern.NoNodeTest;
import com.icl.saxon.pattern.NodeTest;
import com.icl.saxon.pattern.NodeTypeTest;
import com.icl.saxon.pattern.Pattern;
import com.icl.saxon.pattern.UnionPattern;
import javax.xml.transform.TransformerException;

public final class ExpressionParser {
    private Tokenizer t;
    private StaticContext env;
    private static final int CHILD_AXIS = 0;
    private static final int ATTRIBUTE_AXIS = 1;

    private void expect(int n2) throws XPathException {
        if (this.t.currentToken != n2) {
            this.grumble("expected \"" + Tokenizer.tokens[n2] + "\"" + ", found \"" + Tokenizer.tokens[this.t.currentToken] + "\"");
        }
    }

    private void grumble(String string) throws XPathException {
        throw new XPathException("Error in expression " + this.t.pattern + ": " + string);
    }

    public Expression parse(String string, StaticContext staticContext) throws XPathException {
        this.env = staticContext;
        this.t = new Tokenizer();
        this.t.tokenize(string);
        Expression expression = this.parseExpression();
        if (this.t.currentToken != 0) {
            this.grumble("Unexpected token " + Tokenizer.tokens[this.t.currentToken] + " beyond end of expression");
        }
        expression.setStaticContext(staticContext);
        return expression;
    }

    public Pattern parsePattern(String string, StaticContext staticContext) throws XPathException {
        this.env = staticContext;
        this.t = new Tokenizer();
        this.t.tokenize(string);
        Pattern pattern = this.parseUnionPattern();
        if (this.t.currentToken != 0) {
            this.grumble("Unexpected token " + Tokenizer.tokens[this.t.currentToken] + " beyond end of pattern");
        }
        pattern.setStaticContext(staticContext);
        return pattern;
    }

    private Expression parseExpression() throws XPathException {
        Expression expression = this.parseAndExpression();
        while (this.t.currentToken == 18) {
            this.t.next();
            expression = new BooleanExpression(expression, 18, this.parseAndExpression());
            expression.setStaticContext(this.env);
        }
        return expression;
    }

    private Expression parseAndExpression() throws XPathException {
        Expression expression = this.parseEqualityExpression();
        while (this.t.currentToken == 19) {
            this.t.next();
            expression = new BooleanExpression(expression, 19, this.parseEqualityExpression());
            expression.setStaticContext(this.env);
        }
        return expression;
    }

    private Expression parseEqualityExpression() throws XPathException {
        Expression expression = this.parseRelationalExpression();
        while (this.t.currentToken == 11 || this.t.currentToken == 34) {
            int n2 = this.t.currentToken;
            this.t.next();
            expression = new RelationalExpression(expression, n2, this.parseRelationalExpression());
            expression.setStaticContext(this.env);
        }
        return expression;
    }

    private Expression parseRelationalExpression() throws XPathException {
        Expression expression = this.parseAdditiveExpression();
        while (this.t.currentToken == 22 || this.t.currentToken == 21 || this.t.currentToken == 24 || this.t.currentToken == 23) {
            int n2 = this.t.currentToken;
            this.t.next();
            expression = new RelationalExpression(expression, n2, this.parseAdditiveExpression());
            expression.setStaticContext(this.env);
        }
        return expression;
    }

    private Expression parseAdditiveExpression() throws XPathException {
        Expression expression = this.parseMultiplicativeExpression();
        while (this.t.currentToken == 25 || this.t.currentToken == 26) {
            int n2 = this.t.currentToken;
            this.t.next();
            expression = new ArithmeticExpression(expression, n2, this.parseMultiplicativeExpression());
            expression.setStaticContext(this.env);
        }
        return expression;
    }

    private Expression parseMultiplicativeExpression() throws XPathException {
        Expression expression = this.parseUnaryExpression();
        while (this.t.currentToken == 27 || this.t.currentToken == 28 || this.t.currentToken == 29) {
            int n2 = this.t.currentToken;
            this.t.next();
            expression = new ArithmeticExpression(expression, n2, this.parseUnaryExpression());
            expression.setStaticContext(this.env);
        }
        return expression;
    }

    private Expression parseUnaryExpression() throws XPathException {
        Expression expression;
        if (this.t.currentToken == 26) {
            this.t.next();
            expression = new ArithmeticExpression((Expression)new NumericValue(0.0), 99, this.parseUnaryExpression());
            expression.setStaticContext(this.env);
        } else {
            expression = this.parseUnionExpression();
        }
        return expression;
    }

    private Expression parseUnionExpression() throws XPathException {
        Expression expression = this.parsePathExpression();
        while (this.t.currentToken == 4) {
            this.t.next();
            expression = new UnionExpression(expression, this.parsePathExpression());
            expression.setStaticContext(this.env);
        }
        return expression;
    }

    private Expression parsePathExpression() throws XPathException {
        switch (this.t.currentToken) {
            case 5: {
                this.t.next();
                switch (this.t.currentToken) {
                    case 1: 
                    case 6: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 17: 
                    case 32: 
                    case 33: {
                        return this.parseRelativePath((Expression)new RootExpression());
                    }
                }
                return new RootExpression();
            }
            case 16: {
                return this.parsePathContinuation((Expression)new RootExpression());
            }
            case 12: {
                this.t.next();
                return this.parsePathContinuation((Expression)new ContextNodeExpression());
            }
            case 13: {
                this.t.next();
                return this.parsePathContinuation((Expression)new ParentNodeExpression());
            }
            case 1: 
            case 6: 
            case 14: 
            case 17: 
            case 32: 
            case 33: {
                return this.parseRelativePath((Expression)new ContextNodeExpression());
            }
        }
        Expression expression = this.parseFilterExpression();
        Expression expression2 = this.parsePathContinuation(expression);
        expression2.setStaticContext(this.env);
        return expression2;
    }

    private Expression parseFilterExpression() throws XPathException {
        Expression expression = this.parsePrimaryExpression();
        while (this.t.currentToken == 7) {
            this.t.next();
            Expression expression2 = this.parseExpression();
            this.expect(8);
            expression = new FilterExpression(expression, expression2);
            expression.setStaticContext(this.env);
            this.t.next();
        }
        return expression;
    }

    private Expression parsePrimaryExpression() throws XPathException {
        switch (this.t.currentToken) {
            case 31: {
                this.t.next();
                this.expect(1);
                String string = this.t.currentTokenValue;
                this.t.next();
                int n2 = this.env.makeNameCode(string, false) & 0xFFFFF;
                return new VariableReference(n2, this.env);
            }
            case 9: {
                this.t.next();
                Expression expression = this.parseExpression();
                this.expect(10);
                this.t.next();
                return expression;
            }
            case 3: {
                StringValue stringValue = new StringValue(this.t.currentTokenValue);
                this.t.next();
                return stringValue;
            }
            case 20: {
                NumericValue numericValue = new NumericValue(this.t.currentTokenValue);
                this.t.next();
                return numericValue;
            }
            case 2: {
                return this.parseFunctionCall();
            }
        }
        this.grumble("Unexpected token " + Tokenizer.tokens[this.t.currentToken] + " in expression");
        return null;
    }

    private Expression parsePathContinuation(Expression expression) throws XPathException {
        switch (this.t.currentToken) {
            case 5: {
                this.t.next();
                return this.parseRelativePath(expression);
            }
            case 16: {
                PathExpression pathExpression = new PathExpression(expression, new Step(5, (NodeTest)AnyNodeTest.getInstance()));
                pathExpression.setStaticContext(this.env);
                this.t.next();
                return this.parseRelativePath((Expression)pathExpression);
            }
        }
        return expression;
    }

    private Expression parseRelativePath(Expression expression) throws XPathException {
        Step step = this.parseStep();
        PathExpression pathExpression = new PathExpression(expression, step);
        pathExpression.setStaticContext(this.env);
        return this.parsePathContinuation((Expression)pathExpression);
    }

    private Step parseStep() throws XPathException {
        Step step = null;
        switch (this.t.currentToken) {
            case 12: {
                step = new Step(12, (NodeTest)AnyNodeTest.getInstance());
                this.t.next();
                break;
            }
            case 13: {
                step = new Step(9, (NodeTest)AnyNodeTest.getInstance());
                this.t.next();
                break;
            }
            case 1: {
                step = new Step(3, (NodeTest)this.env.makeNameTest((short)1, this.t.currentTokenValue, false));
                this.t.next();
                while (this.t.currentToken == 7) {
                    step = this.parseStepPredicate(step);
                }
                break;
            }
            case 17: {
                NamespaceTest namespaceTest = this.env.makeNamespaceTest((short)1, this.t.currentTokenValue);
                step = new Step(3, (NodeTest)namespaceTest);
                this.t.next();
                while (this.t.currentToken == 7) {
                    step = this.parseStepPredicate(step);
                }
                break;
            }
            case 14: {
                step = new Step(3, (NodeTest)new NodeTypeTest(1));
                this.t.next();
                while (this.t.currentToken == 7) {
                    step = this.parseStepPredicate(step);
                }
                break;
            }
            case 6: {
                this.t.next();
                switch (this.t.currentToken) {
                    case 1: {
                        step = new Step(2, (NodeTest)this.env.makeNameTest((short)2, this.t.currentTokenValue, false));
                        this.t.next();
                        break;
                    }
                    case 17: {
                        NamespaceTest namespaceTest = this.env.makeNamespaceTest((short)2, this.t.currentTokenValue);
                        step = new Step(2, (NodeTest)namespaceTest);
                        this.t.next();
                        break;
                    }
                    case 14: {
                        step = new Step(2, (NodeTest)AnyNodeTest.getInstance());
                        this.t.next();
                        break;
                    }
                    case 32: {
                        String string = this.t.currentTokenValue;
                        this.t.next();
                        if (string == "text") {
                            step = new Step(2, (NodeTest)NoNodeTest.getInstance());
                        } else if (string == "node") {
                            step = new Step(2, (NodeTest)AnyNodeTest.getInstance());
                        } else if (string == "comment") {
                            step = new Step(2, (NodeTest)NoNodeTest.getInstance());
                        } else if (string == "processing-instruction") {
                            if (this.t.currentToken == 3) {
                                this.t.next();
                            }
                            step = new Step(2, (NodeTest)NoNodeTest.getInstance());
                        }
                        this.expect(10);
                        this.t.next();
                        break;
                    }
                    default: {
                        this.grumble("@ must be followed by a NameTest or NodeTest");
                    }
                }
                while (this.t.currentToken == 7) {
                    step = this.parseStepPredicate(step);
                }
                break;
            }
            case 32: {
                String string = this.t.currentTokenValue;
                this.t.next();
                if (string == "text") {
                    step = new Step(3, (NodeTest)new NodeTypeTest(3));
                } else if (string == "node") {
                    step = new Step(3, (NodeTest)AnyNodeTest.getInstance());
                } else if (string == "comment") {
                    step = new Step(3, (NodeTest)new NodeTypeTest(8));
                } else if (string == "processing-instruction") {
                    if (this.t.currentToken == 3) {
                        step = Name.isNCName((String)this.t.currentTokenValue) ? new Step(3, (NodeTest)this.env.makeNameTest((short)7, this.t.currentTokenValue, false)) : new Step(3, (NodeTest)NoNodeTest.getInstance());
                        this.t.next();
                    } else {
                        step = new Step(3, (NodeTest)new NodeTypeTest(7));
                    }
                }
                this.expect(10);
                this.t.next();
                while (this.t.currentToken == 7) {
                    step = this.parseStepPredicate(step);
                }
                break;
            }
            case 33: {
                byte by = Axis.getAxisNumber((String)this.t.currentTokenValue);
                short s2 = Axis.principalNodeType[by];
                this.t.next();
                switch (this.t.currentToken) {
                    case 1: {
                        step = new Step(by, (NodeTest)this.env.makeNameTest(s2, this.t.currentTokenValue, false));
                        this.t.next();
                        break;
                    }
                    case 17: {
                        NamespaceTest namespaceTest = this.env.makeNamespaceTest(s2, this.t.currentTokenValue);
                        step = new Step(by, (NodeTest)namespaceTest);
                        this.t.next();
                        break;
                    }
                    case 14: {
                        step = new Step(by, (NodeTest)new NodeTypeTest(s2));
                        this.t.next();
                        break;
                    }
                    case 32: {
                        String string = this.t.currentTokenValue;
                        this.t.next();
                        if (string == "node") {
                            step = new Step(by, (NodeTest)AnyNodeTest.getInstance());
                        } else if (string == "text") {
                            step = new Step(by, (NodeTest)new NodeTypeTest(3));
                        } else if (string == "comment") {
                            step = new Step(by, (NodeTest)new NodeTypeTest(8));
                        } else if (string == "processing-instruction") {
                            if (this.t.currentToken == 3) {
                                step = Name.isNCName((String)this.t.currentTokenValue) ? new Step(by, (NodeTest)this.env.makeNameTest((short)7, this.t.currentTokenValue, false)) : new Step(by, (NodeTest)NoNodeTest.getInstance());
                                this.t.next();
                            } else {
                                step = new Step(by, (NodeTest)new NodeTypeTest(7));
                            }
                        } else {
                            this.grumble("Unsupported node type");
                        }
                        this.expect(10);
                        this.t.next();
                        break;
                    }
                    default: {
                        this.grumble("Unexpected token [" + Tokenizer.tokens[this.t.currentToken] + "] after axis name");
                    }
                }
                while (this.t.currentToken == 7) {
                    step = this.parseStepPredicate(step);
                }
                break;
            }
            default: {
                this.grumble("Unexpected token [" + Tokenizer.tokens[this.t.currentToken] + "] in path expression");
            }
        }
        return step;
    }

    private Step parseStepPredicate(Step step) throws XPathException {
        this.t.next();
        Expression expression = this.parseExpression();
        this.expect(8);
        this.t.next();
        return step.addFilter(expression);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Expression parseFunctionCall() throws XPathException {
        String string = this.t.currentTokenValue;
        Function function = null;
        int n2 = string.indexOf(":");
        if (n2 < 0) {
            Expression expression = ExpressionParser.makeSystemFunction(string);
            if (expression == null) {
                this.grumble("Unknown system function: " + string);
            }
            expression.setStaticContext(this.env);
            if (!(expression instanceof Function)) {
                this.t.next();
                this.expect(10);
                this.t.next();
                return expression;
            }
            function = (Function)expression;
        } else {
            function = this.env.getStyleSheetFunction(this.env.makeNameCode(string, false) & 0xFFFFF);
        }
        if (function == null) {
            function = new FunctionProxy();
        }
        function.setStaticContext(this.env);
        this.t.next();
        if (this.t.currentToken != 10) {
            Expression expression = this.parseExpression();
            function.addArgument(expression);
            while (this.t.currentToken == 15) {
                this.t.next();
                Expression expression2 = this.parseExpression();
                function.addArgument(expression2);
            }
            this.expect(10);
        }
        this.t.next();
        if (function instanceof FunctionProxy) {
            String string2 = this.env.getURIForPrefix(string.substring(0, n2));
            String string3 = string.substring(n2 + 1);
            Class clazz = null;
            try {
                clazz = this.env.getExternalJavaClass(string2);
            }
            catch (TransformerException transformerException) {
                XPathException xPathException = new XPathException("Failed to load external Java class for uri " + string2);
                return new ErrorExpression(xPathException);
            }
            if (clazz == null) {
                XPathException xPathException = new XPathException("The URI " + string2 + " does not identify an external Java class");
                return new ErrorExpression(xPathException);
            }
            ((FunctionProxy)function).setFunctionName(clazz, string3);
        }
        return function;
    }

    public static Expression makeSystemFunction(String string) {
        if (string == "last") {
            return new Last();
        }
        if (string == "position") {
            return new Position();
        }
        if (string == "count") {
            return new Count();
        }
        if (string == "current") {
            return new Current();
        }
        if (string == "id") {
            return new Id();
        }
        if (string == "key") {
            return new Key();
        }
        if (string == "document") {
            return new Document();
        }
        if (string == "local-name") {
            return new LocalName();
        }
        if (string == "namespace-uri") {
            return new NamespaceURI();
        }
        if (string == "name") {
            return new NameFn();
        }
        if (string == "generate-id") {
            return new GenerateId();
        }
        if (string == "not") {
            return new Not();
        }
        if (string == "true") {
            return new BooleanValue(true);
        }
        if (string == "false") {
            return new BooleanValue(false);
        }
        if (string == "boolean") {
            return new BooleanFn();
        }
        if (string == "lang") {
            return new Lang();
        }
        if (string == "number") {
            return new NumberFn();
        }
        if (string == "floor") {
            return new Floor();
        }
        if (string == "ceiling") {
            return new Ceiling();
        }
        if (string == "round") {
            return new Round();
        }
        if (string == "sum") {
            return new Sum();
        }
        if (string == "string") {
            return new StringFn();
        }
        if (string == "starts-with") {
            return new StartsWith();
        }
        if (string == "string-length") {
            return new StringLength();
        }
        if (string == "substring") {
            return new Substring();
        }
        if (string == "contains") {
            return new Contains();
        }
        if (string == "substring-before") {
            return new SubstringBefore();
        }
        if (string == "substring-after") {
            return new SubstringAfter();
        }
        if (string == "normalize-space") {
            return new NormalizeSpace();
        }
        if (string == "translate") {
            return new Translate();
        }
        if (string == "concat") {
            return new Concat();
        }
        if (string == "format-number") {
            return new FormatNumber();
        }
        if (string == "system-property") {
            return new SystemProperty();
        }
        if (string == "function-available") {
            return new FunctionAvailable();
        }
        if (string == "element-available") {
            return new ElementAvailable();
        }
        if (string == "unparsed-entity-uri") {
            return new UnparsedEntityURI();
        }
        return null;
    }

    private Pattern parseUnionPattern() throws XPathException {
        Pattern pattern = this.parsePathPattern();
        while (this.t.currentToken == 4) {
            this.t.next();
            Pattern pattern2 = this.parsePathPattern();
            pattern = new UnionPattern(pattern, pattern2);
            pattern.setStaticContext(this.env);
            pattern2.setStaticContext(this.env);
        }
        return pattern;
    }

    private Pattern parsePathPattern() throws XPathException {
        LocationPathPattern locationPathPattern = new LocationPathPattern();
        locationPathPattern.setStaticContext(this.env);
        Pattern pattern = locationPathPattern;
        Object object = null;
        int n2 = -1;
        boolean bl = false;
        switch (this.t.currentToken) {
            case 5: {
                n2 = this.t.currentToken;
                this.t.next();
                object = new NodeTypeTest(9);
                bl = true;
                break;
            }
            case 16: {
                n2 = this.t.currentToken;
                this.t.next();
                object = new NodeTypeTest(9);
                bl = false;
                break;
            }
        }
        boolean bl2 = true;
        while (bl2) {
            switch (this.t.currentToken) {
                case 33: {
                    if (this.t.currentTokenValue.equals("child")) {
                        this.t.next();
                        pattern = this.patternStep(0, locationPathPattern, (Pattern)object, n2);
                        break;
                    }
                    if (this.t.currentTokenValue.equals("attribute")) {
                        this.t.next();
                        pattern = this.patternStep(1, locationPathPattern, (Pattern)object, n2);
                        break;
                    }
                    this.grumble("Axis in pattern must be child or attribute");
                    break;
                }
                case 1: 
                case 14: 
                case 17: 
                case 32: {
                    pattern = this.patternStep(0, locationPathPattern, (Pattern)object, n2);
                    break;
                }
                case 6: {
                    this.t.next();
                    pattern = this.patternStep(1, locationPathPattern, (Pattern)object, n2);
                    break;
                }
                case 2: {
                    if (object != null) {
                        this.grumble("Function may appear only at the start of a pattern");
                    }
                    if (this.t.currentTokenValue.equals("id")) {
                        this.t.next();
                        this.expect(3);
                        pattern = new IDPattern(this.t.currentTokenValue);
                        pattern.setStaticContext(this.env);
                        this.t.next();
                        this.expect(10);
                        this.t.next();
                        break;
                    }
                    if (this.t.currentTokenValue.equals("key")) {
                        this.t.next();
                        this.expect(3);
                        String string = this.t.currentTokenValue;
                        this.t.next();
                        this.expect(15);
                        this.t.next();
                        this.expect(3);
                        if (!this.env.allowsKeyFunction()) {
                            this.grumble("key() function cannot be used here");
                        }
                        pattern = new KeyPattern(this.env.makeNameCode(string, false), this.t.currentTokenValue);
                        pattern.setStaticContext(this.env);
                        this.t.next();
                        this.expect(10);
                        this.t.next();
                        break;
                    }
                    this.grumble("The only functions allowed in a pattern are id() and key()");
                    break;
                }
                default: {
                    if (bl) {
                        return object;
                    }
                    this.grumble("Unexpected token in pattern, found " + Tokenizer.tokens[this.t.currentToken]);
                }
            }
            n2 = this.t.currentToken;
            bl = false;
            bl2 = n2 == 5 || n2 == 16;
            if (!bl2) continue;
            object = pattern;
            locationPathPattern = new LocationPathPattern();
            locationPathPattern.setStaticContext(this.env);
            if (n2 == 5) {
                locationPathPattern.parentPattern = object;
            } else {
                locationPathPattern.ancestorPattern = object;
            }
            this.t.next();
        }
        pattern.setStaticContext(this.env);
        return pattern;
    }

    private Pattern patternStep(int n2, LocationPathPattern locationPathPattern, Pattern pattern, int n3) throws XPathException {
        if (n2 == 0) {
            if (this.t.currentToken == 14) {
                locationPathPattern.nodeTest = new NodeTypeTest(1);
            } else if (this.t.currentToken == 1) {
                locationPathPattern.nodeTest = this.env.makeNameTest((short)1, this.t.currentTokenValue, false);
            } else if (this.t.currentToken == 17) {
                locationPathPattern.nodeTest = this.env.makeNamespaceTest((short)1, this.t.currentTokenValue);
            } else if (this.t.currentToken == 32) {
                String string = this.t.currentTokenValue;
                this.t.next();
                if (string == "text") {
                    locationPathPattern.nodeTest = new NodeTypeTest(3);
                } else if (string == "node") {
                    locationPathPattern.nodeTest = new AnyChildNodePattern();
                } else if (string == "comment") {
                    locationPathPattern.nodeTest = new NodeTypeTest(8);
                } else if (string == "processing-instruction") {
                    if (this.t.currentToken == 3) {
                        locationPathPattern.nodeTest = Name.isNCName((String)this.t.currentTokenValue) ? this.env.makeNameTest((short)7, this.t.currentTokenValue, false) : NoNodeTest.getInstance();
                        this.t.next();
                    } else {
                        locationPathPattern.nodeTest = new NodeTypeTest(7);
                    }
                }
                this.expect(10);
            } else {
                this.grumble("Unexpected token in pattern, found " + Tokenizer.tokens[this.t.currentToken]);
            }
            if (pattern != null) {
                if (n3 == 5) {
                    locationPathPattern.parentPattern = pattern;
                } else {
                    locationPathPattern.ancestorPattern = pattern;
                }
            }
            this.t.next();
            this.parseFilters(locationPathPattern);
            return locationPathPattern;
        }
        if (n2 == 1) {
            if (this.t.currentToken == 14) {
                locationPathPattern.nodeTest = new NodeTypeTest(2);
            } else if (this.t.currentToken == 1) {
                locationPathPattern.nodeTest = this.env.makeNameTest((short)2, this.t.currentTokenValue, false);
            } else if (this.t.currentToken == 17) {
                locationPathPattern.nodeTest = this.env.makeNamespaceTest((short)2, this.t.currentTokenValue);
            } else if (this.t.currentToken == 32) {
                String string = this.t.currentTokenValue;
                this.t.next();
                if (string == "text") {
                    locationPathPattern.nodeTest = NoNodeTest.getInstance();
                } else if (string == "node") {
                    locationPathPattern.nodeTest = new NodeTypeTest(2);
                } else if (string == "comment") {
                    locationPathPattern.nodeTest = NoNodeTest.getInstance();
                } else if (string == "processing-instruction") {
                    locationPathPattern.nodeTest = NoNodeTest.getInstance();
                    if (this.t.currentToken == 3) {
                        this.t.next();
                    }
                }
                this.expect(10);
            } else {
                this.grumble("@ in pattern not followed by NameTest or NodeTest");
            }
            this.t.next();
            this.parseFilters(locationPathPattern);
            return locationPathPattern;
        }
        this.grumble("Axis in pattern must be child or attribute");
        return null;
    }

    private void parseFilters(LocationPathPattern locationPathPattern) throws XPathException {
        while (this.t.currentToken == 7) {
            this.t.next();
            Expression expression = this.parseExpression();
            this.expect(8);
            this.t.next();
            locationPathPattern.addFilter(expression);
        }
    }

    public void checkPatternFiltersUsesCurrent(Pattern pattern) throws XPathException {
        if (pattern instanceof UnionPattern) {
            UnionPattern unionPattern = (UnionPattern)pattern;
            this.checkPatternFiltersUsesCurrent(unionPattern.getLHS());
            this.checkPatternFiltersUsesCurrent(unionPattern.getRHS());
        } else if (pattern instanceof LocationPathPattern) {
            LocationPathPattern locationPathPattern = (LocationPathPattern)pattern;
            Expression[] expressionArray = locationPathPattern.getFilters();
            int n2 = locationPathPattern.getNumberOfFilters();
            if (n2 > 0 && expressionArray != null && n2 <= expressionArray.length) {
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (expressionArray[i2] == null || !expressionArray[i2].usesCurrent()) continue;
                    this.grumble("The current() function may not be used in a pattern");
                }
            }
        }
    }
}

