/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.output;

import com.icl.saxon.charcode.CharacterSetFactory;
import com.icl.saxon.charcode.PluggableCharacterSet;
import com.icl.saxon.charcode.UnicodeCharacterSet;
import com.icl.saxon.om.DocumentInfo;
import com.icl.saxon.om.NamePool;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.output.CDATAFilter;
import com.icl.saxon.output.ContentHandlerProxy;
import com.icl.saxon.output.DOMEmitter;
import com.icl.saxon.output.Emitter;
import com.icl.saxon.output.HTMLEmitter;
import com.icl.saxon.output.HTMLIndenter;
import com.icl.saxon.output.NamespaceEmitter;
import com.icl.saxon.output.Outputter;
import com.icl.saxon.output.TEXTEmitter;
import com.icl.saxon.output.UncommittedEmitter;
import com.icl.saxon.output.XHTMLEmitter;
import com.icl.saxon.output.XMLEmitter;
import com.icl.saxon.output.XMLIndenter;
import com.icl.saxon.tinytree.TinyBuilder;
import com.icl.saxon.tree.AttributeCollection;
import com.icl.saxon.tree.DocumentImpl;
import com.icl.saxon.tree.TreeBuilder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import ro.sync.util.URLUtil;

public class GeneralOutputterSaxon
extends Outputter {
    private NamePool namePool;
    private Properties outputProperties;
    private Writer writer;
    private OutputStream outputStream;
    private boolean closeAfterUse = false;
    private int pendingStartTag = -1;
    private AttributeCollection pendingAttList;
    private int[] pendingNSList = new int[20];
    private int pendingNSListSize = 0;
    private boolean suppressAttributes = false;
    char[] charbuffer = new char[1024];

    public GeneralOutputterSaxon(NamePool namePool) {
        this.namePool = namePool;
        this.pendingAttList = new AttributeCollection(this.namePool, 10);
    }

    public void setOutputDestination(Properties properties, Result result) throws TransformerException {
        this.setOutputProperties(properties);
        Emitter emitter = this.makeEmitter(properties, result);
        emitter.setNamePool(this.namePool);
        emitter.setOutputProperties(properties);
        this.setEmitter(emitter);
        this.open();
    }

    public static String urlToFileName(String string) {
        if (null != string) {
            if (string.startsWith("file:////")) {
                string = string.substring(7);
            } else if (string.startsWith("file:///")) {
                string = string.substring(6);
            } else if (string.startsWith("file://")) {
                string = string.substring(5);
            } else if (string.startsWith("file:/")) {
                string = string.substring(5);
            } else if (string.startsWith("file:")) {
                string = string.substring(4);
            }
            if (string.startsWith("file:\\\\\\\\")) {
                string = string.substring(7);
            } else if (string.startsWith("file:\\\\\\")) {
                string = string.substring(6);
            } else if (string.startsWith("file:\\\\")) {
                string = string.substring(5);
            } else if (string.startsWith("file:\\")) {
                string = string.substring(5);
            }
        }
        if (string != null) {
            if (File.separatorChar != '/') {
                string = string.replace('/', File.separatorChar);
            }
            string = URLUtil.uncorrect(string);
        }
        return string;
    }

    public static FileOutputStream makeFileOutputStream(String string, String string2, boolean bl) throws TransformerException {
        try {
            File file;
            Object object;
            File file2 = new File(string2);
            if (!file2.isAbsolute() && null != (object = GeneralOutputterSaxon.urlToFileName(string))) {
                file = new File((String)object);
                file2 = new File(file.getParent(), string2);
            }
            if (bl && null != (object = file2.getParent()) && ((String)object).length() > 0) {
                file = new File((String)object);
                file.mkdirs();
            }
            object = new FileOutputStream(file2);
            return object;
        }
        catch (Exception exception) {
            throw new TransformerException("Failed to create output file", exception);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Emitter makeEmitter(Properties properties, Result result) throws TransformerException {
        void var3_40;
        Object object;
        if (result instanceof DOMResult) {
            object = ((DOMResult)result).getNode();
            if (object != null) {
                if (object instanceof NodeInfo) {
                    void var6_12;
                    if (!(object instanceof DocumentInfo)) throw new TransformerException("Cannot add to an existing Saxon document");
                    DocumentInfo documentInfo = (DocumentInfo)object;
                    if (object.getFirstChild() != null) {
                        throw new TransformerException("Target document must be empty");
                    }
                    if (documentInfo instanceof DocumentImpl) {
                        TreeBuilder treeBuilder = new TreeBuilder();
                    } else {
                        TinyBuilder tinyBuilder = new TinyBuilder();
                    }
                    var6_12.setRootNode(documentInfo);
                    var6_12.setSystemId(result.getSystemId());
                    var6_12.setNamePool(this.namePool);
                    void var3_17 = var6_12;
                } else {
                    DOMEmitter dOMEmitter = new DOMEmitter();
                    dOMEmitter.setNode((Node)object);
                }
            } else {
                TinyBuilder tinyBuilder = new TinyBuilder();
                tinyBuilder.setSystemId(result.getSystemId());
                tinyBuilder.setNamePool(this.namePool);
                tinyBuilder.createDocument();
                Document document = (Document)tinyBuilder.getCurrentDocument();
                ((DOMResult)result).setNode(document);
                TinyBuilder tinyBuilder2 = tinyBuilder;
            }
        } else if (result instanceof SAXResult) {
            object = (SAXResult)result;
            ContentHandlerProxy contentHandlerProxy = new ContentHandlerProxy();
            contentHandlerProxy.setUnderlyingContentHandler(((SAXResult)object).getHandler());
            if (((SAXResult)object).getLexicalHandler() != null) {
                contentHandlerProxy.setLexicalHandler(((SAXResult)object).getLexicalHandler());
            }
            ContentHandlerProxy contentHandlerProxy2 = contentHandlerProxy;
        } else if (result instanceof Emitter) {
            Emitter emitter = (Emitter)result;
        } else {
            void var3_39;
            if (!(result instanceof StreamResult)) throw new IllegalArgumentException("Unknown type of Result: " + result.getClass());
            object = properties.getProperty("method");
            if (object == null) {
                UncommittedEmitter uncommittedEmitter = new UncommittedEmitter();
            } else if (((String)object).equals("html")) {
                HTMLEmitter hTMLEmitter = new HTMLEmitter();
                if (!"no".equals(properties.getProperty("indent"))) {
                    HTMLIndenter hTMLIndenter = new HTMLIndenter();
                    hTMLIndenter.setUnderlyingEmitter((Emitter)hTMLEmitter);
                    HTMLIndenter hTMLIndenter2 = hTMLIndenter;
                }
            } else if (((String)object).equals("xml")) {
                Object object2;
                XMLEmitter xMLEmitter = new XMLEmitter();
                if ("yes".equals(properties.getProperty("indent"))) {
                    object2 = new XMLIndenter();
                    object2.setUnderlyingEmitter((Emitter)xMLEmitter);
                    Object object3 = object2;
                }
                if ((object2 = properties.getProperty("cdata-section-elements")) != null && ((String)object2).length() > 0) {
                    void var3_28;
                    CDATAFilter cDATAFilter = new CDATAFilter();
                    cDATAFilter.setUnderlyingEmitter((Emitter)var3_28);
                    CDATAFilter cDATAFilter2 = cDATAFilter;
                }
            } else if (((String)object).equals("text")) {
                TEXTEmitter tEXTEmitter = new TEXTEmitter();
            } else {
                int n2;
                int n3 = ((String)object).indexOf(125);
                String string2 = ((String)object).substring(n3 + 1);
                string2 = string2.substring((n2 = string2.indexOf(58)) + 1);
                if (string2.equals("fop")) {
                    Emitter emitter = Emitter.makeEmitter((String)"com.icl.saxon.fop.FOPEmitter");
                } else if (string2.equals("xhtml")) {
                    Object object4;
                    XHTMLEmitter xHTMLEmitter = new XHTMLEmitter();
                    if ("yes".equals(properties.getProperty("indent"))) {
                        object4 = new HTMLIndenter();
                        object4.setUnderlyingEmitter((Emitter)xHTMLEmitter);
                        Object object5 = object4;
                    }
                    if ((object4 = properties.getProperty("cdata-section-elements")) != null && ((String)object4).length() > 0) {
                        void var3_35;
                        CDATAFilter cDATAFilter = new CDATAFilter();
                        cDATAFilter.setUnderlyingEmitter((Emitter)var3_35);
                        CDATAFilter cDATAFilter3 = cDATAFilter;
                    }
                } else {
                    Emitter emitter = Emitter.makeEmitter((String)string2);
                }
            }
            if (var3_39.usesWriter()) {
                this.writer = this.getStreamWriter((StreamResult)result, properties);
                var3_39.setWriter(this.writer);
            } else {
                this.outputStream = this.getOutputStream((StreamResult)result, properties);
                var3_39.setOutputStream(this.outputStream);
            }
        }
        object = new NamespaceEmitter();
        object.setUnderlyingEmitter((Emitter)var3_40);
        return object;
    }

    private Writer getStreamWriter(StreamResult streamResult, Properties properties) throws TransformerException {
        Writer writer;
        block12: {
            this.closeAfterUse = false;
            writer = streamResult.getWriter();
            if (writer == null) {
                String string;
                OutputStream outputStream = streamResult.getOutputStream();
                if (outputStream == null) {
                    string = streamResult.getSystemId();
                    if (string == null) {
                        outputStream = System.out;
                    } else {
                        outputStream = GeneralOutputterSaxon.makeFileOutputStream("", GeneralOutputterSaxon.urlToFileName(string), true);
                        this.closeAfterUse = true;
                    }
                }
                string = CharacterSetFactory.getCharacterSet((Properties)properties);
                String string2 = properties.getProperty("encoding");
                if (string2 == null) {
                    string2 = "UTF8";
                }
                if (string2.equalsIgnoreCase("utf-8")) {
                    string2 = "UTF8";
                }
                if (string instanceof PluggableCharacterSet) {
                    string2 = ((PluggableCharacterSet)string).getEncodingName();
                }
                while (true) {
                    try {
                        writer = new BufferedWriter(new OutputStreamWriter(outputStream, string2));
                        break block12;
                    }
                    catch (Exception exception) {
                        if (string2.equalsIgnoreCase("UTF8")) {
                            throw new TransformerException("Failed to create a UTF8 output writer");
                        }
                        string2 = "UTF8";
                        string = new UnicodeCharacterSet();
                        properties.put("encoding", "utf-8");
                        continue;
                    }
                    break;
                }
            }
            if (writer instanceof OutputStreamWriter) {
                String string = ((OutputStreamWriter)writer).getEncoding();
                properties.put("encoding", string);
            }
        }
        return writer;
    }

    private OutputStream getOutputStream(StreamResult streamResult, Properties properties) throws TransformerException {
        this.closeAfterUse = false;
        OutputStream outputStream = streamResult.getOutputStream();
        if (outputStream == null) {
            String string = streamResult.getSystemId();
            if (string == null) {
                outputStream = System.out;
            } else {
                outputStream = GeneralOutputterSaxon.makeFileOutputStream("", GeneralOutputterSaxon.urlToFileName(string), true);
                this.closeAfterUse = true;
            }
        }
        if (outputStream == null) {
            throw new TransformerException("This output method requires a binary output destination");
        }
        return outputStream;
    }

    private void setEmitter(Emitter emitter) {
        this.emitter = emitter;
    }

    public void reset() throws TransformerException {
        if (this.pendingStartTag != -1) {
            this.flushStartTag();
        }
    }

    private void setOutputProperties(Properties properties) throws TransformerException {
        this.outputProperties = properties;
    }

    public Properties getOutputProperties() {
        return this.outputProperties;
    }

    public void write(String string) throws TransformerException {
        if (this.pendingStartTag != -1) {
            this.flushStartTag();
        }
        this.emitter.setEscaping(false);
        int n2 = string.length();
        if (n2 > this.charbuffer.length) {
            this.charbuffer = new char[n2];
        }
        string.getChars(0, n2, this.charbuffer, 0);
        this.emitter.characters(this.charbuffer, 0, n2);
        this.emitter.setEscaping(true);
    }

    public void writeContent(String string) throws TransformerException {
        if (string == null) {
            return;
        }
        int n2 = string.length();
        if (n2 > this.charbuffer.length) {
            this.charbuffer = new char[n2];
        }
        string.getChars(0, n2, this.charbuffer, 0);
        this.writeContent(this.charbuffer, 0, n2);
    }

    public void writeContent(char[] cArray, int n2, int n3) throws TransformerException {
        if (n3 == 0) {
            return;
        }
        if (this.pendingStartTag != -1) {
            this.flushStartTag();
        }
        this.emitter.characters(cArray, n2, n3);
    }

    public void writeContent(StringBuffer stringBuffer, int n2, int n3) throws TransformerException {
        if (n3 == 0) {
            return;
        }
        if (this.pendingStartTag != -1) {
            this.flushStartTag();
        }
        if (n3 > this.charbuffer.length) {
            this.charbuffer = new char[n3];
        }
        stringBuffer.getChars(n2, n2 + n3, this.charbuffer, 0);
        this.emitter.characters(this.charbuffer, 0, n3);
    }

    public void writeStartTag(int n2) throws TransformerException {
        if (n2 == -1) {
            this.suppressAttributes = true;
            return;
        }
        this.suppressAttributes = false;
        if (this.pendingStartTag != -1) {
            this.flushStartTag();
        }
        this.pendingAttList.clear();
        this.pendingNSListSize = 0;
        this.pendingStartTag = n2;
    }

    public int checkAttributePrefix(int n2) throws TransformerException {
        int n3 = this.namePool.allocateNamespaceCode(n2);
        for (int i2 = 0; i2 < this.pendingNSListSize; ++i2) {
            if (n3 >> 16 != this.pendingNSList[i2] >> 16) continue;
            if ((n3 & 0xFFFF) == (this.pendingNSList[i2] & 0xFFFF)) {
                return n2;
            }
            String string = this.getSubstitutePrefix(n3);
            int n4 = this.namePool.allocate(string, this.namePool.getURI(n2), this.namePool.getLocalName(n2));
            this.writeNamespaceDeclaration(this.namePool.allocateNamespaceCode(n4));
            return n4;
        }
        this.writeNamespaceDeclaration(n3);
        return n2;
    }

    public void writeNamespaceDeclaration(int n2) throws TransformerException {
        if (this.suppressAttributes) {
            return;
        }
        if (this.pendingStartTag == -1) {
            throw new TransformerException("Cannot write a namespace declaration when there is no open start tag");
        }
        for (int i2 = 0; i2 < this.pendingNSListSize; ++i2) {
            if (n2 >> 16 != this.pendingNSList[i2] >> 16) continue;
            return;
        }
        if (this.pendingNSListSize + 1 > this.pendingNSList.length) {
            int[] nArray = new int[this.pendingNSListSize * 2];
            System.arraycopy(this.pendingNSList, 0, nArray, 0, this.pendingNSListSize);
            this.pendingNSList = nArray;
        }
        this.pendingNSList[this.pendingNSListSize++] = n2;
    }

    public void copyNamespaceNode(int n2) throws TransformerException {
        if (this.pendingStartTag == -1) {
            throw new TransformerException("Cannot copy a namespace node when there is no containing element node");
        }
        if (this.pendingAttList.getLength() > 0) {
            throw new TransformerException("Cannot copy a namespace node to an element after attributes have been added");
        }
        for (int i2 = 0; i2 < this.pendingNSListSize; ++i2) {
            if (n2 >> 16 != this.pendingNSList[i2] >> 16) continue;
            if (n2 == this.pendingNSList[i2]) {
                return;
            }
            throw new TransformerException("Cannot create two namespace nodes with the same name");
        }
        this.writeNamespaceDeclaration(n2);
    }

    private String getSubstitutePrefix(int n2) {
        String string = this.namePool.getPrefixFromNamespaceCode(n2);
        return string + "." + (n2 & 0xFFFF);
    }

    public boolean thereIsAnOpenStartTag() {
        return this.pendingStartTag != -1;
    }

    public void writeAttribute(int n2, String string) throws TransformerException {
        this.writeAttribute(n2, string, false);
    }

    public void writeAttribute(int n2, String string, boolean bl) throws TransformerException {
        if (this.suppressAttributes) {
            return;
        }
        if (this.pendingStartTag == -1) {
            throw new TransformerException("Cannot write an attribute when there is no open start tag");
        }
        this.pendingAttList.setAttribute(n2, bl ? "NO-ESC" : "CDATA", string);
    }

    public void writeEndTag(int n2) throws TransformerException {
        if (this.pendingStartTag != -1) {
            this.flushStartTag();
        }
        this.emitter.endElement(n2);
    }

    public void writeComment(String string) throws TransformerException {
        if (this.pendingStartTag != -1) {
            this.flushStartTag();
        }
        this.emitter.comment(string.toCharArray(), 0, string.length());
    }

    public void writePI(String string, String string2) throws TransformerException {
        if (this.pendingStartTag != -1) {
            this.flushStartTag();
        }
        this.emitter.processingInstruction(string, string2);
    }

    public void close() throws TransformerException {
        this.emitter.endDocument();
        if (this.closeAfterUse) {
            try {
                if (this.writer != null) {
                    this.writer.close();
                }
                if (this.outputStream != null) {
                    this.outputStream.close();
                }
            }
            catch (IOException iOException) {
                throw new TransformerException(iOException);
            }
        }
    }

    protected void flushStartTag() throws TransformerException {
        this.emitter.startElement(this.pendingStartTag, (Attributes)this.pendingAttList, this.pendingNSList, this.pendingNSListSize);
        this.pendingNSListSize = 0;
        this.pendingStartTag = -1;
    }
}

