/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.messaging.saaj.soap;

import com.sun.xml.messaging.saaj.SOAPExceptionImpl;
import com.sun.xml.messaging.saaj.packaging.mime.Header;
import com.sun.xml.messaging.saaj.packaging.mime.MessagingException;
import com.sun.xml.messaging.saaj.packaging.mime.internet.BMMimeMultipart;
import com.sun.xml.messaging.saaj.packaging.mime.internet.ContentType;
import com.sun.xml.messaging.saaj.packaging.mime.internet.MimeBodyPart;
import com.sun.xml.messaging.saaj.packaging.mime.internet.MimeMultipart;
import com.sun.xml.messaging.saaj.packaging.mime.internet.ParameterList;
import com.sun.xml.messaging.saaj.packaging.mime.internet.ParseException;
import com.sun.xml.messaging.saaj.packaging.mime.internet.SharedInputStream;
import com.sun.xml.messaging.saaj.packaging.mime.util.ASCIIUtility;
import com.sun.xml.messaging.saaj.soap.AttachmentPartImpl;
import com.sun.xml.messaging.saaj.soap.SOAPPartImpl;
import com.sun.xml.messaging.saaj.soap.SOAPVersionMismatchException;
import com.sun.xml.messaging.saaj.soap.impl.EnvelopeImpl;
import com.sun.xml.messaging.saaj.util.ByteInputStream;
import com.sun.xml.messaging.saaj.util.ByteOutputStream;
import com.sun.xml.messaging.saaj.util.FastInfosetReflection;
import com.sun.xml.messaging.saaj.util.FinalArrayList;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConstants;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public abstract class MessageImpl
extends SOAPMessage
implements SOAPConstants {
    public static final String CONTENT_ID = "Content-ID";
    public static final String CONTENT_LOCATION = "Content-Location";
    protected static Logger log = Logger.getLogger("javax.xml.messaging.saaj.soap", "com.sun.xml.messaging.saaj.soap.LocalStrings");
    protected static final int PLAIN_XML_FLAG = 1;
    protected static final int MIME_MULTIPART_FLAG = 2;
    protected static final int SOAP1_1_FLAG = 4;
    protected static final int SOAP1_2_FLAG = 8;
    protected static final int MIME_MULTIPART_XOP_FLAG = 14;
    protected static final int XOP_FLAG = 13;
    protected static final int FI_ENCODED_FLAG = 16;
    protected MimeHeaders headers;
    protected SOAPPartImpl soapPart;
    protected FinalArrayList attachments;
    protected boolean saved = false;
    protected byte[] messageBytes;
    protected int messageByteCount;
    protected HashMap properties = new HashMap();
    protected MimeMultipart multiPart = null;
    protected boolean attachmentsInitialized = false;
    protected boolean isFastInfoset = false;
    protected boolean acceptFastInfoset = false;
    private static boolean switchOffBM = false;
    private static boolean switchOffLazyAttachment = false;
    private boolean lazyAttachments = false;
    private static final Iterator nullIter;

    private static boolean isSoap1_1Type(String string, String string2) {
        return string.equals("text") && string2.equals("xml") || string.equals("application") && string2.equals("fastinfoset");
    }

    private static boolean isEqualToSoap1_1Type(String string) {
        return string.startsWith("text/xml") || string.startsWith("application/fastinfoset");
    }

    private static boolean isSoap1_2Type(String string, String string2) {
        return string.equals("application") && (string2.equals("soap+xml") || string2.equals("soap+fastinfoset"));
    }

    private static boolean isEqualToSoap1_2Type(String string) {
        return string.startsWith("application/soap+xml") || string.startsWith("application/soap+fastinfoset");
    }

    protected MessageImpl() {
        this(false, false);
        this.attachmentsInitialized = true;
    }

    protected MessageImpl(boolean bl, boolean bl2) {
        this.isFastInfoset = bl;
        this.acceptFastInfoset = bl2;
        this.headers = new MimeHeaders();
        this.headers.setHeader("Accept", this.getExpectedAcceptHeader());
    }

    protected MessageImpl(SOAPMessage sOAPMessage) {
        if (!(sOAPMessage instanceof MessageImpl)) {
            // empty if block
        }
        MessageImpl messageImpl = (MessageImpl)sOAPMessage;
        this.headers = messageImpl.headers;
        this.soapPart = messageImpl.soapPart;
        this.attachments = messageImpl.attachments;
        this.saved = messageImpl.saved;
        this.messageBytes = messageImpl.messageBytes;
        this.messageByteCount = messageImpl.messageByteCount;
        this.properties = messageImpl.properties;
    }

    protected static boolean isSoap1_1Content(int n2) {
        return (n2 & 4) != 0;
    }

    protected static boolean isSoap1_2Content(int n2) {
        return (n2 & 8) != 0;
    }

    private static boolean isMimeMultipartXOPPackage(ContentType contentType) {
        String string = contentType.getParameter("type");
        if (string == null) {
            return false;
        }
        if (!(string = string.toLowerCase()).startsWith("application/xop+xml")) {
            return false;
        }
        String string2 = contentType.getParameter("start-info");
        if (string2 == null) {
            return false;
        }
        return MessageImpl.isEqualToSoap1_2Type(string2 = string2.toLowerCase()) || MessageImpl.isEqualToSoap1_1Type(string2);
    }

    private static boolean isSOAPBodyXOPPackage(ContentType contentType) {
        String string = contentType.getPrimaryType();
        String string2 = contentType.getSubType();
        if (string.equalsIgnoreCase("application") && string2.equalsIgnoreCase("xop+xml")) {
            String string3 = MessageImpl.getTypeParameter(contentType);
            return MessageImpl.isEqualToSoap1_2Type(string3) || MessageImpl.isEqualToSoap1_1Type(string3);
        }
        return false;
    }

    protected MessageImpl(MimeHeaders mimeHeaders, InputStream inputStream) throws SOAPExceptionImpl {
        ContentType contentType = MessageImpl.parseContentType(mimeHeaders);
        this.init(mimeHeaders, MessageImpl.identifyContentType(contentType), contentType, inputStream);
    }

    private static ContentType parseContentType(MimeHeaders mimeHeaders) throws SOAPExceptionImpl {
        if (mimeHeaders == null) {
            log.severe("SAAJ0550.soap.null.headers");
            throw new SOAPExceptionImpl("Cannot create message: Headers can't be null");
        }
        String string = MessageImpl.getContentType(mimeHeaders);
        if (string == null) {
            log.severe("SAAJ0532.soap.no.Content-Type");
            throw new SOAPExceptionImpl("Absent Content-Type");
        }
        try {
            return new ContentType(string);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            log.severe("SAAJ0535.soap.cannot.internalize.message");
            throw new SOAPExceptionImpl("Unable to internalize message", throwable);
        }
    }

    protected MessageImpl(MimeHeaders mimeHeaders, ContentType contentType, int n2, InputStream inputStream) throws SOAPExceptionImpl {
        this.init(mimeHeaders, n2, contentType, inputStream);
    }

    private void init(MimeHeaders mimeHeaders, int n2, final ContentType contentType, final InputStream inputStream) throws SOAPExceptionImpl {
        block24: {
            this.headers = mimeHeaders;
            try {
                String string;
                StringTokenizer stringTokenizer;
                Object object;
                if ((n2 & 0x10) > 0) {
                    this.acceptFastInfoset = true;
                    this.isFastInfoset = true;
                }
                if (!this.isFastInfoset && (object = mimeHeaders.getHeader("Accept")) != null) {
                    block4: for (int i2 = 0; i2 < ((String[])object).length; ++i2) {
                        stringTokenizer = new StringTokenizer(object[i2], ",");
                        while (stringTokenizer.hasMoreTokens()) {
                            string = stringTokenizer.nextToken().trim();
                            if (!string.equalsIgnoreCase("application/fastinfoset") && !string.equalsIgnoreCase("application/soap+fastinfoset")) continue;
                            this.acceptFastInfoset = true;
                            continue block4;
                        }
                    }
                }
                if (!this.isCorrectSoapVersion(n2)) {
                    log.log(Level.SEVERE, "SAAJ0533.soap.incorrect.Content-Type", new String[]{contentType.toString(), this.getExpectedContentType()});
                    throw new SOAPVersionMismatchException("Cannot create message: incorrect content-type for SOAP version. Got: " + contentType + " Expected: " + this.getExpectedContentType());
                }
                if ((n2 & 1) != 0) {
                    if (this.isFastInfoset) {
                        this.getSOAPPart().setContent(FastInfosetReflection.FastInfosetSource_new((InputStream)inputStream));
                    } else {
                        this.initCharsetProperty(contentType);
                        this.getSOAPPart().setContent((Source)new StreamSource(inputStream));
                    }
                    break block24;
                }
                if ((n2 & 2) != 0) {
                    SharedInputStream sharedInputStream;
                    Object object2;
                    object = new DataSource(){

                        public InputStream getInputStream() {
                            return inputStream;
                        }

                        public OutputStream getOutputStream() {
                            return null;
                        }

                        public String getContentType() {
                            return contentType.toString();
                        }

                        public String getName() {
                            return "";
                        }
                    };
                    this.multiPart = null;
                    this.multiPart = switchOffBM ? new MimeMultipart((DataSource)object, contentType) : new BMMimeMultipart((DataSource)object, contentType);
                    String string2 = contentType.getParameter("start");
                    stringTokenizer = null;
                    string = null;
                    if (switchOffBM || switchOffLazyAttachment) {
                        if (string2 == null) {
                            stringTokenizer = this.multiPart.getBodyPart(0);
                            for (int i3 = 1; i3 < this.multiPart.getCount(); ++i3) {
                                this.initializeAttachment(this.multiPart, i3);
                            }
                        } else {
                            stringTokenizer = this.multiPart.getBodyPart(string2);
                            for (int i4 = 0; i4 < this.multiPart.getCount(); ++i4) {
                                string = this.multiPart.getBodyPart(i4).getContentID();
                                if (string.equals(string2)) continue;
                                this.initializeAttachment(this.multiPart, i4);
                            }
                        }
                    } else {
                        BMMimeMultipart bMMimeMultipart = (BMMimeMultipart)this.multiPart;
                        object2 = bMMimeMultipart.initStream();
                        sharedInputStream = null;
                        if (object2 instanceof SharedInputStream) {
                            sharedInputStream = (SharedInputStream)object2;
                        }
                        String string3 = "--" + contentType.getParameter("boundary");
                        byte[] byArray = ASCIIUtility.getBytes((String)string3);
                        if (string2 == null) {
                            stringTokenizer = bMMimeMultipart.getNextPart((InputStream)object2, byArray, sharedInputStream);
                            bMMimeMultipart.removeBodyPart((MimeBodyPart)stringTokenizer);
                        } else {
                            MimeBodyPart mimeBodyPart = null;
                            try {
                                while (!string2.equals(string)) {
                                    mimeBodyPart = bMMimeMultipart.getNextPart((InputStream)object2, byArray, sharedInputStream);
                                    string = mimeBodyPart.getContentID();
                                }
                                stringTokenizer = mimeBodyPart;
                                bMMimeMultipart.removeBodyPart(mimeBodyPart);
                            }
                            catch (Exception exception) {
                                throw new SOAPExceptionImpl((Throwable)exception);
                            }
                        }
                    }
                    ContentType contentType2 = new ContentType(stringTokenizer.getContentType());
                    this.initCharsetProperty(contentType2);
                    object2 = contentType2.getBaseType().toLowerCase();
                    if (!(MessageImpl.isEqualToSoap1_1Type((String)object2) || MessageImpl.isEqualToSoap1_2Type((String)object2) || MessageImpl.isSOAPBodyXOPPackage(contentType2))) {
                        log.log(Level.SEVERE, "SAAJ0549.soap.part.invalid.Content-Type", new Object[]{object2});
                        throw new SOAPExceptionImpl("Bad Content-Type for SOAP Part : " + (String)object2);
                    }
                    sharedInputStream = this.getSOAPPart();
                    this.setMimeHeaders((SOAPPart)sharedInputStream, (MimeBodyPart)stringTokenizer);
                    sharedInputStream.setContent(this.isFastInfoset ? FastInfosetReflection.FastInfosetSource_new((InputStream)stringTokenizer.getInputStream()) : new StreamSource(stringTokenizer.getInputStream()));
                    break block24;
                }
                log.severe("SAAJ0534.soap.unknown.Content-Type");
                throw new SOAPExceptionImpl("Unrecognized Content-Type");
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                log.severe("SAAJ0535.soap.cannot.internalize.message");
                throw new SOAPExceptionImpl("Unable to internalize message", throwable);
            }
        }
        this.needsSave();
    }

    public boolean isFastInfoset() {
        return this.isFastInfoset;
    }

    public boolean acceptFastInfoset() {
        return this.acceptFastInfoset;
    }

    public void setIsFastInfoset(boolean bl) {
        if (bl != this.isFastInfoset) {
            this.isFastInfoset = bl;
            if (this.isFastInfoset) {
                this.acceptFastInfoset = true;
            }
            this.saved = false;
        }
    }

    public Object getProperty(String string) {
        return (String)this.properties.get(string);
    }

    public void setProperty(String string, Object object) {
        this.verify(string, object);
        this.properties.put(string, object);
    }

    private void verify(String string, Object object) {
        if (string.equalsIgnoreCase("javax.xml.soap.write-xml-declaration")) {
            if (!"true".equals(object) && !"false".equals(object)) {
                throw new RuntimeException(string + " must have value false or true");
            }
            try {
                EnvelopeImpl envelopeImpl = (EnvelopeImpl)this.getSOAPPart().getEnvelope();
                if ("true".equalsIgnoreCase((String)object)) {
                    envelopeImpl.setOmitXmlDecl("no");
                } else if ("false".equalsIgnoreCase((String)object)) {
                    envelopeImpl.setOmitXmlDecl("yes");
                }
            }
            catch (Exception exception) {
                log.log(Level.SEVERE, "SAAJ0591.soap.exception.in.set.property", new Object[]{exception.getMessage(), "javax.xml.soap.write-xml-declaration"});
                throw new RuntimeException(exception);
            }
            return;
        }
        if (string.equalsIgnoreCase("javax.xml.soap.character-set-encoding")) {
            try {
                ((EnvelopeImpl)this.getSOAPPart().getEnvelope()).setCharsetEncoding((String)object);
            }
            catch (Exception exception) {
                log.log(Level.SEVERE, "SAAJ0591.soap.exception.in.set.property", new Object[]{exception.getMessage(), "javax.xml.soap.character-set-encoding"});
                throw new RuntimeException(exception);
            }
        }
    }

    protected abstract boolean isCorrectSoapVersion(int var1);

    protected abstract String getExpectedContentType();

    protected abstract String getExpectedAcceptHeader();

    static int identifyContentType(ContentType contentType) throws SOAPExceptionImpl {
        String string = contentType.getPrimaryType().toLowerCase();
        String string2 = contentType.getSubType().toLowerCase();
        if (string.equals("multipart")) {
            if (string2.equals("related")) {
                String string3 = MessageImpl.getTypeParameter(contentType);
                if (MessageImpl.isEqualToSoap1_1Type(string3)) {
                    return (string3.equals("application/fastinfoset") ? 16 : 0) | 2 | 4;
                }
                if (MessageImpl.isEqualToSoap1_2Type(string3)) {
                    return (string3.equals("application/soap+fastinfoset") ? 16 : 0) | 2 | 8;
                }
                if (MessageImpl.isMimeMultipartXOPPackage(contentType)) {
                    return 14;
                }
                log.severe("SAAJ0536.soap.content-type.mustbe.multipart");
                throw new SOAPExceptionImpl("Content-Type needs to be Multipart/Related and with \"type=text/xml\" or \"type=application/soap+xml\"");
            }
            log.severe("SAAJ0537.soap.invalid.content-type");
            throw new SOAPExceptionImpl("Invalid Content-Type: " + string + '/' + string2);
        }
        if (MessageImpl.isSoap1_1Type(string, string2)) {
            return (string.equalsIgnoreCase("application") && string2.equalsIgnoreCase("fastinfoset") ? 16 : 0) | 1 | 4;
        }
        if (MessageImpl.isSoap1_2Type(string, string2)) {
            return (string.equalsIgnoreCase("application") && string2.equalsIgnoreCase("soap+fastinfoset") ? 16 : 0) | 1 | 8;
        }
        if (MessageImpl.isSOAPBodyXOPPackage(contentType)) {
            return 13;
        }
        log.severe("SAAJ0537.soap.invalid.content-type");
        throw new SOAPExceptionImpl("Invalid Content-Type:" + string + '/' + string2 + ". Is this an error message instead of a SOAP response?");
    }

    private static String getTypeParameter(ContentType contentType) {
        String string = contentType.getParameter("type");
        if (string != null) {
            return string.toLowerCase();
        }
        return "text/xml";
    }

    public MimeHeaders getMimeHeaders() {
        return this.headers;
    }

    static final String getContentType(MimeHeaders mimeHeaders) {
        String[] stringArray = mimeHeaders.getHeader("Content-Type");
        if (stringArray == null) {
            return null;
        }
        return stringArray[0];
    }

    public String getContentType() {
        return MessageImpl.getContentType(this.headers);
    }

    public void setContentType(String string) {
        this.headers.setHeader("Content-Type", string);
        this.needsSave();
    }

    private ContentType ContentType() {
        ContentType contentType = null;
        try {
            contentType = new ContentType(this.getContentType());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return contentType;
    }

    public String getBaseType() {
        return this.ContentType().getBaseType();
    }

    public void setBaseType(String string) {
        ContentType contentType = this.ContentType();
        contentType.setParameter("type", string);
        this.headers.setHeader("Content-Type", contentType.toString());
        this.needsSave();
    }

    public String getAction() {
        return this.ContentType().getParameter("action");
    }

    public void setAction(String string) {
        ContentType contentType = this.ContentType();
        contentType.setParameter("action", string);
        this.headers.setHeader("Content-Type", contentType.toString());
        this.needsSave();
    }

    public String getCharset() {
        return this.ContentType().getParameter("charset");
    }

    public void setCharset(String string) {
        ContentType contentType = this.ContentType();
        contentType.setParameter("charset", string);
        this.headers.setHeader("Content-Type", contentType.toString());
        this.needsSave();
    }

    private final void needsSave() {
        this.saved = false;
    }

    public boolean saveRequired() {
        return !this.saved;
    }

    public String getContentDescription() {
        String[] stringArray = this.headers.getHeader("Content-Description");
        if (stringArray != null && stringArray.length > 0) {
            return stringArray[0];
        }
        return null;
    }

    public void setContentDescription(String string) {
        this.headers.setHeader("Content-Description", string);
        this.needsSave();
    }

    public abstract SOAPPart getSOAPPart();

    public void removeAllAttachments() {
        try {
            this.initializeAllAttachments();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (this.attachments != null) {
            this.attachments.clear();
            this.needsSave();
        }
    }

    public int countAttachments() {
        try {
            this.initializeAllAttachments();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (this.attachments != null) {
            return this.attachments.size();
        }
        return 0;
    }

    public void addAttachmentPart(AttachmentPart attachmentPart) {
        try {
            this.initializeAllAttachments();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (this.attachments == null) {
            this.attachments = new FinalArrayList();
        }
        this.attachments.add((Object)attachmentPart);
        this.needsSave();
    }

    public Iterator getAttachments() {
        try {
            this.initializeAllAttachments();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (this.attachments == null) {
            return nullIter;
        }
        return this.attachments.iterator();
    }

    public Iterator getAttachments(MimeHeaders mimeHeaders) {
        try {
            this.initializeAllAttachments();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (this.attachments == null) {
            return nullIter;
        }
        return new MimeMatchingIterator(mimeHeaders);
    }

    public void removeAttachments(MimeHeaders mimeHeaders) {
        try {
            this.initializeAllAttachments();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (this.attachments == null) {
            return;
        }
        MimeMatchingIterator mimeMatchingIterator = new MimeMatchingIterator(mimeHeaders);
        while (mimeMatchingIterator.hasNext()) {
            int n2 = this.attachments.indexOf(mimeMatchingIterator.next());
            this.attachments.set(n2, null);
        }
        FinalArrayList finalArrayList = new FinalArrayList();
        for (int i2 = 0; i2 < this.attachments.size(); ++i2) {
            if (this.attachments.get(i2) == null) continue;
            finalArrayList.add(this.attachments.get(i2));
        }
        this.attachments = finalArrayList;
    }

    public AttachmentPart createAttachmentPart() {
        return new AttachmentPartImpl();
    }

    public AttachmentPart getAttachment(SOAPElement sOAPElement) throws SOAPException {
        String string;
        try {
            this.initializeAllAttachments();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        String string2 = sOAPElement.getAttribute("href");
        if ("".equals(string2)) {
            Node node = this.getValueNodeStrict(sOAPElement);
            String string3 = null;
            if (node != null) {
                string3 = node.getValue();
            }
            if (string3 == null || "".equals(string3)) {
                return null;
            }
            string = string3;
        } else {
            string = string2;
        }
        return this.getAttachmentPart(string);
    }

    private Node getValueNodeStrict(SOAPElement sOAPElement) {
        Node node = (Node)sOAPElement.getFirstChild();
        if (node != null) {
            if (node.getNextSibling() == null && node.getNodeType() == 3) {
                return node;
            }
            return null;
        }
        return null;
    }

    private AttachmentPart getAttachmentPart(String string) throws SOAPException {
        Object object;
        block5: {
            try {
                Iterator iterator;
                Object object2;
                if (string.startsWith("cid:")) {
                    string = '<' + string.substring("cid:".length()) + '>';
                    object2 = new MimeHeaders();
                    object2.addHeader(CONTENT_ID, string);
                    iterator = this.getAttachments((MimeHeaders)object2);
                    object = iterator == null ? null : (AttachmentPart)iterator.next();
                } else {
                    object2 = new MimeHeaders();
                    object2.addHeader(CONTENT_LOCATION, string);
                    iterator = this.getAttachments((MimeHeaders)object2);
                    AttachmentPart attachmentPart = object = iterator == null ? null : (AttachmentPart)iterator.next();
                }
                if (object != null) break block5;
                object2 = this.getAttachments();
                while (object2.hasNext()) {
                    int n2;
                    iterator = (AttachmentPart)object2.next();
                    String string2 = iterator.getContentId();
                    if (string2 == null || (n2 = string2.indexOf("=")) <= -1 || !(string2 = string2.substring(1, n2)).equalsIgnoreCase(string)) continue;
                    object = iterator;
                    break;
                }
            }
            catch (Exception exception) {
                log.log(Level.SEVERE, "SAAJ0590.soap.unable.to.locate.attachment", new Object[]{string});
                throw new SOAPExceptionImpl((Throwable)exception);
            }
        }
        return object;
    }

    private final ByteInputStream getHeaderBytes() throws IOException {
        SOAPPartImpl sOAPPartImpl = (SOAPPartImpl)this.getSOAPPart();
        return sOAPPartImpl.getContentAsStream();
    }

    private String convertToSingleLine(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '\r' || c2 == '\n' || c2 == '\t') continue;
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    private MimeMultipart getMimeMessage() throws SOAPException {
        try {
            Object object;
            SOAPPartImpl sOAPPartImpl = (SOAPPartImpl)this.getSOAPPart();
            MimeBodyPart mimeBodyPart = sOAPPartImpl.getMimePart();
            ContentType contentType = new ContentType(this.getExpectedContentType());
            if (!this.isFastInfoset) {
                contentType.setParameter("charset", this.initCharset());
            }
            mimeBodyPart.setHeader("Content-Type", contentType.toString());
            MimeMultipart mimeMultipart = null;
            if (!(switchOffBM || switchOffLazyAttachment || this.multiPart == null || this.attachmentsInitialized)) {
                mimeMultipart = new BMMimeMultipart();
                mimeMultipart.addBodyPart(mimeBodyPart);
                if (this.attachments != null) {
                    object = this.attachments.iterator();
                    while (object.hasNext()) {
                        mimeMultipart.addBodyPart(((AttachmentPartImpl)object.next()).getMimePart());
                    }
                }
                object = ((BMMimeMultipart)this.multiPart).getInputStream();
                if (!((BMMimeMultipart)this.multiPart).lastBodyPartFound() && !((BMMimeMultipart)this.multiPart).isEndOfStream()) {
                    ((BMMimeMultipart)mimeMultipart).setInputStream((InputStream)object);
                    ((BMMimeMultipart)mimeMultipart).setBoundary(((BMMimeMultipart)this.multiPart).getBoundary());
                    ((BMMimeMultipart)mimeMultipart).setLazyAttachments(this.lazyAttachments);
                }
            } else {
                mimeMultipart = new MimeMultipart();
                mimeMultipart.addBodyPart(mimeBodyPart);
                object = this.getAttachments();
                while (object.hasNext()) {
                    mimeMultipart.addBodyPart(((AttachmentPartImpl)object.next()).getMimePart());
                }
            }
            object = mimeMultipart.getContentType();
            ParameterList parameterList = object.getParameterList();
            parameterList.set("type", this.getExpectedContentType());
            parameterList.set("boundary", object.getParameter("boundary"));
            ContentType contentType2 = new ContentType("multipart", "related", parameterList);
            this.headers.setHeader("Content-Type", this.convertToSingleLine(contentType2.toString()));
            return mimeMultipart;
        }
        catch (SOAPException sOAPException) {
            throw sOAPException;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            log.severe("SAAJ0538.soap.cannot.convert.msg.to.multipart.obj");
            throw new SOAPExceptionImpl("Unable to convert SOAP message into a MimeMultipart object", throwable);
        }
    }

    private String initCharset() {
        String string = null;
        String[] stringArray = this.getMimeHeaders().getHeader("Content-Type");
        if (stringArray != null && stringArray[0] != null) {
            string = this.getCharsetString(stringArray[0]);
        }
        if (string == null) {
            string = (String)this.getProperty("javax.xml.soap.character-set-encoding");
        }
        if (string != null) {
            return string;
        }
        return "utf-8";
    }

    private String getCharsetString(String string) {
        try {
            int n2 = string.indexOf(";");
            if (n2 < 0) {
                return null;
            }
            ParameterList parameterList = new ParameterList(string.substring(n2));
            return parameterList.get("charset");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void saveChanges() throws SOAPException {
        block9: {
            int n2;
            String string = this.initCharset();
            int n3 = n2 = this.attachments == null ? 0 : this.attachments.size();
            if (!(n2 != 0 || switchOffBM || switchOffLazyAttachment || this.attachmentsInitialized || this.multiPart == null)) {
                n2 = 1;
            }
            try {
                if (n2 == 0 && !this.hasXOPContent()) {
                    ByteInputStream byteInputStream;
                    try {
                        byteInputStream = this.getHeaderBytes();
                    }
                    catch (IOException iOException) {
                        log.severe("SAAJ0539.soap.cannot.get.header.stream");
                        throw new SOAPExceptionImpl("Unable to get header stream in saveChanges: ", (Throwable)iOException);
                    }
                    this.messageBytes = byteInputStream.getBytes();
                    this.messageByteCount = byteInputStream.getCount();
                    this.headers.setHeader("Content-Type", this.getExpectedContentType() + (this.isFastInfoset ? "" : "; charset=" + string));
                    break block9;
                }
                ByteOutputStream byteOutputStream = new ByteOutputStream();
                if (this.hasXOPContent()) {
                    this.getXOPMessage().writeTo((OutputStream)byteOutputStream);
                } else {
                    MimeMultipart mimeMultipart = this.getMimeMessage();
                    mimeMultipart.writeTo((OutputStream)byteOutputStream);
                    if (!(switchOffBM || switchOffLazyAttachment || this.multiPart == null || this.attachmentsInitialized)) {
                        ((BMMimeMultipart)this.multiPart).setInputStream(((BMMimeMultipart)mimeMultipart).getInputStream());
                    }
                }
                this.messageBytes = byteOutputStream.getBytes();
                this.messageByteCount = byteOutputStream.getCount();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                log.severe("SAAJ0540.soap.err.saving.multipart.msg");
                throw new SOAPExceptionImpl("Error during saving a multipart message", throwable);
            }
        }
        this.headers.setHeader("Content-Length", Integer.toString(this.messageByteCount));
        this.saved = true;
    }

    private MimeMultipart getXOPMessage() throws SOAPException {
        try {
            String string;
            MimeMultipart mimeMultipart = new MimeMultipart();
            SOAPPartImpl sOAPPartImpl = (SOAPPartImpl)this.getSOAPPart();
            MimeBodyPart mimeBodyPart = sOAPPartImpl.getMimePart();
            ContentType contentType = new ContentType("application/xop+xml");
            contentType.setParameter("type", this.getExpectedContentType());
            String string2 = this.initCharset();
            contentType.setParameter("charset", string2);
            mimeBodyPart.setHeader("Content-Type", contentType.toString());
            mimeMultipart.addBodyPart(mimeBodyPart);
            Iterator iterator = this.getAttachments();
            while (iterator.hasNext()) {
                mimeMultipart.addBodyPart(((AttachmentPartImpl)iterator.next()).getMimePart());
            }
            iterator = mimeMultipart.getContentType();
            ParameterList parameterList = iterator.getParameterList();
            parameterList.set("start-info", this.getExpectedContentType());
            parameterList.set("type", "application/xop+xml");
            if (this.isCorrectSoapVersion(8) && (string = this.getAction()) != null) {
                parameterList.set("action", string);
            }
            parameterList.set("boundary", iterator.getParameter("boundary"));
            string = new ContentType("Multipart", "Related", parameterList);
            this.headers.setHeader("Content-Type", this.convertToSingleLine(string.toString()));
            return mimeMultipart;
        }
        catch (SOAPException sOAPException) {
            throw sOAPException;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            log.severe("SAAJ0538.soap.cannot.convert.msg.to.multipart.obj");
            throw new SOAPExceptionImpl("Unable to convert SOAP message into a MimeMultipart object", throwable);
        }
    }

    private boolean hasXOPContent() throws ParseException {
        String string = this.getContentType();
        if (string == null) {
            return false;
        }
        ContentType contentType = new ContentType(string);
        return MessageImpl.isMimeMultipartXOPPackage(contentType) || MessageImpl.isSOAPBodyXOPPackage(contentType);
    }

    public void writeTo(OutputStream outputStream) throws SOAPException, IOException {
        String[] stringArray;
        if (this.saveRequired()) {
            this.saveChanges();
        }
        outputStream.write(this.messageBytes, 0, this.messageByteCount);
        if (this.isCorrectSoapVersion(4) && ((stringArray = this.headers.getHeader("SOAPAction")) == null || stringArray.length == 0)) {
            this.headers.setHeader("SOAPAction", "\"\"");
        }
        this.messageBytes = null;
        this.needsSave();
    }

    public SOAPBody getSOAPBody() throws SOAPException {
        return this.getSOAPPart().getEnvelope().getBody();
    }

    public SOAPHeader getSOAPHeader() throws SOAPException {
        return this.getSOAPPart().getEnvelope().getHeader();
    }

    private void initializeAllAttachments() throws MessagingException, SOAPException {
        if (switchOffBM || switchOffLazyAttachment) {
            return;
        }
        if (this.attachmentsInitialized || this.multiPart == null) {
            return;
        }
        if (this.attachments == null) {
            this.attachments = new FinalArrayList();
        }
        int n2 = this.multiPart.getCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.initializeAttachment(this.multiPart.getBodyPart(i2));
        }
        this.attachmentsInitialized = true;
        this.needsSave();
    }

    private void initializeAttachment(MimeBodyPart mimeBodyPart) throws SOAPException {
        AttachmentPartImpl attachmentPartImpl = new AttachmentPartImpl();
        DataHandler dataHandler = mimeBodyPart.getDataHandler();
        attachmentPartImpl.setDataHandler(dataHandler);
        AttachmentPartImpl.copyMimeHeaders((MimeBodyPart)mimeBodyPart, (AttachmentPartImpl)attachmentPartImpl);
        this.attachments.add((Object)attachmentPartImpl);
    }

    private void initializeAttachment(MimeMultipart mimeMultipart, int n2) throws Exception {
        MimeBodyPart mimeBodyPart = mimeMultipart.getBodyPart(n2);
        AttachmentPartImpl attachmentPartImpl = new AttachmentPartImpl();
        DataHandler dataHandler = mimeBodyPart.getDataHandler();
        attachmentPartImpl.setDataHandler(dataHandler);
        AttachmentPartImpl.copyMimeHeaders((MimeBodyPart)mimeBodyPart, (AttachmentPartImpl)attachmentPartImpl);
        this.addAttachmentPart((AttachmentPart)attachmentPartImpl);
    }

    private void setMimeHeaders(SOAPPart sOAPPart, MimeBodyPart mimeBodyPart) throws Exception {
        sOAPPart.removeAllMimeHeaders();
        FinalArrayList finalArrayList = mimeBodyPart.getAllHeaders();
        int n2 = finalArrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Header header = (Header)finalArrayList.get(i2);
            sOAPPart.addMimeHeader(header.getName(), header.getValue());
        }
    }

    private void initCharsetProperty(ContentType contentType) {
        String string = contentType.getParameter("charset");
        if (string != null) {
            ((SOAPPartImpl)this.getSOAPPart()).setSourceCharsetEncoding(string);
            if (!string.equalsIgnoreCase("utf-8")) {
                this.setProperty("javax.xml.soap.character-set-encoding", string);
            }
        }
    }

    public void setLazyAttachments(boolean bl) {
        this.lazyAttachments = bl;
    }

    static {
        try {
            String string = System.getProperty("saaj.mime.optimization");
            if (string != null && string.equals("false")) {
                switchOffBM = true;
            }
            if ((string = System.getProperty("saaj.lazy.mime.optimization")) != null && string.equals("false")) {
                switchOffLazyAttachment = true;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        nullIter = Collections.emptyList().iterator();
    }

    private class MimeMatchingIterator
    implements Iterator {
        private Iterator iter;
        private MimeHeaders headers;
        private Object nextAttachment;

        public MimeMatchingIterator(MimeHeaders mimeHeaders) {
            this.headers = mimeHeaders;
            this.iter = MessageImpl.this.attachments.iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.nextAttachment == null) {
                this.nextAttachment = this.nextMatch();
            }
            return this.nextAttachment != null;
        }

        public Object next() {
            if (this.nextAttachment != null) {
                Object object = this.nextAttachment;
                this.nextAttachment = null;
                return object;
            }
            if (this.hasNext()) {
                return this.nextAttachment;
            }
            return null;
        }

        Object nextMatch() {
            while (this.iter.hasNext()) {
                AttachmentPartImpl attachmentPartImpl = (AttachmentPartImpl)this.iter.next();
                if (!attachmentPartImpl.hasAllHeaders(this.headers)) continue;
                return attachmentPartImpl;
            }
            return null;
        }

        @Override
        public void remove() {
            this.iter.remove();
        }
    }
}

