/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.pattern;

import com.thaiopensource.relaxng.pattern.AfterPattern;
import com.thaiopensource.relaxng.pattern.AttributePattern;
import com.thaiopensource.relaxng.pattern.ChoicePattern;
import com.thaiopensource.relaxng.pattern.DataExceptPattern;
import com.thaiopensource.relaxng.pattern.DataPattern;
import com.thaiopensource.relaxng.pattern.ElementPattern;
import com.thaiopensource.relaxng.pattern.EmptyPattern;
import com.thaiopensource.relaxng.pattern.ErrorPattern;
import com.thaiopensource.relaxng.pattern.GroupPattern;
import com.thaiopensource.relaxng.pattern.InterleavePattern;
import com.thaiopensource.relaxng.pattern.ListPattern;
import com.thaiopensource.relaxng.pattern.NameClass;
import com.thaiopensource.relaxng.pattern.NameClassVisitor;
import com.thaiopensource.relaxng.pattern.NotAllowedPattern;
import com.thaiopensource.relaxng.pattern.OneOrMorePattern;
import com.thaiopensource.relaxng.pattern.Pattern;
import com.thaiopensource.relaxng.pattern.PatternFunction;
import com.thaiopensource.relaxng.pattern.RefPattern;
import com.thaiopensource.relaxng.pattern.TextPattern;
import com.thaiopensource.relaxng.pattern.ValuePattern;
import com.thaiopensource.util.VoidValue;
import com.thaiopensource.xml.util.Name;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import ro.sync.contentcompletion.xml.CIAttribute;
import ro.sync.contentcompletion.xml.g.b;
import ro.sync.contentcompletion.xml.g.b.i;

public class OxygenContentCompletionComponentExtractor
implements PatternFunction<VoidValue>,
NameClassVisitor {
    private Boolean inElement = null;
    private List<b> elements = new ArrayList<b>();
    List<b> startElements = new ArrayList<b>();
    List<CIAttribute> attributes = new ArrayList<CIAttribute>();
    private i annotationManager;
    private final Vector patternList = new Vector();
    private final Hashtable patternTable = new Hashtable();
    private Boolean mixed;

    public OxygenContentCompletionComponentExtractor(i i2) {
        this.annotationManager = i2;
    }

    public List<b> getElements() {
        return this.elements;
    }

    public List<b> getStartElements() {
        return this.startElements;
    }

    public List<CIAttribute> getAttributes() {
        return this.attributes;
    }

    private String getName(Pattern pattern) {
        String string = (String)this.patternTable.get(pattern);
        if (string == null) {
            string = "p" + this.patternList.size();
            this.patternList.addElement(pattern);
            this.patternTable.put(pattern, string);
        }
        return string;
    }

    public void parsePattern(Pattern pattern) {
        b b2;
        pattern.apply((PatternFunction)this);
        for (b b3 : this.elements) {
            b2 = new b();
            b2.setName(b3.getName());
            String string = b3.getNamespace();
            b2.setNamespace(string);
            if (string != null && !"".equals(string)) {
                b2.setDeclareXmlns(true);
            }
            b2.j(this.annotationManager);
            this.startElements.add(b2);
        }
        for (int i2 = 0; i2 < this.patternList.size(); ++i2) {
            b2 = (Pattern)this.patternList.elementAt(i2);
            this.getName((Pattern)b2);
            b2.apply(this);
        }
    }

    public VoidValue caseError(ErrorPattern errorPattern) {
        return VoidValue.VOID;
    }

    public VoidValue caseEmpty(EmptyPattern emptyPattern) {
        return VoidValue.VOID;
    }

    public VoidValue caseNotAllowed(NotAllowedPattern notAllowedPattern) {
        return VoidValue.VOID;
    }

    public VoidValue caseGroup(GroupPattern groupPattern) {
        groupPattern.getOperand1().apply((PatternFunction)this);
        groupPattern.getOperand2().apply((PatternFunction)this);
        return VoidValue.VOID;
    }

    public VoidValue caseInterleave(InterleavePattern interleavePattern) {
        interleavePattern.getOperand1().apply((PatternFunction)this);
        interleavePattern.getOperand2().apply((PatternFunction)this);
        return VoidValue.VOID;
    }

    public VoidValue caseChoice(ChoicePattern choicePattern) {
        choicePattern.getOperand1().apply((PatternFunction)this);
        choicePattern.getOperand2().apply((PatternFunction)this);
        return VoidValue.VOID;
    }

    public VoidValue caseOneOrMore(OneOrMorePattern oneOrMorePattern) {
        oneOrMorePattern.getOperand().apply((PatternFunction)this);
        return VoidValue.VOID;
    }

    public VoidValue caseElement(ElementPattern elementPattern) {
        this.inElement = Boolean.TRUE;
        this.mixed = elementPattern.getContent().getContentType() != 1;
        elementPattern.getNameClass().accept((NameClassVisitor)this);
        this.inElement = null;
        this.mixed = null;
        this.getName(elementPattern.getContent());
        return VoidValue.VOID;
    }

    public VoidValue caseAttribute(AttributePattern attributePattern) {
        this.inElement = Boolean.FALSE;
        attributePattern.getNameClass().accept((NameClassVisitor)this);
        attributePattern.getContent().apply((PatternFunction)this);
        this.inElement = null;
        return VoidValue.VOID;
    }

    public VoidValue caseData(DataPattern dataPattern) {
        return VoidValue.VOID;
    }

    public VoidValue caseDataExcept(DataExceptPattern dataExceptPattern) {
        return VoidValue.VOID;
    }

    public VoidValue caseValue(ValuePattern valuePattern) {
        return VoidValue.VOID;
    }

    public VoidValue caseText(TextPattern textPattern) {
        return VoidValue.VOID;
    }

    public VoidValue caseList(ListPattern listPattern) {
        listPattern.getOperand().apply((PatternFunction)this);
        return VoidValue.VOID;
    }

    public VoidValue caseRef(RefPattern refPattern) {
        refPattern.getPattern().apply((PatternFunction)this);
        return VoidValue.VOID;
    }

    public VoidValue caseAfter(AfterPattern afterPattern) {
        return VoidValue.VOID;
    }

    public void visitChoice(NameClass nameClass, NameClass nameClass2) {
        nameClass.accept((NameClassVisitor)this);
        nameClass2.accept((NameClassVisitor)this);
    }

    public void visitNsName(String string) {
    }

    public void visitNsNameExcept(String string, NameClass nameClass) {
        nameClass.accept((NameClassVisitor)this);
    }

    public void visitAnyName() {
    }

    public void visitAnyNameExcept(NameClass nameClass) {
        nameClass.accept((NameClassVisitor)this);
    }

    public void visitName(Name name) {
        if (this.inElement == Boolean.TRUE) {
            b b2 = new b();
            b2.setName(name.getLocalName());
            b2.setNamespace(name.getNamespaceUri());
            if (name.getNamespaceUri() != null && !name.getNamespaceUri().equals("")) {
                b2.setDeclareXmlns(true);
            }
            b2.i(this.mixed);
            int n2 = this.elements.indexOf(b2);
            if (n2 == -1) {
                this.elements.add(b2);
            } else if (this.mixed == Boolean.TRUE) {
                this.elements.set(n2, b2);
            }
        } else if (this.inElement == Boolean.FALSE) {
            CIAttribute cIAttribute = new CIAttribute();
            cIAttribute.setName(name.getLocalName());
            cIAttribute.setNamespace(name.getNamespaceUri());
            if (!this.attributes.contains(cIAttribute)) {
                this.attributes.add(cIAttribute);
            }
        }
    }

    public void visitNull() {
    }

    public void visitError() {
    }
}

