/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.pattern;

import com.thaiopensource.relaxng.parse.sax.DtdContext;
import com.thaiopensource.relaxng.pattern.ApplyAfterFunction;
import com.thaiopensource.relaxng.pattern.AttributePattern;
import com.thaiopensource.relaxng.pattern.BinaryPattern;
import com.thaiopensource.relaxng.pattern.ElementPattern;
import com.thaiopensource.relaxng.pattern.FindElementFunction;
import com.thaiopensource.relaxng.pattern.IdTypeMap;
import com.thaiopensource.relaxng.pattern.ListPattern;
import com.thaiopensource.relaxng.pattern.NameFormatter;
import com.thaiopensource.relaxng.pattern.OneOrMorePattern;
import com.thaiopensource.relaxng.pattern.OxygenAdditionalContentFunction;
import com.thaiopensource.relaxng.pattern.OxygenContentCompletionValuesExtractor;
import com.thaiopensource.relaxng.pattern.OxygenEmptyDetectorVisitor;
import com.thaiopensource.relaxng.pattern.OxygenModelExtractorVisitor;
import com.thaiopensource.relaxng.pattern.OxygenRequiredContent;
import com.thaiopensource.relaxng.pattern.Pattern;
import com.thaiopensource.relaxng.pattern.PatternBuilder;
import com.thaiopensource.relaxng.pattern.PatternFunction;
import com.thaiopensource.relaxng.pattern.PatternMemo;
import com.thaiopensource.relaxng.pattern.RefPattern;
import com.thaiopensource.relaxng.pattern.ValidatorPatternBuilder;
import com.thaiopensource.validate.Validator;
import com.thaiopensource.xml.util.Name;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.relaxng.datatype.ValidationContext;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import ro.sync.contentcompletion.xml.CIAttribute;
import ro.sync.contentcompletion.xml.CIElement;
import ro.sync.contentcompletion.xml.CIValue;
import ro.sync.contentcompletion.xml.Context;
import ro.sync.contentcompletion.xml.ContextElement;
import ro.sync.contentcompletion.xml.NameValue;
import ro.sync.contentcompletion.xml.WhatElementsCanGoHereContext;
import ro.sync.contentcompletion.xml.WhatPossibleValuesHasAttributeContext;
import ro.sync.contentcompletion.xml.g.b;
import ro.sync.contentcompletion.xml.g.b.i;
import ro.sync.contentcompletion.xml.o;
import ro.sync.exml.options.Options;
import ro.sync.outline.xml.Attribute;
import ro.sync.util.cc;
import ro.sync.xml.ProxyNamespaceMapping;
import ro.sync.xml.XmlUtil;
import ro.sync.xml.parser.IDValue;

public class OxygenContentCompletionHelper
extends DtdContext
implements Validator {
    private final ValidatorPatternBuilder builder;
    private final Pattern start;
    private final ErrorHandler eh;
    private Hashtable recoverPatternTable;
    private PatternMemo memo;
    private boolean hadError;
    private boolean collectingCharacters;
    private final StringBuffer charBuf = new StringBuffer();
    private PrefixMapping prefixMapping = new PrefixMapping("xml", "http://www.w3.org/XML/1998/namespace", null);
    private Locator locator;
    private IdTypeMap idTypeMap;

    private void startCollectingCharacters() {
        if (!this.collectingCharacters) {
            this.collectingCharacters = true;
            this.charBuf.setLength(0);
        }
    }

    private void flushCharacters() throws SAXException {
        this.collectingCharacters = false;
        int n2 = this.charBuf.length();
        block3: for (int i2 = 0; i2 < n2; ++i2) {
            switch (this.charBuf.charAt(i2)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
                default: {
                    this.text();
                    return;
                }
            }
        }
    }

    public void startElement(String string, String string2, Attribute[] attributeArray) throws SAXException {
        Name name;
        if (this.collectingCharacters) {
            this.flushCharacters();
        }
        if (!this.setMemo(this.memo.startTagOpenDeriv(name = new Name(OxygenContentCompletionHelper.notNull(string), string2)))) {
            PatternMemo patternMemo = this.memo.startTagOpenRecoverDeriv(name);
            if (!patternMemo.isNotAllowed()) {
                this.error("required_elements_missing");
            } else {
                patternMemo = this.builder.getPatternMemo(this.builder.makeAfter(this.findElement(name), this.memo.getPattern()));
                this.error(patternMemo.isNotAllowed() ? "unknown_element" : "out_of_context_element", name);
            }
            this.memo = patternMemo;
        }
        int n2 = attributeArray == null ? -1 : attributeArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (attributeArray[i2].getQName().startsWith("xmlns:") || "xmlns".equals(attributeArray[i2].getQName())) continue;
            Name name2 = new Name(OxygenContentCompletionHelper.notNull(attributeArray[i2].getNamespace()), attributeArray[i2].getLocalName());
            if (!this.setMemo(this.memo.startAttributeDeriv(name2))) {
                this.error("impossible_attribute_ignored", name2);
                continue;
            }
            if (this.setMemo(this.memo.dataDeriv(attributeArray[i2].getValue(), (ValidationContext)this))) continue;
            this.error("bad_attribute_value", name2);
            this.memo = this.memo.recoverAfter();
        }
        if (!this.setMemo(this.memo.endAttributes())) {
            this.error("required_attributes_missing");
            this.memo = this.memo.ignoreMissingAttributes();
        }
        if (this.memo.getPattern().getContentType() == 3) {
            this.startCollectingCharacters();
        }
    }

    private PatternMemo fixAfter(PatternMemo patternMemo) {
        return this.builder.getPatternMemo((Pattern)patternMemo.getPattern().apply((PatternFunction)new ApplyAfterFunction(this.builder){

            Pattern apply(Pattern pattern) {
                return OxygenContentCompletionHelper.this.builder.makeEmpty();
            }
        }));
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.collectingCharacters) {
            this.collectingCharacters = false;
            if (!this.setMemo(this.memo.textOnly())) {
                this.error("only_text_not_allowed");
                this.memo = this.memo.recoverAfter();
                return;
            }
            String string4 = this.charBuf.toString();
            if (!this.setMemo(this.memo.dataDeriv(string4, (ValidationContext)this))) {
                PatternMemo patternMemo = this.memo.recoverAfter();
                if (!(this.memo.isNotAllowed() || patternMemo.isNotAllowed() && !this.fixAfter(this.memo).dataDeriv(string4, (ValidationContext)this).isNotAllowed())) {
                    this.error("string_not_allowed");
                }
                this.memo = patternMemo;
            }
        } else if (!this.setMemo(this.memo.endTagDeriv())) {
            PatternMemo patternMemo = this.memo.recoverAfter();
            if (!(this.memo.isNotAllowed() || patternMemo.isNotAllowed() && !this.fixAfter(this.memo).endTagDeriv().isNotAllowed())) {
                this.error("unfinished_element");
            }
            this.memo = patternMemo;
        }
    }

    public void characters(char[] cArray, int n2, int n3) throws SAXException {
        if (this.collectingCharacters) {
            this.charBuf.append(cArray, n2, n3);
            return;
        }
        block3: for (int i2 = 0; i2 < n3; ++i2) {
            switch (cArray[n2 + i2]) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
                default: {
                    this.text();
                    return;
                }
            }
        }
    }

    private void text() throws SAXException {
        if (!this.setMemo(this.memo.mixedTextDeriv())) {
            this.error("text_not_allowed");
        }
    }

    public void endDocument() {
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startDocument() throws SAXException {
        if (this.memo.isNotAllowed()) {
            this.error("schema_allows_nothing");
        }
    }

    public void processingInstruction(String string, String string2) {
    }

    public void skippedEntity(String string) {
    }

    public void ignorableWhitespace(char[] cArray, int n2, int n3) {
    }

    public void startPrefixMapping(String string, String string2) {
        this.prefixMapping = new PrefixMapping(string, string2, this.prefixMapping);
    }

    public void endPrefixMapping(String string) {
        this.prefixMapping = this.prefixMapping.getPrevious();
    }

    public OxygenContentCompletionHelper(Pattern pattern, ValidatorPatternBuilder validatorPatternBuilder, ErrorHandler errorHandler, IdTypeMap idTypeMap) {
        this.start = pattern;
        this.idTypeMap = idTypeMap;
        this.builder = validatorPatternBuilder;
        this.eh = errorHandler;
        this.reset();
    }

    public void reset() {
        this.hadError = false;
        this.collectingCharacters = false;
        this.locator = null;
        this.memo = this.builder.getPatternMemo(this.start);
        this.prefixMapping = new PrefixMapping("xml", "http://www.w3.org/XML/1998/namespace", null);
        this.clearDtdContext();
    }

    private void error(String string) throws SAXException {
        if (this.hadError && this.memo.isNotAllowed()) {
            return;
        }
        this.hadError = true;
        this.eh.error(new SAXParseException(string, this.locator));
    }

    private void error(String string, Name name) throws SAXException {
        this.error(string, NameFormatter.format((Name)name));
    }

    private void error(String string, String string2) throws SAXException {
        if (this.hadError && this.memo.isNotAllowed()) {
            return;
        }
        this.hadError = true;
        this.eh.error(new SAXParseException(string, this.locator));
    }

    private boolean setMemo(PatternMemo patternMemo) {
        if (patternMemo.isNotAllowed()) {
            return false;
        }
        this.memo = patternMemo;
        return true;
    }

    private Pattern findElement(Name name) {
        Pattern pattern;
        if (this.recoverPatternTable == null) {
            this.recoverPatternTable = new Hashtable();
        }
        if ((pattern = (Pattern)this.recoverPatternTable.get(name)) == null) {
            pattern = FindElementFunction.findElement((ValidatorPatternBuilder)this.builder, (Name)name, (Pattern)this.start);
            this.recoverPatternTable.put(name, pattern);
        }
        return pattern;
    }

    public Pattern findPatternForElement(Name name) {
        return FindElementFunction.findElement((ValidatorPatternBuilder)this.builder, (Name)name, (Pattern)this.start);
    }

    public String resolveNamespacePrefix(String string) {
        PrefixMapping prefixMapping = this.prefixMapping;
        do {
            if (!prefixMapping.prefix.equals(string)) continue;
            return prefixMapping.namespaceURI;
        } while ((prefixMapping = prefixMapping.previous) != null);
        return null;
    }

    public String getBaseUri() {
        return null;
    }

    public ContentHandler getContentHandler() {
        return null;
    }

    public DTDHandler getDTDHandler() {
        return null;
    }

    static String notNull(String string) {
        return string == null ? "" : string;
    }

    public Locator getPatternLocator(CIElement cIElement) {
        Locator locator = null;
        Name name = new Name(OxygenContentCompletionHelper.notNull(cIElement.getNamespace()), XmlUtil.getLocalName(cIElement.getName()));
        Pattern pattern = this.memo.getPattern();
        locator = this.getLocatorFromPattern(pattern, name);
        return locator;
    }

    public Locator getPatternLocator(CIAttribute cIAttribute) {
        Locator locator = null;
        Name name = new Name(OxygenContentCompletionHelper.notNull(cIAttribute.getNamespace()), XmlUtil.getLocalName(cIAttribute.getName()));
        Pattern pattern = this.memo.getPattern();
        locator = this.getAttrLocatorFromPattern(pattern, name);
        return locator;
    }

    private Locator getLocatorFromPattern(Pattern pattern, Name name) {
        ElementPattern elementPattern;
        if (pattern instanceof BinaryPattern) {
            Locator locator = null;
            Pattern pattern2 = ((BinaryPattern)pattern).p1;
            locator = this.getLocatorFromPattern(pattern2, name);
            if (locator == null) {
                pattern2 = ((BinaryPattern)pattern).p2;
                locator = this.getLocatorFromPattern(pattern2, name);
            }
            return locator;
        }
        if (pattern instanceof OneOrMorePattern) {
            return this.getLocatorFromPattern(((OneOrMorePattern)pattern).getOperand(), name);
        }
        if (pattern instanceof RefPattern) {
            return this.getLocatorFromPattern(((RefPattern)pattern).getPattern(), name);
        }
        if (pattern instanceof ListPattern) {
            return this.getLocatorFromPattern(((ListPattern)pattern).getOperand(), name);
        }
        if (pattern instanceof ElementPattern && (elementPattern = (ElementPattern)pattern).getNameClass().contains(name)) {
            return elementPattern.getLocator();
        }
        return null;
    }

    private Locator getAttrLocatorFromPattern(Pattern pattern, Name name) {
        ArrayList<Pattern> arrayList = new ArrayList<Pattern>();
        HashSet<Pattern> hashSet = new HashSet<Pattern>();
        this.addPattern(pattern, arrayList, hashSet);
        while (!arrayList.isEmpty()) {
            AttributePattern attributePattern;
            Pattern pattern2 = (Pattern)arrayList.remove(0);
            hashSet.add(pattern2);
            if (pattern2 instanceof AttributePattern) {
                attributePattern = (AttributePattern)pattern2;
                if (!attributePattern.getNameClass().contains(name)) continue;
                return attributePattern.getLocator();
            }
            if (pattern2 instanceof BinaryPattern) {
                attributePattern = (BinaryPattern)pattern2;
                this.addPattern(((BinaryPattern)attributePattern).p1, arrayList, hashSet);
                this.addPattern(((BinaryPattern)attributePattern).p2, arrayList, hashSet);
                continue;
            }
            if (pattern2 instanceof OneOrMorePattern) {
                this.addPattern(((OneOrMorePattern)pattern2).getOperand(), arrayList, hashSet);
                continue;
            }
            if (pattern2 instanceof RefPattern) {
                this.addPattern(((RefPattern)pattern2).getPattern(), arrayList, hashSet);
                continue;
            }
            if (pattern2 instanceof ListPattern) {
                this.addPattern(((ListPattern)pattern2).getOperand(), arrayList, hashSet);
                continue;
            }
            if (!(pattern2 instanceof ElementPattern)) continue;
            this.addPattern(((ElementPattern)pattern2).getContent(), arrayList, hashSet);
        }
        return null;
    }

    private void addPattern(Pattern pattern, List<Pattern> list, Set<Pattern> set) {
        if (set.contains(pattern)) {
            return;
        }
        if (pattern instanceof AttributePattern || pattern instanceof BinaryPattern || pattern instanceof OneOrMorePattern || pattern instanceof RefPattern || pattern instanceof ListPattern || pattern instanceof ElementPattern) {
            list.add(pattern);
        }
    }

    public List getNextElements(List list, List list2, WhatElementsCanGoHereContext whatElementsCanGoHereContext, i i2) {
        return this.getNextElements(list, list2, whatElementsCanGoHereContext, i2, true, false, false);
    }

    private int checkValidation(PatternMemo patternMemo, Name[] nameArray) {
        int n2 = 0;
        PatternMemo patternMemo2 = patternMemo;
        for (Name name : nameArray) {
            PatternMemo patternMemo3 = patternMemo2.startTagOpenDeriv(name);
            if (patternMemo3.isNotAllowed()) continue;
            ++n2;
            patternMemo2 = this.skipAttributesAndContent(patternMemo3);
        }
        return n2;
    }

    private PatternMemo skipAttributesAndContent(PatternMemo patternMemo) {
        PatternMemo patternMemo2;
        PatternMemo patternMemo3 = patternMemo.endAttributes();
        if (patternMemo3.isNotAllowed()) {
            patternMemo3 = patternMemo.ignoreMissingAttributes();
        }
        if ((patternMemo2 = patternMemo3.endTagDeriv()).isNotAllowed()) {
            patternMemo2 = patternMemo3.recoverAfter();
        }
        return patternMemo2;
    }

    public List getNextElements(List list, List list2, WhatElementsCanGoHereContext whatElementsCanGoHereContext, i i2, boolean bl, boolean bl2, boolean bl3) {
        Object object;
        ProxyNamespaceMapping proxyNamespaceMapping = whatElementsCanGoHereContext.getPrefixNamespaceMapping();
        int n2 = 0;
        Name[] nameArray = null;
        if (whatElementsCanGoHereContext.getNextSiblingElements() != null) {
            nameArray = new Name[whatElementsCanGoHereContext.getNextSiblingElements().size()];
            object = whatElementsCanGoHereContext.getNextSiblingElements().iterator();
            int n3 = 0;
            while (object.hasNext()) {
                Object object2 = (ContextElement)object.next();
                nameArray[n3++] = new Name(OxygenContentCompletionHelper.notNull(((ContextElement)object2).getNamespace()), XmlUtil.getLocalName(((ContextElement)object2).getQName()));
            }
            n2 = this.checkValidation(this.memo, nameArray);
        }
        object = new ArrayList();
        for (Object object2 : list) {
            PatternMemo patternMemo;
            Object object3;
            Name name = new Name(OxygenContentCompletionHelper.notNull(object2.getNamespace()), object2.getName());
            PatternMemo patternMemo2 = this.memo.startTagOpenDeriv(name);
            if (patternMemo2.isNotAllowed()) continue;
            boolean bl4 = true;
            if (n2 > 0) {
                object3 = this.skipAttributesAndContent(patternMemo2);
                int n4 = this.checkValidation((PatternMemo)object3, nameArray);
                boolean bl5 = bl4 = n2 <= n4;
            }
            if (!bl4) continue;
            object3 = new b();
            String string = proxyNamespaceMapping.getPrefixForNamespace(object2.getNamespace());
            if (string == null) {
                ((o)object3).setDeclareXmlns(true);
            } else {
                ((o)object3).setPrefix(string);
            }
            ProxyNamespaceMapping proxyNamespaceMapping2 = (ProxyNamespaceMapping)proxyNamespaceMapping.clone();
            if (((o)object3).isDeclareXmlns()) {
                proxyNamespaceMapping2.addMapping("", object2.getNamespace());
            }
            if ((patternMemo = patternMemo2.endAttributes()).isNotAllowed()) {
                patternMemo = patternMemo2.ignoreMissingAttributes();
            }
            ((b)object3).g(this.getAdditionalContent(proxyNamespaceMapping2, patternMemo2, bl, bl2, bl3, i2));
            OxygenEmptyDetectorVisitor oxygenEmptyDetectorVisitor = new OxygenEmptyDetectorVisitor();
            patternMemo2.getPattern().apply((PatternFunction)oxygenEmptyDetectorVisitor);
            if (oxygenEmptyDetectorVisitor.getEmpty()) {
                ((o)object3).setContentType(1);
            }
            ((o)object3).setName(object2.getName());
            ((o)object3).setNamespace(object2.getNamespace());
            ((b)object3).j(i2);
            ((o)object3).setAttributes(this.getAttributes(patternMemo2, list2, proxyNamespaceMapping, object2.getName(), object2.getNamespace(), i2));
            object.add(object3);
        }
        return object;
    }

    public void setModelAndContentType(ContextElement contextElement, ProxyNamespaceMapping proxyNamespaceMapping, CIElement cIElement) {
        String string;
        OxygenModelExtractorVisitor oxygenModelExtractorVisitor;
        if (contextElement == null) {
            cIElement.setModelDescription(null);
            return;
        }
        Name name = new Name(OxygenContentCompletionHelper.notNull(contextElement.getNamespace()), XmlUtil.getLocalName(contextElement.getQName()));
        Object object = this.memo.startTagOpenDeriv(name);
        if (object.isNotAllowed() && (object = this.memo.startTagOpenRecoverDeriv(name)).isNotAllowed() && (object = this.builder.getPatternMemo(this.builder.makeAfter(this.findElement(name), this.memo.getPattern()))).isNotAllowed()) {
            cIElement.setModelDescription(null);
            return;
        }
        Attribute[] attributeArray = contextElement.getAttributes();
        int n2 = attributeArray == null ? -1 : attributeArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (attributeArray[i2].getQName().startsWith("xmlns:") || "xmlns".equals(attributeArray[i2].getQName()) || (oxygenModelExtractorVisitor = object.startAttributeDeriv((Name)(string = new Name(OxygenContentCompletionHelper.notNull(attributeArray[i2].getNamespace()), attributeArray[i2].getLocalName())))).isNotAllowed()) continue;
            object = oxygenModelExtractorVisitor;
            object = (oxygenModelExtractorVisitor = object.dataDeriv(attributeArray[i2].getValue(), (ValidationContext)this)).isNotAllowed() ? object.recoverAfter() : oxygenModelExtractorVisitor;
        }
        PatternMemo patternMemo = object.endAttributes();
        if (patternMemo.isNotAllowed()) {
            patternMemo = patternMemo.ignoreMissingAttributes();
        }
        string = "";
        oxygenModelExtractorVisitor = new OxygenModelExtractorVisitor(proxyNamespaceMapping);
        object.getPattern().apply((PatternFunction)oxygenModelExtractorVisitor);
        string = string + oxygenModelExtractorVisitor.getModel();
        cIElement.setModelDescription(string);
        if (oxygenModelExtractorVisitor.isElementAllowed()) {
            if (oxygenModelExtractorVisitor.isTextAllowed()) {
                cIElement.setContentType(3);
            } else {
                cIElement.setContentType(2);
            }
        } else if (!oxygenModelExtractorVisitor.isTextAllowed()) {
            cIElement.setContentType(1);
        }
    }

    public List getAttributes(List list, ContextElement contextElement, ProxyNamespaceMapping proxyNamespaceMapping, i i2) {
        String string;
        if (contextElement == null) {
            return new ArrayList(0);
        }
        String string2 = OxygenContentCompletionHelper.notNull(contextElement.getNamespace());
        Name name = new Name(string2, string = XmlUtil.getLocalName(contextElement.getQName()));
        PatternMemo patternMemo = this.memo.startTagOpenDeriv(name);
        if (patternMemo.isNotAllowed() && (patternMemo = this.memo.startTagOpenRecoverDeriv(name)).isNotAllowed() && (patternMemo = this.builder.getPatternMemo(this.builder.makeAfter(this.findElement(name), this.memo.getPattern()))).isNotAllowed()) {
            return new ArrayList(0);
        }
        Attribute[] attributeArray = contextElement.getAttributes();
        int n2 = attributeArray == null ? -1 : attributeArray.length;
        for (int i3 = 0; i3 < n2; ++i3) {
            Name name2;
            PatternMemo patternMemo2;
            if (attributeArray[i3].getQName().startsWith("xmlns:") || "xmlns".equals(attributeArray[i3].getQName()) || (patternMemo2 = patternMemo.startAttributeDeriv(name2 = new Name(OxygenContentCompletionHelper.notNull(attributeArray[i3].getNamespace()), attributeArray[i3].getLocalName()))).isNotAllowed()) continue;
            patternMemo = patternMemo2;
            patternMemo = (patternMemo2 = patternMemo.dataDeriv(attributeArray[i3].getValue(), (ValidationContext)this)).isNotAllowed() ? patternMemo.recoverAfter() : patternMemo2;
        }
        return this.getAttributes(patternMemo, list, proxyNamespaceMapping, string, string2, i2);
    }

    private List<CIElement> getAdditionalContent(final ProxyNamespaceMapping proxyNamespaceMapping, final PatternMemo patternMemo, boolean bl, boolean bl2, boolean bl3, final i i2) {
        final boolean bl4 = bl ? Options.getInstance().getBooleanProperty("code.insight.add.optional.content") : bl2;
        final boolean bl5 = bl ? Options.getInstance().getBooleanProperty("code.insight.add.first.choice") : bl3;
        return new cc(new cc._b(){

            @Override
            public List<CIElement> getList() {
                OxygenAdditionalContentFunction oxygenAdditionalContentFunction = new OxygenAdditionalContentFunction(proxyNamespaceMapping, bl5, bl4, i2);
                return (List)patternMemo.getPattern().apply((PatternFunction)oxygenAdditionalContentFunction);
            }
        });
    }

    List getAttributes(final PatternMemo patternMemo, final List list, final ProxyNamespaceMapping proxyNamespaceMapping, final String string, final String string2, final i i2) {
        return new cc(new cc._b(){

            @Override
            public List getList() {
                return OxygenContentCompletionHelper.getAttributes(patternMemo, list, proxyNamespaceMapping, string, string2, i2, OxygenContentCompletionHelper.this.builder);
            }
        });
    }

    static List getAttributes(PatternMemo patternMemo, List list, ProxyNamespaceMapping proxyNamespaceMapping, String string, String string2, i i2, ValidatorPatternBuilder validatorPatternBuilder) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Integer> hashMap2 = new HashMap<String, Integer>();
        ArrayList<CIAttribute> arrayList = new ArrayList<CIAttribute>();
        Iterator iterator = list.iterator();
        Pattern pattern = OxygenRequiredContent.getStrictRequiredAttributes((PatternBuilder)validatorPatternBuilder, patternMemo.getPattern());
        PatternMemo patternMemo2 = new PatternMemo(pattern, validatorPatternBuilder);
        while (iterator.hasNext()) {
            String string3;
            CIAttribute cIAttribute = (CIAttribute)iterator.next();
            Name name = new Name(OxygenContentCompletionHelper.notNull(cIAttribute.getNamespace()), cIAttribute.getName());
            PatternMemo patternMemo3 = patternMemo.startAttributeDeriv(name);
            if (patternMemo3.isNotAllowed()) continue;
            CIAttribute cIAttribute2 = new CIAttribute();
            PatternMemo patternMemo4 = patternMemo2.startAttributeDeriv(name);
            if (!patternMemo4.isNotAllowed()) {
                cIAttribute2.setRequired(true);
            }
            String string4 = cIAttribute.getName();
            String string5 = cIAttribute.getNamespace();
            if ("http://www.w3.org/XML/1998/namespace".equals(string5)) {
                string4 = "xml:" + string4;
            } else if (string5 != null && string5.length() > 0) {
                string3 = proxyNamespaceMapping.getPrefixForAttributeNamespace(string5);
                if (string3 == null || "".equals(string3)) {
                    String string6 = (String)hashMap.get(string5);
                    if (string6 == null || string6.length() == 0) {
                        string6 = XmlUtil.getProxyForNamespace(string5, proxyNamespaceMapping, hashMap2);
                        hashMap.put(string5, string6);
                    }
                    cIAttribute2.setDeclareXmlns(true);
                    cIAttribute2.setPrefix(string6);
                } else {
                    string4 = string3 + ":" + string4;
                }
            }
            cIAttribute2.setName(string4);
            if ("".equals(string5)) {
                string5 = null;
            }
            cIAttribute2.setNamespace(string5);
            if (i2 != null) {
                string3 = i2.l(string, string2, cIAttribute.getName(), string5);
                cIAttribute2.setAnnotation(string3);
                cIAttribute2.setDefaultValue(i2.n(string, string2, cIAttribute.getName(), string5));
            }
            arrayList.add(cIAttribute2);
        }
        return arrayList;
    }

    public List<CIValue> getValues(List<IDValue> list, List<NameValue> list2, WhatPossibleValuesHasAttributeContext whatPossibleValuesHasAttributeContext, i i2) {
        ArrayList<CIValue> arrayList;
        block11: {
            Object object;
            OxygenContentCompletionValuesExtractor oxygenContentCompletionValuesExtractor;
            block10: {
                arrayList = new ArrayList<CIValue>();
                String string = XmlUtil.getProxy(whatPossibleValuesHasAttributeContext.getAttributeName());
                String string2 = whatPossibleValuesHasAttributeContext.getPrefixNamespaceMapping().getNamespaceForAttributePrefix(string);
                String string3 = XmlUtil.getLocalName(whatPossibleValuesHasAttributeContext.getAttributeName());
                Name name = new Name(OxygenContentCompletionHelper.notNull(string2), string3);
                ContextElement contextElement = whatPossibleValuesHasAttributeContext.getParentElement();
                String string4 = XmlUtil.getLocalName(contextElement.getQName());
                Name name2 = new Name(OxygenContentCompletionHelper.notNull(contextElement.getNamespace()), string4);
                PatternMemo patternMemo = this.memo.startTagOpenDeriv(name2);
                if (patternMemo.isNotAllowed() && (patternMemo = this.memo.startTagOpenRecoverDeriv(name2)).isNotAllowed() && (patternMemo = this.builder.getPatternMemo(this.builder.makeAfter(this.findElement(name2), this.memo.getPattern()))).isNotAllowed()) {
                    return new ArrayList<CIValue>(0);
                }
                Attribute[] attributeArray = contextElement.getAttributes();
                int n2 = attributeArray == null ? -1 : attributeArray.length;
                for (int i3 = 0; i3 < n2; ++i3) {
                    PatternMemo patternMemo2;
                    if (attributeArray[i3].getQName().equals(whatPossibleValuesHasAttributeContext.getAttributeName()) || attributeArray[i3].getQName().startsWith("xmlns:") || "xmlns".equals(attributeArray[i3].getQName()) || (patternMemo2 = patternMemo.startAttributeDeriv((Name)(oxygenContentCompletionValuesExtractor = new Name(OxygenContentCompletionHelper.notNull(attributeArray[i3].getNamespace()), attributeArray[i3].getLocalName())))).isNotAllowed()) continue;
                    patternMemo = patternMemo2;
                    patternMemo = (patternMemo2 = patternMemo.dataDeriv(attributeArray[i3].getValue(), (ValidationContext)this)).isNotAllowed() ? patternMemo.recoverAfter() : patternMemo2;
                }
                PatternMemo patternMemo3 = patternMemo.startAttributeDeriv(name);
                if (patternMemo.isNotAllowed()) {
                    return null;
                }
                oxygenContentCompletionValuesExtractor = new OxygenContentCompletionValuesExtractor(whatPossibleValuesHasAttributeContext.getPrefixNamespaceMapping());
                oxygenContentCompletionValuesExtractor.parsePattern(patternMemo3.getPattern());
                arrayList.addAll(oxygenContentCompletionValuesExtractor.getValues());
                if (i2 != null) {
                    for (CIValue cIValue : arrayList) {
                        cIValue.setAnnotation(i2.f(string4, contextElement.getNamespace(), string3, string2, cIValue.getValue()));
                    }
                }
                if (this.idTypeMap != null) {
                    int n3 = this.idTypeMap.getIdType(name2, name);
                    if (list != null && (n3 == 2 || n3 == 3)) {
                        boolean bl = n3 == 3;
                        for (IDValue iDValue : list) {
                            CIValue cIValue = new CIValue(iDValue.getId(), bl, iDValue.getAnnotation());
                            arrayList.add(cIValue);
                        }
                    }
                }
                if (!oxygenContentCompletionValuesExtractor.isAnyURIDetected() || list == null) break block10;
                for (IDValue iDValue : list) {
                    object = new CIValue("#" + iDValue.getId(), oxygenContentCompletionValuesExtractor.isAnyURIListDetected(), iDValue.getAnnotation());
                    arrayList.add((CIValue)object);
                }
                break block11;
            }
            if (!oxygenContentCompletionValuesExtractor.isEntityRefDetected() || list2 == null) break block11;
            for (int i4 = 0; i4 < list2.size(); ++i4) {
                NameValue nameValue = list2.get(i4);
                object = new CIValue(nameValue.getName(), false, nameValue.getDocumentation());
                arrayList.add((CIValue)object);
            }
        }
        return arrayList;
    }

    public List getElementValues(Context context, i i2) {
        ArrayList arrayList = new ArrayList();
        if (context.getElementStack() != null && !context.getElementStack().isEmpty()) {
            ContextElement contextElement = context.getElementStack().peek();
            String string = XmlUtil.getLocalName(contextElement.getQName());
            OxygenContentCompletionValuesExtractor oxygenContentCompletionValuesExtractor = new OxygenContentCompletionValuesExtractor(context.getPrefixNamespaceMapping());
            oxygenContentCompletionValuesExtractor.parsePattern(this.memo.getPattern());
            arrayList.addAll(oxygenContentCompletionValuesExtractor.getValues());
            if (i2 != null) {
                for (CIValue cIValue : arrayList) {
                    cIValue.setAnnotation(i2.f(string, contextElement.getNamespace(), null, null, cIValue.getValue()));
                }
            }
        }
        return arrayList;
    }

    private static final class PrefixMapping {
        private final String prefix;
        private final String namespaceURI;
        private final PrefixMapping previous;

        PrefixMapping(String string, String string2, PrefixMapping prefixMapping) {
            this.prefix = string;
            this.namespaceURI = string2;
            this.previous = prefixMapping;
        }

        PrefixMapping getPrevious() {
            return this.previous;
        }
    }
}

