/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Platform;
import net.sf.saxon.Version;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.ContentHandlerProxy;
import net.sf.saxon.event.FilterFactory;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.Sender;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.evpull.PullEventSource;
import net.sf.saxon.expr.CollationMap;
import net.sf.saxon.expr.EarlyEvaluationContext;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.PJConverter;
import net.sf.saxon.expr.PendingUpdateList;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Debugger;
import net.sf.saxon.expr.instruct.DocumentInstr;
import net.sf.saxon.expr.instruct.ElementCreator;
import net.sf.saxon.expr.instruct.GlobalParam;
import net.sf.saxon.expr.instruct.ResultDocument;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.expr.number.Numberer_en;
import net.sf.saxon.expr.parser.CodeInjector;
import net.sf.saxon.expr.parser.ExpressionParser;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.functions.IntegratedFunctionLibrary;
import net.sf.saxon.functions.VendorFunctionLibrary;
import net.sf.saxon.java.JavaPlatform;
import net.sf.saxon.lib.AugmentedSource;
import net.sf.saxon.lib.CollationURIResolver;
import net.sf.saxon.lib.CollectionURIResolver;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.lib.EnvironmentVariableResolver;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.lib.ExternalObjectModel;
import net.sf.saxon.lib.LocalizerFactory;
import net.sf.saxon.lib.ModuleURIResolver;
import net.sf.saxon.lib.Numberer;
import net.sf.saxon.lib.OutputURIResolver;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.SchemaURIResolver;
import net.sf.saxon.lib.SerializerFactory;
import net.sf.saxon.lib.SourceResolver;
import net.sf.saxon.lib.StandardCollationURIResolver;
import net.sf.saxon.lib.StandardCollectionURIResolver;
import net.sf.saxon.lib.StandardEntityResolver;
import net.sf.saxon.lib.StandardEnvironmentVariableResolver;
import net.sf.saxon.lib.StandardErrorListener;
import net.sf.saxon.lib.StandardModuleURIResolver;
import net.sf.saxon.lib.StandardURIChecker;
import net.sf.saxon.lib.StandardURIResolver;
import net.sf.saxon.lib.StaticQueryContextFactory;
import net.sf.saxon.lib.TraceListener;
import net.sf.saxon.lib.URIChecker;
import net.sf.saxon.lib.Validation;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.DocumentPool;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.Name10Checker;
import net.sf.saxon.om.Name11Checker;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NotationSet;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.TreeModel;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.PatternParser20;
import net.sf.saxon.pull.PullSource;
import net.sf.saxon.query.QueryParser;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.serialize.charcode.CharacterSetFactory;
import net.sf.saxon.style.StyleNodeFactory;
import net.sf.saxon.sxpath.IndependentContext;
import net.sf.saxon.trace.TraceCodeInjector;
import net.sf.saxon.trans.CompilerInfo;
import net.sf.saxon.trans.ConfigurationReader;
import net.sf.saxon.trans.DynamicLoader;
import net.sf.saxon.trans.LicenseException;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.util.DocumentNumberAllocator;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.BuiltInType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ExternalObjectType;
import net.sf.saxon.type.SchemaDeclaration;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.StringToDouble;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.MemoClosure;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringToDouble11;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.ext.LexicalHandler;
import ro.sync.xml.transformer.b.c;

public class Configuration
implements Serializable,
SourceResolver,
NotationSet {
    private transient Object transformationStopper;
    private static final Platform platform = Configuration.makePlatform();
    public static final Class<? extends Configuration> configurationClass = Configuration.makeConfigurationClass();
    public static final String softwareEdition = Configuration.setSoftwareEdition();
    private transient Object apiProcessor = null;
    private transient CharacterSetFactory characterSetFactory;
    private CollationMap collationMap = new CollationMap(this);
    private CollationURIResolver collationResolver = new StandardCollationURIResolver();
    protected CollectionURIResolver collectionResolver = new StandardCollectionURIResolver();
    private EnvironmentVariableResolver environmentVariableResolver = new StandardEnvironmentVariableResolver();
    private String defaultCollection = null;
    private ParseOptions defaultParseOptions = new ParseOptions();
    private transient StaticQueryContext defaultStaticQueryContext;
    private CompilerInfo defaultXsltCompilerInfo = new CompilerInfo();
    private DocumentNumberAllocator documentNumberAllocator = new DocumentNumberAllocator();
    private transient Debugger debugger = null;
    private String defaultLanguage = Locale.getDefault().getLanguage();
    private String defaultCountry = Locale.getDefault().getCountry();
    private Properties defaultSerializationProperties = new Properties();
    private int domLevel = 3;
    private transient DynamicLoader dynamicLoader = new DynamicLoader();
    private Set<String> enabledProperties = new HashSet<String>();
    private List<ExternalObjectModel> externalObjectModels = new ArrayList<ExternalObjectModel>(4);
    private DocumentPool globalDocumentPool = new DocumentPool();
    private int hostLanguage = 50;
    private IntegratedFunctionLibrary integratedFunctionLibrary = new IntegratedFunctionLibrary();
    private transient LocalizerFactory localizerFactory;
    private ModuleURIResolver moduleURIResolver = null;
    private StaticQueryContextFactory staticQueryContextFactory = new StaticQueryContextFactory();
    private NamePool namePool = new NamePool();
    protected int optimizationLevel = 10;
    protected Optimizer optimizer = null;
    private SchemaURIResolver schemaURIResolver = null;
    private SerializerFactory serializerFactory = new SerializerFactory(this);
    private volatile ConcurrentLinkedQueue<XMLReader> sourceParserPool = new ConcurrentLinkedQueue();
    private volatile ConcurrentLinkedQueue<XMLReader> styleParserPool = new ConcurrentLinkedQueue();
    private String sourceParserClass;
    private transient SourceResolver sourceResolver = this;
    private transient PrintStream standardErrorOutput = System.err;
    private ModuleURIResolver standardModuleURIResolver = StandardModuleURIResolver.getInstance();
    private String styleParserClass;
    private StandardURIResolver systemURIResolver = new StandardURIResolver(this);
    private transient XPathContext theConversionContext = null;
    private ConversionRules theConversionRules = null;
    private transient TraceListener traceListener = null;
    private String traceListenerClass = null;
    protected transient TypeHierarchy typeHierarchy;
    private transient URIResolver uriResolver;
    protected VendorFunctionLibrary vendorFunctionLibrary;
    protected int xsdVersion = 10;
    private int xmlVersion = 10;
    public static final int RECOVER_SILENTLY = 0;
    public static final int RECOVER_WITH_WARNINGS = 1;
    public static final int DO_NOT_RECOVER = 2;
    public static final int XML10 = 10;
    public static final int XML11 = 11;
    public static final int XSLT = 50;
    public static final int XQUERY = 51;
    public static final int XML_SCHEMA = 52;
    public static final int JAVA_APPLICATION = 53;
    public static final int XPATH = 54;
    public static final int XSD10 = 10;
    public static final int XSD11 = 11;
    private static LexicalHandler dummyLexicalHandler = new DefaultHandler2();

    public static InputStream locateResource(String string, List<String> list, List<ClassLoader> list2) {
        URL uRL;
        ClassLoader classLoader = null;
        try {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        catch (Exception exception) {
            list.add("Failed to getContextClassLoader() - continuing\n");
        }
        InputStream inputStream = null;
        if (classLoader != null && (inputStream = classLoader.getResourceAsStream(string)) == null) {
            list.add("Cannot read " + string + " file located using ClassLoader " + classLoader + " - continuing\n");
        }
        if (inputStream == null && (classLoader = Configuration.class.getClassLoader()) != null && (inputStream = classLoader.getResourceAsStream(string)) == null) {
            list.add("Cannot read " + string + " file located using ClassLoader " + classLoader + " - continuing\n");
        }
        if (inputStream == null && (uRL = ClassLoader.getSystemResource(string)) != null) {
            try {
                inputStream = uRL.openStream();
            }
            catch (IOException iOException) {
                list.add("IO error " + iOException.getMessage() + " reading " + string + " located using getSystemResource(): using defaults");
                inputStream = null;
            }
        }
        list2.add(classLoader);
        return inputStream;
    }

    public static Configuration readConfiguration(Source source) throws XPathException {
        Configuration configuration = Configuration.newConfiguration();
        return configuration.readConfigurationFile(source);
    }

    protected Configuration readConfigurationFile(Source source) throws XPathException {
        return new ConfigurationReader().makeConfiguration(source);
    }

    public Configuration() {
        this.init();
    }

    public static Configuration newConfiguration() {
        try {
            Configuration configuration = configurationClass.newInstance();
            c.b().b(configuration, true);
            return configuration;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException("Cannot instantiate a Configuration", exception);
        }
    }

    protected void init() {
        platform.initialize(this);
        this.defaultXsltCompilerInfo.setURIResolver((URIResolver)this.getSystemURIResolver());
        StandardEntityResolver standardEntityResolver = new StandardEntityResolver();
        standardEntityResolver.setConfiguration(this);
        this.defaultParseOptions.setEntityResolver((EntityResolver)standardEntityResolver);
        this.internalSetBooleanProperty("http://saxon.sf.net/feature/preferJaxpParser", true);
        this.internalSetBooleanProperty("http://saxon.sf.net/feature/allow-external-functions", true);
        try {
            this.setConfigurationProperty("http://saxon.sf.net/feature/allow-old-java-uri-format", true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public static Configuration makeLicensedConfiguration(ClassLoader classLoader, String string) throws RuntimeException {
        if (string == null) {
            string = "com.saxonica.config.ProfessionalConfiguration";
        }
        try {
            Class<?> clazz;
            ClassLoader classLoader2 = classLoader;
            if (classLoader2 == null) {
                try {
                    classLoader2 = Thread.currentThread().getContextClassLoader();
                }
                catch (Exception exception) {
                    System.err.println("Failed to getContextClassLoader() - continuing");
                }
            }
            if (classLoader2 != null) {
                try {
                    clazz = classLoader2.loadClass(string);
                }
                catch (Exception exception) {
                    clazz = Class.forName(string);
                }
            } else {
                clazz = Class.forName(string);
            }
            Configuration configuration = (Configuration)clazz.newInstance();
            c.b().b(configuration, false);
            return configuration;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
    }

    @Deprecated
    public static Configuration makeSchemaAwareConfiguration(ClassLoader classLoader, String string) {
        return Configuration.makeLicensedConfiguration(classLoader, string);
    }

    public String getEditionCode() {
        return "HE";
    }

    public void setProcessor(Object object) {
        this.apiProcessor = object;
    }

    public Object getProcessor() {
        return this.apiProcessor;
    }

    public String getProductTitle() {
        return "Saxon-" + this.getEditionCode() + " " + Version.getProductVersion() + platform.getPlatformSuffix() + " from Saxonica";
    }

    public void checkLicensedFeature(int n2, String string) throws LicenseException {
        String string2 = n2 == 8 ? "PE" : "EE";
        String string3 = "Requested feature (" + string + ") requires Saxon-" + string2;
        if (!softwareEdition.equals("HE")) {
            string3 = string3 + ". You are using Saxon-" + softwareEdition + " software, but the Configuration is an instance of " + this.getClass().getName() + "; to use this feature you need to create an instance of " + (n2 == 8 ? "com.saxonica.config.ProfessionalConfiguration" : "com.saxonica.config.EnterpriseConfiguration");
        }
        throw new LicenseException(string3, 6);
    }

    public boolean isLicensedFeature(int n2) {
        return false;
    }

    @Deprecated
    public boolean isSchemaAware(int n2) {
        return false;
    }

    public void displayLicenseMessage() {
    }

    public int getHostLanguage() {
        return this.hostLanguage;
    }

    public void setHostLanguage(int n2) {
        this.hostLanguage = n2;
    }

    public static Platform getPlatform() {
        return platform;
    }

    public void setDynamicLoader(DynamicLoader dynamicLoader) {
        this.dynamicLoader = dynamicLoader;
    }

    public DynamicLoader getDynamicLoader() {
        return this.dynamicLoader;
    }

    public Class getClass(String string, boolean bl, ClassLoader classLoader) throws XPathException {
        return this.dynamicLoader.getClass(string, bl ? this.standardErrorOutput : null, classLoader);
    }

    public Object getInstance(String string, ClassLoader classLoader) throws XPathException {
        return this.dynamicLoader.getInstance(string, this.isTiming() ? this.standardErrorOutput : null, classLoader);
    }

    public URIResolver getURIResolver() {
        if (this.uriResolver == null) {
            return this.systemURIResolver;
        }
        return this.uriResolver;
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this.uriResolver = uRIResolver;
        if (uRIResolver instanceof StandardURIResolver) {
            ((StandardURIResolver)uRIResolver).setConfiguration(this);
        }
        this.defaultXsltCompilerInfo.setURIResolver(uRIResolver);
    }

    public void setParameterizedURIResolver() {
        this.getSystemURIResolver().setRecognizeQueryParameters(true);
    }

    public StandardURIResolver getSystemURIResolver() {
        return this.systemURIResolver;
    }

    public URIResolver makeURIResolver(String string) throws TransformerException {
        Object object = this.dynamicLoader.getInstance(string, null);
        if (object instanceof StandardURIResolver) {
            ((StandardURIResolver)object).setConfiguration(this);
        }
        if (object instanceof URIResolver) {
            return (URIResolver)object;
        }
        throw new XPathException("Class " + string + " is not a URIResolver");
    }

    public ErrorListener getErrorListener() {
        ErrorListener errorListener = this.defaultParseOptions.getErrorListener();
        if (errorListener == null) {
            errorListener = new StandardErrorListener();
            ((StandardErrorListener)errorListener).setErrorOutput(this.standardErrorOutput);
            ((StandardErrorListener)errorListener).setRecoveryPolicy(this.defaultXsltCompilerInfo.getRecoveryPolicy());
            this.defaultParseOptions.setErrorListener(errorListener);
        }
        return errorListener;
    }

    public void setErrorListener(ErrorListener errorListener) {
        this.defaultParseOptions.setErrorListener(errorListener);
    }

    public void reportFatalError(XPathException xPathException) {
        if (!xPathException.hasBeenReported()) {
            try {
                this.getErrorListener().fatalError((TransformerException)xPathException);
            }
            catch (TransformerException transformerException) {
                // empty catch block
            }
            xPathException.setHasBeenReported(true);
        }
    }

    public void setStandardErrorOutput(PrintStream printStream) {
        this.standardErrorOutput = printStream;
    }

    public PrintStream getStandardErrorOutput() {
        if (this.standardErrorOutput == null) {
            this.standardErrorOutput = System.err;
        }
        return this.standardErrorOutput;
    }

    public void setXMLVersion(int n2) {
        this.xmlVersion = n2;
        this.theConversionRules = null;
    }

    public int getXMLVersion() {
        return this.xmlVersion;
    }

    public ParseOptions getParseOptions() {
        return this.defaultParseOptions;
    }

    public NameChecker getNameChecker() {
        return this.getConversionRules().getNameChecker();
    }

    public void setConversionRules(ConversionRules conversionRules) {
        this.theConversionRules = conversionRules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConversionRules getConversionRules() {
        if (this.theConversionRules == null) {
            Configuration configuration = this;
            synchronized (configuration) {
                ConversionRules conversionRules = new ConversionRules();
                conversionRules.setNameChecker((NameChecker)(this.xmlVersion == 10 ? Name10Checker.getInstance() : Name11Checker.getInstance()));
                conversionRules.setStringToDoubleConverter((StringToDouble)(this.xsdVersion == 10 ? StringToDouble.getInstance() : StringToDouble11.getInstance()));
                conversionRules.setNotationSet((NotationSet)this);
                if (this.xsdVersion == 10) {
                    conversionRules.setURIChecker((URIChecker)StandardURIChecker.getInstance());
                }
                conversionRules.setAllowYearZero(this.xsdVersion != 10);
                this.theConversionRules = conversionRules;
                return this.theConversionRules;
            }
        }
        return this.theConversionRules;
    }

    public int getXsdVersion() {
        return this.xsdVersion;
    }

    public XPathContext getConversionContext() {
        if (this.theConversionContext == null) {
            this.theConversionContext = new EarlyEvaluationContext(this, new CollationMap(this));
        }
        return this.theConversionContext;
    }

    public int getTreeModel() {
        return this.defaultParseOptions.getModel().getSymbolicValue();
    }

    public void setTreeModel(int n2) {
        this.defaultParseOptions.setModel(TreeModel.getTreeModel((int)n2));
    }

    public boolean isLineNumbering() {
        return this.defaultParseOptions.isLineNumbering();
    }

    public void setLineNumbering(boolean bl) {
        this.defaultParseOptions.setLineNumbering(bl);
    }

    public void setXIncludeAware(boolean bl) {
        this.defaultParseOptions.setXIncludeAware(bl);
    }

    public boolean isXIncludeAware() {
        return this.defaultParseOptions.isXIncludeAware();
    }

    public TraceListener getTraceListener() {
        return this.traceListener;
    }

    public TraceListener makeTraceListener() throws XPathException {
        if (this.traceListener != null) {
            return this.traceListener;
        }
        if (this.traceListenerClass != null) {
            try {
                return this.makeTraceListener(this.traceListenerClass);
            }
            catch (ClassCastException classCastException) {
                throw new XPathException((Throwable)classCastException);
            }
        }
        return null;
    }

    public void setTraceListener(TraceListener traceListener) {
        this.traceListener = traceListener;
        this.setCompileWithTracing(traceListener != null);
        this.internalSetBooleanProperty("http://saxon.sf.net/feature/allow-multithreading", false);
    }

    public void setTraceListenerClass(String string) {
        if (string == null) {
            this.traceListenerClass = null;
            this.setCompileWithTracing(false);
        } else {
            try {
                this.makeTraceListener(string);
            }
            catch (XPathException xPathException) {
                throw new IllegalArgumentException(string + ": " + xPathException.getMessage());
            }
            this.traceListenerClass = string;
            this.setCompileWithTracing(true);
        }
    }

    public String getTraceListenerClass() {
        return this.traceListenerClass;
    }

    public boolean isCompileWithTracing() {
        return this.getBooleanProperty("http://saxon.sf.net/feature/compile-with-tracing");
    }

    public void setCompileWithTracing(boolean bl) {
        this.internalSetBooleanProperty("http://saxon.sf.net/feature/compile-with-tracing", bl);
        if (this.defaultXsltCompilerInfo != null) {
            if (bl) {
                this.defaultXsltCompilerInfo.setCodeInjector((CodeInjector)new TraceCodeInjector());
            } else {
                this.defaultXsltCompilerInfo.setCodeInjector(null);
            }
        }
        if (this.getDefaultStaticQueryContext() != null) {
            if (bl) {
                this.defaultStaticQueryContext.setCodeInjector((CodeInjector)new TraceCodeInjector());
            } else {
                this.defaultStaticQueryContext.setCodeInjector(null);
            }
        }
    }

    public TraceListener makeTraceListener(String string) throws XPathException {
        Object object = this.dynamicLoader.getInstance(string, null);
        if (object instanceof TraceListener) {
            return (TraceListener)object;
        }
        throw new XPathException("Class " + string + " is not a TraceListener");
    }

    public void registerExtensionFunction(ExtensionFunctionDefinition extensionFunctionDefinition) {
        this.integratedFunctionLibrary.registerFunction(extensionFunctionDefinition);
    }

    public IntegratedFunctionLibrary getIntegratedFunctionLibrary() {
        return this.integratedFunctionLibrary;
    }

    public VendorFunctionLibrary getVendorFunctionLibrary() {
        if (this.vendorFunctionLibrary == null) {
            this.vendorFunctionLibrary = new VendorFunctionLibrary();
        }
        return this.vendorFunctionLibrary;
    }

    public void addExtensionBinders(FunctionLibraryList functionLibraryList) {
    }

    public UserFunction newUserFunction(boolean bl) {
        return new UserFunction();
    }

    public void setCollationURIResolver(CollationURIResolver collationURIResolver) {
        this.collationResolver = collationURIResolver;
    }

    public CollationURIResolver getCollationURIResolver() {
        return this.collationResolver;
    }

    public CollationMap getCollationMap() {
        return this.collationMap;
    }

    public void setDefaultCollection(String string) {
        this.defaultCollection = string;
    }

    public String getDefaultCollection() {
        return this.defaultCollection;
    }

    public void setCollectionURIResolver(CollectionURIResolver collectionURIResolver) {
        this.collectionResolver = collectionURIResolver;
    }

    public CollectionURIResolver getCollectionURIResolver() {
        return this.collectionResolver;
    }

    public void setLocalizerFactory(LocalizerFactory localizerFactory) {
        this.localizerFactory = localizerFactory;
    }

    public LocalizerFactory getLocalizerFactory() {
        return this.localizerFactory;
    }

    public void setDefaultLanguage(String string) {
        this.defaultLanguage = string;
    }

    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public void setDefaultCountry(String string) {
        this.defaultCountry = string;
    }

    public String getDefaultCountry() {
        return this.defaultCountry;
    }

    public Numberer makeNumberer(String string, String string2) {
        if (this.localizerFactory == null) {
            return new Numberer_en();
        }
        Numberer numberer = this.localizerFactory.getNumberer(string, string2);
        if (numberer == null) {
            numberer = new Numberer_en();
        }
        return numberer;
    }

    public void setModuleURIResolver(ModuleURIResolver moduleURIResolver) {
        this.moduleURIResolver = moduleURIResolver;
    }

    public void setModuleURIResolver(String string) throws TransformerException {
        Object object = this.dynamicLoader.getInstance(string, null);
        if (!(object instanceof ModuleURIResolver)) {
            throw new XPathException("Class " + string + " is not a ModuleURIResolver");
        }
        this.setModuleURIResolver((ModuleURIResolver)object);
    }

    public ModuleURIResolver getModuleURIResolver() {
        return this.moduleURIResolver;
    }

    public ModuleURIResolver getStandardModuleURIResolver() {
        return this.standardModuleURIResolver;
    }

    public void setSchemaURIResolver(SchemaURIResolver schemaURIResolver) {
        this.schemaURIResolver = schemaURIResolver;
    }

    public SchemaURIResolver getSchemaURIResolver() {
        return this.schemaURIResolver;
    }

    public CompilerInfo getDefaultXsltCompilerInfo() {
        return this.defaultXsltCompilerInfo;
    }

    public StaticQueryContext getDefaultStaticQueryContext() {
        if (this.defaultStaticQueryContext == null) {
            this.defaultStaticQueryContext = new StaticQueryContext(this, true);
        }
        return this.defaultStaticQueryContext;
    }

    public int getRecoveryPolicy() {
        return this.defaultXsltCompilerInfo.getRecoveryPolicy();
    }

    public void setRecoveryPolicy(int n2) {
        this.defaultXsltCompilerInfo.setRecoveryPolicy(n2);
    }

    public String getMessageEmitterClass() {
        return this.defaultXsltCompilerInfo.getMessageReceiverClassName();
    }

    public void setMessageEmitterClass(String string) {
        this.defaultXsltCompilerInfo.setMessageReceiverClassName(string);
    }

    public String getSourceParserClass() {
        return this.sourceParserClass;
    }

    public void setSourceParserClass(String string) {
        this.sourceParserClass = string;
    }

    public String getStyleParserClass() {
        return this.styleParserClass;
    }

    public void setStyleParserClass(String string) {
        this.styleParserClass = string;
    }

    public OutputURIResolver getOutputURIResolver() {
        return this.defaultXsltCompilerInfo.getOutputURIResolver();
    }

    public void setOutputURIResolver(OutputURIResolver outputURIResolver) {
        this.defaultXsltCompilerInfo.setOutputURIResolver(outputURIResolver);
    }

    public void setSerializerFactory(SerializerFactory serializerFactory) {
        this.serializerFactory = serializerFactory;
    }

    public SerializerFactory getSerializerFactory() {
        return this.serializerFactory;
    }

    public CharacterSetFactory getCharacterSetFactory() {
        if (this.characterSetFactory == null) {
            this.characterSetFactory = new CharacterSetFactory();
        }
        return this.characterSetFactory;
    }

    public void setDefaultSerializationProperties(Properties properties) {
        this.defaultSerializationProperties = properties;
    }

    public Properties getDefaultSerializationProperties() {
        return this.defaultSerializationProperties;
    }

    public void processResultDocument(ResultDocument resultDocument, Expression expression, XPathContext xPathContext) throws XPathException {
        resultDocument.processInstruction(expression, xPathContext);
    }

    public boolean isTiming() {
        return this.enabledProperties.contains("http://saxon.sf.net/feature/timing");
    }

    public void setTiming(boolean bl) {
        if (bl) {
            this.enabledProperties.add("http://saxon.sf.net/feature/timing");
        } else {
            this.enabledProperties.remove("http://saxon.sf.net/feature/timing");
        }
    }

    public boolean isVersionWarning() {
        return this.defaultXsltCompilerInfo.isVersionWarning();
    }

    public void setVersionWarning(boolean bl) {
        this.defaultXsltCompilerInfo.setVersionWarning(bl);
    }

    public boolean isAllowStreamabilityExtensions() {
        return this.enabledProperties.contains("http://saxon.sf.net/feature/allow-streamability-extensions");
    }

    public boolean isValidation() {
        return this.defaultParseOptions.getDTDValidationMode() == 1 || this.defaultParseOptions.getDTDValidationMode() == 2;
    }

    public void setValidation(boolean bl) {
        this.defaultParseOptions.setDTDValidationMode(bl ? 1 : 4);
    }

    public FilterFactory makeDocumentProjector(PathMap.PathMapRoot pathMapRoot) {
        throw new UnsupportedOperationException("Document projection requires Saxon-EE");
    }

    public int getSchemaValidationMode() {
        return this.defaultParseOptions.getSchemaValidationMode();
    }

    public void setSchemaValidationMode(int n2) {
        switch (n2) {
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                if (this.isLicensedFeature(1)) break;
                n2 = 4;
                break;
            }
            case 1: {
                this.checkLicensedFeature(1, "strict validation");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported validation mode " + n2);
            }
        }
        this.defaultParseOptions.setSchemaValidationMode(n2);
    }

    public void setValidationWarnings(boolean bl) {
        this.defaultParseOptions.setContinueAfterValidationErrors(bl);
    }

    public boolean isValidationWarnings() {
        return this.defaultParseOptions.isContinueAfterValidationErrors();
    }

    public void setExpandAttributeDefaults(boolean bl) {
        this.defaultParseOptions.setExpandAttributeDefaults(bl);
    }

    public boolean isExpandAttributeDefaults() {
        return this.defaultParseOptions.isExpandAttributeDefaults();
    }

    public NamePool getNamePool() {
        return this.namePool;
    }

    public void setNamePool(NamePool namePool) {
        this.namePool = namePool;
    }

    public TypeHierarchy getTypeHierarchy() {
        if (this.typeHierarchy == null) {
            this.typeHierarchy = new TypeHierarchy(this);
        }
        return this.typeHierarchy;
    }

    public DocumentNumberAllocator getDocumentNumberAllocator() {
        return this.documentNumberAllocator;
    }

    public void setDocumentNumberAllocator(DocumentNumberAllocator documentNumberAllocator) {
        this.documentNumberAllocator = documentNumberAllocator;
    }

    public boolean isCompatible(Configuration configuration) {
        return this.namePool == configuration.namePool && this.documentNumberAllocator == configuration.documentNumberAllocator;
    }

    public DocumentPool getGlobalDocumentPool() {
        return this.globalDocumentPool;
    }

    public boolean isStripsAllWhiteSpace() {
        return this.defaultParseOptions.getStripSpace() == 2;
    }

    public void setStripsAllWhiteSpace(boolean bl) {
        if (bl) {
            this.defaultParseOptions.setStripSpace(2);
        }
    }

    public void setStripsWhiteSpace(int n2) {
        this.defaultParseOptions.setStripSpace(n2);
    }

    public int getStripsWhiteSpace() {
        return this.defaultParseOptions.getStripSpace();
    }

    public XMLReader getSourceParser() throws TransformerFactoryConfigurationError {
        XMLReader xMLReader;
        if (this.sourceParserPool == null) {
            this.sourceParserPool = new ConcurrentLinkedQueue();
        }
        if ((xMLReader = this.sourceParserPool.poll()) != null) {
            return xMLReader;
        }
        xMLReader = this.getSourceParserClass() != null ? this.makeParser(this.getSourceParserClass()) : Configuration.loadParser();
        if (this.isTiming()) {
            this.reportParserDetails(xMLReader);
        }
        try {
            Sender.configureParser((XMLReader)xMLReader);
        }
        catch (XPathException xPathException) {
            throw new TransformerFactoryConfigurationError((Exception)((Object)xPathException));
        }
        if (this.isValidation()) {
            try {
                xMLReader.setFeature("http://xml.org/sax/features/validation", true);
            }
            catch (SAXException sAXException) {
                throw new TransformerFactoryConfigurationError("The XML parser does not support validation");
            }
        }
        return xMLReader;
    }

    private void reportParserDetails(XMLReader xMLReader) {
        String string = xMLReader.getClass().getName();
        this.standardErrorOutput.println("Using parser " + string);
    }

    public synchronized void reuseSourceParser(XMLReader xMLReader) {
        if (this.sourceParserPool == null) {
            this.sourceParserPool = new ConcurrentLinkedQueue();
        }
        try {
            try {
                xMLReader.setContentHandler(null);
                if (xMLReader.getEntityResolver() == this.defaultParseOptions.getEntityResolver()) {
                    xMLReader.setEntityResolver(null);
                }
                xMLReader.setDTDHandler(null);
                xMLReader.setErrorHandler(null);
                xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", dummyLexicalHandler);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                // empty catch block
            }
            this.sourceParserPool.offer(xMLReader);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static XMLReader loadParser() {
        return platform.loadParser();
    }

    public synchronized XMLReader getStyleParser() throws TransformerFactoryConfigurationError {
        XMLReader xMLReader;
        if (this.styleParserPool == null) {
            this.styleParserPool = new ConcurrentLinkedQueue();
        }
        if ((xMLReader = this.styleParserPool.poll()) != null) {
            return xMLReader;
        }
        if (this.getStyleParserClass() != null) {
            xMLReader = this.makeParser(this.getStyleParserClass());
        } else {
            xMLReader = Configuration.loadParser();
            StandardEntityResolver standardEntityResolver = new StandardEntityResolver();
            standardEntityResolver.setConfiguration(this);
            xMLReader.setEntityResolver((EntityResolver)standardEntityResolver);
        }
        try {
            xMLReader.setFeature("http://xml.org/sax/features/namespaces", true);
            xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            throw new TransformerFactoryConfigurationError(sAXNotRecognizedException);
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            throw new TransformerFactoryConfigurationError(sAXNotSupportedException);
        }
        return xMLReader;
    }

    public synchronized void reuseStyleParser(XMLReader xMLReader) {
        if (this.styleParserPool == null) {
            this.styleParserPool = new ConcurrentLinkedQueue();
        }
        try {
            try {
                xMLReader.setContentHandler(null);
                xMLReader.setDTDHandler(null);
                xMLReader.setErrorHandler(null);
                xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", dummyLexicalHandler);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                // empty catch block
            }
            this.styleParserPool.offer(xMLReader);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loadSchema(String string) throws SchemaException {
        this.readSchema(this.makePipelineConfiguration(), "", string, null);
    }

    public String readSchema(PipelineConfiguration pipelineConfiguration, String string, String string2, String string3) throws SchemaException {
        this.needEnterpriseEdition();
        return null;
    }

    public void readMultipleSchemas(PipelineConfiguration pipelineConfiguration, String string, Collection<String> collection, String string2) throws SchemaException {
        this.needEnterpriseEdition();
    }

    public String readInlineSchema(NodeInfo nodeInfo, String string, ErrorListener errorListener) throws SchemaException {
        this.needEnterpriseEdition();
        return null;
    }

    protected void needEnterpriseEdition() {
        throw new UnsupportedOperationException("You need the Enterprise Edition of Saxon (with an EnterpriseConfiguration) for this operation");
    }

    public void addSchemaSource(Source source) throws SchemaException {
        this.addSchemaSource(source, this.getErrorListener());
    }

    public void addSchemaSource(Source source, ErrorListener errorListener) throws SchemaException {
        this.needEnterpriseEdition();
    }

    public void addSchemaForBuiltInNamespace(String string) {
    }

    public boolean isSchemaAvailable(String string) {
        return false;
    }

    public void clearSchemaCache() {
    }

    public Set getImportedNamespaces() {
        return Collections.EMPTY_SET;
    }

    public void sealNamespace(String string) {
    }

    public Collection<GlobalParam> getDeclaredSchemaParameters() {
        return null;
    }

    public Iterator<? extends SchemaType> getExtensionsOfType(SchemaType schemaType) {
        Set set = Collections.emptySet();
        return set.iterator();
    }

    public void importComponents(Source source) throws XPathException {
        this.needEnterpriseEdition();
    }

    public void exportComponents(Receiver receiver) throws XPathException {
        this.needEnterpriseEdition();
    }

    public FunctionItem getSchemaAsFunctionItem() {
        return null;
    }

    public FunctionItem getSchemaComponentAsFunctionItem(String string, QNameValue qNameValue) throws XPathException {
        return null;
    }

    public SchemaDeclaration getElementDeclaration(int n2) {
        return null;
    }

    public SchemaDeclaration getElementDeclaration(StructuredQName structuredQName) {
        return null;
    }

    public SchemaDeclaration getAttributeDeclaration(int n2) {
        return null;
    }

    public SchemaType getSchemaType(int n2) {
        if (n2 < 1023) {
            return BuiltInType.getSchemaType((int)n2);
        }
        return null;
    }

    public boolean isDeclaredNotation(String string, String string2) {
        return false;
    }

    protected ExternalObjectType getExternalObjectType(int n2) {
        if (this.getNamePool().getURI(n2).equals("http://saxon.sf.net/java-type")) {
            try {
                Class clazz = this.dynamicLoader.getClass(this.getNamePool().getLocalName(n2), null, null);
                if (clazz == null) {
                    return null;
                }
                return new ExternalObjectType(clazz, this);
            }
            catch (XPathException xPathException) {
                return null;
            }
        }
        return null;
    }

    public void checkTypeDerivationIsOK(SchemaType schemaType, SchemaType schemaType2, int n2) throws SchemaException {
    }

    public Receiver getDocumentValidator(Receiver receiver, String string, ParseOptions parseOptions) {
        return receiver;
    }

    public SequenceReceiver getElementValidator(SequenceReceiver sequenceReceiver, ParseOptions parseOptions, int n2) throws XPathException {
        return sequenceReceiver;
    }

    public SimpleType validateAttribute(int n2, CharSequence charSequence, int n3) throws ValidationException {
        return BuiltInAtomicType.UNTYPED_ATOMIC;
    }

    public Receiver getAnnotationStripper(Receiver receiver) {
        return receiver;
    }

    public XMLReader makeParser(String string) throws TransformerFactoryConfigurationError {
        Object object;
        try {
            object = this.dynamicLoader.getInstance(string, null);
        }
        catch (XPathException xPathException) {
            throw new TransformerFactoryConfigurationError((Exception)((Object)xPathException));
        }
        if (object instanceof XMLReader) {
            return (XMLReader)object;
        }
        throw new TransformerFactoryConfigurationError("Class " + string + " is not a SAX2 XMLReader");
    }

    public ExpressionParser newExpressionParser(String string, boolean bl, DecimalValue decimalValue) {
        if ("XQ".equals(string)) {
            if (bl) {
                throw new UnsupportedOperationException("XQuery Update is supported only in Saxon-EE");
            }
            if (DecimalValue.THREE.equals((Object)decimalValue) || DecimalValue.ONE_POINT_ONE.equals((Object)decimalValue)) {
                throw new UnsupportedOperationException("XQuery 3.0 extensions are supported only in Saxon-PE");
            }
            if (DecimalValue.ONE.equals((Object)decimalValue)) {
                return new QueryParser();
            }
            throw new IllegalArgumentException("Unknown XQuery version " + decimalValue);
        }
        if ("XP".equals(string)) {
            if (DecimalValue.THREE.equals((Object)decimalValue)) {
                throw new UnsupportedOperationException("XPath 3.0 extensions are supported only in Saxon-PE");
            }
            if (DecimalValue.TWO.equals((Object)decimalValue)) {
                return new ExpressionParser();
            }
            throw new IllegalArgumentException("Unknown XPath version " + decimalValue);
        }
        if ("PATTERN".equals(string)) {
            if (DecimalValue.THREE.equals((Object)decimalValue)) {
                throw new UnsupportedOperationException("XSLT 3.0 extensions are supported only in Saxon-PE");
            }
            return new PatternParser20();
        }
        throw new IllegalArgumentException("Unknown expression language " + string);
    }

    public Expression makeOuterForExpression() {
        throw new UnsupportedOperationException("'allowing empty' requires Saxon-PE or -EE");
    }

    public static Locale getLocale(String string) {
        String string2;
        String string3;
        int n2 = string.indexOf("-");
        if (n2 < 1) {
            string3 = string;
            string2 = "";
        } else {
            string3 = string.substring(1, n2);
            string2 = string.substring(n2 + 1);
        }
        return new Locale(string3, string2);
    }

    public void setDebugger(Debugger debugger) {
        this.debugger = debugger;
    }

    public Debugger getDebugger() {
        return this.debugger;
    }

    public SlotManager makeSlotManager() {
        if (this.debugger == null) {
            return new SlotManager();
        }
        return this.debugger.makeSlotManager();
    }

    public Receiver makeStreamingTransformer(XPathContext xPathContext, Mode mode) throws XPathException {
        throw new XPathException("Streaming is only available in Saxon-EE");
    }

    public Optimizer obtainOptimizer() {
        if (this.optimizer == null) {
            this.optimizer = new Optimizer(this);
            this.optimizer.setOptimizationLevel(this.optimizationLevel);
            assert (this.optimizer != null);
            return this.optimizer;
        }
        return this.optimizer;
    }

    public Sequence makeClosure(Expression expression, int n2, XPathContext xPathContext) throws XPathException {
        MemoClosure memoClosure = new MemoClosure();
        if (n2 > 1) {
            memoClosure = new MemoClosure();
        }
        return memoClosure;
    }

    public Sequence makeSequenceExtent(Expression expression, int n2, XPathContext xPathContext) throws XPathException {
        return SequenceExtent.makeSequenceExtent((SequenceIterator)expression.iterate(xPathContext));
    }

    public StyleNodeFactory makeStyleNodeFactory() {
        return new StyleNodeFactory(this);
    }

    public void registerExternalObjectModel(ExternalObjectModel externalObjectModel) {
        if (this.externalObjectModels == null) {
            this.externalObjectModels = new ArrayList<ExternalObjectModel>(4);
        }
        if (!this.externalObjectModels.contains(externalObjectModel)) {
            this.externalObjectModels.add(externalObjectModel);
        }
    }

    public ExternalObjectModel getExternalObjectModel(String string) {
        for (ExternalObjectModel externalObjectModel : this.externalObjectModels) {
            if (!externalObjectModel.getIdentifyingURI().equals(string)) continue;
            return externalObjectModel;
        }
        return null;
    }

    public ExternalObjectModel getExternalObjectModel(Class clazz) {
        for (ExternalObjectModel externalObjectModel : this.externalObjectModels) {
            PJConverter pJConverter = externalObjectModel.getPJConverter(clazz);
            if (pJConverter == null) continue;
            return externalObjectModel;
        }
        return null;
    }

    public List<ExternalObjectModel> getExternalObjectModels() {
        return this.externalObjectModels;
    }

    public NodeInfo unravel(Source source) {
        List<ExternalObjectModel> list = this.getExternalObjectModels();
        for (ExternalObjectModel externalObjectModel : list) {
            NodeInfo nodeInfo = externalObjectModel.unravel(source, this);
            if (nodeInfo == null) continue;
            if (nodeInfo.getConfiguration() != this) {
                throw new IllegalArgumentException("Externally supplied Node belongs to the wrong Configuration");
            }
            return nodeInfo;
        }
        if (source instanceof NodeInfo) {
            if (((NodeInfo)source).getConfiguration() != this) {
                throw new IllegalArgumentException("Externally supplied NodeInfo belongs to the wrong Configuration");
            }
            return (NodeInfo)source;
        }
        throw new IllegalArgumentException("A source of class " + source.getClass() + " is not recognized by any registered object model");
    }

    public void setDOMLevel(int n2) {
        if (n2 != 2 && n2 != 3) {
            throw new IllegalArgumentException("DOM Level must be 2 or 3");
        }
        this.domLevel = n2;
    }

    public int getDOMLevel() {
        return this.domLevel;
    }

    public void setStaticQueryContextFactory(StaticQueryContextFactory staticQueryContextFactory) {
        this.staticQueryContextFactory = staticQueryContextFactory;
    }

    public StaticQueryContext newStaticQueryContext() {
        return this.staticQueryContextFactory.newStaticQueryContext(this);
    }

    public PendingUpdateList newPendingUpdateList() {
        throw new UnsupportedOperationException("XQuery update is supported only in Saxon-EE");
    }

    public PipelineConfiguration makePipelineConfiguration() {
        PipelineConfiguration pipelineConfiguration = new PipelineConfiguration(this);
        pipelineConfiguration.setURIResolver(this.getURIResolver());
        pipelineConfiguration.setSchemaURIResolver(this.getSchemaURIResolver());
        pipelineConfiguration.setHostLanguage(this.getHostLanguage());
        pipelineConfiguration.setParseOptions(new ParseOptions(this.defaultParseOptions));
        return pipelineConfiguration;
    }

    public static Configuration getConfiguration(XPathContext xPathContext) {
        return xPathContext.getConfiguration();
    }

    public void setSourceResolver(SourceResolver sourceResolver) {
        this.sourceResolver = sourceResolver;
    }

    public SourceResolver getSourceResolver() {
        return this.sourceResolver;
    }

    public Source resolveSource(Source source, Configuration configuration) throws XPathException {
        if (source instanceof AugmentedSource) {
            return source;
        }
        if (source instanceof StreamSource) {
            return source;
        }
        if (source instanceof SAXSource) {
            return source;
        }
        if (source instanceof DOMSource) {
            return source;
        }
        if (source instanceof NodeInfo) {
            return source;
        }
        if (source instanceof PullSource) {
            return source;
        }
        if (source instanceof PullEventSource) {
            return source;
        }
        return null;
    }

    public DocumentInfo buildDocument(Source source) throws XPathException {
        ParseOptions parseOptions;
        if (source == null) {
            throw new NullPointerException("source");
        }
        Source source2 = this.resolveSource(source, this);
        if (source2 == null) {
            throw new XPathException("Unknown source class " + source.getClass().getName());
        }
        Source source3 = source = source2;
        if (source instanceof AugmentedSource) {
            parseOptions = ((AugmentedSource)source).getParseOptions();
            source3 = ((AugmentedSource)source).getContainedSource();
        } else {
            parseOptions = new ParseOptions();
        }
        source = source3;
        return this.buildDocument(source, parseOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentInfo buildDocument(Source source, ParseOptions parseOptions) throws XPathException {
        if (source == null) {
            throw new NullPointerException("source");
        }
        boolean bl = false;
        try {
            ParseOptions parseOptions2 = new ParseOptions(parseOptions);
            Source source2 = this.resolveSource(source, this);
            if (source2 == null) {
                throw new XPathException("Unknown source class " + source.getClass().getName());
            }
            source = source2;
            if (source instanceof AugmentedSource) {
                parseOptions2.merge(((AugmentedSource)source).getParseOptions());
            }
            parseOptions2.applyDefaults(this);
            bl = parseOptions2.isPleaseCloseAfterUse();
            TreeModel treeModel = parseOptions2.getModel();
            boolean bl2 = parseOptions2.isLineNumbering();
            PipelineConfiguration pipelineConfiguration = this.makePipelineConfiguration();
            Builder builder = treeModel.makeBuilder(pipelineConfiguration);
            builder.setTiming(this.isTiming());
            builder.setLineNumbering(bl2);
            builder.setPipelineConfiguration(pipelineConfiguration);
            Sender.send((Source)source, (Receiver)new NamespaceReducer((Receiver)builder), (ParseOptions)parseOptions2);
            NodeInfo nodeInfo = builder.getCurrentRoot();
            if (!(nodeInfo instanceof DocumentInfo)) {
                throw new XPathException("Source object represents a node other than a document node");
            }
            builder.reset();
            DocumentInfo documentInfo = (DocumentInfo)nodeInfo;
            return documentInfo;
        }
        finally {
            if (bl) {
                ParseOptions.close((Source)source);
            }
        }
    }

    public Receiver makeEmitter(String string, Properties properties) throws XPathException {
        Object object;
        int n2 = string.indexOf(125);
        String string2 = string.substring(n2 + 1);
        int n3 = string2.indexOf(58);
        String string3 = string2.substring(n3 + 1);
        try {
            object = this.dynamicLoader.getInstance(string3, null);
        }
        catch (XPathException xPathException) {
            throw new XPathException("Cannot create user-supplied output method. " + xPathException.getMessage(), "SXCH0004");
        }
        if (object instanceof Receiver) {
            return (Receiver)object;
        }
        if (object instanceof ContentHandler) {
            ContentHandlerProxy contentHandlerProxy = new ContentHandlerProxy();
            contentHandlerProxy.setUnderlyingContentHandler((ContentHandler)object);
            contentHandlerProxy.setOutputProperties(properties);
            return contentHandlerProxy;
        }
        throw new XPathException("Output method " + string3 + " is neither a Receiver nor a SAX2 ContentHandler");
    }

    public NodeInfo makeUnconstructedElement(ElementCreator elementCreator, XPathContext xPathContext) throws XPathException {
        throw new XPathException("Lazy element construction requires Saxon-PE");
    }

    public DocumentInfo makeUnconstructedDocument(DocumentInstr documentInstr, XPathContext xPathContext) throws XPathException {
        throw new XPathException("Lazy document construction requires Saxon-PE");
    }

    public int getSiblingPosition(NodeInfo nodeInfo, NodeTest nodeTest, int n2) throws XPathException {
        AxisIterator axisIterator = nodeInfo.iterateAxis((byte)11, nodeTest);
        int n3 = 1;
        do {
            NodeInfo nodeInfo2;
            if ((nodeInfo2 = axisIterator.next()) != null) continue;
            return n3;
        } while (++n3 <= n2);
        return n3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setConfigurationProperty(String string, Object object) {
        if (string.equals("http://saxon.sf.net/feature/allow-external-functions")) {
            this.internalSetBooleanProperty(string, object);
            return;
        }
        if (string.equals("http://saxon.sf.net/feature/allow-multithreading")) {
            this.internalSetBooleanProperty(string, object);
            return;
        }
        if (string.equals("http://saxon.sf.net/feature/collation-uri-resolver")) {
            if (!(object instanceof CollationURIResolver)) {
                throw new IllegalArgumentException("COLLATION_URI_RESOLVER value must be an instance of net.sf.saxon.lib.CollationURIResolver");
            }
            this.setCollationURIResolver((CollationURIResolver)object);
            return;
        }
        if (string.equals("http://saxon.sf.net/feature/collation-uri-resolver-class")) {
            this.setCollationURIResolver((CollationURIResolver)this.instantiateClassName(string, object, CollationURIResolver.class));
            return;
        }
        if (string.equals("http://saxon.sf.net/feature/collection-uri-resolver")) {
            if (!(object instanceof CollectionURIResolver)) {
                throw new IllegalArgumentException("COLLECTION_URI_RESOLVER value must be an instance of net.sf.saxon.lib.CollectionURIResolver");
            }
            this.setCollectionURIResolver((CollectionURIResolver)object);
            return;
        }
        if (string.equals("http://saxon.sf.net/feature/collection-uri-resolver-class")) {
            this.setCollectionURIResolver((CollectionURIResolver)this.instantiateClassName(string, object, CollectionURIResolver.class));
            return;
        }
        if (string.equals("http://saxon.sf.net/feature/compile-with-tracing")) {
            boolean bl = this.requireBoolean("COMPILE_WITH_TRACING", object);
            this.setCompileWithTracing(bl);
            return;
        }
        if (string.equals("http://saxon.sf.net/feature/defaultCollation")) {
            this.getCollationMap().setDefaultCollationName(object.toString());
            return;
        }
        if (string.equals("http://saxon.sf.net/feature/defaultCollection")) {
            this.setDefaultCollection(object.toString());
            return;
        }
        if (string.equals("http://saxon.sf.net/feature/defaultCountry")) {
            this.setDefaultCountry(object.toString());
            return;
        }
        if (string.equals("http://saxon.sf.net/feature/defaultLanguage")) {
            this.setDefaultLanguage(object.toString());
            return;
        }
        if (string.equals("http://saxon.sf.net/feature/validation")) {
            boolean bl = this.requireBoolean(string, object);
            this.setValidation(bl);
            return;
        }
        if (string.equals("http://saxon.sf.net/feature/dtd-validation-recoverable")) {
            boolean bl = this.requireBoolean(string, object);
            if (bl) {
                this.defaultParseOptions.setDTDValidationMode(2);
                return;
            } else {
                this.defaultParseOptions.setDTDValidationMode(this.isValidation() ? 1 : 4);
            }
            return;
        }
        if (string.equals("http://saxon.sf.net/feature/entityResolverClass")) {
            if ("".equals(object)) {
                this.defaultParseOptions.setEntityResolver(null);
                return;
            } else {
                this.defaultParseOptions.setEntityResolver((EntityResolver)this.instantiateClassName(string, object, EntityResolver.class));
            }
            return;
        }
        if (string.equals("http://saxon.sf.net/feature/environmentVariableResolver")) {
            if (!(object instanceof EnvironmentVariableResolver)) {
                throw new IllegalArgumentException("ENVIRONMENT_VARIABLE_RESOLVER value must be an instance of net.sf.saxon.lib.EnvironmentVariableResolver");
            }
            this.environmentVariableResolver = (EnvironmentVariableResolver)object;
            return;
        }
        if (string.equals("http://saxon.sf.net/feature/environmentVariableResolverClass")) {
            this.environmentVariableResolver = (EnvironmentVariableResolver)this.instantiateClassName(string, object, EnvironmentVariableResolver.class);
            return;
        }
        if (string.equals("http://saxon.sf.net/feature/errorListenerClass")) {
            this.setErrorListener((ErrorListener)this.instantiateClassName(string, object, ErrorListener.class));
            return;
        }
        if (string.equals("http://saxon.sf.net/feature/expandAttributeDefaults")) {
            boolean bl = this.requireBoolean(string, object);
            this.setExpandAttributeDefaults(bl);
            return;
        }
        if (string.equals("http://saxon.sf.net/feature/ignoreSAXSourceParser")) {
            this.internalSetBooleanProperty(string, object);
            return;
        }
        if (string.equals("http://saxon.sf.net/feature/lazyConstructionMode")) {
            this.internalSetBooleanProperty(string, object);
            return;
        }
        if (string.equals("http://saxon.sf.net/feature/linenumbering")) {
            boolean bl = this.requireBoolean(string, object);
            this.setLineNumbering(bl);
            return;
        }
        if (string.equals("http://saxon.sf.net/feature/messageEmitterClass")) {
            if (!(object instanceof String)) {
                throw new IllegalArgumentException("MESSAGE_EMITTER_CLASS class must be a String");
            }
            this.setMessageEmitterClass((String)object);
            return;
        }
        if (string.equals("http://saxon.sf.net/feature/moduleURIResolver")) {
            if (!(object instanceof ModuleURIResolver)) {
                throw new IllegalArgumentException("MODULE_URI_RESOLVER value must be an instance of net.sf.saxon.lib.ModuleURIResolver");
            }
            this.setModuleURIResolver((ModuleURIResolver)object);
            return;
        }
        if (string.equals("http://saxon.sf.net/feature/moduleURIResolverClass")) {
            this.setModuleURIResolver((ModuleURIResolver)this.instantiateClassName(string, object, ModuleURIResolver.class));
            return;
        }
        if (string.equals("http://saxon.sf.net/feature/namePool")) {
            if (!(object instanceof NamePool)) {
                throw new IllegalArgumentException("NAME_POOL value must be an instance of net.sf.saxon.om.NamePool");
            }
            this.setNamePool((NamePool)object);
            return;
        }
        if (string.equals("http://saxon.sf.net/feature/optimizationLevel")) {
            String string2 = this.requireString(string, object);
            try {
                this.optimizationLevel = Integer.parseInt(string2);
                if (this.optimizationLevel < 0 || this.optimizationLevel > 10) {
                    throw new IllegalArgumentException("OPTIMIZATION_LEVEL must be in the range 0 to 10");
                }
                if (this.optimizer != null) {
                    this.optimizer.setOptimizationLevel(this.optimizationLevel);
                }
                if (this.optimizationLevel >= 10) return;
                this.internalSetBooleanProperty("http://saxon.sf.net/feature/generateByteCode", false);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("OPTIMIZATION_LEVEL value must be a number represented as a string");
            }
        }
        if (string.equals("http://saxon.sf.net/feature/outputURIResolver")) {
            if (!(object instanceof OutputURIResolver)) {
                throw new IllegalArgumentException("OUTPUT_URI_RESOLVER value must be an instance of net.sf.saxon.lib.OutputURIResolver");
            }
            this.setOutputURIResolver((OutputURIResolver)object);
            return;
        }
        if (string.equals("http://saxon.sf.net/feature/outputURIResolverClass")) {
            this.setOutputURIResolver((OutputURIResolver)this.instantiateClassName(string, object, OutputURIResolver.class));
            return;
        }
        if (string.equals("http://saxon.sf.net/feature/preEvaluateDocFunction")) {
            this.internalSetBooleanProperty(string, object);
            return;
        }
        if (string.equals("http://saxon.sf.net/feature/preferJaxpParser")) {
            this.internalSetBooleanProperty(string, object);
            return;
        }
        if (string.equals("http://saxon.sf.net/feature/recognize-uri-query-parameters")) {
            boolean bl = this.requireBoolean(string, object);
            this.getSystemURIResolver().setRecognizeQueryParameters(bl);
            return;
        }
        if (string.equals("http://saxon.sf.net/feature/recoveryPolicy")) {
            if (!(object instanceof Integer)) {
                throw new IllegalArgumentException("RECOVERY_POLICY value must be an Integer");
            }
            this.setRecoveryPolicy((Integer)object);
            return;
        }
        if (string.equals("http://saxon.sf.net/feature/recoveryPolicyName")) {
            int n2;
            if (!(object instanceof String)) {
                throw new IllegalArgumentException("RECOVERY_POLICY_NAME value must be a String");
            }
            if (object.equals("recoverSilently")) {
                n2 = 0;
            } else if (object.equals("recoverWithWarnings")) {
                n2 = 1;
            } else {
                if (!object.equals("doNotRecover")) throw new IllegalArgumentException("Unrecognized value of RECOVERY_POLICY_NAME = '" + object + "': must be 'recoverSilently', 'recoverWithWarnings', or 'doNotRecover'");
                n2 = 2;
            }
            this.setRecoveryPolicy(n2);
            return;
        }
        if (string.equals("http://saxon.sf.net/feature/serializerFactoryClass")) {
            this.setSerializerFactory((SerializerFactory)this.instantiateClassName(string, object, OutputURIResolver.class));
            return;
        }
        if (string.equals("http://saxon.sf.net/feature/schemaURIResolver")) {
            if (!(object instanceof SchemaURIResolver)) {
                throw new IllegalArgumentException("SCHEMA_URI_RESOLVER value must be an instance of net.sf.saxon.lib.SchemaURIResolver");
            }
            this.setSchemaURIResolver((SchemaURIResolver)object);
            return;
        }
        if (string.equals("http://saxon.sf.net/feature/schemaURIResolverClass")) {
            this.setSchemaURIResolver((SchemaURIResolver)this.instantiateClassName(string, object, SchemaURIResolver.class));
            return;
        }
        if (string.equals("http://saxon.sf.net/feature/schema-validation")) {
            if (!(object instanceof Integer)) {
                throw new IllegalArgumentException("SCHEMA_VALIDATION must be an integer");
            }
            this.setSchemaValidationMode((Integer)object);
            return;
        }
        if (string.equals("http://saxon.sf.net/feature/schema-validation-mode")) {
            if (!(object instanceof String)) {
                throw new IllegalArgumentException("SCHEMA_VALIDATION_MODE must be a string");
            }
            this.setSchemaValidationMode(Validation.getCode((String)((String)object)));
            return;
        }
        if (string.equals("http://saxon.sf.net/feature/sourceParserClass")) {
            if (!(object instanceof String)) {
                throw new IllegalArgumentException("SOURCE_PARSER_CLASS class must be a String");
            }
            this.setSourceParserClass((String)object);
            return;
        }
        if (string.equals("http://saxon.sf.net/feature/sourceResolverClass")) {
            this.setSourceResolver((SourceResolver)this.instantiateClassName(string, object, SourceResolver.class));
            return;
        }
        if (string.equals("http://saxon.sf.net/feature/standardErrorOutputFile")) {
            try {
                boolean bl = true;
                boolean bl2 = true;
                this.setStandardErrorOutput(new PrintStream(new FileOutputStream((String)object, bl), bl2));
                return;
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new IllegalArgumentException(fileNotFoundException);
            }
        }
        if (string.equals("http://saxon.sf.net/feature/strip-whitespace")) {
            int n3;
            String string3 = this.requireString(string, object);
            if (string3.equals("all")) {
                n3 = 2;
            } else if (string3.equals("none")) {
                n3 = 0;
            } else {
                if (!string3.equals("ignorable")) throw new IllegalArgumentException("Unrecognized value STRIP_WHITESPACE = '" + object + "': must be 'all', 'none', or 'ignorable'");
                n3 = 1;
            }
            this.setStripsWhiteSpace(n3);
            return;
        }
        if (string.equals("http://saxon.sf.net/feature/styleParserClass")) {
            this.setStyleParserClass(this.requireString(string, object));
            return;
        }
        if (string.equals("http://saxon.sf.net/feature/timing")) {
            this.setTiming(this.requireBoolean(string, object));
            return;
        }
        if (string.equals("http://saxon.sf.net/feature/trace-external-functions")) {
            this.internalSetBooleanProperty("http://saxon.sf.net/feature/trace-external-functions", object);
            return;
        }
        if (string.equals("http://saxon.sf.net/feature/trace-optimizer-decisions")) {
            this.internalSetBooleanProperty(string, object);
            return;
        }
        if (string.equals("http://saxon.sf.net/feature/traceListener")) {
            if (!(object instanceof TraceListener)) {
                throw new IllegalArgumentException("TRACE_LISTENER is of wrong class");
            }
            this.setTraceListener((TraceListener)object);
            return;
        }
        if (string.equals("http://saxon.sf.net/feature/traceListenerClass")) {
            this.setTraceListenerClass(this.requireString(string, object));
            return;
        }
        if (string.equals("http://saxon.sf.net/feature/treeModel")) {
            if (!(object instanceof Integer)) {
                throw new IllegalArgumentException("Tree model must be an Integer");
            }
            this.setTreeModel((Integer)object);
            return;
        }
        if (string.equals("http://saxon.sf.net/feature/treeModelName")) {
            String string4 = this.requireString(string, object);
            if (string4.equals("tinyTree")) {
                this.setTreeModel(1);
                return;
            } else if (string4.equals("tinyTreeCondensed")) {
                this.setTreeModel(2);
                return;
            } else if (string4.equals("linkedTree")) {
                this.setTreeModel(0);
                return;
            } else if (string4.equals("jdom")) {
                this.setTreeModel(3);
                return;
            } else {
                if (!string4.equals("jdom2")) throw new IllegalArgumentException("Unrecognized value TREE_MODEL_NAME = '" + object + "': must be linkedTree|tinyTree|tinyTreeCondensed");
                this.setTreeModel(4);
            }
            return;
        }
        if (string.equals("http://saxon.sf.net/feature/uriResolverClass")) {
            this.setURIResolver((URIResolver)this.instantiateClassName(string, object, URIResolver.class));
            return;
        }
        if (string.equals("http://saxon.sf.net/feature/use-pi-disable-output-escaping")) {
            this.internalSetBooleanProperty(string, object);
            return;
        }
        if (string.equals("http://saxon.sf.net/feature/use-typed-value-cache")) {
            this.internalSetBooleanProperty(string, object);
            return;
        }
        if (string.equals("http://saxon.sf.net/feature/useXsiSchemaLocation")) {
            this.defaultParseOptions.setUseXsiSchemaLocation(this.requireBoolean(string, object));
            return;
        }
        if (string.equals("http://saxon.sf.net/feature/validation-comments")) {
            this.defaultParseOptions.setAddCommentsAfterValidationErrors(this.requireBoolean(string, object));
            return;
        }
        if (string.equals("http://saxon.sf.net/feature/validation-warnings")) {
            this.setValidationWarnings(this.requireBoolean(string, object));
            return;
        }
        if (string.equals("http://saxon.sf.net/feature/version-warning")) {
            this.setVersionWarning(this.requireBoolean(string, object));
            return;
        }
        if (string.equals("http://saxon.sf.net/feature/xinclude-aware")) {
            this.setXIncludeAware(this.requireBoolean(string, object));
            return;
        }
        if (string.equals("http://saxon.sf.net/feature/xqueryAllowUpdate")) {
            this.getDefaultStaticQueryContext().setUpdatingEnabled(this.requireBoolean(string, object));
            return;
        }
        if (string.equals("http://saxon.sf.net/feature/xqueryConstructionMode")) {
            this.getDefaultStaticQueryContext().setConstructionMode(Validation.getCode((String)object.toString()));
            return;
        }
        if (string.equals("http://saxon.sf.net/feature/xqueryDefaultElementNamespace")) {
            this.getDefaultStaticQueryContext().setDefaultElementNamespace(object.toString());
            return;
        }
        if (string.equals("http://saxon.sf.net/feature/xqueryDefaultFunctionNamespace")) {
            this.getDefaultStaticQueryContext().setDefaultFunctionNamespace(object.toString());
            return;
        }
        if (string.equals("http://saxon.sf.net/feature/xqueryEmptyLeast")) {
            this.getDefaultStaticQueryContext().setEmptyLeast(this.requireBoolean(string, object));
            return;
        }
        if (string.equals("http://saxon.sf.net/feature/xqueryInheritNamespaces")) {
            this.getDefaultStaticQueryContext().setInheritNamespaces(this.requireBoolean(string, object));
            return;
        }
        if (string.equals("http://saxon.sf.net/feature/xqueryPreserveBoundarySpace")) {
            this.getDefaultStaticQueryContext().setPreserveBoundarySpace(this.requireBoolean(string, object));
            return;
        }
        if (string.equals("http://saxon.sf.net/feature/xqueryPreserveNamespaces")) {
            this.getDefaultStaticQueryContext().setPreserveNamespaces(this.requireBoolean(string, object));
            return;
        }
        if (string.equals("http://saxon.sf.net/feature/xqueryRequiredContextItemType")) {
            ExpressionParser expressionParser = new ExpressionParser();
            expressionParser.setLanguage(2, DecimalValue.THREE);
            try {
                SequenceType sequenceType = expressionParser.parseSequenceType(object.toString(), (StaticContext)new IndependentContext(this));
                this.getDefaultStaticQueryContext().setRequiredContextItemType(sequenceType.getPrimaryType());
                return;
            }
            catch (XPathException xPathException) {
                throw new IllegalArgumentException(xPathException);
            }
        }
        if (string.equals("http://saxon.sf.net/feature/xquerySchemaAware")) {
            this.getDefaultStaticQueryContext().setSchemaAware(this.requireBoolean(string, object));
            return;
        }
        if (string.equals("http://saxon.sf.net/feature/xqueryStaticErrorListenerClass")) {
            this.getDefaultStaticQueryContext().setErrorListener((ErrorListener)this.instantiateClassName(string, object, ErrorListener.class));
            return;
        }
        if (string.equals("http://saxon.sf.net/feature/xqueryVersion")) {
            DecimalValue decimalValue;
            if ("1.1".equals(object)) {
                object = "3.0";
            }
            try {
                decimalValue = (DecimalValue)DecimalValue.makeDecimalValue((CharSequence)object.toString(), (boolean)true);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("XQuery version");
            }
            this.getDefaultStaticQueryContext().setLanguageVersion(decimalValue);
            return;
        }
        if (string.equals("http://saxon.sf.net/feature/xml-version") || string.equals("http://saxon.sf.bet/feature/xml-version")) {
            String string5 = this.requireString(string, object);
            if (!string5.equals("1.0") && !string5.equals("1.1")) {
                throw new IllegalArgumentException("XML_VERSION value must be \"1.0\" or \"1.1\" as a String");
            }
            this.setXMLVersion(string5.equals("1.0") ? 10 : 11);
            return;
        } else if (string.equals("http://saxon.sf.net/feature/xsd-version")) {
            String string6 = this.requireString(string, object);
            if (!string6.equals("1.0") && !string6.equals("1.1")) {
                throw new IllegalArgumentException("XSD_VERSION value must be \"1.0\" or \"1.1\" as a String");
            }
            this.xsdVersion = object.equals("1.0") ? 10 : 11;
            this.theConversionRules = null;
            return;
        } else if (string.equals("http://saxon.sf.net/feature/initialMode")) {
            String string7 = this.requireString(string, object);
            this.getDefaultXsltCompilerInfo().setDefaultInitialMode(StructuredQName.fromClarkName((String)string7));
            return;
        } else if (string.equals("http://saxon.sf.net/feature/initialTemplate")) {
            String string8 = this.requireString(string, object);
            this.getDefaultXsltCompilerInfo().setDefaultInitialTemplate(StructuredQName.fromClarkName((String)string8));
            return;
        } else if (string.equals("http://saxon.sf.net/feature/xsltSchemaAware")) {
            this.getDefaultXsltCompilerInfo().setSchemaAware(this.requireBoolean(string, object));
            return;
        } else if (string.equals("http://saxon.sf.net/feature/stylesheetErrorListener")) {
            this.getDefaultXsltCompilerInfo().setErrorListener((ErrorListener)this.instantiateClassName(string, object, ErrorListener.class));
            return;
        } else if (string.equals("http://saxon.sf.net/feature/stylesheetURIResolver")) {
            this.getDefaultXsltCompilerInfo().setURIResolver((URIResolver)this.instantiateClassName(string, object, URIResolver.class));
            return;
        } else if (string.equals("http://saxon.sf.net/feature/xsltVersion")) {
            try {
                if ("2.1".equals(object)) {
                    object = "3.0";
                }
                ConversionResult conversionResult = DecimalValue.makeDecimalValue((CharSequence)this.requireString(string, object), (boolean)true);
                DecimalValue decimalValue = (DecimalValue)conversionResult.asAtomic();
                this.getDefaultXsltCompilerInfo().setXsltVersion(decimalValue);
                return;
            }
            catch (ValidationException validationException) {
                throw new IllegalArgumentException("XSLT version must be a decimal number");
            }
        } else {
            if (!string.equals("STOP_HANDLER")) throw new IllegalArgumentException("Unknown configuration option " + string);
            this.transformationStopper = object;
        }
    }

    protected boolean requireBoolean(String string, Object object) {
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            if ("true".equals(object) || "on".equals(object) || "yes".equals(object) || "1".equals(object)) {
                return true;
            }
            if ("false".equals(object) || "off".equals(object) || "no".equals(object) || "0".equals(object)) {
                return false;
            }
            throw new IllegalArgumentException(string + " must be 'true' or 'false' (or on|off, yes|no, 1|0)");
        }
        throw new IllegalArgumentException(string + " must be a boolean (or a string representing a boolean)");
    }

    protected void internalSetBooleanProperty(String string, Object object) {
        boolean bl = this.requireBoolean(string, object);
        if (bl) {
            this.enabledProperties.add(string);
        } else {
            this.enabledProperties.remove(string);
        }
    }

    public boolean getBooleanProperty(String string) {
        return this.enabledProperties.contains(string);
    }

    public void setBooleanProperty(String string, boolean bl) {
        this.setConfigurationProperty(string, bl);
    }

    protected String requireString(String string, Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        throw new IllegalArgumentException("The value of " + string + " must be a string");
    }

    protected Object instantiateClassName(String string, Object object, Class clazz) {
        if (!(object instanceof String)) {
            throw new IllegalArgumentException(string + " must be a String");
        }
        try {
            Object object2 = this.getInstance((String)object, null);
            if (!clazz.isAssignableFrom(object2.getClass())) {
                throw new IllegalArgumentException("Error in " + string + ": Class " + object + " does not implement " + clazz.getName());
            }
            return object2;
        }
        catch (XPathException xPathException) {
            throw new IllegalArgumentException("Cannot use " + object + " as the value of " + string + ". " + xPathException.getMessage());
        }
    }

    public Object getConfigurationProperty(String string) {
        if (string.equals("http://saxon.sf.net/feature/allow-external-functions")) {
            return this.getBooleanProperty(string);
        }
        if (string.equals("http://saxon.sf.net/feature/allow-multithreading")) {
            return this.getBooleanProperty(string);
        }
        if (string.equals("http://saxon.sf.net/feature/collation-uri-resolver")) {
            return this.getCollationURIResolver();
        }
        if (string.equals("http://saxon.sf.net/feature/collation-uri-resolver-class")) {
            return this.getCollationURIResolver().getClass().getName();
        }
        if (string.equals("http://saxon.sf.net/feature/collection-uri-resolver")) {
            return this.getCollectionURIResolver();
        }
        if (string.equals("http://saxon.sf.net/feature/collection-uri-resolver-class")) {
            return this.getCollectionURIResolver().getClass().getName();
        }
        if (string.equals("http://saxon.sf.net/feature/generateByteCode")) {
            return this.getBooleanProperty(string);
        }
        if (string.equals("http://saxon.sf.net/feature/compile-with-tracing")) {
            return this.isCompileWithTracing();
        }
        if (string.equals("http://saxon.sf.net/feature/defaultCollation")) {
            return this.getCollationMap().getDefaultCollationName();
        }
        if (string.equals("http://saxon.sf.net/feature/defaultCollection")) {
            return this.getDefaultCollection();
        }
        if (string.equals("http://saxon.sf.net/feature/defaultCountry")) {
            return this.getDefaultCountry();
        }
        if (string.equals("http://saxon.sf.net/feature/defaultLanguage")) {
            return this.getDefaultLanguage();
        }
        if (string.equals("http://saxon.sf.net/feature/validation")) {
            return this.isValidation();
        }
        if (string.equals("http://saxon.sf.net/feature/dtd-validation-recoverable")) {
            return this.defaultParseOptions.getDTDValidationMode() == 2;
        }
        if (string.equals("http://saxon.sf.net/feature/errorListenerClass")) {
            return this.getErrorListener().getClass().getName();
        }
        if (string.equals("http://saxon.sf.net/feature/entityResolverClass")) {
            EntityResolver entityResolver = this.defaultParseOptions.getEntityResolver();
            if (entityResolver == null) {
                return "";
            }
            return entityResolver.getClass().getName();
        }
        if (string.equals("http://saxon.sf.net/feature/environmentVariableResolver")) {
            return this.environmentVariableResolver;
        }
        if (string.equals("http://saxon.sf.net/feature/environmentVariableResolverClass")) {
            return this.environmentVariableResolver.getClass().getName();
        }
        if (string.equals("http://saxon.sf.net/feature/expandAttributeDefaults")) {
            return this.isExpandAttributeDefaults();
        }
        if (string.equals("http://saxon.sf.net/feature/ignoreSAXSourceParser")) {
            return this.getBooleanProperty(string);
        }
        if (string.equals("http://saxon.sf.net/feature/lazyConstructionMode")) {
            return this.getBooleanProperty(string);
        }
        if (string.equals("http://saxon.sf.net/feature/linenumbering")) {
            return this.isLineNumbering();
        }
        if (string.equals("http://saxon.sf.net/feature/messageEmitterClass")) {
            return this.getMessageEmitterClass();
        }
        if (string.equals("http://saxon.sf.net/feature/moduleURIResolver")) {
            return this.getModuleURIResolver();
        }
        if (string.equals("http://saxon.sf.net/feature/moduleURIResolverClass")) {
            return this.getModuleURIResolver().getClass().getName();
        }
        if (string.equals("http://saxon.sf.net/feature/namePool")) {
            return this.getNamePool();
        }
        if (string.equals("http://saxon.sf.net/feature/optimizationLevel")) {
            return "" + this.optimizationLevel;
        }
        if (string.equals("http://saxon.sf.net/feature/outputURIResolver")) {
            return this.getOutputURIResolver();
        }
        if (string.equals("http://saxon.sf.net/feature/outputURIResolverClass")) {
            return this.getOutputURIResolver().getClass().getName();
        }
        if (string.equals("http://saxon.sf.net/feature/preEvaluateDocFunction")) {
            return this.getBooleanProperty(string);
        }
        if (string.equals("http://saxon.sf.net/feature/preferJaxpParser")) {
            return this.getBooleanProperty(string);
        }
        if (string.equals("http://saxon.sf.net/feature/recognize-uri-query-parameters")) {
            return this.getSystemURIResolver().queryParametersAreRecognized();
        }
        if (string.equals("http://saxon.sf.net/feature/recoveryPolicy")) {
            return this.getRecoveryPolicy();
        }
        if (string.equals("http://saxon.sf.net/feature/recoveryPolicyName")) {
            switch (this.getRecoveryPolicy()) {
                case 0: {
                    return "recoverSilently";
                }
                case 1: {
                    return "recoverWithWarnings";
                }
                case 2: {
                    return "doNotRecover";
                }
            }
            throw new IllegalStateException();
        }
        if (string.equals("http://saxon.sf.net/feature/schemaURIResolver")) {
            return this.getSchemaURIResolver();
        }
        if (string.equals("http://saxon.sf.net/feature/schemaURIResolverClass")) {
            return this.getSchemaURIResolver().getClass().getName();
        }
        if (string.equals("http://saxon.sf.net/feature/schema-validation")) {
            return this.getSchemaValidationMode();
        }
        if (string.equals("http://saxon.sf.net/feature/schema-validation-mode")) {
            return Validation.toString((int)this.getSchemaValidationMode());
        }
        if (string.equals("http://saxon.sf.net/feature/serializerFactoryClass")) {
            return this.getSerializerFactory().getClass().getName();
        }
        if (string.equals("http://saxon.sf.net/feature/sourceParserClass")) {
            return this.getSourceParserClass();
        }
        if (string.equals("http://saxon.sf.net/feature/sourceResolverClass")) {
            return this.getSourceResolver().getClass().getName();
        }
        if (string.equals("http://saxon.sf.net/feature/strip-whitespace")) {
            int n2 = this.getStripsWhiteSpace();
            if (n2 == 2) {
                return "all";
            }
            if (n2 == 1) {
                return "ignorable";
            }
            return "none";
        }
        if (string.equals("http://saxon.sf.net/feature/styleParserClass")) {
            return this.getStyleParserClass();
        }
        if (string.equals("http://saxon.sf.net/feature/timing")) {
            return this.isTiming();
        }
        if (string.equals("http://saxon.sf.net/feature/traceListener")) {
            return this.traceListener;
        }
        if (string.equals("http://saxon.sf.net/feature/traceListenerClass")) {
            return this.traceListenerClass;
        }
        if (string.equals("http://saxon.sf.net/feature/trace-external-functions")) {
            return this.getBooleanProperty(string);
        }
        if (string.equals("http://saxon.sf.net/feature/trace-optimizer-decisions")) {
            return this.getBooleanProperty(string);
        }
        if (string.equals("http://saxon.sf.net/feature/treeModel")) {
            return this.getTreeModel();
        }
        if (string.equals("http://saxon.sf.net/feature/treeModelName")) {
            switch (this.getTreeModel()) {
                default: {
                    return "tinyTree";
                }
                case 2: {
                    return "tinyTreeCondensed";
                }
                case 0: 
            }
            return "linkedTree";
        }
        if (string.equals("http://saxon.sf.net/feature/uriResolverClass")) {
            return this.getURIResolver().getClass().getName();
        }
        if (string.equals("http://saxon.sf.net/feature/use-pi-disable-output-escaping")) {
            return this.getBooleanProperty(string);
        }
        if (string.equals("http://saxon.sf.net/feature/use-typed-value-cache")) {
            return this.getBooleanProperty(string);
        }
        if (string.equals("http://saxon.sf.net/feature/useXsiSchemaLocation")) {
            return this.defaultParseOptions.isUseXsiSchemaLocation();
        }
        if (string.equals("http://saxon.sf.net/feature/validation-comments")) {
            return this.defaultParseOptions.isAddCommentsAfterValidationErrors();
        }
        if (string.equals("http://saxon.sf.net/feature/validation-warnings")) {
            return this.isValidationWarnings();
        }
        if (string.equals("http://saxon.sf.net/feature/version-warning")) {
            return this.isVersionWarning();
        }
        if (string.equals("http://saxon.sf.net/feature/xinclude-aware")) {
            return this.isXIncludeAware();
        }
        if (string.equals("http://saxon.sf.net/feature/xml-version")) {
            return this.getXMLVersion() == 10 ? "1.0" : "1.1";
        }
        if (string.equals("http://saxon.sf.net/feature/xqueryAllowUpdate")) {
            return this.getDefaultStaticQueryContext().isUpdatingEnabled();
        }
        if (string.equals("http://saxon.sf.net/feature/xqueryConstructionMode")) {
            return this.getDefaultStaticQueryContext().getConstructionMode();
        }
        if (string.equals("http://saxon.sf.net/feature/xqueryDefaultElementNamespace")) {
            return this.getDefaultStaticQueryContext().getDefaultElementNamespace();
        }
        if (string.equals("http://saxon.sf.net/feature/xqueryDefaultFunctionNamespace")) {
            return this.getDefaultStaticQueryContext().getDefaultFunctionNamespace();
        }
        if (string.equals("http://saxon.sf.net/feature/xqueryEmptyLeast")) {
            return this.getDefaultStaticQueryContext().isEmptyLeast();
        }
        if (string.equals("http://saxon.sf.net/feature/xqueryInheritNamespaces")) {
            return this.getDefaultStaticQueryContext().isInheritNamespaces();
        }
        if (string.equals("http://saxon.sf.net/feature/xqueryPreserveBoundarySpace")) {
            return this.getDefaultStaticQueryContext().isPreserveBoundarySpace();
        }
        if (string.equals("http://saxon.sf.net/feature/xqueryPreserveNamespaces")) {
            return this.getDefaultStaticQueryContext().isPreserveNamespaces();
        }
        if (string.equals("http://saxon.sf.net/feature/xqueryRequiredContextItemType")) {
            return this.getDefaultStaticQueryContext().getRequiredContextItemType();
        }
        if (string.equals("http://saxon.sf.net/feature/xquerySchemaAware")) {
            return this.getDefaultStaticQueryContext().isSchemaAware();
        }
        if (string.equals("http://saxon.sf.net/feature/xqueryStaticErrorListenerClass")) {
            return this.getDefaultStaticQueryContext().getErrorListener().getClass().getName();
        }
        if (string.equals("http://saxon.sf.net/feature/xqueryVersion")) {
            return this.getDefaultStaticQueryContext().getLanguageVersion();
        }
        if (string.equals("http://saxon.sf.net/feature/xsd-version")) {
            return this.xsdVersion == 10 ? "1.0" : "1.1";
        }
        if (string.equals("http://saxon.sf.net/feature/initialMode")) {
            return this.getDefaultXsltCompilerInfo().getDefaultInitialMode().getClarkName();
        }
        if (string.equals("http://saxon.sf.net/feature/initialTemplate")) {
            return this.getDefaultXsltCompilerInfo().getDefaultInitialTemplate().getClarkName();
        }
        if (string.equals("http://saxon.sf.net/feature/xsltSchemaAware")) {
            return this.defaultXsltCompilerInfo.isSchemaAware();
        }
        if (string.equals("http://saxon.sf.net/feature/stylesheetErrorListener")) {
            return this.getDefaultXsltCompilerInfo().getErrorListener().getClass().getName();
        }
        if (string.equals("http://saxon.sf.net/feature/stylesheetURIResolver")) {
            return this.getDefaultXsltCompilerInfo().getURIResolver().getClass().getName();
        }
        if (string.equals("http://saxon.sf.net/feature/xsltVersion")) {
            return this.getDefaultXsltCompilerInfo().getXsltVersion().toString();
        }
        if (string.equals("STOP_HANDLER")) {
            return this.transformationStopper;
        }
        throw new IllegalArgumentException("Unknown attribute " + string);
    }

    public boolean isGenerateByteCode(int n2) {
        return this.getBooleanProperty("http://saxon.sf.net/feature/generateByteCode") && this.isLicensedFeature(n2 == 50 ? 2 : 4);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.standardErrorOutput != System.err) {
            this.standardErrorOutput.close();
        }
    }

    public static Platform makePlatform() {
        Platform platform = null;
        try {
            platform = (Platform)Class.forName("com.saxonica.config.JavaPlatformPE").newInstance();
        }
        catch (Exception exception) {
            platform = new JavaPlatform();
        }
        return platform;
    }

    public static Class<? extends Configuration> makeConfigurationClass() {
        Class<Object> clazz = null;
        try {
            clazz = Class.forName("com.saxonica.config.EnterpriseConfiguration");
        }
        catch (Exception exception) {
            clazz = Configuration.class;
        }
        return clazz;
    }

    public static String setSoftwareEdition() {
        String string = "HE";
        string = "EE";
        return string;
    }

    public static class LicenseFeature {
        public static final int SCHEMA_VALIDATION = 1;
        public static final int ENTERPRISE_XSLT = 2;
        public static final int ENTERPRISE_XQUERY = 4;
        public static final int PROFESSIONAL_EDITION = 8;
    }
}

