/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import com.saxonica.bytecode.ExpressionCompiler;
import com.saxonica.bytecode.InterpretedExpressionCompiler;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.Controller;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.TreeReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.Message;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.instruct.TerminationException;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.lib.SerializerFactory;
import net.sf.saxon.lib.StandardErrorListener;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.TypeHierarchy;

public class MessageSaxon
extends Instruction {
    private Expression terminate;
    private Expression select;
    private Expression errorCode;
    private NamespaceResolver nsResolver;
    private boolean isAssert;

    public MessageSaxon(Expression expression, Expression expression2, Expression expression3) {
        this.terminate = expression2;
        this.select = expression;
        this.errorCode = expression3;
        this.adoptChildExpression(expression2);
        this.adoptChildExpression(expression);
    }

    public void setIsAssert(boolean bl) {
        this.isAssert = bl;
    }

    public void setNamespaceResolver(NamespaceResolver namespaceResolver) {
        this.nsResolver = namespaceResolver;
    }

    @Override
    public Expression simplify(ExpressionVisitor expressionVisitor) throws XPathException {
        this.select = expressionVisitor.simplify(this.select);
        this.terminate = expressionVisitor.simplify(this.terminate);
        this.errorCode = expressionVisitor.simplify(this.errorCode);
        return this;
    }

    public Expression typeCheck(ExpressionVisitor expressionVisitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        this.select = expressionVisitor.typeCheck(this.select, contextItemType);
        this.adoptChildExpression(this.select);
        this.terminate = expressionVisitor.typeCheck(this.terminate, contextItemType);
        this.adoptChildExpression(this.terminate);
        this.errorCode = expressionVisitor.typeCheck(this.errorCode, contextItemType);
        this.adoptChildExpression(this.errorCode);
        return this;
    }

    public Expression optimize(ExpressionVisitor expressionVisitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        this.select = expressionVisitor.optimize(this.select, contextItemType);
        this.adoptChildExpression(this.select);
        this.terminate = expressionVisitor.optimize(this.terminate, contextItemType);
        this.adoptChildExpression(this.terminate);
        this.errorCode = expressionVisitor.optimize(this.errorCode, contextItemType);
        this.adoptChildExpression(this.errorCode);
        return this;
    }

    public Expression copy() {
        return new Message(this.select.copy(), this.terminate.copy(), this.errorCode.copy());
    }

    @Override
    public int getInstructionNameCode() {
        return this.isAssert ? 133 : 173;
    }

    @Override
    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return AnyItemType.getInstance();
    }

    public int getCardinality() {
        return 24576;
    }

    @Override
    public final boolean createsNewNodes() {
        return true;
    }

    @Override
    protected void promoteInst(PromotionOffer promotionOffer) throws XPathException {
        this.select = this.doPromotion(this.select, promotionOffer);
        this.terminate = this.doPromotion(this.terminate, promotionOffer);
        this.errorCode = this.doPromotion(this.errorCode, promotionOffer);
    }

    public int getStreamability(int n2, boolean bl, List<String> list) {
        Iterator<Expression> iterator = this.iterateSubExpressions();
        int n3 = 3;
        while (iterator.hasNext()) {
            Expression expression = iterator.next();
            int n4 = expression.getStreamability(0, bl, null);
            if (expression == this.select) {
                n3 = n4;
                continue;
            }
            if (n4 == 0) continue;
            return 3;
        }
        return n3;
    }

    public Iterator<Expression> iterateSubExpressions() {
        Expression[] expressionArray = new Expression[]{this.select, this.terminate, this.errorCode};
        return Arrays.asList(expressionArray).iterator();
    }

    public boolean replaceSubExpression(Expression expression, Expression expression2) {
        boolean bl = false;
        if (this.select == expression) {
            this.select = expression2;
            bl = true;
        }
        if (this.terminate == expression) {
            this.terminate = expression2;
            bl = true;
        }
        if (this.errorCode == expression) {
            this.errorCode = expression2;
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TailCall processLeavingTail(XPathContext xPathContext) throws XPathException {
        Controller controller = xPathContext.getController();
        assert (controller != null);
        Receiver receiver = controller.getMessageEmitter();
        if (receiver != null) {
            Receiver receiver2 = receiver;
            synchronized (receiver2) {
                Item item;
                Object object = new TreeReceiver(receiver);
                object = new AttributeMasker((SequenceReceiver)object);
                SequenceReceiver sequenceReceiver = xPathContext.getReceiver();
                Properties properties = new Properties();
                properties.setProperty("omit-xml-declaration", "yes");
                SerializerFactory serializerFactory = xPathContext.getConfiguration().getSerializerFactory();
                PipelineConfiguration pipelineConfiguration = controller.makePipelineConfiguration();
                pipelineConfiguration.setHostLanguage(50);
                Receiver receiver3 = serializerFactory.getReceiver((Result)object, pipelineConfiguration, properties);
                xPathContext.changeOutputDestination(receiver3, null);
                boolean bl = false;
                String string = ((Object)this.terminate.evaluateAsString(xPathContext)).toString();
                if (!string.equals("no")) {
                    if (string.equals("yes")) {
                        bl = true;
                    } else {
                        XPathException xPathException = new XPathException("The terminate attribute of xsl:message must be 'yes' or 'no'");
                        xPathException.setXPathContext(xPathContext);
                        xPathException.setErrorCode("XTDE0030");
                        throw xPathException;
                    }
                }
                object.startDocument(bl ? 16384 : 0);
                SequenceIterator sequenceIterator = this.select.iterate(xPathContext);
                while ((item = sequenceIterator.next()) != null) {
                    object.append(item, this.locationId, 2);
                }
                object.endDocument();
                xPathContext.setReceiver(sequenceReceiver);
                if (bl) {
                    item = new TerminationException("Processing terminated by " + StandardErrorListener.getInstructionName((Instruction)this) + " at line " + this.getLineNumber() + " in " + StandardErrorListener.abbreviatePath((String)this.getSystemId()));
                    try {
                        String string2 = ((Object)this.errorCode.evaluateAsString(xPathContext)).toString();
                        StructuredQName structuredQName = StructuredQName.fromLexicalQName((CharSequence)string2, (boolean)false, (boolean)true, (NameChecker)xPathContext.getConfiguration().getNameChecker(), (NamespaceResolver)this.nsResolver);
                        item.setErrorCodeQName(structuredQName);
                        item.setLocator((SourceLocator)this);
                    }
                    catch (XPathException xPathException) {
                        // empty catch block
                    }
                    throw item;
                }
                return null;
            }
        }
        return null;
    }

    public void explain(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("xslMessage");
        expressionPresenter.endElement();
    }

    public ExpressionCompiler getExpressionCompiler() {
        return new InterpretedExpressionCompiler();
    }

    private static class AttributeMasker
    extends ProxyReceiver {
        private boolean contentStarted = true;

        public AttributeMasker(SequenceReceiver sequenceReceiver) {
            super((Receiver)sequenceReceiver);
        }

        public void startElement(NodeName nodeName, SchemaType schemaType, int n2, int n3) throws XPathException {
            this.contentStarted = false;
            super.startElement(nodeName, schemaType, n2, n3);
        }

        public void startContent() throws XPathException {
            this.contentStarted = true;
            super.startContent();
        }

        public void attribute(NodeName nodeName, SimpleType simpleType, CharSequence charSequence, int n2, int n3) throws XPathException {
            if (this.contentStarted) {
                String string = nodeName.getDisplayName();
                this.processingInstruction("attribute", "name=\"" + string + "\" value=\"" + charSequence + "\"", 0, 0);
            } else {
                super.attribute(nodeName, simpleType, charSequence, n2, n3);
            }
        }

        public void namespace(NamespaceBinding namespaceBinding, int n2) throws XPathException {
            if (this.contentStarted) {
                String string = namespaceBinding.getPrefix();
                String string2 = namespaceBinding.getURI();
                this.processingInstruction("namespace", "prefix=\"" + string + "\" uri=\"" + string2 + "\"", 0, 0);
            } else {
                super.namespace(namespaceBinding, n2);
            }
        }

        public void append(Item item, int n2, int n3) throws XPathException {
            int n4;
            if (item instanceof NodeInfo && ((n4 = ((NodeInfo)item).getNodeKind()) == 2 || n4 == 13)) {
                ((NodeInfo)item).copy((Receiver)this, 0, 0);
                return;
            }
            ((SequenceReceiver)this.nextReceiver).append(item, n2, n3);
        }
    }
}

