/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import com.saxonica.bytecode.ExpressionCompiler;
import com.saxonica.bytecode.ResultDocumentCompiler;
import com.saxonica.stream.adjunct.DivisibleInstruction;
import com.saxonica.stream.adjunct.ResultDocumentAdjunct;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Stack;
import javax.xml.transform.Result;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.DocumentInstr;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.instruct.ValidatingInstruction;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.functions.EscapeURI;
import net.sf.saxon.lib.OutputURIResolver;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.SaxonOutputKeys;
import net.sf.saxon.lib.SerializerFactory;
import net.sf.saxon.lib.StandardOutputResolver;
import net.sf.saxon.om.DocumentURI;
import net.sf.saxon.om.InscopeNamespaceResolver;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Whitespace;
import net.sf.saxon.z.IntHashMap;
import net.sf.saxon.z.IntIterator;

public class ResultDocument
extends Instruction
implements ValidatingInstruction,
DivisibleInstruction {
    protected Expression href;
    protected Expression formatExpression;
    protected Expression content;
    private boolean async = false;
    protected Properties globalProperties;
    protected Properties localProperties;
    protected String baseURI;
    protected ParseOptions validationOptions;
    protected IntHashMap<Expression> serializationAttributes;
    protected NamespaceResolver nsResolver;
    protected Expression dynamicOutputElement;
    protected boolean resolveAgainstStaticBase = false;

    public ResultDocument(Properties properties, Properties properties2, Expression expression, Expression expression2, String string, int n2, SchemaType schemaType, IntHashMap<Expression> intHashMap, NamespaceResolver namespaceResolver) {
        this.globalProperties = properties;
        this.localProperties = properties2;
        this.href = expression;
        this.formatExpression = expression2;
        this.baseURI = string;
        this.setValidationAction(n2, schemaType);
        this.serializationAttributes = intHashMap;
        this.nsResolver = namespaceResolver;
        this.adoptChildExpression(expression);
        Iterator iterator = intHashMap.valueIterator();
        while (iterator.hasNext()) {
            this.adoptChildExpression((Expression)iterator.next());
        }
    }

    public void setContentExpression(Expression expression) {
        this.content = expression;
        this.adoptChildExpression(expression);
    }

    public Expression getContentExpression() {
        return this.content;
    }

    public void setSchemaType(SchemaType schemaType) {
        if (this.validationOptions == null) {
            this.validationOptions = new ParseOptions();
        }
        this.validationOptions.setSchemaValidationMode(8);
        this.validationOptions.setTopLevelType(schemaType);
    }

    public SchemaType getSchemaType() {
        return this.validationOptions == null ? null : this.validationOptions.getTopLevelType();
    }

    public Expression getHrefExpression() {
        return this.href;
    }

    public String getStaticBaseURI() {
        return this.baseURI;
    }

    public boolean isResolveAgainstStaticBase() {
        return this.resolveAgainstStaticBase;
    }

    public ParseOptions getValidationOptions() {
        return this.validationOptions;
    }

    public void setValidationAction(int n2, SchemaType schemaType) {
        boolean bl;
        boolean bl2 = bl = n2 == 3 && schemaType == null;
        if (!bl && this.validationOptions == null) {
            this.validationOptions = new ParseOptions();
            this.validationOptions.setSchemaValidationMode(n2);
            this.validationOptions.setTopLevelType(schemaType);
        }
    }

    public int getValidationAction() {
        return this.validationOptions == null ? 3 : this.validationOptions.getSchemaValidationMode();
    }

    public Expression getFormatExpression() {
        return this.formatExpression;
    }

    public void setDynamicOutputElement(Expression expression) {
        this.dynamicOutputElement = expression;
    }

    public void setUseStaticBaseUri(boolean bl) {
        this.resolveAgainstStaticBase = bl;
    }

    public void setAsynchronous(boolean bl) {
        this.async = bl;
    }

    public boolean isAsynchronous() {
        return this.async;
    }

    @Override
    public Expression simplify(ExpressionVisitor expressionVisitor) throws XPathException {
        this.content = expressionVisitor.simplify(this.content);
        this.href = expressionVisitor.simplify(this.href);
        IntIterator intIterator = this.serializationAttributes.keyIterator();
        while (intIterator.hasNext()) {
            int n2 = intIterator.next();
            Expression expression = (Expression)this.serializationAttributes.get(n2);
            if (expression instanceof Literal) continue;
            expression = expressionVisitor.simplify(expression);
            this.serializationAttributes.put(n2, (Object)expression);
        }
        return this;
    }

    public Expression typeCheck(ExpressionVisitor expressionVisitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        this.content = expressionVisitor.typeCheck(this.content, contextItemType);
        this.adoptChildExpression(this.content);
        if (this.href != null) {
            this.href = expressionVisitor.typeCheck(this.href, contextItemType);
            this.adoptChildExpression(this.href);
        }
        if (this.formatExpression != null) {
            this.formatExpression = expressionVisitor.typeCheck(this.formatExpression, contextItemType);
            this.adoptChildExpression(this.formatExpression);
        }
        IntIterator intIterator = this.serializationAttributes.keyIterator();
        while (intIterator.hasNext()) {
            int n2 = intIterator.next();
            Expression expression = (Expression)this.serializationAttributes.get(n2);
            if (expression instanceof Literal) continue;
            expression = expressionVisitor.typeCheck(expression, contextItemType);
            this.adoptChildExpression(expression);
            this.serializationAttributes.put(n2, (Object)expression);
        }
        try {
            DocumentInstr.checkContentSequence((StaticContext)expressionVisitor.getStaticContext(), (Expression)this.content, (ParseOptions)this.validationOptions);
        }
        catch (XPathException xPathException) {
            xPathException.maybeSetLocation((SourceLocator)this);
            throw xPathException;
        }
        return this;
    }

    public Expression optimize(ExpressionVisitor expressionVisitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        this.content = expressionVisitor.optimize(this.content, contextItemType);
        this.adoptChildExpression(this.content);
        if (this.href != null) {
            this.href = expressionVisitor.optimize(this.href, contextItemType);
            this.adoptChildExpression(this.href);
        }
        if (this.formatExpression != null) {
            this.formatExpression = expressionVisitor.optimize(this.formatExpression, contextItemType);
            this.adoptChildExpression(this.formatExpression);
        }
        IntIterator intIterator = this.serializationAttributes.keyIterator();
        while (intIterator.hasNext()) {
            int n2 = intIterator.next();
            Expression expression = (Expression)this.serializationAttributes.get(n2);
            if (expression instanceof Literal) continue;
            expression = expressionVisitor.optimize(expression, contextItemType);
            this.adoptChildExpression(expression);
            this.serializationAttributes.put(n2, (Object)expression);
        }
        return this;
    }

    public int getIntrinsicDependencies() {
        return 0x1000000;
    }

    public Expression copy() {
        ResultDocument resultDocument = new ResultDocument(this.globalProperties, this.localProperties, this.href == null ? null : this.href.copy(), this.formatExpression == null ? null : this.formatExpression.copy(), this.baseURI, this.getValidationAction(), this.getSchemaType(), this.serializationAttributes, this.nsResolver);
        resultDocument.content = this.content.copy();
        resultDocument.dynamicOutputElement = this.dynamicOutputElement == null ? null : this.dynamicOutputElement.copy();
        resultDocument.resolveAgainstStaticBase = this.resolveAgainstStaticBase;
        resultDocument.async = this.async;
        return resultDocument;
    }

    @Override
    protected void promoteInst(PromotionOffer promotionOffer) throws XPathException {
        this.content = this.doPromotion(this.content, promotionOffer);
        if (this.href != null) {
            this.href = this.doPromotion(this.href, promotionOffer);
        }
        IntIterator intIterator = this.serializationAttributes.keyIterator();
        while (intIterator.hasNext()) {
            int n2 = intIterator.next();
            Expression expression = (Expression)this.serializationAttributes.get(n2);
            if (expression instanceof Literal) continue;
            expression = this.doPromotion(expression, promotionOffer);
            this.serializationAttributes.put(n2, (Object)expression);
        }
    }

    @Override
    public int getInstructionNameCode() {
        return 192;
    }

    @Override
    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return ErrorType.getInstance();
    }

    public Iterator<Expression> iterateSubExpressions() {
        ArrayList<Object> arrayList = new ArrayList<Object>(6);
        arrayList.add(this.content);
        if (this.href != null) {
            arrayList.add(this.href);
        }
        if (this.formatExpression != null) {
            arrayList.add(this.formatExpression);
        }
        Iterator iterator = this.serializationAttributes.valueIterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        if (this.dynamicOutputElement != null) {
            arrayList.add(this.dynamicOutputElement);
        }
        return arrayList.iterator();
    }

    public boolean replaceSubExpression(Expression expression, Expression expression2) {
        boolean bl = false;
        if (this.content == expression) {
            this.content = expression2;
            bl = true;
        }
        if (this.href == expression) {
            this.href = expression2;
            bl = true;
        }
        IntIterator intIterator = this.serializationAttributes.keyIterator();
        while (intIterator.hasNext()) {
            int n2 = intIterator.next();
            if (this.serializationAttributes.get(n2) != expression) continue;
            this.serializationAttributes.put(n2, (Object)expression2);
            bl = true;
        }
        if (this.dynamicOutputElement == expression) {
            this.dynamicOutputElement = expression2;
            bl = true;
        }
        return bl;
    }

    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        PathMap.PathMapNodeSet pathMapNodeSet2 = super.addToPathMap(pathMap, pathMapNodeSet);
        pathMapNodeSet2.setReturnable(false);
        return new PathMap.PathMapNodeSet((PathMap.PathMapNode)pathMap.makeNewRoot((Expression)this));
    }

    @Override
    public TailCall processLeavingTail(XPathContext xPathContext) throws XPathException {
        this.process(this.content, xPathContext);
        return null;
    }

    public void process(Expression expression, XPathContext xPathContext) throws XPathException {
        xPathContext.getConfiguration().processResultDocument(this, expression, xPathContext);
    }

    public void processInstruction(Expression expression, XPathContext xPathContext) throws XPathException {
        Result result;
        Controller controller = xPathContext.getController();
        assert (controller != null);
        SequenceReceiver sequenceReceiver = xPathContext.getReceiver();
        if (xPathContext.isTemporaryOutputState()) {
            XPathException xPathException = new XPathException("Cannot execute xsl:result-document while writing a temporary tree");
            xPathException.setErrorCode("XTDE1480");
            xPathException.setLocator((SourceLocator)this);
            throw xPathException;
        }
        OutputURIResolver outputURIResolver = this.href == null ? null : controller.getOutputURIResolver().newInstance();
        try {
            result = ResultDocument.getResult(this.href, this.baseURI, xPathContext, outputURIResolver, this.resolveAgainstStaticBase);
        }
        catch (XPathException xPathException) {
            xPathException.maybeSetLocation((SourceLocator)this);
            throw xPathException;
        }
        SerializerFactory serializerFactory = xPathContext.getConfiguration().getSerializerFactory();
        Properties properties = this.gatherOutputProperties(xPathContext);
        String string = properties.getProperty("{http://saxon.sf.net/}next-in-chain");
        if (string != null && string.length() > 0) {
            try {
                result = serializerFactory.prepareNextStylesheet(controller, string, this.baseURI, result);
            }
            catch (TransformerException transformerException) {
                throw XPathException.makeXPathException((TransformerException)transformerException);
            }
        }
        PipelineConfiguration pipelineConfiguration = controller.makePipelineConfiguration();
        pipelineConfiguration.setHostLanguage(50);
        LocationProvider locationProvider = pipelineConfiguration.getLocationProvider();
        Receiver receiver = serializerFactory.getReceiver(result, pipelineConfiguration, properties);
        xPathContext.changeOutputDestination(receiver, this.validationOptions);
        pipelineConfiguration.setLocationProvider(locationProvider);
        SequenceReceiver sequenceReceiver2 = xPathContext.getReceiver();
        sequenceReceiver2.open();
        try {
            sequenceReceiver2.startDocument(0);
            expression.process(xPathContext);
            sequenceReceiver2.endDocument();
        }
        catch (XPathException xPathException) {
            xPathException.setXPathContext(xPathContext);
            xPathException.maybeSetLocation((SourceLocator)this);
            throw xPathException;
        }
        finally {
            sequenceReceiver2.close();
            xPathContext.setReceiver(sequenceReceiver);
            if (outputURIResolver != null && result != controller.getPrincipalResult()) {
                try {
                    outputURIResolver.close(result);
                }
                catch (TransformerException transformerException) {
                    throw XPathException.makeXPathException((TransformerException)transformerException);
                }
            }
        }
    }

    public static Result getResult(Expression expression, String string, XPathContext xPathContext, OutputURIResolver outputURIResolver, boolean bl) throws XPathException {
        String string2;
        Result result;
        block14: {
            Controller controller = xPathContext.getController();
            if (expression == null) {
                result = controller.getPrincipalResult();
                string2 = controller.getBaseOutputURI();
                if (string2 == null) {
                    string2 = "dummy:/anonymous/principal/result";
                }
            } else {
                try {
                    String string3 = bl ? string : controller.getCookedBaseOutputURI();
                    String string4 = ((Object)EscapeURI.iriToUri((CharSequence)expression.evaluateAsString(xPathContext))).toString();
                    if (string4.equals("")) {
                        result = controller.getPrincipalResult();
                        string2 = controller.getBaseOutputURI();
                        if (string2 == null) {
                            string2 = "dummy:/anonymous/principal/result";
                        }
                        break block14;
                    }
                    try {
                        result = outputURIResolver == null ? null : outputURIResolver.resolve(string4, string3);
                    }
                    catch (TransformerException transformerException) {
                        throw XPathException.makeXPathException((TransformerException)transformerException);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        throw new XPathException("Exception thrown by OutputURIResolver", (Throwable)exception);
                    }
                    if (result == null) {
                        outputURIResolver = StandardOutputResolver.getInstance();
                        result = outputURIResolver.resolve(string4, string3);
                    }
                    if ((string2 = result.getSystemId()) == null) {
                        try {
                            string2 = new URI(string3).resolve(string4).toString();
                            result.setSystemId(string2);
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (TransformerException transformerException) {
                    throw XPathException.makeXPathException((TransformerException)transformerException);
                }
            }
        }
        ResultDocument.checkAcceptableUri(xPathContext, string2);
        ResultDocument.traceDestination(xPathContext, result);
        return result;
    }

    public static void traceDestination(XPathContext xPathContext, Result result) {
        Configuration configuration = xPathContext.getConfiguration();
        boolean bl = configuration.isTiming();
        if (bl) {
            String string = result.getSystemId();
            if (string == null) {
                string = result instanceof StreamResult ? "anonymous output stream" : (result instanceof SAXResult ? "SAX2 ContentHandler" : (result instanceof DOMResult ? "DOM tree" : result.getClass().getName()));
            }
            configuration.getStandardErrorOutput().println("Writing to " + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkAcceptableUri(XPathContext xPathContext, String string) throws XPathException {
        Controller controller = xPathContext.getController();
        assert (controller != null);
        if (string != null) {
            if (controller.getDocumentPool().find(string) != null) {
                XPathException xPathException = new XPathException("Cannot write to a URI that has already been read: " + (string.equals("dummy:/anonymous/principal/result") ? "(implicit output URI)" : string));
                xPathException.setXPathContext(xPathContext);
                xPathException.setErrorCode("XTRE1500");
                throw xPathException;
            }
            DocumentURI documentURI = new DocumentURI(string);
            Controller controller2 = controller;
            synchronized (controller2) {
                if (!controller.checkUniqueOutputDestination(documentURI)) {
                    XPathException xPathException = new XPathException("Cannot write more than one result document to the same URI: " + (string.equals("dummy:/anonymous/principal/result") ? "(implicit output URI)" : string));
                    xPathException.setXPathContext(xPathContext);
                    xPathException.setErrorCode("XTDE1490");
                    throw xPathException;
                }
                controller.addUnavailableOutputDestination(documentURI);
            }
        }
        controller.setThereHasBeenAnExplicitResultDocument();
    }

    public Properties gatherOutputProperties(XPathContext xPathContext) throws XPathException {
        String string;
        String string2;
        Object object;
        IntIterator intIterator;
        Object object3;
        Controller controller = xPathContext.getController();
        assert (controller != null);
        Configuration configuration = xPathContext.getConfiguration();
        NamePool namePool = configuration.getNamePool();
        Properties properties = this.globalProperties;
        if (this.formatExpression != null) {
            object3 = this.formatExpression.evaluateAsString(xPathContext);
            try {
                intIterator = configuration.getNameChecker().getQNameParts((CharSequence)object3);
            }
            catch (QNameException qNameException) {
                XPathException object2 = new XPathException("The requested output format " + Err.wrap((CharSequence)object3) + " is not a valid QName");
                object2.setErrorCode("XTDE1460");
                object2.setXPathContext(xPathContext);
                throw object2;
            }
            String object4 = this.nsResolver.getURIForPrefix(intIterator[0], false);
            if (object4 == null) {
                XPathException xPathException = new XPathException("The namespace prefix in the format name " + object3 + " is undeclared");
                xPathException.setErrorCode("XTDE1460");
                xPathException.setXPathContext(xPathContext);
                throw xPathException;
            }
            object = new StructuredQName((String)intIterator[0], object4, (String)intIterator[1]);
            properties = this.getExecutable().getOutputProperties((StructuredQName)object);
            if (properties == null) {
                XPathException xPathException = new XPathException("There is no xsl:output format named " + object3);
                xPathException.setErrorCode("XTDE1460");
                xPathException.setXPathContext(xPathContext);
                throw xPathException;
            }
        }
        object3 = new Properties(properties);
        for (Object n2 : this.localProperties.keySet()) {
            object = (String)n2;
            String[] stringArray = NamePool.parseClarkName((String)object);
            try {
                ResultDocument.setSerializationProperty((Properties)object3, stringArray[0], stringArray[1], this.localProperties.getProperty((String)object), this.nsResolver, true, configuration);
            }
            catch (XPathException xPathException) {
                xPathException.setErrorCode("XTDE0030");
                xPathException.maybeSetLocation((SourceLocator)this);
                throw xPathException;
            }
        }
        if (this.serializationAttributes.size() > 0) {
            intIterator = this.serializationAttributes.keyIterator();
            while (intIterator.hasNext()) {
                int properties2 = intIterator.next();
                object = (Expression)this.serializationAttributes.get(properties2);
                String string3 = ((Object)object.evaluateAsString(xPathContext)).toString();
                string2 = namePool.getLocalName(properties2);
                string = namePool.getURI(properties2);
                try {
                    ResultDocument.setSerializationProperty((Properties)object3, string, string2, string3, this.nsResolver, false, configuration);
                }
                catch (XPathException xPathException) {
                    xPathException.setErrorCode("XTDE0030");
                    xPathException.maybeSetLocation((SourceLocator)this);
                    xPathException.maybeSetContext(xPathContext);
                    if ("http://saxon.sf.net/".equals(xPathException.getErrorCodeNamespace()) && "SXWN".equals(xPathException.getErrorCodeLocalPart().substring(0, 4))) {
                        try {
                            controller.getErrorListener().warning((TransformerException)((Object)xPathException));
                            continue;
                        }
                        catch (TransformerException transformerException) {
                            throw XPathException.makeXPathException((TransformerException)transformerException);
                        }
                    }
                    throw xPathException;
                }
            }
        }
        if (this.dynamicOutputElement != null) {
            intIterator = this.dynamicOutputElement.evaluateItem(xPathContext);
            if (!(intIterator instanceof NodeInfo) || ((NodeInfo)intIterator).getNodeKind() != 1 || ((NodeInfo)intIterator).getFingerprint() != 183) {
                XPathException xPathException = new XPathException("The third argument of saxon:result-document must be an <xsl:output> element");
                xPathException.setLocator((SourceLocator)this);
                xPathException.setXPathContext(xPathContext);
                throw xPathException;
            }
            Properties properties2 = new Properties();
            ResultDocument.processXslOutputElement((NodeInfo)intIterator, properties2, xPathContext);
            for (Object e2 : properties2.keySet()) {
                string2 = (String)e2;
                string = StructuredQName.fromClarkName((String)string2);
                String string4 = properties2.getProperty(string2);
                try {
                    ResultDocument.setSerializationProperty((Properties)object3, string.getURI(), string.getLocalPart(), string4, this.nsResolver, false, configuration);
                }
                catch (XPathException xPathException) {
                    xPathException.setErrorCode("XTDE0030");
                    xPathException.maybeSetLocation((SourceLocator)this);
                    xPathException.maybeSetContext(xPathContext);
                    throw xPathException;
                }
            }
        }
        return object3;
    }

    public static void setSerializationProperty(Properties properties, String string, String string2, String string3, NamespaceResolver namespaceResolver, boolean bl, Configuration configuration) throws XPathException {
        NameChecker nameChecker = configuration.getNameChecker();
        if (string.length() == 0 || "http://saxon.sf.net/".equals(string)) {
            if (string2.equals("method")) {
                if (string3.equals("xml") || string3.equals("html") || string3.equals("text") || string3.equals("xhtml") || bl || string3.startsWith("{")) {
                    properties.setProperty("method", string3);
                } else {
                    try {
                        String[] stringArray = nameChecker.getQNameParts((CharSequence)string3);
                        String string4 = stringArray[0];
                        if (string4.length() == 0) {
                            XPathException xPathException = new XPathException("method must be xml, html, xhtml, or text, or a prefixed name");
                            xPathException.setErrorCode("SEPM0016");
                            xPathException.setIsStaticError(true);
                            throw xPathException;
                        }
                        if (namespaceResolver != null) {
                            String string5 = namespaceResolver.getURIForPrefix(string4, false);
                            if (string5 == null) {
                                XPathException xPathException = new XPathException("Namespace prefix '" + string4 + "' has not been declared");
                                xPathException.setErrorCode("SEPM0016");
                                xPathException.setIsStaticError(true);
                                throw xPathException;
                            }
                            properties.setProperty("method", '{' + string5 + '}' + stringArray[1]);
                        }
                        properties.setProperty("method", string3);
                    }
                    catch (QNameException qNameException) {
                        XPathException xPathException = new XPathException("Invalid method name. " + qNameException.getMessage());
                        xPathException.setErrorCode("SEPM0016");
                        xPathException.setIsStaticError(true);
                        throw xPathException;
                    }
                }
            } else if (string2.equals("use-character-maps")) {
                String string6 = properties.getProperty("use-character-maps");
                if (string6 == null) {
                    string6 = "";
                }
                properties.setProperty("use-character-maps", string6 + string3);
            } else if (string2.equals("cdata-section-elements")) {
                ResultDocument.processListOfNodeNames(properties, "cdata-section-elements", string3, namespaceResolver, true, bl, nameChecker);
            } else if (string2.equals("suppress-indentation")) {
                ResultDocument.processListOfNodeNames(properties, "suppress-indentation", string3, namespaceResolver, true, bl, nameChecker);
            } else if (string2.equals("double-space")) {
                ResultDocument.processListOfNodeNames(properties, "{http://saxon.sf.net/}double-space", string3, namespaceResolver, true, bl, nameChecker);
            } else if (string2.equals("attribute-order")) {
                ResultDocument.processListOfNodeNames(properties, "{http://saxon.sf.net/}attribute-order", string3, namespaceResolver, false, bl, nameChecker);
            } else {
                if (string2.equals("next-in-chain")) {
                    XPathException xPathException = new XPathException("saxon:next-in-chain property is available only on xsl:output");
                    xPathException.setErrorCodeQName(new StructuredQName("saxon", "http://saxon.sf.net/", "SXWN9004"));
                    throw xPathException;
                }
                if (string2.equals("output-version")) {
                    string2 = "version";
                }
                String string7 = string2;
                if (string.length() != 0) {
                    string7 = '{' + string + '}' + string2;
                }
                if (!bl) {
                    try {
                        SaxonOutputKeys.checkOutputProperty((String)string7, (String)string3, (Configuration)configuration);
                    }
                    catch (XPathException xPathException) {
                        xPathException.maybeSetErrorCode("SEPM0016");
                        throw xPathException;
                    }
                }
                properties.setProperty(string7, string3);
            }
        } else {
            properties.setProperty('{' + string + '}' + string2, string3);
        }
    }

    private static void processListOfNodeNames(Properties properties, String string, String string2, NamespaceResolver namespaceResolver, boolean bl, boolean bl2, NameChecker nameChecker) throws XPathException {
        String string3 = properties.getProperty(string);
        if (string3 == null) {
            string3 = "";
        }
        String string4 = SaxonOutputKeys.parseListOfNodeNames((String)string2, (NamespaceResolver)namespaceResolver, (boolean)bl, (boolean)bl2, (NameChecker)nameChecker, (String)"SEPM0016");
        properties.setProperty(string, string3 + string4);
    }

    public void explain(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("resultDocument");
        if (this.href != null) {
            expressionPresenter.startSubsidiaryElement("href");
            this.href.explain(expressionPresenter);
            expressionPresenter.endSubsidiaryElement();
        }
        expressionPresenter.startSubsidiaryElement("content");
        this.content.explain(expressionPresenter);
        expressionPresenter.endSubsidiaryElement();
        expressionPresenter.endElement();
    }

    public static void processXslOutputElement(NodeInfo nodeInfo, Properties properties, XPathContext xPathContext) throws XPathException {
        NodeInfo nodeInfo2;
        AxisIterator axisIterator = nodeInfo.iterateAxis((byte)2);
        InscopeNamespaceResolver inscopeNamespaceResolver = new InscopeNamespaceResolver(nodeInfo);
        while ((nodeInfo2 = (NodeInfo)axisIterator.next()) != null) {
            String string = nodeInfo2.getURI();
            String string2 = nodeInfo2.getLocalPart();
            String string3 = Whitespace.trim((CharSequence)nodeInfo2.getStringValueCS());
            ResultDocument.setSerializationProperty(properties, string, string2, string3, (NamespaceResolver)inscopeNamespaceResolver, false, xPathContext.getConfiguration());
        }
    }

    public ExpressionCompiler getExpressionCompiler() {
        return new ResultDocumentCompiler();
    }

    public int getStreamability(int n2, boolean bl, List<String> list) {
        Iterator<Expression> iterator = this.iterateSubExpressions();
        int n3 = 3;
        while (iterator.hasNext()) {
            Expression expression = iterator.next();
            int n4 = expression.getStreamability(0, bl, null);
            if (expression == this.content) {
                n3 = n4;
                continue;
            }
            if (n4 == 0) continue;
            return 3;
        }
        return n3;
    }

    public ResultDocumentAdjunct getStreamingAdjunct() {
        return new ResultDocumentAdjunct();
    }

    public void processLeft(Stack<XPathContext> stack, Stack<Object> stack2) throws XPathException {
        ResultDocumentAdjunct.processLeft((ResultDocument)this, stack, stack2);
    }

    public void processRight(Stack<XPathContext> stack, Stack<Object> stack2) throws XPathException {
        ResultDocumentAdjunct.processRight((ResultDocument)this, stack, stack2);
    }
}

