/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.List;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.TeeOutputter;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ArrayIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.GroundedIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.value.Closure;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.MemoClosure;
import net.sf.saxon.value.SequenceExtent;

public class MemoClosure<T extends Item>
extends Closure<T> {
    private T[] reservoir = null;
    private int used;
    protected int state;
    private static final int UNREAD = 0;
    private static final int MAYBE_MORE = 1;
    private static final int ALL_READ = 3;
    private static final int BUSY = 4;
    protected static final int EMPTY = 5;

    public synchronized SequenceIterator<T> iterate() throws XPathException {
        switch (this.state) {
            case 0: {
                this.state = 4;
                this.inputIterator = this.expression.iterate((XPathContext)this.savedXPathContext);
                if (this.inputIterator instanceof EmptyIterator) {
                    this.state = 5;
                    return this.inputIterator;
                }
                this.reservoir = new Item[50];
                this.used = 0;
                this.state = 1;
                return new ProgressiveIterator();
            }
            case 1: {
                return new ProgressiveIterator();
            }
            case 3: {
                switch (this.used) {
                    case 0: {
                        this.state = 5;
                        return EmptyIterator.emptyIterator();
                    }
                    case 1: {
                        assert (this.reservoir != null);
                        return SingletonIterator.makeIterator(this.reservoir[0]);
                    }
                }
                return new ArrayIterator(this.reservoir, 0, this.used);
            }
            case 4: {
                XPathException xPathException = new XPathException("Attempt to access a variable while it is being evaluated");
                xPathException.setErrorCode("XTDE0640");
                throw xPathException;
            }
            case 5: {
                return EmptyIterator.emptyIterator();
            }
        }
        throw new IllegalStateException("Unknown iterator state");
    }

    public synchronized void process(XPathContext xPathContext) throws XPathException {
        if (this.state == 5) {
            return;
        }
        if (this.state == 4) {
            XPathException xPathException = new XPathException("Attempt to access a variable while it is being evaluated");
            xPathException.setErrorCode("XTDE0640");
            xPathException.setXPathContext(xPathContext);
            throw xPathException;
        }
        if (this.reservoir != null) {
            Item item;
            SequenceIterator<T> sequenceIterator = this.iterate();
            SequenceReceiver sequenceReceiver = xPathContext.getReceiver();
            while ((item = sequenceIterator.next()) != null) {
                sequenceReceiver.append(item, 0, 2);
            }
        } else {
            this.state = 4;
            Controller controller = xPathContext.getController();
            XPathContextMajor xPathContextMajor = this.savedXPathContext.newContext();
            SequenceOutputter sequenceOutputter = controller.allocateSequenceOutputter(20);
            sequenceOutputter.open();
            TeeOutputter teeOutputter = new TeeOutputter((Receiver)xPathContext.getReceiver(), (Receiver)sequenceOutputter);
            teeOutputter.setPipelineConfiguration(controller.makePipelineConfiguration());
            xPathContextMajor.setReceiver((SequenceReceiver)teeOutputter);
            xPathContextMajor.setTemporaryOutputState(true);
            this.expression.process((XPathContext)xPathContextMajor);
            sequenceOutputter.close();
            List list = sequenceOutputter.getList();
            if (list.isEmpty()) {
                this.state = 5;
            } else {
                this.reservoir = new Item[list.size()];
                this.reservoir = (Item[])list.toArray(this.reservoir);
                this.used = list.size();
                this.state = 3;
            }
            this.savedXPathContext = null;
            sequenceOutputter.reset();
        }
    }

    private void append(T t2) {
        assert (this.reservoir != null);
        if (this.used >= this.reservoir.length) {
            Item[] itemArray = new Item[this.used * 2];
            System.arraycopy(this.reservoir, 0, itemArray, 0, this.used);
            this.reservoir = itemArray;
        }
        this.reservoir[this.used++] = t2;
    }

    private void condense() {
        if (this.reservoir != null && this.reservoir.length - this.used > 30) {
            Item[] itemArray = new Item[this.used];
            System.arraycopy(this.reservoir, 0, itemArray, 0, this.used);
            this.reservoir = itemArray;
        }
        this.savedXPathContext = null;
    }

    public boolean isFullyRead() {
        return this.state == 5 || this.state == 3;
    }

    public GroundedValue materialize() throws XPathException {
        if (this.state == 3) {
            return new SequenceExtent(this.reservoir, 0, this.used);
        }
        if (this.state == 5) {
            return EmptySequence.getInstance();
        }
        return new SequenceExtent(this.iterate());
    }

    public boolean isRead() {
        return this.isFullyRead() || this.state == 1;
    }

    static /* synthetic */ Item[] access$102(MemoClosure memoClosure, Item[] itemArray) {
        memoClosure.reservoir = itemArray;
        return itemArray;
    }

    public final class ProgressiveIterator
    implements SequenceIterator<T>,
    LastPositionFinder<T>,
    GroundedIterator<T> {
        int position = -1;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T next() throws XPathException {
            MemoClosure memoClosure = MemoClosure.this;
            synchronized (memoClosure) {
                if (this.position == -2) {
                    return null;
                }
                if (++this.position < MemoClosure.this.used) {
                    assert (MemoClosure.this.reservoir != null);
                    return MemoClosure.this.reservoir[this.position];
                }
                if (MemoClosure.this.state == 3) {
                    this.position = -2;
                    return null;
                }
                assert (MemoClosure.this.inputIterator != null);
                Item item = MemoClosure.this.inputIterator.next();
                if (item == null) {
                    MemoClosure.this.state = 3;
                    MemoClosure.this.condense();
                    this.position = -2;
                    return null;
                }
                this.position = MemoClosure.this.used;
                MemoClosure.this.append(item);
                MemoClosure.this.state = 1;
                return item;
            }
        }

        public T current() {
            if (this.position < 0) {
                return null;
            }
            assert (MemoClosure.this.reservoir != null);
            return MemoClosure.this.reservoir[this.position];
        }

        public int position() {
            return this.position + 1;
        }

        public void close() {
        }

        public MemoClosure.ProgressiveIterator getAnother() {
            return new ProgressiveIterator();
        }

        public int getLength() throws XPathException {
            Object t2;
            if (MemoClosure.this.state == 3) {
                return MemoClosure.this.used;
            }
            if (MemoClosure.this.state == 5) {
                return 0;
            }
            int n2 = this.position;
            while ((t2 = this.next()) != null) {
            }
            this.position = n2;
            return MemoClosure.this.used;
        }

        public GroundedValue materialize() throws XPathException {
            if (MemoClosure.this.state == 3) {
                assert (MemoClosure.this.reservoir != null);
                return new SequenceExtent(MemoClosure.this.reservoir, 0, MemoClosure.this.used);
            }
            if (MemoClosure.this.state == 5) {
                return EmptySequence.getInstance();
            }
            return new SequenceExtent(MemoClosure.this.iterate());
        }

        public int getProperties() {
            return 3;
        }

        public synchronized T itemAt(int n2) throws XPathException {
            if (n2 < 0) {
                return null;
            }
            if (MemoClosure.this.reservoir != null && n2 < MemoClosure.this.used) {
                return MemoClosure.this.reservoir[n2];
            }
            if (MemoClosure.this.state == 3 || MemoClosure.this.state == 5) {
                return null;
            }
            if (MemoClosure.this.state == 0) {
                Item item = MemoClosure.this.inputIterator.next();
                MemoClosure.this.state = 1;
                if (item == null) {
                    MemoClosure.this.state = 5;
                    return null;
                }
                MemoClosure.this.state = 1;
                MemoClosure.access$102(MemoClosure.this, new Item[50]);
                MemoClosure.this.used = 0;
                MemoClosure.this.append(item);
                if (n2 == 0) {
                    return item;
                }
            }
            int n3 = n2 - MemoClosure.this.used + 1;
            while (n3-- > 0) {
                Item item = MemoClosure.this.inputIterator.next();
                if (item == null) {
                    MemoClosure.this.state = 3;
                    MemoClosure.this.condense();
                    return null;
                }
                MemoClosure.this.append(item);
                MemoClosure.this.state = 1;
            }
            return MemoClosure.this.reservoir[n2];
        }
    }
}

