/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.Checksum;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.FalseFileFilter;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.output.NullOutputStream;

public class FileUtils {
    public static final long ONE_KB = 1024L;
    public static final long ONE_MB = 0x100000L;
    public static final long ONE_GB = 0x40000000L;
    public static final File[] EMPTY_FILE_ARRAY = new File[0];
    private static final Charset UTF8 = Charset.forName("UTF-8");

    public static FileInputStream openInputStream(File file) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException("File '" + file + "' exists but is a directory");
            }
            if (!file.canRead()) {
                throw new IOException("File '" + file + "' cannot be read");
            }
        } else {
            throw new FileNotFoundException("File '" + file + "' does not exist");
        }
        return new FileInputStream(file);
    }

    public static FileOutputStream openOutputStream(File file) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException("File '" + file + "' exists but is a directory");
            }
            if (!file.canWrite()) {
                throw new IOException("File '" + file + "' cannot be written to");
            }
        } else {
            File file2 = file.getParentFile();
            if (file2 != null && !file2.exists() && !file2.mkdirs()) {
                throw new IOException("File '" + file + "' could not be created");
            }
        }
        return new FileOutputStream(file);
    }

    public static String byteCountToDisplaySize(long l2) {
        String string = l2 / 0x40000000L > 0L ? String.valueOf(l2 / 0x40000000L) + " GB" : (l2 / 0x100000L > 0L ? String.valueOf(l2 / 0x100000L) + " MB" : (l2 / 1024L > 0L ? String.valueOf(l2 / 1024L) + " KB" : String.valueOf(l2) + " bytes"));
        return string;
    }

    public static void touch(File file) throws IOException {
        boolean bl;
        if (!file.exists()) {
            FileOutputStream fileOutputStream = FileUtils.openOutputStream(file);
            IOUtils.closeQuietly((OutputStream)fileOutputStream);
        }
        if (!(bl = file.setLastModified(System.currentTimeMillis()))) {
            throw new IOException("Unable to set the last modification time for " + file);
        }
    }

    public static File[] convertFileCollectionToFileArray(Collection collection) {
        return collection.toArray(new File[collection.size()]);
    }

    private static void innerListFiles(Collection collection, File file, IOFileFilter iOFileFilter) {
        File[] fileArray = file.listFiles((FileFilter)iOFileFilter);
        if (fileArray != null) {
            for (int i2 = 0; i2 < fileArray.length; ++i2) {
                if (fileArray[i2].isDirectory()) {
                    FileUtils.innerListFiles(collection, fileArray[i2], iOFileFilter);
                    continue;
                }
                collection.add(fileArray[i2]);
            }
        }
    }

    public static Collection listFiles(File file, IOFileFilter iOFileFilter, IOFileFilter iOFileFilter2) {
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("Parameter 'directory' is not a directory");
        }
        if (iOFileFilter == null) {
            throw new NullPointerException("Parameter 'fileFilter' is null");
        }
        IOFileFilter iOFileFilter3 = FileFilterUtils.andFileFilter((IOFileFilter)iOFileFilter, (IOFileFilter)FileFilterUtils.notFileFilter((IOFileFilter)DirectoryFileFilter.INSTANCE));
        IOFileFilter iOFileFilter4 = iOFileFilter2 == null ? FalseFileFilter.INSTANCE : FileFilterUtils.andFileFilter((IOFileFilter)iOFileFilter2, (IOFileFilter)DirectoryFileFilter.INSTANCE);
        LinkedList linkedList = new LinkedList();
        FileUtils.innerListFiles(linkedList, file, FileFilterUtils.orFileFilter((IOFileFilter)iOFileFilter3, (IOFileFilter)iOFileFilter4));
        return linkedList;
    }

    public static Iterator iterateFiles(File file, IOFileFilter iOFileFilter, IOFileFilter iOFileFilter2) {
        return FileUtils.listFiles(file, iOFileFilter, iOFileFilter2).iterator();
    }

    private static String[] toSuffixes(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray2[i2] = "." + stringArray[i2];
        }
        return stringArray2;
    }

    public static Collection listFiles(File file, String[] stringArray, boolean bl) {
        IOFileFilter iOFileFilter;
        if (stringArray == null) {
            iOFileFilter = TrueFileFilter.INSTANCE;
        } else {
            String[] stringArray2 = FileUtils.toSuffixes(stringArray);
            iOFileFilter = new SuffixFileFilter(stringArray2);
        }
        return FileUtils.listFiles(file, iOFileFilter, bl ? TrueFileFilter.INSTANCE : FalseFileFilter.INSTANCE);
    }

    public static Iterator iterateFiles(File file, String[] stringArray, boolean bl) {
        return FileUtils.listFiles(file, stringArray, bl).iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean contentEquals(File file, File file2) throws IOException {
        boolean bl;
        boolean bl2 = file.exists();
        if (bl2 != file2.exists()) {
            return false;
        }
        if (!bl2) {
            return true;
        }
        if (file.isDirectory() || file2.isDirectory()) {
            throw new IOException("Can't compare directories, only files");
        }
        if (file.length() != file2.length()) {
            return false;
        }
        if (file.getCanonicalFile().equals(file2.getCanonicalFile())) {
            return true;
        }
        FileInputStream fileInputStream = null;
        FileInputStream fileInputStream2 = null;
        try {
            fileInputStream = new FileInputStream(file);
            fileInputStream2 = new FileInputStream(file2);
            bl = IOUtils.contentEquals((InputStream)fileInputStream, (InputStream)fileInputStream2);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileInputStream);
            IOUtils.closeQuietly(fileInputStream2);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)fileInputStream);
        IOUtils.closeQuietly((InputStream)fileInputStream2);
        return bl;
    }

    public static File toFile(URL uRL) {
        if (uRL == null || !"file".equalsIgnoreCase(uRL.getProtocol())) {
            return null;
        }
        String string = uRL.getFile().replace('/', File.separatorChar);
        string = FileUtils.decodeUrl(string);
        return new File(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String decodeUrl(String string) {
        String string2 = string;
        if (string != null && string.indexOf(37) >= 0) {
            int n2 = string.length();
            StringBuffer stringBuffer = new StringBuffer();
            ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
            int n3 = 0;
            while (n3 < n2) {
                if (string.charAt(n3) == '%') {
                    try {
                        do {
                            byte by = (byte)Integer.parseInt(string.substring(n3 + 1, n3 + 3), 16);
                            byteBuffer.put(by);
                        } while ((n3 += 3) < n2 && string.charAt(n3) == '%');
                        continue;
                    }
                    catch (RuntimeException runtimeException) {
                    }
                    finally {
                        if (byteBuffer.position() <= 0) continue;
                        byteBuffer.flip();
                        stringBuffer.append(UTF8.decode(byteBuffer).toString());
                        byteBuffer.clear();
                        continue;
                    }
                }
                stringBuffer.append(string.charAt(n3++));
            }
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    public static File[] toFiles(URL[] uRLArray) {
        if (uRLArray == null || uRLArray.length == 0) {
            return EMPTY_FILE_ARRAY;
        }
        File[] fileArray = new File[uRLArray.length];
        for (int i2 = 0; i2 < uRLArray.length; ++i2) {
            URL uRL = uRLArray[i2];
            if (uRL == null) continue;
            if (!uRL.getProtocol().equals("file")) {
                throw new IllegalArgumentException("URL could not be converted to a File: " + uRL);
            }
            fileArray[i2] = FileUtils.toFile(uRL);
        }
        return fileArray;
    }

    public static URL[] toURLs(File[] fileArray) throws IOException {
        URL[] uRLArray = new URL[fileArray.length];
        for (int i2 = 0; i2 < uRLArray.length; ++i2) {
            uRLArray[i2] = fileArray[i2].toURL();
        }
        return uRLArray;
    }

    public static void copyFileToDirectory(File file, File file2) throws IOException {
        FileUtils.copyFileToDirectory(file, file2, true);
    }

    public static void copyFileToDirectory(File file, File file2, boolean bl) throws IOException {
        if (file2 == null) {
            throw new NullPointerException("Destination must not be null");
        }
        if (file2.exists() && !file2.isDirectory()) {
            throw new IllegalArgumentException("Destination '" + file2 + "' is not a directory");
        }
        FileUtils.copyFile(file, new File(file2, file.getName()), bl);
    }

    public static void copyFile(File file, File file2) throws IOException {
        FileUtils.copyFile(file, file2, true);
    }

    public static void copyFile(File file, File file2, boolean bl) throws IOException {
        if (file == null) {
            throw new NullPointerException("Source must not be null");
        }
        if (file2 == null) {
            throw new NullPointerException("Destination must not be null");
        }
        if (!file.exists()) {
            throw new FileNotFoundException("Source '" + file + "' does not exist");
        }
        if (file.isDirectory()) {
            throw new IOException("Source '" + file + "' exists but is a directory");
        }
        if (file.getCanonicalPath().equals(file2.getCanonicalPath())) {
            throw new IOException("Source '" + file + "' and destination '" + file2 + "' are the same");
        }
        if (file2.getParentFile() != null && !file2.getParentFile().exists() && !file2.getParentFile().mkdirs()) {
            throw new IOException("Destination '" + file2 + "' directory cannot be created");
        }
        if (file2.exists() && !file2.canWrite()) {
            throw new IOException("Destination '" + file2 + "' exists but is read-only");
        }
        FileUtils.doCopyFile(file, file2, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doCopyFile(File file, File file2, boolean bl) throws IOException {
        if (file2.exists() && file2.isDirectory()) {
            throw new IOException("Destination '" + file2 + "' exists but is a directory");
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            try {
                IOUtils.copy((InputStream)fileInputStream, (OutputStream)fileOutputStream);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)fileOutputStream);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)fileInputStream);
        }
        if (file.length() != file2.length()) {
            throw new IOException("Failed to copy full contents from '" + file + "' to '" + file2 + "'");
        }
        if (bl) {
            file2.setLastModified(file.lastModified());
        }
    }

    public static void copyDirectoryToDirectory(File file, File file2) throws IOException {
        if (file == null) {
            throw new NullPointerException("Source must not be null");
        }
        if (file.exists() && !file.isDirectory()) {
            throw new IllegalArgumentException("Source '" + file2 + "' is not a directory");
        }
        if (file2 == null) {
            throw new NullPointerException("Destination must not be null");
        }
        if (file2.exists() && !file2.isDirectory()) {
            throw new IllegalArgumentException("Destination '" + file2 + "' is not a directory");
        }
        FileUtils.copyDirectory(file, new File(file2, file.getName()), true);
    }

    public static void copyDirectory(File file, File file2) throws IOException {
        FileUtils.copyDirectory(file, file2, true);
    }

    public static void copyDirectory(File file, File file2, boolean bl) throws IOException {
        if (file == null) {
            throw new NullPointerException("Source must not be null");
        }
        if (file2 == null) {
            throw new NullPointerException("Destination must not be null");
        }
        if (!file.exists()) {
            throw new FileNotFoundException("Source '" + file + "' does not exist");
        }
        if (!file.isDirectory()) {
            throw new IOException("Source '" + file + "' exists but is not a directory");
        }
        if (file.getCanonicalPath().equals(file2.getCanonicalPath())) {
            throw new IOException("Source '" + file + "' and destination '" + file2 + "' are the same");
        }
        FileUtils.doCopyDirectory(file, file2, bl);
    }

    private static void doCopyDirectory(File file, File file2, boolean bl) throws IOException {
        if (file2.exists()) {
            if (!file2.isDirectory()) {
                throw new IOException("Destination '" + file2 + "' exists but is not a directory");
            }
        } else {
            if (!file2.mkdirs()) {
                throw new IOException("Destination '" + file2 + "' directory cannot be created");
            }
            if (bl) {
                file2.setLastModified(file.lastModified());
            }
        }
        if (!file2.canWrite()) {
            throw new IOException("Destination '" + file2 + "' cannot be written to");
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            throw new IOException("Failed to list contents of " + file);
        }
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            File file3 = new File(file2, fileArray[i2].getName());
            if (fileArray[i2].isDirectory()) {
                FileUtils.doCopyDirectory(fileArray[i2], file3, bl);
                continue;
            }
            FileUtils.doCopyFile(fileArray[i2], file3, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyURLToFile(URL uRL, File file) throws IOException {
        InputStream inputStream = uRL.openStream();
        try {
            FileOutputStream fileOutputStream = FileUtils.openOutputStream(file);
            try {
                IOUtils.copy((InputStream)inputStream, (OutputStream)fileOutputStream);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)fileOutputStream);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    public static void deleteDirectory(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        FileUtils.cleanDirectory(file);
        if (!file.delete()) {
            String string = "Unable to delete directory " + file + ".";
            throw new IOException(string);
        }
    }

    public static void cleanDirectory(File file) throws IOException {
        if (!file.exists()) {
            String string = file + " does not exist";
            throw new IllegalArgumentException(string);
        }
        if (!file.isDirectory()) {
            String string = file + " is not a directory";
            throw new IllegalArgumentException(string);
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            throw new IOException("Failed to list contents of " + file);
        }
        IOException iOException = null;
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            File file2 = fileArray[i2];
            try {
                FileUtils.forceDelete(file2);
                continue;
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
        }
        if (null != iOException) {
            throw iOException;
        }
    }

    public static boolean waitFor(File file, int n2) {
        int n3 = 0;
        int n4 = 0;
        while (!file.exists()) {
            if (n4++ >= 10) {
                n4 = 0;
                if (n3++ > n2) {
                    return false;
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception exception) {
                break;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileToString(File file, String string) throws IOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = FileUtils.openInputStream(file);
            String string2 = IOUtils.toString((InputStream)fileInputStream, (String)string);
            return string2;
        }
        finally {
            IOUtils.closeQuietly((InputStream)fileInputStream);
        }
    }

    public static String readFileToString(File file) throws IOException {
        return FileUtils.readFileToString(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFileToByteArray(File file) throws IOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = FileUtils.openInputStream(file);
            byte[] byArray = IOUtils.toByteArray((InputStream)fileInputStream);
            return byArray;
        }
        finally {
            IOUtils.closeQuietly((InputStream)fileInputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List readLines(File file, String string) throws IOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = FileUtils.openInputStream(file);
            List list = IOUtils.readLines((InputStream)fileInputStream, (String)string);
            return list;
        }
        finally {
            IOUtils.closeQuietly((InputStream)fileInputStream);
        }
    }

    public static List readLines(File file) throws IOException {
        return FileUtils.readLines(file, null);
    }

    public static LineIterator lineIterator(File file, String string) throws IOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = FileUtils.openInputStream(file);
            return IOUtils.lineIterator((InputStream)fileInputStream, (String)string);
        }
        catch (IOException iOException) {
            IOUtils.closeQuietly((InputStream)fileInputStream);
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            IOUtils.closeQuietly((InputStream)fileInputStream);
            throw runtimeException;
        }
    }

    public static LineIterator lineIterator(File file) throws IOException {
        return FileUtils.lineIterator(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStringToFile(File file, String string, String string2) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = FileUtils.openOutputStream(file);
            IOUtils.write((String)string, (OutputStream)fileOutputStream, (String)string2);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)fileOutputStream);
        }
    }

    public static void writeStringToFile(File file, String string) throws IOException {
        FileUtils.writeStringToFile(file, string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeByteArrayToFile(File file, byte[] byArray) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = FileUtils.openOutputStream(file);
            ((OutputStream)fileOutputStream).write(byArray);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)fileOutputStream);
        }
    }

    public static void writeLines(File file, String string, Collection collection) throws IOException {
        FileUtils.writeLines(file, string, collection, null);
    }

    public static void writeLines(File file, Collection collection) throws IOException {
        FileUtils.writeLines(file, null, collection, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeLines(File file, String string, Collection collection, String string2) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = FileUtils.openOutputStream(file);
            IOUtils.writeLines((Collection)collection, (String)string2, (OutputStream)fileOutputStream, (String)string);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)fileOutputStream);
        }
    }

    public static void writeLines(File file, Collection collection, String string) throws IOException {
        FileUtils.writeLines(file, null, collection, string);
    }

    public static void forceDelete(File file) throws IOException {
        if (file.isDirectory()) {
            FileUtils.deleteDirectory(file);
        } else {
            if (!file.exists()) {
                throw new FileNotFoundException("File does not exist: " + file);
            }
            if (!file.delete()) {
                String string = "Unable to delete file: " + file;
                throw new IOException(string);
            }
        }
    }

    public static void forceDeleteOnExit(File file) throws IOException {
        if (file.isDirectory()) {
            FileUtils.deleteDirectoryOnExit(file);
        } else {
            file.deleteOnExit();
        }
    }

    private static void deleteDirectoryOnExit(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        FileUtils.cleanDirectoryOnExit(file);
        file.deleteOnExit();
    }

    private static void cleanDirectoryOnExit(File file) throws IOException {
        if (!file.exists()) {
            String string = file + " does not exist";
            throw new IllegalArgumentException(string);
        }
        if (!file.isDirectory()) {
            String string = file + " is not a directory";
            throw new IllegalArgumentException(string);
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            throw new IOException("Failed to list contents of " + file);
        }
        IOException iOException = null;
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            File file2 = fileArray[i2];
            try {
                FileUtils.forceDeleteOnExit(file2);
                continue;
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
        }
        if (null != iOException) {
            throw iOException;
        }
    }

    public static void forceMkdir(File file) throws IOException {
        if (file.exists()) {
            if (file.isFile()) {
                String string = "File " + file + " exists and is " + "not a directory. Unable to create directory.";
                throw new IOException(string);
            }
        } else if (!file.mkdirs()) {
            String string = "Unable to create directory " + file;
            throw new IOException(string);
        }
    }

    public static long sizeOfDirectory(File file) {
        if (!file.exists()) {
            String string = file + " does not exist";
            throw new IllegalArgumentException(string);
        }
        if (!file.isDirectory()) {
            String string = file + " is not a directory";
            throw new IllegalArgumentException(string);
        }
        long l2 = 0L;
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return 0L;
        }
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            File file2 = fileArray[i2];
            if (file2.isDirectory()) {
                l2 += FileUtils.sizeOfDirectory(file2);
                continue;
            }
            l2 += file2.length();
        }
        return l2;
    }

    public static boolean isFileNewer(File file, File file2) {
        if (file2 == null) {
            throw new IllegalArgumentException("No specified reference file");
        }
        if (!file2.exists()) {
            throw new IllegalArgumentException("The reference file '" + file + "' doesn't exist");
        }
        return FileUtils.isFileNewer(file, file2.lastModified());
    }

    public static boolean isFileNewer(File file, Date date) {
        if (date == null) {
            throw new IllegalArgumentException("No specified date");
        }
        return FileUtils.isFileNewer(file, date.getTime());
    }

    public static boolean isFileNewer(File file, long l2) {
        if (file == null) {
            throw new IllegalArgumentException("No specified file");
        }
        if (!file.exists()) {
            return false;
        }
        return file.lastModified() > l2;
    }

    public static boolean isFileOlder(File file, File file2) {
        if (file2 == null) {
            throw new IllegalArgumentException("No specified reference file");
        }
        if (!file2.exists()) {
            throw new IllegalArgumentException("The reference file '" + file + "' doesn't exist");
        }
        return FileUtils.isFileOlder(file, file2.lastModified());
    }

    public static boolean isFileOlder(File file, Date date) {
        if (date == null) {
            throw new IllegalArgumentException("No specified date");
        }
        return FileUtils.isFileOlder(file, date.getTime());
    }

    public static boolean isFileOlder(File file, long l2) {
        if (file == null) {
            throw new IllegalArgumentException("No specified file");
        }
        if (!file.exists()) {
            return false;
        }
        return file.lastModified() < l2;
    }

    public static long checksumCRC32(File file) throws IOException {
        CRC32 cRC32 = new CRC32();
        FileUtils.checksum(file, cRC32);
        return cRC32.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Checksum checksum(File file, Checksum checksum) throws IOException {
        if (file.isDirectory()) {
            throw new IllegalArgumentException("Checksums can't be computed on directories");
        }
        CheckedInputStream checkedInputStream = null;
        try {
            checkedInputStream = new CheckedInputStream(new FileInputStream(file), checksum);
            IOUtils.copy((InputStream)checkedInputStream, (OutputStream)new NullOutputStream());
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(checkedInputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)checkedInputStream);
        return checksum;
    }
}

