/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dtd;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.dtd.DTDGrammar;
import org.apache.xerces.impl.dtd.XMLAttributeDecl;
import org.apache.xerces.impl.dtd.XMLDTDValidatorXerces;
import org.apache.xerces.impl.validation.ValidationState;
import org.apache.xerces.impl.xs.IDRefLocatorStorer;
import org.apache.xerces.impl.xs.util.SimpleLocator;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import ro.sync.exml.n.c.d;
import ro.sync.exml.n.c.r;

public class XMLDTDValidator
extends XMLDTDValidatorXerces {
    private static boolean DEBUG = false;
    private IDRefLocatorStorer idrefLocatorStorer = new IDRefLocatorStorer();
    private TemporaryDelegatingErrorReporter tmpDelegatingErrorReporter;

    public XMLDTDValidator() {
        this.fValidationState = new ValidationState(){

            public void addIdRef(String string) {
                XMLDTDValidator.this.idrefLocatorStorer.addIdRef(string);
                super.addIdRef(string);
            }
        };
    }

    @Override
    public void startDocument(XMLLocator xMLLocator, String string, NamespaceContext namespaceContext, Augmentations augmentations) throws XNIException {
        this.idrefLocatorStorer.init(xMLLocator, this.fErrorReporter);
        super.startDocument(xMLLocator, string, namespaceContext, augmentations);
    }

    @Override
    public void reset(XMLComponentManager xMLComponentManager) throws XMLConfigurationException {
        super.reset(xMLComponentManager);
        this.tmpDelegatingErrorReporter = new TemporaryDelegatingErrorReporter(this.fErrorReporter);
        try {
            boolean bl = xMLComponentManager.getFeature("http://oxygenxml.com/xml/features/dtd/post_validation");
            if (bl) {
                this.fValidation = false;
                this.fDynamicValidation = false;
            }
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            // empty catch block
        }
    }

    @Override
    public void characters(XMLString xMLString, Augmentations augmentations) throws XNIException {
        boolean bl = true;
        boolean bl2 = true;
        for (int i2 = xMLString.offset; i2 < xMLString.offset + xMLString.length; ++i2) {
            if (this.isSpace(xMLString.ch[i2])) continue;
            bl2 = false;
            break;
        }
        if (this.fInElementContent && bl2 && !this.fInCDATASection && this.fDocumentHandler != null) {
            this.fDocumentHandler.ignorableWhitespace(xMLString, augmentations);
            bl = false;
        }
        if (this.fPerformValidation) {
            if (this.fInElementContent) {
                if (this.fGrammarBucket.getStandalone() && this.fDTDGrammar.getElementDeclIsExternal(this.fCurrentElementIndex) && bl2) {
                    this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_WHITE_SPACE_IN_ELEMENT_CONTENT_WHEN_STANDALONE", null, (short)1);
                }
                if (!bl2) {
                    this.charDataInContent();
                }
                if (augmentations != null && augmentations.getItem("CHAR_REF_PROBABLE_WS") == Boolean.TRUE) {
                    this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_CONTENT_INVALID_SPECIFIED", new Object[]{this.fCurrentElement.rawname, this.fDTDGrammar.getContentSpecAsString(this.fElementDepth), "character reference"}, (short)1);
                }
            }
            if (this.fCurrentContentSpecType == 1) {
                this.charDataInContent();
            }
        }
        if (this.fPerformValidation && this.fCurrentContentSpecType == 3 && !bl2) {
            this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_CONTENT_INVALID_UNEXPECTED_CHARACTERS", new Object[]{xMLString}, (short)1);
        }
        if (bl && this.fDocumentHandler != null) {
            this.fDocumentHandler.characters(xMLString, augmentations);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void validateDTDattribute(QName qName, String string, XMLAttributeDecl xMLAttributeDecl) throws XNIException {
        try {
            if (this.fErrorReporter instanceof r) {
                ((r)this.fErrorReporter).g(xMLAttributeDecl.name);
            }
            super.validateDTDattribute(qName, string, xMLAttributeDecl);
        }
        finally {
            if (this.fErrorReporter instanceof r) {
                ((r)this.fErrorReporter).g(null);
            }
        }
    }

    private String dump(int[] nArray, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append(nArray[i2]);
            stringBuilder.append("  ");
        }
        return stringBuilder.toString();
    }

    private String dump(QName[] qNameArray, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append(qNameArray[i2].rawname);
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }

    private void dumpState(QName qName) {
        System.out.println();
        System.out.println("End element " + qName);
        System.out.println();
        System.out.println(" fElementDepth " + this.fElementDepth);
        System.out.println(" fElementChildrenLength " + this.fElementChildrenLength);
        System.out.println(" fElementChildren " + this.dump(this.fElementChildren, this.fElementChildrenLength));
        System.out.println(" fElemOffStackCld " + this.dump(this.fElementChildrenOffsetStack, this.fElementChildrenLength));
        System.out.println(" fElemIndexStack  " + this.dump(this.fElementIndexStack, this.fElementDepth));
        System.out.println(" Checking parent '" + this.fElementQNamePartsStack[this.fElementDepth].rawname + "'");
        System.out.println(" Parent grammar " + this.fElementIndexStack[this.fElementDepth]);
        System.out.println(" Checking parent  " + this.fElementIndexStack[this.fElementDepth]);
        int n2 = this.fElementChildrenOffsetStack[this.fElementDepth] + 1;
        int n3 = this.fElementChildrenOffsetStack[this.fElementDepth + 1] - this.fElementChildrenOffsetStack[this.fElementDepth];
        System.out.println(" Parent children offset " + n2);
        System.out.println(" ParentChildrenLength " + n3);
        System.out.println(" Model for " + this.fElementQNamePartsStack[this.fElementDepth].rawname + " " + this.fDTDGrammar.getContentSpecAsString(this.fElementIndexStack[this.fElementDepth]));
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < n3; ++i2) {
            stringBuilder.append(this.fElementChildren[i2 + n2].rawname);
            stringBuilder.append(" ");
        }
        System.out.println(" Seq: " + stringBuilder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleEndElement(QName qName, Augmentations augmentations, boolean bl) throws XNIException {
        XMLErrorReporter xMLErrorReporter = this.fErrorReporter;
        try {
            if (this.tmpDelegatingErrorReporter == null) {
                throw new XNIException("The temporary error reporter must not be null.");
            }
            this.fErrorReporter = this.tmpDelegatingErrorReporter;
            super.handleEndElement(qName, augmentations, bl);
        }
        finally {
            this.fErrorReporter = xMLErrorReporter;
        }
        if (this.fPerformValidation && this.fCurrentElementIndex != -1 && this.fCurrentContentSpecType != -1 && this.fElementDepth >= 0) {
            if (DEBUG) {
                this.dumpState(qName);
            }
            int n2 = this.fElementIndexStack[this.fElementDepth];
            QName[] qNameArray = this.fElementChildren;
            int n3 = this.fElementChildrenOffsetStack[this.fElementDepth] + 1;
            int n4 = this.fElementChildrenOffsetStack[this.fElementDepth + 1] - this.fElementChildrenOffsetStack[this.fElementDepth];
            int n5 = this.checkContent(n2, qNameArray, n3, n4);
            if (DEBUG) {
                System.out.println(" Result " + n5 + " " + this.fTempElementDecl.type);
                System.out.println(" Parent Children Lenght " + n4);
            }
            if (n5 != -1 && this.fTempElementDecl.type != 1 && n5 == n4 - 1) {
                String string = this.fDTDGrammar.getContentSpecAsString(n2);
                this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_CONTENT_INVALID_UNEXPECTED_ELEMENT", new Object[]{this.fElementChildren[n3 + n5].rawname, string == null ? "(#PCDATA)" : string}, (short)1);
            }
        }
    }

    @Override
    public String[] getRecognizedFeatures() {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(super.getRecognizedFeatures()));
        arrayList.add("http://oxygenxml.com/xml/features/dtd/post_validation");
        return arrayList.toArray(new String[0]);
    }

    public DTDGrammar getDTDGrammar() {
        return this.fDTDGrammar;
    }

    private class TemporaryDelegatingErrorReporter
    extends XMLErrorReporter {
        private XMLErrorReporter delegate;

        private TemporaryDelegatingErrorReporter(XMLErrorReporter xMLErrorReporter) {
            this.delegate = xMLErrorReporter;
        }

        public String reportError(String string, String string2, Object[] objectArray, short s2) throws XNIException {
            d d2;
            if ("MSG_ELEMENT_WITH_ID_REQUIRED".equals(string2) && objectArray.length == 1) {
                d2 = XMLDTDValidator.this.idrefLocatorStorer.getLocatorForIdRef(objectArray[0]);
                if (!(this.delegate instanceof r)) {
                    SimpleLocator simpleLocator = null;
                    if (d2 != null) {
                        simpleLocator = new SimpleLocator("", d2.getSystemId(), d2.getLineNumber(), d2.getColumnNumber());
                    }
                    return this.delegate.reportError(simpleLocator, string, string2, objectArray, s2);
                }
            } else {
                return this.delegate.reportError(string, string2, objectArray, s2);
            }
            ((r)this.delegate).s(d2);
            this.delegate.reportError(string, string2, objectArray, s2);
            return "";
        }

        public String reportError(XMLLocator xMLLocator, String string, String string2, Object[] objectArray, short s2) throws XNIException {
            return this.delegate.reportError(xMLLocator, string, string2, objectArray, s2);
        }
    }
}

