/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.xerces.impl.xs.IDRefLocatorStorer;
import org.apache.xerces.impl.xs.XMLSchemaValidatorXerces;
import org.apache.xerces.impl.xs.XSDAssertionValidator;
import org.apache.xerces.impl.xs.XSDTypeAlternativeValidator;
import org.apache.xerces.impl.xs.XSValidationState;
import org.apache.xerces.impl.xs.util.SimpleLocator;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import ro.sync.exml.n.c.d;
import ro.sync.exml.n.c.r;

public class XMLSchemaValidator
extends XMLSchemaValidatorXerces {
    private IDRefLocatorStorer idrefLocatorStorer = new IDRefLocatorStorer();

    public XMLSchemaValidator() {
        this.fValidationState = new ConfigurableLocatableValidationState();
    }

    @Override
    protected XSDAssertionValidator createValidator() {
        return new XSDAssertionValidator(this);
    }

    @Override
    protected XSDTypeAlternativeValidator createTypeAlternativeValidator() {
        return new XSDTypeAlternativeValidator(this);
    }

    @Override
    public void startDocument(XMLLocator xMLLocator, String string, NamespaceContext namespaceContext, Augmentations augmentations) throws XNIException {
        this.idrefLocatorStorer.init(xMLLocator, this.fXSIErrorReporter.fErrorReporter);
        super.startDocument(xMLLocator, string, namespaceContext, augmentations);
    }

    @Override
    public void startElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        super.startElement(qName, xMLAttributes, augmentations);
    }

    @Override
    public void reset(XMLComponentManager xMLComponentManager) throws XMLConfigurationException {
        try {
            Object object = xMLComponentManager.getProperty("http://apache.org/xml/properties/validation/schema/version");
            if (object != null) {
                this.setProperty("http://apache.org/xml/properties/validation/schema/version", object);
            }
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            // empty catch block
        }
        this.ignoreElementDefaultValues = xMLComponentManager.getFeature("http://oxygenxml.com/xml/features/elementDefaultValues/disable");
        super.reset(xMLComponentManager);
    }

    void reportSchemaError(String string, Object[] objectArray) {
        if (this.fDoValidation) {
            if ("cvc-id.1".equals(string) && objectArray.length == 1) {
                d d2 = this.idrefLocatorStorer.getLocatorForIdRef(objectArray[0]);
                if (this.fXSIErrorReporter.fErrorReporter instanceof r) {
                    ((r)this.fXSIErrorReporter.fErrorReporter).s(d2);
                    this.fXSIErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", string, objectArray, (short)1);
                } else {
                    SimpleLocator simpleLocator = null;
                    if (d2 != null) {
                        simpleLocator = new SimpleLocator("", d2.getSystemId(), d2.getLineNumber(), d2.getColumnNumber());
                    }
                    this.fXSIErrorReporter.reportError(simpleLocator, "http://www.w3.org/TR/xml-schema-1", string, objectArray, (short)1);
                }
            } else {
                this.fXSIErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", string, objectArray, (short)1);
            }
        }
    }

    @Override
    public String[] getRecognizedFeatures() {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(super.getRecognizedFeatures()));
        arrayList.add("http://oxygenxml.com/xml/features/elementDefaultValues/disable");
        return arrayList.toArray(new String[0]);
    }

    @Override
    public void setFeature(String string, boolean bl) throws XMLConfigurationException {
        super.setFeature(string, bl);
        if ("http://oxygenxml.com/xml/features/elementDefaultValues/disable".equals(string)) {
            this.ignoreElementDefaultValues = bl;
        }
    }

    private final class ConfigurableLocatableValidationState
    extends XSValidationState {
        private boolean fIdIdrefChecking;

        private ConfigurableLocatableValidationState() {
        }

        @Override
        public void addIdRef(String string) {
            if (this.fIdIdrefChecking) {
                XMLSchemaValidator.this.idrefLocatorStorer.addIdRef(string);
                super.addIdRef(string);
            }
        }

        @Override
        public void setIdIdrefChecking(boolean bl) {
            this.fIdIdrefChecking = bl;
            super.setIdIdrefChecking(bl);
        }
    }
}

