/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.azcheck.ui;

import java.util.Arrays;
import org.apache.log4j.Logger;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.options.PersistentObject;
import ro.sync.options.f;
import ro.sync.util.Equaler;
import ro.sync.util.fb;
import ro.sync.util.rc;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class SpellCheckOptions
implements PersistentObject {
    private static final Logger logger = Logger.getLogger((String)SpellCheckOptions.class.getName());
    private static final String[] AUTO_SPELL_EDITORS = new String[]{"text/xml", "text/html", "text/plain", "text/properties", "text/xsd", "text/rng", "text/sch", "text/nvdl", "text/wsdl", "text/xproc", "text/xsl"};
    public boolean automaticSpellCheck = false;
    private String[] automaticSpellCheckContentTypes;
    public boolean spellCheckInComments = false;
    public boolean spellCheckInAttributeValues = false;
    public boolean spellCheckInText = true;
    public boolean spellCheckInCDATA = true;
    public String language = "en";
    public boolean caseSensitive = false;
    public boolean ignoreMixedCase = false;
    public boolean ignoreAcronyms = true;
    public boolean ignoreDigits = true;
    public boolean ignoreDuplicates = false;
    public boolean ignoreURL = true;
    public boolean checkPunctuation = false;
    public boolean allowCompound = true;
    public boolean allowPrefixes = false;
    public boolean allowFileExtensions = true;
    public boolean obeyLangAttributes = true;
    public boolean langAttrMissingUseDefault = true;
    public String[] ignoreSpellCheckElements = new String[0];
    public int preferredChecker = 1;
    public static final int PREFERRED_CHECKER_AZCHECK = 0;
    public static final int PREFERRED_CHECKER_HUNSPELL = 1;

    @Override
    public void checkValid() throws f {
        if (this.language == null) {
            this.language = "en";
        }
    }

    public SpellCheckOptions() {
        this.automaticSpellCheckContentTypes = new String[AUTO_SPELL_EDITORS.length];
        System.arraycopy(AUTO_SPELL_EDITORS, 0, this.automaticSpellCheckContentTypes, 0, AUTO_SPELL_EDITORS.length);
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof SpellCheckOptions) {
            SpellCheckOptions spellCheckOptions = (SpellCheckOptions)object;
            bl = this.allowCompound == spellCheckOptions.allowCompound && this.allowFileExtensions == spellCheckOptions.allowFileExtensions && this.allowPrefixes == spellCheckOptions.allowPrefixes && this.automaticSpellCheck == spellCheckOptions.automaticSpellCheck && this.caseSensitive == spellCheckOptions.caseSensitive && this.checkPunctuation == spellCheckOptions.checkPunctuation && this.language.equals(spellCheckOptions.language) && this.ignoreDigits == spellCheckOptions.ignoreDigits && this.ignoreDuplicates == spellCheckOptions.ignoreDuplicates && this.ignoreMixedCase == spellCheckOptions.ignoreMixedCase && this.ignoreAcronyms == spellCheckOptions.ignoreAcronyms && this.ignoreURL == spellCheckOptions.ignoreURL && this.spellCheckInAttributeValues == spellCheckOptions.spellCheckInAttributeValues && this.spellCheckInCDATA == spellCheckOptions.spellCheckInCDATA && this.spellCheckInComments == spellCheckOptions.spellCheckInComments && this.spellCheckInText == spellCheckOptions.spellCheckInText && this.obeyLangAttributes == spellCheckOptions.obeyLangAttributes && this.langAttrMissingUseDefault == spellCheckOptions.langAttrMissingUseDefault && Equaler.verifyArrayEquals(this.automaticSpellCheckContentTypes, spellCheckOptions.automaticSpellCheckContentTypes) && Equaler.verifyArrayEquals(this.ignoreSpellCheckElements, spellCheckOptions.ignoreSpellCheckElements);
        }
        return bl;
    }

    public int hashCode() {
        StringBuilder stringBuilder = new StringBuilder(this.getBit(this.allowCompound)).append(this.getBit(this.allowFileExtensions));
        stringBuilder.append(this.getBit(this.allowPrefixes)).append(this.getBit(this.automaticSpellCheck));
        stringBuilder.append(this.getBit(this.caseSensitive)).append(this.getBit(this.checkPunctuation)).append(this.getBit(this.ignoreAcronyms));
        stringBuilder.append(this.getBit(this.ignoreDigits)).append(this.getBit(this.ignoreDuplicates)).append(this.getBit(this.ignoreMixedCase));
        stringBuilder.append(this.getBit(this.ignoreURL)).append(this.getBit(this.langAttrMissingUseDefault));
        stringBuilder.append(this.getBit(this.obeyLangAttributes)).append(this.getBit(this.spellCheckInAttributeValues));
        stringBuilder.append(this.getBit(this.spellCheckInCDATA)).append(this.getBit(this.spellCheckInComments));
        stringBuilder.append(this.getBit(this.spellCheckInText));
        Integer n2 = 0;
        try {
            n2 = rc.b(stringBuilder.toString(), 2);
        }
        catch (fb fb2) {
            logger.warn((Object)fb2, (Throwable)fb2);
        }
        return n2;
    }

    private char getBit(boolean bl) {
        return bl ? (char)'1' : '0';
    }

    @Override
    public String[] getNotPersistentFieldNames() {
        return null;
    }

    @Override
    public Object clone() {
        SpellCheckOptions spellCheckOptions = null;
        try {
            spellCheckOptions = (SpellCheckOptions)super.clone();
            if (this.ignoreSpellCheckElements != null) {
                spellCheckOptions.ignoreSpellCheckElements = new String[this.ignoreSpellCheckElements.length];
                System.arraycopy(this.ignoreSpellCheckElements, 0, spellCheckOptions.ignoreSpellCheckElements, 0, this.ignoreSpellCheckElements.length);
            }
            if (this.automaticSpellCheckContentTypes != null) {
                spellCheckOptions.automaticSpellCheckContentTypes = new String[this.automaticSpellCheckContentTypes.length];
                System.arraycopy(this.automaticSpellCheckContentTypes, 0, spellCheckOptions.automaticSpellCheckContentTypes, 0, this.automaticSpellCheckContentTypes.length);
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        return spellCheckOptions;
    }

    public boolean isAutomaticSpellCheck(String string) {
        boolean bl = false;
        if (this.automaticSpellCheck && this.automaticSpellCheckContentTypes != null) {
            if (string != null) {
                int n2 = Arrays.binarySearch(this.automaticSpellCheckContentTypes, string);
                bl = n2 >= 0;
            } else {
                logger.warn((Object)"Requested automatic spell check for a null content type", (Throwable)new Exception());
            }
        }
        return bl;
    }

    public String[] getAutomaticSpellCheckEditors() {
        return this.automaticSpellCheckContentTypes;
    }

    public void setAutomaticSpellCheckEditors(String[] stringArray) {
        this.automaticSpellCheckContentTypes = new String[stringArray.length];
        System.arraycopy(stringArray, 0, this.automaticSpellCheckContentTypes, 0, stringArray.length);
        Arrays.sort(this.automaticSpellCheckContentTypes);
    }

    static {
        Arrays.sort(AUTO_SPELL_EDITORS);
    }
}

