/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.contentcompletion.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.util.Equaler;
import ro.sync.xml.XmlUtil;
import ro.sync.xml.parser.IDValue;

@API(type=APIType.EXTENDABLE, src=SourceType.PRIVATE)
@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class CIValue
implements Comparable<CIValue> {
    private String value;
    private boolean listValue = false;
    private boolean defaultValue = false;
    private String annotation;
    protected int afterInsertCaretPosition = -1;
    public static final int TYPE_PLAIN = 0;
    public static final int TYPE_XSLT_AXIS = 1;
    public static final int TYPE_XSLT_FUNCTION = 2;
    public static final int TYPE_XSLT_ELEMENT = 3;
    public static final int TYPE_XSLT_ATTRIBUTE = 4;
    public static final int TYPE_FOLDER = 5;
    public static final int TYPE_FILE_NAME = 6;
    public static final int TYPE_UNKNOWN = 7;
    public static final int TYPE_ANT_PROPERTY = 8;
    public static final int TYPE_ANT_TARGET = 9;
    public static final int TYPE_ANT_EXTENSION_POINT = 10;
    public static final int TYPE_ANT_REFERENCE = 11;
    private int type = 0;
    private String insertString;

    public CIValue(String string) {
        this(string, false, null, null, 0);
    }

    public CIValue(String string, boolean bl) {
        this(string, bl, null, null, 0);
    }

    public CIValue(String string, String string2) {
        this(string, false, string2, null, 0);
    }

    public CIValue(String string, boolean bl, String string2) {
        this(string, bl, string2, null, 0);
    }

    public CIValue(String string, boolean bl, String string2, boolean bl2) {
        this(string, bl, string2, null, 0, bl2);
    }

    public CIValue(String string, boolean bl, String string2, String string3, int n2) {
        this(string, bl, string2, string3, n2, false);
    }

    public CIValue(String string, boolean bl, String string2, String string3, int n2, boolean bl2) {
        this(string, bl, string2, string3, n2, bl2, -1);
    }

    public CIValue(String string, boolean bl, String string2, String string3, int n2, boolean bl2, int n3) {
        this.value = string == null ? "" : string;
        this.listValue = bl;
        this.annotation = string2;
        this.insertString = string3;
        this.type = n2;
        this.defaultValue = bl2;
        this.afterInsertCaretPosition = n3;
    }

    public CIValue(String string, CIValue cIValue) {
        this(string + cIValue.value, cIValue.listValue, cIValue.annotation, null, 0);
    }

    public String getValue() {
        return this.value;
    }

    public boolean isListValue() {
        return this.listValue;
    }

    public void setListValue() {
        this.listValue = true;
    }

    public String getAnnotation() {
        return this.annotation;
    }

    public void setAnnotation(String string) {
        this.annotation = string;
    }

    public static CIValue[] getCIValues(Collection<String> collection) {
        if (collection == null) {
            return null;
        }
        CIValue[] cIValueArray = new CIValue[collection.size()];
        Iterator<String> iterator = collection.iterator();
        for (int i2 = 0; i2 < cIValueArray.length; ++i2) {
            cIValueArray[i2] = new CIValue(iterator.next());
        }
        return cIValueArray;
    }

    public static CIValue[] getCIFromIDValues(Collection<IDValue> collection, boolean bl) {
        if (collection == null) {
            return null;
        }
        CIValue[] cIValueArray = new CIValue[collection.size()];
        Iterator<IDValue> iterator = collection.iterator();
        for (int i2 = 0; i2 < cIValueArray.length; ++i2) {
            IDValue iDValue = iterator.next();
            cIValueArray[i2] = new CIValue(iDValue.getId(), iDValue.getAnnotation());
            if (!bl) continue;
            cIValueArray[i2].setListValue();
        }
        return cIValueArray;
    }

    public static List<CIValue> getCIValuesAsList(Collection<String> collection) {
        return CIValue.getCIValuesAsList(collection, null);
    }

    public static List<CIValue> getCIValuesAsList(Collection<String> collection, String string) {
        if (collection == null) {
            return null;
        }
        ArrayList<CIValue> arrayList = new ArrayList<CIValue>(collection.size());
        for (String string2 : collection) {
            CIValue cIValue = new CIValue(string2);
            if (string != null && string.equals(string2)) {
                cIValue.setDefaultValue();
            }
            arrayList.add(cIValue);
        }
        return arrayList;
    }

    public boolean equals(Object object) {
        if (object instanceof CIValue) {
            CIValue cIValue = (CIValue)object;
            return Equaler.verifyEquals(this.value, cIValue.value) && this.listValue == cIValue.listValue && this.defaultValue == cIValue.defaultValue;
        }
        return false;
    }

    public int hashCode() {
        int n2 = Boolean.valueOf(this.defaultValue).hashCode() + Boolean.valueOf(this.listValue).hashCode();
        if (this.value != null) {
            n2 += this.value.hashCode();
        }
        return n2;
    }

    public boolean isDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue() {
        this.defaultValue = true;
    }

    public String toString() {
        return "[value: " + this.value + "][listValue: " + this.listValue + "][defaultValue: " + this.defaultValue + "][annotation: " + this.annotation + "]";
    }

    @Override
    public int compareTo(CIValue cIValue) {
        return this.value.compareTo(cIValue.getValue());
    }

    public String getInsertString() {
        if (this.insertString == null) {
            return XmlUtil.escape(this.value);
        }
        return this.insertString;
    }

    public void setInsertString(String string) {
        this.insertString = string;
    }

    public int getType() {
        return this.type;
    }

    public Object valueOf(String string) {
        return this;
    }

    public int getAfterInsertCaretPosition() {
        return this.afterInsertCaretPosition;
    }

    public void setAfterInsertCaretPosition(int n2) {
        this.afterInsertCaretPosition = n2;
    }

    protected void setValue(String string) {
        this.value = string;
    }
}

