/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.db;

import java.net.URL;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.db.bb;
import ro.sync.options.PersistentObject;
import ro.sync.options.f;
import ro.sync.options.u;
import ro.sync.util.Equaler;
import ro.sync.util.URLUtil;
import ro.sync.util.t;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class DBConnectionInfo
implements PersistentObject {
    public static int INVALID_KEY = 0;
    public static int RDBMS = 0;
    public static int NXD = 1;
    private int key = INVALID_KEY;
    private boolean isVisibleFromExplorer = true;
    private boolean canBeDisplayedInExplorer = true;
    private String sessionName = "";
    private String userName;
    private String password;
    private String driverName;
    private String urlFormat;
    private String host;
    private String port;
    private String initialDatabase;
    private boolean additionalCheck;
    private String webdavUrl;
    private u<String, String> properties = null;

    public u<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(u<String, String> u2) {
        this.properties = u2;
    }

    public String getSessionName() {
        if ("".equals(this.sessionName)) {
            return null;
        }
        return this.sessionName;
    }

    public DBConnectionInfo() {
    }

    public DBConnectionInfo(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        this(string, string2, string3, string4, string5, string6, string7, null);
    }

    public DBConnectionInfo(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        this.key = bb.j();
        this.driverName = string2;
        this.urlFormat = string3;
        this.userName = string4;
        this.setPassword(string5);
        this.host = string6;
        this.port = string7;
        this.sessionName = string == null ? this.getSessionNameProposal() : string;
        this.initialDatabase = string8;
    }

    public DBConnectionInfo(int n2) {
        this.key = n2;
    }

    public boolean equals(Object object) {
        return object == null || !(object instanceof DBConnectionInfo) ? false : ((DBConnectionInfo)object).getKey() == this.key;
    }

    public int hashCode() {
        return this.key;
    }

    public String getURL() {
        return this.urlFormat;
    }

    public void setURL(String string) {
        this.urlFormat = string;
    }

    public String getPassword() {
        String string = null;
        if (this.password != null) {
            string = t.b(this.password);
        }
        return string;
    }

    public void setPassword(String string) {
        this.password = string != null ? t.f(string) : null;
    }

    public String getUsername() {
        return this.userName;
    }

    public void setUsername(String string) {
        this.userName = string;
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public void setPort(String string) {
        this.port = string;
    }

    public String getDriverName() {
        return this.driverName;
    }

    @Override
    public void checkValid() throws f {
        if (this.sessionName.length() == 0) {
            throw new f("Empty session name");
        }
        if (this.key <= 0) {
            throw new f("Invalid unique key " + this.key);
        }
    }

    public String toString() {
        return this.key + " - " + this.sessionName;
    }

    public String getInitialDatabase() {
        return this.initialDatabase;
    }

    public void setInitialDatabase(String string) {
        this.initialDatabase = string;
    }

    public boolean isAdditionalCheck() {
        return this.additionalCheck;
    }

    public void setAdditionalCheck(boolean bl) {
        this.additionalCheck = bl;
    }

    public void setSessionName(String string) {
        this.sessionName = string;
    }

    public void setDriverName(String string) {
        this.driverName = string;
    }

    public boolean isVisibleFromExplorer() {
        return this.isVisibleFromExplorer;
    }

    public boolean canBeDisplayedInExplorer() {
        return this.canBeDisplayedInExplorer;
    }

    public void setVisibleFromExplorer(boolean bl) {
        this.isVisibleFromExplorer = bl;
    }

    public void setCanBeDisplayedInExplorer(boolean bl) {
        this.canBeDisplayedInExplorer = bl;
    }

    public int getKey() {
        return this.key;
    }

    public void setWebdavUrl(String string) {
        this.webdavUrl = string;
    }

    public String getWebdavUrl() {
        return this.webdavUrl;
    }

    private String getSessionNameProposal() {
        URL uRL;
        if (this.host != null) {
            return this.host;
        }
        if (this.urlFormat != null && (uRL = URLUtil.clearUserInfo(this.urlFormat)) != null) {
            return uRL.getHost();
        }
        return "";
    }

    public boolean isDifferent(DBConnectionInfo dBConnectionInfo) {
        if (this.key != dBConnectionInfo.key) {
            return true;
        }
        return !Equaler.verifyEquals(this.sessionName, dBConnectionInfo.sessionName) || !Equaler.verifyEquals(this.driverName, dBConnectionInfo.driverName) || !Equaler.verifyEquals(this.userName, dBConnectionInfo.userName) || !Equaler.verifyEquals(this.password, dBConnectionInfo.password) || !Equaler.verifyEquals(this.host, dBConnectionInfo.host) || !Equaler.verifyEquals(this.port, dBConnectionInfo.port) || !Equaler.verifyEquals(this.initialDatabase, dBConnectionInfo.initialDatabase) || !Equaler.verifyEquals(this.urlFormat, dBConnectionInfo.urlFormat) || !Equaler.verifyEquals(this.webdavUrl, dBConnectionInfo.webdavUrl) || this.additionalCheck != dBConnectionInfo.additionalCheck;
    }

    public void setKey(int n2) {
        this.key = n2;
    }

    @Override
    public Object clone() {
        try {
            DBConnectionInfo dBConnectionInfo = (DBConnectionInfo)super.clone();
            if (this.properties != null) {
                dBConnectionInfo.properties = (u)this.properties.clone();
            }
            return dBConnectionInfo;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            return null;
        }
    }

    @Override
    public String[] getNotPersistentFieldNames() {
        return null;
    }

    public DBConnectionInfo copy() {
        DBConnectionInfo dBConnectionInfo = (DBConnectionInfo)this.clone();
        dBConnectionInfo.setKey(bb.j());
        return dBConnectionInfo;
    }
}

