/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.db.core;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.exml.ic;
import ro.sync.exml.r;
import ro.sync.licensemanager.v;
import ro.sync.options.PersistentObject;
import ro.sync.options.f;
import ro.sync.util.Equaler;
import ro.sync.util.PlatformDetector;
import ro.sync.util.Resource;
import ro.sync.util.TextUtil;
import ro.sync.util.URLUtil;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class DBSourceDriverInfo
implements PersistentObject {
    private static Logger logger = Logger.getLogger((String)DBSourceDriverInfo.class.getName());
    private String driverName = null;
    public static final String GENERIC_JDBC = "Generic JDBC";
    public static int JDBC_TYPE = 0;
    public static int NXD_TYPE = 1;
    public static int JDBC_NXD_TYPE = 2;
    public static int WEBDAV_TYPE = 3;
    public static int DOCUMENTUM_CMS_TYPE = 4;
    public static int SHAREPOINT_TYPE = 5;
    private String driverType = "JDBC";
    private String driverClassName = null;
    private URL[] driverLibraries = null;
    public static String JDBC_ODBC_BRIDGE = "JDBC-ODBC Bridge";
    public static String MYSQL_DEPRECATED_DRIVER_INFO = "MySQL";
    private static String WEBDAV = "WebDAV FTP";
    public static DBSourceDriverInfo WEBDAV_FTP_DATASOURCE = new DBSourceDriverInfo("WebDAV FTP", WEBDAV, null, null);
    public static DBSourceDriverInfo SHAREPOINT_DATASOURCE = new DBSourceDriverInfo("SharePoint", "SharePoint", null, null);
    public static DBSourceDriverInfo XQJ_DATASOURCE = new DBSourceDriverInfo("XQuery API for Java(XQJ)", "XQuery API for Java(XQJ)", null, null);
    private boolean isPreconfiguredDataSource = false;

    public DBSourceDriverInfo() {
    }

    public DBSourceDriverInfo(String string, String string2, String string3, URL[] uRLArray) {
        this.driverType = string;
        this.driverName = string2;
        this.driverClassName = string3;
        this.driverLibraries = uRLArray;
    }

    public String getDriverType() {
        if (this.isPreconfiguredDataSource && "WebDAV".equals(this.driverType)) {
            this.driverType = "WebDAV FTP";
        }
        return this.driverType;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public void setDriverName(String string) {
        this.driverName = string;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String string) {
        this.driverClassName = string;
    }

    public URL[] getDriverLibraries() {
        return this.driverLibraries;
    }

    public void setDriverLibraries(URL[] uRLArray) {
        this.driverLibraries = uRLArray;
    }

    public String toString() {
        return this.getDriverName();
    }

    public static DBSourceDriverInfo[] getDefaultJDBCDrivers() {
        DBSourceDriverInfo dBSourceDriverInfo;
        Object object;
        Object object2;
        Vector<Object> vector = new Vector<Object>();
        URL[] uRLArray = new URL[1];
        if (PlatformDetector.isWin32()) {
            try {
                object2 = Resource.getResource("/java/lang/Class.class");
                object = ((URL)object2).getFile();
                object = ((String)object).substring(0, ((String)object).length() - "!/java/lang/Class.class".length());
                uRLArray[0] = URLUtil.correct(new URL((String)object));
                dBSourceDriverInfo = new DBSourceDriverInfo("JDBC", JDBC_ODBC_BRIDGE, "sun.jdbc.odbc.JdbcOdbcDriver", uRLArray);
                dBSourceDriverInfo.isPreconfiguredDataSource = true;
                vector.add(dBSourceDriverInfo);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        uRLArray = new URL[1];
        object2 = System.getProperty("com.oxygenxml.editor.home.url");
        if (object2 != null) {
            try {
                uRLArray[0] = new URL(new URL((String)object2), "lib/mysql.jar");
                object = new DBSourceDriverInfo("JDBC", MYSQL_DEPRECATED_DRIVER_INFO, "org.gjt.mm.mysql.Driver", uRLArray);
                ((DBSourceDriverInfo)object).isPreconfiguredDataSource = true;
                vector.add(object);
            }
            catch (MalformedURLException malformedURLException) {
                logger.error((Object)malformedURLException, (Throwable)malformedURLException);
            }
        }
        object = WEBDAV_FTP_DATASOURCE;
        ((DBSourceDriverInfo)object).isPreconfiguredDataSource = true;
        vector.add(object);
        dBSourceDriverInfo = SHAREPOINT_DATASOURCE;
        dBSourceDriverInfo.isPreconfiguredDataSource = true;
        vector.add(dBSourceDriverInfo);
        return vector.toArray(new DBSourceDriverInfo[0]);
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof DBSourceDriverInfo) {
            DBSourceDriverInfo dBSourceDriverInfo = (DBSourceDriverInfo)object;
            bl = Equaler.verifyEquals(this.driverName, dBSourceDriverInfo.getDriverName());
        }
        return bl;
    }

    public int hashCode() {
        int n2 = 1;
        if (this.driverName != null) {
            n2 = this.driverName.hashCode();
        }
        return n2;
    }

    @Override
    public void checkValid() throws f {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.driverName == null) {
            stringBuffer.append("driver name");
        }
        if ("JDBC".equals(this.driverType)) {
            if (this.driverClassName == null) {
                stringBuffer.append(", driver class name");
            }
            if (this.driverLibraries == null || this.driverLibraries.length == 0) {
                stringBuffer.append(", driver libraries");
            }
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.insert(0, "Invalid JDBC driver because: ");
            stringBuffer.append(" are missing.");
            throw new f(stringBuffer.toString());
        }
    }

    public void setDriverType(String string) {
        this.driverType = string;
    }

    public void isAcceptedByCurrentEdition() throws _b {
        DBSourceDriverInfo.isAcceptedByCurrentEdition(this.getDriverType());
    }

    public static void isAcceptedByCurrentEdition(String string) throws _b {
        ic ic2 = r.e();
        boolean bl = false;
        try {
            bl = "true".equals(System.getenv("com.oxygenxml.dita.ot.process"));
        }
        catch (SecurityException securityException) {
            logger.error((Object)"Not enough rights to read the env ", (Throwable)securityException);
        }
        if (v.k().e() == null && !bl) {
            throw new _b(ic2.b("Not_licensed"));
        }
        if (!(v.k().c() || "Berkeley DBXML".equals(string) || "JDBC".equals(string) || "Postgres".equals(string) || "eXist".equals(string) || "XQuery API for Java(XQJ)".equals(string) || "WebDAV FTP".equals(string))) {
            throw new _b(string + ":\n" + ic2.b("Database_driver_available_only_in_enterprise") + ".");
        }
    }

    public boolean isPreconfiguredDataSource() {
        return this.isPreconfiguredDataSource;
    }

    @Override
    public String[] getNotPersistentFieldNames() {
        return null;
    }

    @Override
    public Object clone() {
        DBSourceDriverInfo dBSourceDriverInfo = null;
        try {
            dBSourceDriverInfo = (DBSourceDriverInfo)super.clone();
            if (this.driverLibraries != null) {
                dBSourceDriverInfo.driverLibraries = (URL[])this.driverLibraries.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        return dBSourceDriverInfo;
    }

    public DBSourceDriverInfo copy() {
        DBSourceDriverInfo dBSourceDriverInfo = (DBSourceDriverInfo)this.clone();
        dBSourceDriverInfo.isPreconfiguredDataSource = false;
        return dBSourceDriverInfo;
    }

    public static int getDriverKind(String string) {
        if (GENERIC_JDBC.equals(string)) {
            return JDBC_TYPE;
        }
        if ("DB2".equals(string) || "SQLServer".equals(string) || "Postgres".equals(string) || "Oracle".equals(string) || "XQuery API for Java(XQJ)".equals(string)) {
            return JDBC_NXD_TYPE;
        }
        if ("Documentum (CMS)".equals(string)) {
            return DOCUMENTUM_CMS_TYPE;
        }
        if ("WebDAV FTP".equals(string)) {
            return WEBDAV_TYPE;
        }
        if ("SharePoint".equals(string)) {
            return SHAREPOINT_TYPE;
        }
        return NXD_TYPE;
    }

    public static boolean hasDriverClass(int n2) {
        return n2 == JDBC_NXD_TYPE || n2 == JDBC_TYPE;
    }

    public static void filterJarsForDocumentumCMS(ArrayList<File> arrayList) {
        String string;
        File file = null;
        for (File file2 : arrayList) {
            string = file2.getName();
            if (!string.equalsIgnoreCase("emc-dfs-tools.jar") && (!TextUtil.startsWithIgnoreCase(string, "emc-") || !TextUtil.endsWithIgnoreCase(string, "-remote.jar"))) continue;
            file = file2.getParentFile();
            break;
        }
        if (file != null) {
            Iterator<File> iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                String string2;
                File file3;
                File file2;
                file2 = iterator.next();
                string = file2.getName();
                if (string.equalsIgnoreCase("log4j.jar")) {
                    iterator.remove();
                    continue;
                }
                if (string.equalsIgnoreCase("emc-dfs-tools.jar") || TextUtil.startsWithIgnoreCase(string, "emc-") && TextUtil.endsWithIgnoreCase(string, "-remote.jar") || string.equalsIgnoreCase("ucf-installer.jar") || (file3 = file2.getParentFile()) != null && file.equals(file3.getParentFile()) && ("commons".equalsIgnoreCase(string2 = file3.getName()) || "jaxws".equalsIgnoreCase(string2) || "utils".equalsIgnoreCase(string2))) continue;
                iterator.remove();
            }
        } else {
            arrayList.clear();
        }
    }

    public static class _b
    extends Exception {
        public _b(String string) {
            super(string);
        }
    }
}

