/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.diff.api.sample;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.diff.api.DiffException;
import ro.sync.diff.api.DiffOptions;
import ro.sync.diff.api.DiffPerformerFactory;
import ro.sync.diff.api.DiffProgressEvent;
import ro.sync.diff.api.DiffProgressListener;
import ro.sync.diff.api.Difference;
import ro.sync.diff.api.DifferencePerformer;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class DiffXMLFilesSample {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws DiffException, IOException {
        if (stringArray == null || stringArray.length < 2) {
            System.out.println("Please specify the two XML files to be compared!");
        } else {
            DiffPerformerFactory.registerLicenseKey(new FileReader(new File("test/licenseKeyDiffServer.txt")));
            final DifferencePerformer differencePerformer = DiffPerformerFactory.createDiffPerformer();
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    System.out.println("Press 'C' to cancel the diff process!");
                    try {
                        int n2 = System.in.read();
                        if (99 == n2 || 67 == n2) {
                            differencePerformer.stop();
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            });
            DiffOptions diffOptions = new DiffOptions();
            diffOptions.setMaxNumberOfDiffs(3000);
            diffOptions.setIgnoreWhitespaces(true);
            diffOptions.setAlgorithm(5);
            System.out.println("Comparing '" + stringArray[0] + "' with '" + stringArray[1] + "' using XML fast algorithm!");
            DiffProgressListener diffProgressListener = new DiffProgressListener(){

                @Override
                public void start() {
                    System.out.println("Diff started!");
                }

                @Override
                public void update(DiffProgressEvent diffProgressEvent) {
                    System.out.println("Progress " + diffProgressEvent.getCount() + "%");
                }

                @Override
                public void finished() {
                    System.out.println("Diff finished!");
                }
            };
            try {
                File file = new File(stringArray[0]);
                File file2 = new File(stringArray[1]);
                thread.start();
                List<Difference> list = differencePerformer.performDiff(new FileReader(file), new FileReader(file2), file.toURI().toURL().toString(), file2.toURI().toURL().toString(), "text/xml", diffOptions, diffProgressListener);
                System.out.println("-------------------------------------");
                System.out.println("The differences are:\n" + list);
            }
            finally {
                thread.interrupt();
                System.exit(0);
            }
        }
    }
}

