/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.component.editor;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JToolTip;
import javax.swing.border.Border;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.CursorType;
import ro.sync.ecss.extensions.api.editor.AbstractInplaceEditor;
import ro.sync.ecss.extensions.api.editor.AuthorInplaceContext;
import ro.sync.ecss.extensions.api.editor.EditingEvent;
import ro.sync.ecss.extensions.api.editor.IAuthorExtensionAction;
import ro.sync.ecss.extensions.api.editor.InplaceRenderer;
import ro.sync.ecss.extensions.api.editor.RendererLayoutInfo;
import ro.sync.exml.ic;
import ro.sync.exml.r;
import ro.sync.exml.view.graphics.Point;
import ro.sync.exml.view.graphics.Rectangle;
import ro.sync.exml.w;
import ro.sync.ui.application.q;
import ro.sync.ui.l.b;
import ro.sync.ui.rd;
import ro.sync.util.PlatformDetector;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class ButtonEditor
extends AbstractInplaceEditor
implements InplaceRenderer {
    protected static final ic messages = r.e();
    JButton hek = new JButton(){

        @Override
        public JToolTip createToolTip() {
            b b2 = new b();
            b2.setComponent(this);
            return b2;
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            if (!this.isContentAreaFilled() && this.getModel().isRollover()) {
                ButtonEditor.lwk(graphics, this.getWidth(), this.getHeight());
            }
            super.paintComponent(graphics);
            if (!this.isContentAreaFilled() && this.isFocusOwner()) {
                ((Graphics2D)graphics).setStroke(new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{1.0f}, 0.0f));
                graphics.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            }
        }
    };
    private ActionListener jek;
    private KeyListener gek;
    private final Font iek = this.hek.getFont();
    private Border fek;
    private Color kek = this.hek.getForeground();

    public ButtonEditor() {
        this.fek = this.hek.getBorder();
    }

    static void lwk(Graphics graphics, int n2, int n3) {
        graphics.setColor(new Color(255, 232, 118));
        graphics.fillRect(0, 0, n2 - 1, n3 - 1);
        graphics.setColor(Color.GRAY);
        graphics.drawRect(0, 0, n2 - 1, n3 - 1);
    }

    static void jwk(AbstractButton abstractButton, AuthorInplaceContext authorInplaceContext, Border border) {
        boolean bl;
        boolean bl2;
        abstractButton.getModel().setRollover(authorInplaceContext.getRelativeMouseLocation() != null);
        boolean bl3 = true;
        if (authorInplaceContext.getAuthorAccess() != null && authorInplaceContext.getAuthorAccess().getWorkspaceAccess() != null) {
            bl3 = authorInplaceContext.getAuthorAccess().getWorkspaceAccess().isStandalone();
        }
        boolean bl4 = Boolean.TRUE.equals(authorInplaceContext.getArguments().get("transparent"));
        boolean bl5 = bl2 = PlatformDetector.isMacOS() && !bl3;
        if (bl2) {
            bl4 = false;
        }
        boolean bl6 = bl = !bl4;
        if (PlatformDetector.isMacOS()) {
            bl = false;
        }
        abstractButton.setOpaque(bl);
        Border border2 = border;
        if (bl4) {
            if (PlatformDetector.isWin32()) {
                border2 = abstractButton.getIcon() == null ? q.d(3, 4, 3, 4) : q.d(1, 2, 1, 2);
            } else if (PlatformDetector.isMacOS()) {
                border2 = q.d(1, 1, 1, 1);
            }
            abstractButton.setFocusPainted(false);
            abstractButton.setContentAreaFilled(false);
            if (!PlatformDetector.isMacOS()) {
                abstractButton.setBorderPainted(false);
            }
        } else {
            abstractButton.setFocusPainted(true);
            abstractButton.setContentAreaFilled(true);
            if (!PlatformDetector.isMacOS()) {
                abstractButton.setBorderPainted(true);
            }
        }
        abstractButton.setBorder(border2);
    }

    void hwk(AuthorInplaceContext authorInplaceContext) {
        ro.sync.exml.view.graphics.Font font = (ro.sync.exml.view.graphics.Font)authorInplaceContext.getArguments().get("font");
        if (font != null) {
            this.hek.setFont(new Font(font.getName(), font.getStyle(), font.getSize()));
        } else {
            this.hek.setFont(this.iek);
        }
        ro.sync.exml.view.graphics.Color color = (ro.sync.exml.view.graphics.Color)authorInplaceContext.getArguments().get("color");
        if (color != null) {
            this.hek.setForeground(new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()));
        } else {
            this.hek.setForeground(this.kek);
        }
        final Object object = authorInplaceContext.getArguments().get("actionID");
        IAuthorExtensionAction iAuthorExtensionAction = null;
        if (object instanceof IAuthorExtensionAction) {
            iAuthorExtensionAction = (IAuthorExtensionAction)object;
        }
        final IAuthorExtensionAction iAuthorExtensionAction2 = iAuthorExtensionAction;
        if (this.jek != null) {
            this.hek.removeActionListener(this.jek);
        }
        if (this.gek != null) {
            this.hek.removeKeyListener(this.gek);
        }
        if (iAuthorExtensionAction2 != null) {
            Object object2;
            Object object3;
            String string = (String)iAuthorExtensionAction2.getValue("description");
            Object object4 = null;
            Boolean bl = this.getBoolean(authorInplaceContext, "showIcon");
            if (bl == null || bl.booleanValue()) {
                object3 = rd.h((String)iAuthorExtensionAction2.getValue("large_icon_path"));
                object2 = rd.b((String)iAuthorExtensionAction2.getValue("small_icon_path"), false);
                object4 = object2 != null ? object2 : object3;
            }
            this.hek.setIcon((Icon)object4);
            object3 = this.getBoolean(authorInplaceContext, "showText");
            object2 = null;
            if (object4 == null || Boolean.TRUE.equals(object3)) {
                object2 = (String)iAuthorExtensionAction2.getValue("action_name");
            }
            this.hek.setText((String)object2);
            this.hek.setToolTipText(string);
            this.jek = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ButtonEditor.this.fireEditingStopped(new EditingEvent(iAuthorExtensionAction2));
                }
            };
        } else {
            this.hek.setIcon(null);
            this.hek.setText(messages.b("Unknown"));
            this.hek.setToolTipText("Unknown action");
            this.jek = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    w.getInstance().showErrorMessage("Unknown action ID: " + String.valueOf(object) + ". The document must have an associated Document Type in which an action with the given ID must be declared.");
                    ButtonEditor.this.fireEditingStopped(new EditingEvent((String)null));
                }
            };
        }
        this.hek.addActionListener(this.jek);
        this.gek = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    keyEvent.consume();
                    ButtonEditor.this.fireEditingCanceled();
                } else if (keyEvent.getKeyCode() == 10) {
                    keyEvent.consume();
                    ButtonEditor.this.fireEditingStopped(new EditingEvent(iAuthorExtensionAction2));
                }
            }
        };
        this.hek.addKeyListener(this.gek);
        ButtonEditor.jwk(this.hek, authorInplaceContext, this.fek);
    }

    @Override
    public Object getRendererComponent(AuthorInplaceContext authorInplaceContext) {
        this.hwk(authorInplaceContext);
        return this.hek;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static RendererLayoutInfo iwk(AbstractButton abstractButton, AuthorInplaceContext authorInplaceContext) {
        boolean bl = true;
        if (authorInplaceContext.getAuthorAccess() != null && authorInplaceContext.getAuthorAccess().getWorkspaceAccess() != null) {
            bl = authorInplaceContext.getAuthorAccess().getWorkspaceAccess().isStandalone();
        }
        int n2 = 0;
        if (!bl && PlatformDetector.isMacOS() && abstractButton.getIcon() != null) {
            n2 = 5;
        }
        Dimension dimension = abstractButton.getPreferredSize();
        String string = abstractButton.getText();
        int n3 = -1;
        if (string == null || string.length() == 0) {
            try {
                abstractButton.setText(" ");
                n3 = abstractButton.getBaseline(dimension.width, dimension.height);
            }
            finally {
                abstractButton.setText(string);
            }
        } else {
            n3 = abstractButton.getBaseline(dimension.width, dimension.height);
        }
        return new RendererLayoutInfo(n3, new ro.sync.exml.view.graphics.Dimension(dimension.width + n2, dimension.height + n2));
    }

    @Override
    public RendererLayoutInfo getRenderingInfo(AuthorInplaceContext authorInplaceContext) {
        this.hwk(authorInplaceContext);
        return ButtonEditor.iwk(this.hek, authorInplaceContext);
    }

    @Override
    public Object getEditorComponent(AuthorInplaceContext authorInplaceContext, Rectangle rectangle, Point point) {
        this.hwk(authorInplaceContext);
        return this.hek;
    }

    @Override
    public void requestFocus() {
        this.hek.requestFocus();
    }

    @Override
    public Object getValue() {
        return null;
    }

    @Override
    public void stopEditing() {
        this.fireEditingStopped(new EditingEvent((String)null));
    }

    @Override
    public void cancelEditing() {
        this.fireEditingCanceled();
    }

    @Override
    public String getDescription() {
        return "A button linked to an author extension action";
    }

    @Override
    public Rectangle getScrollRectangle() {
        return null;
    }

    @Override
    public String getTooltipText(AuthorInplaceContext authorInplaceContext, int n2, int n3) {
        this.hwk(authorInplaceContext);
        return this.hek.getToolTipText();
    }

    @Override
    public CursorType getCursorType(AuthorInplaceContext authorInplaceContext, int n2, int n3) {
        return CursorType.CURSOR_NORMAL;
    }

    @Override
    public CursorType getCursorType(int n2, int n3) {
        return null;
    }
}

