/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.conditions;

import java.util.Arrays;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.ecss.conditions.ProfileConditionValuePO;
import ro.sync.options.PersistentObject;
import ro.sync.options.f;
import ro.sync.util.Equaler;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class ProfileConditionInfoPO
implements PersistentObject {
    private String attributeName = null;
    private boolean allowsMultipleValues = true;
    private ProfileConditionValuePO[] allowedValues = null;
    private String documentTypePattern = null;
    private String valuesSeparator = " ";
    private String attributeRenderName = null;
    private static final String DEFAULT_DESCRIPTION = "Sample value. You can change it from the \"Profiling/Conditional Text\" preferences page.";

    public ProfileConditionInfoPO() {
    }

    public static ProfileConditionInfoPO createDefaultProfileConditionInfoPO(String string, String string2, boolean bl, String[] stringArray, String string3, String string4) {
        ProfileConditionValuePO[] profileConditionValuePOArray = new ProfileConditionValuePO[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            profileConditionValuePOArray[i2] = new ProfileConditionValuePO(stringArray[i2], DEFAULT_DESCRIPTION);
        }
        return new ProfileConditionInfoPO(string, string2, bl, profileConditionValuePOArray, string3, string4);
    }

    public ProfileConditionInfoPO(String string, String string2, boolean bl, ProfileConditionValuePO[] profileConditionValuePOArray, String string3, String string4) {
        this.attributeName = string;
        this.attributeRenderName = string2;
        this.allowsMultipleValues = bl;
        this.setAllowedValues(profileConditionValuePOArray, true);
        this.valuesSeparator = string3;
        this.documentTypePattern = string4;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public String getAttributeRenderName() {
        return this.attributeRenderName;
    }

    public boolean isAllowsMultipleValues() {
        return this.allowsMultipleValues;
    }

    public ProfileConditionValuePO[] getAllowedValues() {
        return this.allowedValues;
    }

    public String getValuesSeparator() {
        return this.valuesSeparator;
    }

    public String getDocumentTypePattern() {
        return this.documentTypePattern;
    }

    public boolean containsValue(String string) {
        for (int i2 = 0; i2 < this.allowedValues.length; ++i2) {
            if (!this.allowedValues[i2].getValue().equals(string)) continue;
            return true;
        }
        return false;
    }

    public String getAllowedValuesDescription() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < this.allowedValues.length; ++i2) {
            stringBuilder.append(this.allowedValues[i2].getValue());
            if (i2 == this.allowedValues.length - 1) continue;
            stringBuilder.append(this.valuesSeparator);
        }
        return stringBuilder.toString();
    }

    @Override
    public void checkValid() throws f {
        if (this.attributeName == null) {
            throw new f("Null conditional attribute.");
        }
        if (this.allowedValues == null || this.allowedValues.length == 0) {
            throw new f("No allowed value specified.");
        }
    }

    @Override
    public String[] getNotPersistentFieldNames() {
        return null;
    }

    @Override
    public Object clone() {
        ProfileConditionInfoPO profileConditionInfoPO = null;
        try {
            profileConditionInfoPO = (ProfileConditionInfoPO)super.clone();
            if (this.allowedValues != null) {
                profileConditionInfoPO.allowedValues = new ProfileConditionValuePO[this.allowedValues.length];
                for (int i2 = 0; i2 < this.allowedValues.length; ++i2) {
                    if (this.allowedValues[i2] == null) continue;
                    profileConditionInfoPO.allowedValues[i2] = (ProfileConditionValuePO)this.allowedValues[i2].clone();
                }
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        return profileConditionInfoPO;
    }

    public void setAllowedValues(ProfileConditionValuePO[] profileConditionValuePOArray, boolean bl) {
        this.allowedValues = profileConditionValuePOArray;
        if (bl && this.allowedValues != null) {
            Arrays.sort(this.allowedValues);
        }
    }

    public String toString() {
        return "DT: " + this.documentTypePattern + " attr: " + this.attributeName + " vals: " + (this.allowedValues != null ? Arrays.asList(this.allowedValues) : null);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof ProfileConditionInfoPO) {
            ProfileConditionInfoPO profileConditionInfoPO = (ProfileConditionInfoPO)object;
            return Equaler.verifyEquals(this.documentTypePattern, profileConditionInfoPO.documentTypePattern) && Equaler.verifyOptionsEquals(this.allowedValues, profileConditionInfoPO.allowedValues) && Equaler.verifyEquals(this.attributeName, profileConditionInfoPO.attributeName) && Equaler.verifyEquals(this.attributeRenderName, profileConditionInfoPO.attributeRenderName) && Equaler.verifyEquals(this.valuesSeparator, profileConditionInfoPO.valuesSeparator) && this.allowsMultipleValues == profileConditionInfoPO.allowsMultipleValues;
        }
        return false;
    }
}

