/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.api;

import java.util.ArrayList;
import java.util.List;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorExtensionStateListener;

@API(type=APIType.EXTENDABLE, src=SourceType.PUBLIC)
public class AuthorExtensionStateListenerDelegator
implements AuthorExtensionStateListener {
    private List<AuthorExtensionStateListener> listeners = new ArrayList<AuthorExtensionStateListener>();

    @Override
    public void activated(AuthorAccess authorAccess) {
        this.fireActivated(authorAccess);
    }

    @Override
    public void deactivated(AuthorAccess authorAccess) {
        this.fireDeactivated(authorAccess);
    }

    public void addListener(AuthorExtensionStateListener authorExtensionStateListener) {
        if (!this.listeners.contains(authorExtensionStateListener)) {
            this.listeners.add(authorExtensionStateListener);
        }
    }

    public void removeListener(AuthorExtensionStateListener authorExtensionStateListener) {
        this.listeners.remove(authorExtensionStateListener);
    }

    @Override
    public String getDescription() {
        return "Author Extension State Listener Delegator";
    }

    private void fireActivated(AuthorAccess authorAccess) {
        for (int i2 = 0; i2 < this.listeners.size(); ++i2) {
            this.listeners.get(i2).activated(authorAccess);
        }
    }

    private void fireDeactivated(AuthorAccess authorAccess) {
        for (int i2 = 0; i2 < this.listeners.size(); ++i2) {
            this.listeners.get(i2).deactivated(authorAccess);
        }
    }
}

