/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.api.highlights;

import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.highlights.HighlightPainterInfo;
import ro.sync.ecss.extensions.api.highlights.TextForegroundHighlighterPainter;
import ro.sync.exml.view.graphics.Color;

@API(type=APIType.EXTENDABLE, src=SourceType.PUBLIC)
public class ColorHighlightPainter
implements TextForegroundHighlighterPainter {
    private Color color = Color.COLOR_RED_DARKER;
    private int height = -1;
    private int totalHeight = 1;
    private TextDecoration decoration = null;
    private int textDecorationStroke = 0;
    private Color bgColor;
    private Color foregroundColor;
    private boolean useParentLineBoxHeight;

    public ColorHighlightPainter() {
    }

    public ColorHighlightPainter(Color color, int n2, int n3) {
        this.color = color;
        this.height = n2;
        this.totalHeight = n3;
    }

    @Override
    public void paint(HighlightPainterInfo highlightPainterInfo) {
        int n2;
        int n3;
        int n4 = this.height;
        if (n4 == -1) {
            n4 = (int)Math.max(1L, Math.round((double)highlightPainterInfo.getFontSize() / 16.0));
            this.totalHeight = n4 + 1;
        }
        if (this.bgColor != null) {
            Color color = this.bgColor;
            if (highlightPainterInfo.isHighlightOverImage() && this.bgColor.getAlpha() > 50) {
                color = new Color(this.bgColor.getRed(), this.bgColor.getGreen(), this.bgColor.getBlue(), 50);
            }
            highlightPainterInfo.getGraphics().setFillColor(color);
            n3 = this.useParentLineBoxHeight ? highlightPainterInfo.getParentLineBoxOrigin().y : highlightPainterInfo.getOrigin().y;
            n2 = this.useParentLineBoxHeight ? highlightPainterInfo.getParentLineBoxHight() : highlightPainterInfo.getCurrentBoxHeight();
            highlightPainterInfo.getGraphics().fillRect(highlightPainterInfo.getOrigin().x + highlightPainterInfo.getRelativeX(), n3, highlightPainterInfo.getLength(), n2);
        }
        if (this.decoration == null) {
            this.decoration = TextDecoration.UNDERLINE;
        }
        if (this.decoration != TextDecoration.NONE) {
            highlightPainterInfo.getGraphics().setDrawColor(this.color);
            int n5 = highlightPainterInfo.getOrigin().y;
            if (this.decoration == TextDecoration.STRIKEOUT) {
                n5 += highlightPainterInfo.getTextYPadding() + highlightPainterInfo.getBaseLine() - highlightPainterInfo.getFontAscent() / 3;
            } else if (this.decoration == TextDecoration.UNDERLINE) {
                n5 += highlightPainterInfo.getTextYPadding();
                n5 = this.useBaseLineForUnderline() && highlightPainterInfo.isHighlightOverText() ? (n5 += highlightPainterInfo.getBaseLine() + 1) : (n5 += highlightPainterInfo.getCurrentBoxHeight() - this.totalHeight);
            } else {
                n5 += highlightPainterInfo.getCurrentBoxHeight() - n4 - 1;
            }
            n3 = highlightPainterInfo.getGraphics().getStrokeType();
            n2 = highlightPainterInfo.getGraphics().getStrokeWidth();
            highlightPainterInfo.getGraphics().setStroke(n4, this.textDecorationStroke);
            highlightPainterInfo.getGraphics().drawLine(highlightPainterInfo.getOrigin().x + highlightPainterInfo.getRelativeX(), n5, highlightPainterInfo.getOrigin().x + highlightPainterInfo.getRelativeX() + highlightPainterInfo.getLength(), n5);
            highlightPainterInfo.getGraphics().setStroke(n2, n3);
        }
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setTextDecoration(TextDecoration textDecoration) {
        this.decoration = textDecoration;
    }

    public void setBgColor(Color color) {
        if (this.decoration == null) {
            this.decoration = TextDecoration.NONE;
        }
        this.bgColor = color;
    }

    public void setBgColor(Color color, boolean bl) {
        if (this.decoration == null) {
            this.decoration = TextDecoration.NONE;
        }
        this.bgColor = color;
        this.useParentLineBoxHeight = bl;
    }

    public boolean useBaseLineForUnderline() {
        return false;
    }

    public void setTextDecorationStroke(int n2) {
        this.textDecorationStroke = n2;
    }

    @Deprecated
    public void setStrikeOut(boolean bl) {
        if (bl) {
            this.setTextDecoration(TextDecoration.STRIKEOUT);
        } else {
            this.setTextDecoration(TextDecoration.UNDERLINE);
        }
    }

    public Color getBgColor() {
        return this.bgColor;
    }

    public Color getColor() {
        return this.color;
    }

    public void setTextForegroundColor(Color color) {
        this.foregroundColor = color;
    }

    @Override
    public Color getTextForegroundColor() {
        return this.foregroundColor;
    }

    public static enum TextDecoration {
        NONE,
        UNDERLINE,
        STRIKEOUT,
        BOTTOM;

    }
}

