/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.api.highlights;

import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.highlights.HighlightPainter;
import ro.sync.ecss.extensions.api.highlights.HighlightPainterInfo;
import ro.sync.exml.view.graphics.Color;

@API(type=APIType.EXTENDABLE, src=SourceType.PUBLIC)
public class RectangleHighlightPainter
implements HighlightPainter {
    protected Color fillColor;

    public RectangleHighlightPainter(Color color) {
        this.fillColor = color;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(HighlightPainterInfo highlightPainterInfo) {
        Color color = highlightPainterInfo.getGraphics().getFillColor();
        try {
            Color color2 = this.fillColor;
            if (highlightPainterInfo.isHighlightOverImage() && color2.getAlpha() > 50) {
                color2 = new Color(color2.getRed(), color2.getGreen(), color2.getBlue(), 50);
            }
            highlightPainterInfo.getGraphics().setFillColor(color2);
            int n2 = highlightPainterInfo.getOrigin().x + highlightPainterInfo.getRelativeX();
            int n3 = highlightPainterInfo.getParentLineBoxOrigin() != null ? highlightPainterInfo.getParentLineBoxOrigin().y : highlightPainterInfo.getOrigin().y;
            int n4 = highlightPainterInfo.getLength();
            int n5 = Math.max(highlightPainterInfo.getParentLineBoxHight(), highlightPainterInfo.getCurrentBoxHeight());
            highlightPainterInfo.getGraphics().fillRect(n2, n3, n4, n5);
        }
        finally {
            highlightPainterInfo.getGraphics().setFillColor(color);
        }
    }

    public void setFillColor(Color color) {
        this.fillColor = color;
    }
}

