/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons;

import org.apache.log4j.Logger;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.link.ElementLocator;
import ro.sync.ecss.extensions.api.link.ElementLocatorException;
import ro.sync.ecss.extensions.api.link.ElementLocatorProvider;
import ro.sync.ecss.extensions.api.link.IDTypeVerifier;
import ro.sync.ecss.extensions.commons.IDElementLocator;
import ro.sync.ecss.extensions.commons.XPointerElementLocator;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class DefaultElementLocatorProvider
implements ElementLocatorProvider {
    private static Logger logger = Logger.getLogger((String)DefaultElementLocatorProvider.class.getName());

    @Override
    public ElementLocator getElementLocator(IDTypeVerifier iDTypeVerifier, String string) {
        ElementLocator elementLocator = null;
        try {
            elementLocator = string.startsWith("element(") ? new XPointerElementLocator(iDTypeVerifier, string) : new IDElementLocator(iDTypeVerifier, string);
        }
        catch (ElementLocatorException elementLocatorException) {
            logger.warn((Object)("Exception when create element locator for link: " + string + ". Cause: " + elementLocatorException), (Throwable)elementLocatorException);
        }
        return elementLocator;
    }

    @Override
    public String getDescription() {
        return "Default implementation for locating elements based on a given link.\nThe following cases are covered: XInclude element scheme and ID based links.";
    }
}

