/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import javax.swing.text.BadLocationException;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.node.AuthorNode;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class DeleteElementOperation
implements AuthorOperation {
    private static final String ARGUMENT_ELEMENT_XPATH_LOCATION = "elementLocation";
    private ArgumentDescriptor[] arguments = new ArgumentDescriptor[1];

    public DeleteElementOperation() {
        ArgumentDescriptor argumentDescriptor;
        this.arguments[0] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_ELEMENT_XPATH_LOCATION, 2, "An XPath expression indicating the element to be deleted.\nNote: If it is not defined then the element at the caret position will be used.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void doOperation(AuthorAccess authorAccess, ArgumentsMap argumentsMap) throws AuthorOperationException {
        Object object = argumentsMap.getArgumentValue(ARGUMENT_ELEMENT_XPATH_LOCATION);
        AuthorNode authorNode = null;
        if (object instanceof String) {
            AuthorNode[] authorNodeArray = authorAccess.getDocumentController().findNodesByXPath((String)object, true, true, true);
            if (authorNodeArray.length <= 0 || authorNodeArray[0] == null) throw new AuthorOperationException("The element XPath location does not identify a node: " + object);
            authorNode = authorNodeArray[0];
        } else {
            try {
                authorNode = authorAccess.getDocumentController().getNodeAtOffset(authorAccess.getEditorAccess().getCaretOffset());
            }
            catch (BadLocationException badLocationException) {
                throw new AuthorOperationException("Cannot identify the current node", badLocationException);
            }
        }
        if (authorNode == null) return;
        authorAccess.getDocumentController().deleteNode(authorNode);
    }

    @Override
    public ArgumentDescriptor[] getArguments() {
        return this.arguments;
    }

    @Override
    public String getDescription() {
        return "Deletes the element specified by an XPath expression or the element at the caret position";
    }
}

