/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import java.io.StringReader;
import java.io.StringWriter;
import javax.swing.text.BadLocationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.xml.sax.InputSource;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentType;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.operations.MoveCaretUtil;

@API(type=APIType.EXTENDABLE, src=SourceType.PUBLIC)
public abstract class TransformOperation
implements AuthorOperation {
    private static final Logger logger = Logger.getLogger((String)TransformOperation.class.getName());
    public static final String CURRENT_ELEMENT_LOCATION = "currentElementLocation";
    public static final String ACTION_REPLACE = "Replace";
    public static final String ACTION_AT_CARET = "At caret position";
    public static final String ACTION_INSERT_BEFORE = "Before";
    public static final String ACTION_INSERT_AFTER = "After";
    public static final String ACTION_INSERT_AS_FIRST_CHILD = "Inside as first child";
    public static final String ACTION_INSERT_AS_LAST_CHILD = "Inside as last child";
    public static final String CARET_POSITION_PRESERVE = "Preserve";
    public static final String CARET_POSITION_BEFORE = "Before";
    public static final String CARET_POSITION_START = "Start";
    public static final String CARET_POSITION_EDITABLE = "First editable position";
    public static final String CARET_POSITION_END = "End";
    public static final String CARET_POSITION_AFTER = "After";
    private static final String ARGUMENT_XPATH_SOURCE = "sourceLocation";
    private static final String ARGUMENT_XPATH_TARGET = "targetLocation";
    protected String ARGUMENT_SCRIPT = "script";
    private static final String ARGUMENT_ACTION = "action";
    private static final String ARGUMENT_CARET_POSITION = "caretPosition";
    private static final String ARGUMENT_EXPAND_EDITOR_VARIABLES = "expandEditorVariables";
    private ArgumentDescriptor[] arguments = new ArgumentDescriptor[6];

    public TransformOperation() {
        ArgumentDescriptor argumentDescriptor;
        this.arguments[0] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_XPATH_SOURCE, 2, "An XPath expression indicating the element that the script will be applied on.\nNote: If it is not defined then the element at the caret position will be used.");
        this.arguments[1] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_XPATH_TARGET, 2, "An XPath expression indicating the insert location for the result of the transformation.\nNote: If it is not defined then the insert location will be at the caret.");
        this.arguments[2] = argumentDescriptor = new ArgumentDescriptor(this.ARGUMENT_SCRIPT, 4, "The script. The base system ID for this will be the framework file, so any include/import reference will be resolved relative to the \".framework\" file that contains this action definition");
        this.arguments[3] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_ACTION, 3, "The insert action relative to the node determined by the target XPath expression.\nIt can be: Replace, At caret position, Before, After, Inside as first child or Inside as last child.\n", new String[]{ACTION_REPLACE, ACTION_AT_CARET, "Before", "After", ACTION_INSERT_AS_FIRST_CHILD, ACTION_INSERT_AS_LAST_CHILD}, ACTION_REPLACE);
        this.arguments[4] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_CARET_POSITION, 3, "The position of the caret after the action is executed.\nIt can be: Preserve, Before, Start, First editable position, End or After.\n", new String[]{CARET_POSITION_PRESERVE, "Before", CARET_POSITION_START, CARET_POSITION_EDITABLE, CARET_POSITION_END, "After"}, CARET_POSITION_EDITABLE);
        this.arguments[5] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_EXPAND_EDITOR_VARIABLES, 3, "Parameter controlling the expansion of editor variables returned by the script processing.\nExpansion is enabled by default.", new String[]{"true", "false"}, "true");
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void doOperation(AuthorAccess authorAccess, ArgumentsMap argumentsMap) throws AuthorOperationException {
        int n2;
        AuthorDocumentFragment authorDocumentFragment;
        Object object;
        int n3;
        int n4;
        void var13_20;
        Object object2;
        Object object3;
        AuthorNode authorNode;
        AuthorElement authorElement;
        Object object4 = argumentsMap.getArgumentValue(ARGUMENT_XPATH_SOURCE);
        Object object5 = argumentsMap.getArgumentValue(ARGUMENT_XPATH_TARGET);
        Object object6 = argumentsMap.getArgumentValue(this.ARGUMENT_SCRIPT);
        Object object7 = argumentsMap.getArgumentValue(ARGUMENT_ACTION);
        Object object8 = argumentsMap.getArgumentValue(ARGUMENT_CARET_POSITION);
        if (!(object6 instanceof String)) {
            throw new IllegalArgumentException("The argument \"script\" was not defined as a string object!");
        }
        String string = (String)object6;
        AuthorNode authorNode2 = null;
        AuthorElement authorElement2 = null;
        AuthorNode authorNode3 = null;
        try {
        }
        catch (BadLocationException badLocationException) {
            throw new AuthorOperationException("Cannot identify the current node", badLocationException);
        }
        authorNode2 = authorNode3;
        for (authorNode3 = authorAccess.getDocumentController().getNodeAtOffset(authorAccess.getEditorAccess().getCaretOffset()); authorNode3 != null && !(authorNode3 instanceof AuthorElement); authorNode3 = authorNode3.getParent()) {
        }
        authorElement2 = authorNode3 instanceof AuthorElement ? (AuthorElement)authorNode3 : authorAccess.getDocumentController().getAuthorDocumentNode().getRootElement();
        if (object4 instanceof String && !"".equals(object4)) {
            AuthorNode[] authorNodeArray = authorAccess.getDocumentController().findNodesByXPath((String)object4, true, true, false);
            if (authorNodeArray.length <= 0 || !(authorNodeArray[0] instanceof AuthorElement)) throw new AuthorOperationException("The source XPath location does not identify an element: " + object4);
            authorElement = (AuthorElement)authorNodeArray[0];
        } else {
            authorElement = authorElement2;
        }
        String string2 = "";
        AuthorElement authorElement3 = authorElement2;
        if (authorElement3.isDescendentOf(authorElement)) {
            void var13_16;
            void var14_22;
            while (var14_22 != authorElement) {
                authorNode = (AuthorElement)var14_22.getParent();
                int n5 = authorNode.getContentNodes().indexOf(var14_22) + 1;
                String string3 = "/*[" + n5 + "]" + (String)var13_16;
                AuthorNode authorNode4 = authorNode;
            }
            String string4 = "/*[1]" + (String)var13_16;
        } else {
            String string5 = "/..";
        }
        if (object5 instanceof String && !"".equals(object5)) {
            AuthorNode[] authorNodeArray = authorAccess.getDocumentController().findNodesByXPath((String)object5, true, true, false);
            if (authorNodeArray.length <= 0) throw new AuthorOperationException("The target XPath location does not identify a node: " + object5);
            authorNode = authorNodeArray[0];
        } else {
            authorNode = authorNode2;
        }
        String string6 = null;
        try {
            object3 = authorAccess.getDocumentController().createDocumentFragment(authorElement, true);
            string6 = authorAccess.getDocumentController().serializeFragmentToXML((AuthorDocumentFragment)object3);
        }
        catch (BadLocationException badLocationException) {
            logger.error((Object)badLocationException, (Throwable)badLocationException);
            throw new AuthorOperationException("Could not serialize source", badLocationException);
        }
        if (string6 == null) {
            throw new AuthorOperationException("Cannot serialize the source element: " + object4);
        }
        object3 = authorAccess.getDocumentController().getDoctype();
        if (object3 != null && (object2 = ((AuthorDocumentType)object3).serializeDoctype()) != null) {
            string6 = (String)object2 + string6;
        }
        object2 = new InputSource(new StringReader(string));
        String string7 = authorAccess.getUtilAccess().expandEditorVariables("${framework}", authorAccess.getEditorAccess().getEditorLocation());
        if (string7 != null && string7.contains("${framework}")) {
            string7 = authorAccess.getEditorAccess().getEditorLocation().toString();
        }
        ((InputSource)object2).setSystemId(string7);
        SAXSource sAXSource = new SAXSource((InputSource)object2);
        Transformer transformer = null;
        try {
            transformer = this.createTransformer(authorAccess, sAXSource);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            logger.debug((Object)transformerConfigurationException, (Throwable)transformerConfigurationException);
            throw new AuthorOperationException("Cannot create a transformer from the provided script:\n" + string + "\nReason:" + transformerConfigurationException.getMessage());
        }
        if (transformer == null) return;
        transformer.setParameter(CURRENT_ELEMENT_LOCATION, var13_20);
        StringWriter stringWriter = new StringWriter();
        InputSource inputSource = new InputSource(new StringReader(string6));
        inputSource.setSystemId(authorElement.getXMLBaseURL().toString());
        SAXSource sAXSource2 = new SAXSource(inputSource);
        try {
            transformer.transform(sAXSource2, new StreamResult(stringWriter));
        }
        catch (TransformerException transformerException) {
            throw new AuthorOperationException("The script cannot be executed: " + transformerException.getMessageAndLocation());
        }
        boolean bl = argumentsMap.getArgumentValue(ARGUMENT_EXPAND_EDITOR_VARIABLES) == null || "true".equals(argumentsMap.getArgumentValue(ARGUMENT_EXPAND_EDITOR_VARIABLES));
        boolean bl2 = false;
        String string8 = stringWriter.toString();
        if (string8.startsWith("<?xml ") && (n4 = string8.indexOf("?>")) != -1) {
            string8 = string8.substring(n4 + 2);
        }
        if (bl) {
            string8 = authorAccess.getUtilAccess().expandEditorVariables(string8, authorAccess.getEditorAccess().getEditorLocation());
            n4 = string8.indexOf("${caret}");
            if (n4 != -1) {
                string8 = string8.substring(0, n4) + "<?UNIQUE_CARET_MARKER_FOR_AUTHOR?>" + string8.substring(n4 + "${caret}".length(), string8.length());
                bl2 = true;
            }
            if ((n3 = string8.indexOf("${selection}")) != -1) {
                object = "";
                try {
                    if (authorAccess.getEditorAccess().hasSelection()) {
                        authorDocumentFragment = authorAccess.getDocumentController().createDocumentFragment(authorAccess.getEditorAccess().getSelectionStart(), authorAccess.getEditorAccess().getSelectionEnd() - 1);
                        object = authorAccess.getDocumentController().serializeFragmentToXML(authorDocumentFragment);
                    }
                }
                catch (BadLocationException badLocationException) {
                    logger.error((Object)badLocationException, (Throwable)badLocationException);
                }
                string8 = string8.substring(0, n3) + (String)object + string8.substring(n3 + "${selection}".length(), string8.length());
            }
        }
        n4 = authorAccess.getEditorAccess().getCaretOffset();
        n3 = authorAccess.getEditorAccess().getCaretOffset();
        if (ACTION_REPLACE.equals(object7)) {
            n3 = authorNode.getStartOffset();
        } else if (!ACTION_AT_CARET.equals(object7)) {
            object = object5 != null && ((String)object5).trim().length() > 0 ? (String)object5 : ".";
            n3 = authorAccess.getDocumentController().getXPathLocationOffset((String)object, (String)object7);
        }
        object = null;
        try {
            object = authorAccess.getDocumentController().createPositionInContent(n3);
        }
        catch (BadLocationException badLocationException) {
            logger.error((Object)badLocationException, (Throwable)badLocationException);
        }
        if (ACTION_REPLACE.equals(object7)) {
            if (authorNode.getParent().getType() == 2) {
                authorDocumentFragment = authorAccess.getDocumentController().createNewDocumentFragmentInContext(string8, authorNode.getStartOffset());
                authorAccess.getDocumentController().replaceRoot(authorDocumentFragment);
            } else {
                authorAccess.getDocumentController().insertXMLFragment(string8, authorNode, "Before");
                authorAccess.getDocumentController().deleteNode(authorNode);
            }
        } else if (ACTION_AT_CARET.equals(object7)) {
            authorAccess.getDocumentController().insertXMLFragment(string8, authorAccess.getEditorAccess().getCaretOffset());
        } else {
            authorAccess.getDocumentController().insertXMLFragment(string8, authorNode, (String)object7);
        }
        int n6 = n3 + 1;
        int n7 = n2 = object != null ? object.getOffset() - 1 : n6;
        if (n4 < n6) {
            n4 = n6;
        }
        if (n4 > n2) {
            n4 = n2;
        }
        if (bl2) {
            MoveCaretUtil.moveCaretToImposedEditorVariableOffset(authorAccess, n3);
            return;
        }
        if ("Before".equals(object8)) {
            authorAccess.getEditorAccess().setCaretPosition(n6 - 1);
            return;
        }
        if (CARET_POSITION_START.equals(object8)) {
            authorAccess.getEditorAccess().setCaretPosition(n6);
            return;
        }
        if (CARET_POSITION_PRESERVE.equals(object8)) {
            authorAccess.getEditorAccess().setCaretPosition(n4);
            return;
        }
        if (CARET_POSITION_END.equals(object8)) {
            authorAccess.getEditorAccess().setCaretPosition(n2);
            return;
        }
        if ("After".equals(object8)) {
            authorAccess.getEditorAccess().setCaretPosition(n2 + 1);
            return;
        }
        try {
            authorAccess.getEditorAccess().goToNextEditablePosition(n6 - 1, n2);
            return;
        }
        catch (BadLocationException badLocationException) {
            logger.error((Object)badLocationException, (Throwable)badLocationException);
        }
    }

    protected abstract Transformer createTransformer(AuthorAccess var1, Source var2) throws TransformerConfigurationException;

    @Override
    public ArgumentDescriptor[] getArguments() {
        return this.arguments;
    }

    @Override
    public String getDescription() {
        return "Run a script on a source element and then replace or insert the result in a target node.";
    }
}

