/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations.text;

import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import org.apache.log4j.Logger;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.access.AuthorEditorAccess;
import ro.sync.ecss.extensions.api.content.TextContentIterator;
import ro.sync.ecss.extensions.api.content.TextContext;
import ro.sync.ecss.extensions.commons.operations.text.CapitalizeSentencesOperation;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public abstract class FormSelectedTextOperation
implements AuthorOperation {
    private static final Logger logger = Logger.getLogger((String)CapitalizeSentencesOperation.class.getName());
    private static final char[] WORD_DELIMITERS_CHARS = new char[]{'.', ' ', ';', ':', '\"', '\'', ','};
    private AuthorAccess authorAccess;
    private int selectionStartOffset;

    @Override
    public ArgumentDescriptor[] getArguments() {
        return null;
    }

    protected abstract boolean isDelimiterBeforeTextNode(AuthorAccess var1, int var2) throws BadLocationException, AuthorOperationException;

    protected boolean isWordDelimiter(char c2) {
        boolean bl = false;
        for (int i2 = 0; i2 < WORD_DELIMITERS_CHARS.length; ++i2) {
            if (WORD_DELIMITERS_CHARS[i2] != c2) continue;
            bl = true;
            break;
        }
        return bl;
    }

    @Override
    public void doOperation(AuthorAccess authorAccess, ArgumentsMap argumentsMap) throws AuthorOperationException {
        this.authorAccess = authorAccess;
        AuthorEditorAccess authorEditorAccess = authorAccess.getEditorAccess();
        if (authorEditorAccess.hasSelection()) {
            AuthorDocumentController authorDocumentController = authorAccess.getDocumentController();
            this.selectionStartOffset = authorEditorAccess.getSelectionStart();
            int n2 = authorEditorAccess.getSelectionEnd();
            try {
                Position position = authorDocumentController.createPositionInContent(n2);
                this.processContentRange(authorDocumentController, this.selectionStartOffset, n2 - 1);
                authorEditorAccess.select(this.selectionStartOffset, position.getOffset());
            }
            catch (BadLocationException badLocationException) {
                logger.error((Object)badLocationException, (Throwable)badLocationException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processContentRange(AuthorDocumentController authorDocumentController, int n2, int n3) throws BadLocationException, AuthorOperationException {
        TextContentIterator textContentIterator = authorDocumentController.getTextContentIterator(n2, n3);
        try {
            authorDocumentController.beginCompoundEdit();
            while (textContentIterator.hasNext()) {
                TextContext textContext = textContentIterator.next();
                if (textContext.getEditableState() != 0 && textContext.getEditableState() != 1) continue;
                CharSequence charSequence = textContext.getText();
                char[] cArray = ((Object)charSequence).toString().toCharArray();
                boolean bl = this.isDelimiterBeforeTextNode(this.authorAccess, textContext.getTextStartOffset());
                cArray = this.processTextContent(cArray, bl);
                charSequence = String.copyValueOf(cArray);
                textContext.replaceText(charSequence);
            }
        }
        finally {
            authorDocumentController.endCompoundEdit();
        }
    }

    protected abstract char[] processTextContent(char[] var1, boolean var2);
}

