/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.sort;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.text.Collator;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import javax.swing.text.BadLocationException;
import javax.xml.bind.DatatypeConverter;
import org.apache.log4j.Logger;
import org.eclipse.swt.widgets.Shell;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.ContentInterval;
import ro.sync.ecss.extensions.api.content.TextContentIterator;
import ro.sync.ecss.extensions.api.content.TextContext;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.sort.CriterionInformation;
import ro.sync.ecss.extensions.commons.sort.ECSortCustomizerDialog;
import ro.sync.ecss.extensions.commons.sort.SASortCustomizerDialog;
import ro.sync.ecss.extensions.commons.sort.SortCriteriaInformation;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public abstract class SortOperation
implements AuthorOperation {
    private static final Logger logger = Logger.getLogger((String)SortOperation.class.getName());
    protected static final String COLUMN = "Column";
    protected AuthorAccess authorAccess;
    private SortCriteriaInformation sortInformation = null;
    private final String selElementsString;
    private final String allElementsString;

    public SortOperation(String string, String string2) {
        this.selElementsString = string;
        this.allElementsString = string2;
    }

    @Override
    public String getDescription() {
        return "Sort operation";
    }

    @Override
    public void doOperation(AuthorAccess authorAccess, ArgumentsMap argumentsMap) throws IllegalArgumentException, AuthorOperationException {
        block18: {
            this.authorAccess = authorAccess;
            try {
                int n2;
                Object object;
                Object object2;
                Object object3;
                List<CriterionInformation> list;
                AuthorElement authorElement;
                int n3 = authorAccess.getEditorAccess().getCaretOffset();
                List<ContentInterval> list2 = authorAccess.getEditorAccess().getAuthorSelectionModel().getSelectionIntervals();
                if (list2 != null && !list2.isEmpty()) {
                    n3 = list2.get(0).getStartOffset();
                }
                if ((authorElement = this.getSortParent(n3, authorAccess)) == null || (list = this.getSortCriteria(authorElement)).size() <= 0) break block18;
                int[] nArray = this.getSelectedNonIgnoredChildrenInterval(authorElement);
                this.canBeSorted(authorElement, nArray);
                boolean bl = false;
                try {
                    this.canBeSorted(authorElement, new int[]{0, this.getNonIgnoredChildren(authorElement).size() - 1});
                }
                catch (AuthorOperationException authorOperationException) {
                    bl = true;
                }
                if (authorAccess.getWorkspaceAccess().isStandalone()) {
                    object3 = new SASortCustomizerDialog((Frame)authorAccess.getWorkspaceAccess().getParentFrame(), authorAccess.getAuthorResourceBundle(), authorAccess.getAuthorResourceBundle().getMessage(this.selElementsString), authorAccess.getAuthorResourceBundle().getMessage(this.allElementsString));
                    ((Window)object3).setLocationRelativeTo((Component)authorAccess.getWorkspaceAccess().getParentFrame());
                    this.sortInformation = ((SASortCustomizerDialog)object3).getSortInformation(list, nArray != null, bl);
                } else {
                    this.sortInformation = new ECSortCustomizerDialog((Shell)authorAccess.getWorkspaceAccess().getParentFrame(), authorAccess.getAuthorResourceBundle(), authorAccess.getAuthorResourceBundle().getMessage(this.selElementsString), authorAccess.getAuthorResourceBundle().getMessage(this.allElementsString)).getSortInformation(list, nArray != null, bl);
                }
                if (this.sortInformation == null || this.sortInformation.criteriaInfo == null || this.sortInformation.criteriaInfo.length <= 0) break block18;
                object3 = authorElement.getContentNodes();
                ArrayList<AuthorDocumentFragment> arrayList = new ArrayList<AuthorDocumentFragment>();
                ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
                Locale locale = Locale.getDefault();
                String string = this.detectXMLLangFrom(authorElement);
                if (string != null) {
                    locale = this.createLocale(string);
                }
                final Locale locale2 = locale;
                final AuthorOperationException[] authorOperationExceptionArray = new AuthorOperationException[1];
                TreeSet<SortableFragment> treeSet = new TreeSet<SortableFragment>(new Comparator<SortableFragment>(){

                    @Override
                    public int compare(SortableFragment sortableFragment, SortableFragment sortableFragment2) {
                        for (int i2 = 0; sortableFragment.keyValues != null && sortableFragment2.keyValues != null && i2 < sortableFragment.keyValues.length; ++i2) {
                            Object object;
                            if (sortableFragment.keyValues[i2] == null && sortableFragment2.keyValues[i2] != null) {
                                return CriterionInformation.ORDER.ASCENDING.getName().equals(((SortOperation)SortOperation.this).sortInformation.criteriaInfo[i2].getOrder()) ? 1 : -1;
                            }
                            if (sortableFragment2.keyValues[i2] == null) {
                                return CriterionInformation.ORDER.ASCENDING.getName().equals(((SortOperation)SortOperation.this).sortInformation.criteriaInfo[i2].getOrder()) ? -1 : 1;
                            }
                            if (sortableFragment.keyValues[i2].trim().equals(sortableFragment2.keyValues[i2].trim())) continue;
                            int n2 = 0;
                            ((SortableFragment)sortableFragment).keyValues[i2] = sortableFragment.keyValues[i2].trim();
                            ((SortableFragment)sortableFragment2).keyValues[i2] = sortableFragment2.keyValues[i2].trim();
                            if (CriterionInformation.TYPE.NUMERIC.getName().equals(((SortOperation)SortOperation.this).sortInformation.criteriaInfo[i2].getType())) {
                                object = this.parseNumber(authorOperationExceptionArray, sortableFragment.keyValues[i2]);
                                if (authorOperationExceptionArray[0] == null) {
                                    Double d2 = this.parseNumber(authorOperationExceptionArray, sortableFragment2.keyValues[i2]);
                                    if (authorOperationExceptionArray[0] == null) {
                                        n2 = CriterionInformation.ORDER.ASCENDING.getName().equals(((SortOperation)SortOperation.this).sortInformation.criteriaInfo[i2].getOrder()) ? ((Double)object).compareTo(d2) : d2.compareTo((Double)object);
                                    }
                                }
                            } else if (CriterionInformation.TYPE.DATE.getName().equals(((SortOperation)SortOperation.this).sortInformation.criteriaInfo[i2].getType())) {
                                object = new int[]{2, 3, 2, 1, 0};
                                Date date = null;
                                Date date2 = null;
                                for (int i3 = 0; i3 < ((Object)object).length && (date == null || date2 == null); ++i3) {
                                    DateFormat dateFormat = DateFormat.getDateTimeInstance((int)object[i3], (int)object[i3], Locale.getDefault());
                                    DateFormat dateFormat2 = DateFormat.getDateInstance((int)object[i3], Locale.getDefault());
                                    DateFormat dateFormat3 = DateFormat.getTimeInstance((int)object[i3], Locale.getDefault());
                                    if (date == null) {
                                        date = this.parseDate(authorOperationExceptionArray, sortableFragment.keyValues[i2], dateFormat, dateFormat2, dateFormat3);
                                    }
                                    if (date2 != null) continue;
                                    date2 = this.parseDate(authorOperationExceptionArray, sortableFragment2.keyValues[i2], dateFormat, dateFormat2, dateFormat3);
                                }
                                if (date == null) {
                                    date = this.parseXSD_DATETIME(authorOperationExceptionArray, sortableFragment.keyValues[i2]);
                                }
                                if (date2 == null) {
                                    date2 = this.parseXSD_DATETIME(authorOperationExceptionArray, sortableFragment2.keyValues[i2]);
                                }
                                if (date != null && date2 != null) {
                                    n2 = CriterionInformation.ORDER.ASCENDING.getName().equals(((SortOperation)SortOperation.this).sortInformation.criteriaInfo[i2].getOrder()) ? date.compareTo(date2) : date2.compareTo(date);
                                    authorOperationExceptionArray[0] = null;
                                }
                            } else {
                                object = Collator.getInstance(locale2);
                                ((Collator)object).setStrength(2);
                                ((Collator)object).setDecomposition(2);
                                int n3 = ((Collator)object).compare(sortableFragment.keyValues[i2], sortableFragment2.keyValues[i2]);
                                int n4 = n2 = CriterionInformation.ORDER.ASCENDING.getName().equals(((SortOperation)SortOperation.this).sortInformation.criteriaInfo[i2].getOrder()) ? n3 : -n3;
                            }
                            if (authorOperationExceptionArray[0] != null) break;
                            if (n2 == 0) continue;
                            return n2;
                        }
                        return 1;
                    }

                    private Date parseXSD_DATETIME(AuthorOperationException[] authorOperationExceptionArray2, String string) {
                        Date date = null;
                        Calendar calendar = null;
                        try {
                            calendar = DatatypeConverter.parseDateTime((String)string);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            try {
                                calendar = DatatypeConverter.parseDate((String)string);
                            }
                            catch (IllegalArgumentException illegalArgumentException2) {
                                try {
                                    calendar = DatatypeConverter.parseTime((String)string);
                                }
                                catch (IllegalArgumentException illegalArgumentException3) {
                                    authorOperationExceptionArray2[0] = new AuthorOperationException("Unable to parse the following text value as a date:\n\"" + string + "\"");
                                }
                            }
                        }
                        if (calendar != null) {
                            long l2 = calendar.getTimeInMillis();
                            date = new Date(l2);
                        }
                        return date;
                    }

                    private Date parseDate(AuthorOperationException[] authorOperationExceptionArray2, String string, DateFormat dateFormat, DateFormat dateFormat2, DateFormat dateFormat3) {
                        Date date = null;
                        try {
                            date = dateFormat.parse(string);
                        }
                        catch (ParseException parseException) {
                            try {
                                date = dateFormat2.parse(string);
                            }
                            catch (ParseException parseException2) {
                                try {
                                    date = dateFormat3.parse(string);
                                }
                                catch (ParseException parseException3) {
                                    authorOperationExceptionArray2[0] = new AuthorOperationException("Unable to parse the following text value as a date:\n\"" + string + "\"");
                                }
                            }
                        }
                        return date;
                    }

                    private Double parseNumber(AuthorOperationException[] authorOperationExceptionArray2, String string) {
                        Double d2 = 0.0;
                        try {
                            d2 = string.isEmpty() ? Double.valueOf(Double.MIN_VALUE) : Double.valueOf(Double.parseDouble(string));
                        }
                        catch (NumberFormatException numberFormatException) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)numberFormatException, (Throwable)numberFormatException);
                            }
                            authorOperationExceptionArray2[0] = new AuthorOperationException("Unable to parse the following text value as a number:\n\"" + string + "\"", numberFormatException);
                        }
                        return d2;
                    }
                });
                int n4 = 0;
                int n5 = 0;
                AuthorDocumentFragment[] authorDocumentFragmentArray = object3.iterator();
                while (authorDocumentFragmentArray.hasNext()) {
                    object2 = (AuthorNode)authorDocumentFragmentArray.next();
                    try {
                        if (this.isIgnored((AuthorNode)object2) || this.sortInformation.onlySelectedElements && nArray != null && (nArray[0] > n5 || nArray[1] < n5)) {
                            arrayList.add(authorAccess.getDocumentController().createDocumentFragment((AuthorNode)object2, true));
                            arrayList2.add(n4);
                        } else {
                            object = new SortableFragment();
                            ((SortableFragment)object).documentFragment = authorAccess.getDocumentController().createDocumentFragment((AuthorNode)object2, true);
                            SortableFragment.access$002((SortableFragment)object, this.getSortKeysValues((AuthorNode)object2, this.sortInformation));
                            treeSet.add((SortableFragment)object);
                            if (authorOperationExceptionArray[0] != null) {
                                throw authorOperationExceptionArray[0];
                            }
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        logger.error((Object)badLocationException, (Throwable)badLocationException);
                        throw new AuthorOperationException(badLocationException.getMessage(), badLocationException);
                    }
                    if (!this.isIgnored((AuthorNode)object2)) {
                        ++n5;
                    }
                    ++n4;
                }
                authorDocumentFragmentArray = new AuthorDocumentFragment[treeSet.size() + arrayList.size()];
                object2 = new int[authorDocumentFragmentArray.length];
                object = arrayList.iterator();
                Iterator iterator = arrayList2.iterator();
                while (iterator.hasNext() && object.hasNext()) {
                    n2 = (Integer)iterator.next();
                    authorDocumentFragmentArray[n2] = (AuthorDocumentFragment)object.next();
                }
                object2[0] = authorElement.getStartOffset() + 1;
                iterator = treeSet.iterator();
                for (n2 = 0; n2 < authorDocumentFragmentArray.length; ++n2) {
                    if (authorDocumentFragmentArray[n2] == null && iterator.hasNext()) {
                        AuthorDocumentFragment authorDocumentFragment;
                        authorDocumentFragmentArray[n2] = authorDocumentFragment = ((SortableFragment)iterator.next()).documentFragment;
                    }
                    if (n2 <= 0) continue;
                    object2[n2] = authorElement.getStartOffset() + 1;
                }
                authorAccess.getDocumentController().delete(authorElement.getStartOffset() + 1, authorElement.getEndOffset());
                authorAccess.getDocumentController().insertMultipleFragments(authorElement, authorDocumentFragmentArray, (int[])object2);
                authorAccess.getEditorAccess().setCaretPosition(n3);
            }
            catch (AuthorOperationException authorOperationException) {
                authorAccess.getWorkspaceAccess().showErrorMessage("The sort operation couldn't be performed.\n" + authorOperationException.getMessage());
            }
        }
    }

    private Locale createLocale(String string) {
        int n2 = string.indexOf(45);
        String string2 = string;
        String string3 = "";
        if (n2 > 0) {
            string2 = string.substring(0, n2);
            String[] stringArray = Locale.getISOLanguages();
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (!stringArray[i2].equals(string2) && !stringArray[i2].equals(string2.toLowerCase()) && !stringArray[i2].equals(string2.toUpperCase())) continue;
                string2 = stringArray[i2];
            }
            string3 = string.substring(n2 + 1);
            String[] stringArray2 = Locale.getISOCountries();
            for (int i3 = 0; i3 < stringArray2.length; ++i3) {
                if (!stringArray2[i3].equals(string2) && !stringArray2[i3].equals(string2.toLowerCase()) && !stringArray2[i3].equals(string2.toUpperCase())) continue;
                string3 = stringArray2[i3];
            }
        }
        return new Locale(string2, string3);
    }

    public abstract void canBeSorted(AuthorElement var1, int[] var2) throws AuthorOperationException;

    public int[] getSelectedNonIgnoredChildrenInterval(AuthorElement authorElement) {
        int[] nArray = null;
        if (this.authorAccess.getEditorAccess().hasSelection()) {
            List<AuthorNode> list = this.getNonIgnoredChildren(authorElement);
            if (this.forceSortAll()) {
                return null;
            }
            List<ContentInterval> list2 = this.authorAccess.getEditorAccess().getAuthorSelectionModel().getSelectionIntervals();
            int n2 = 0;
            int n3 = -1;
            boolean bl = true;
            for (int i2 = 0; i2 < list2.size(); ++i2) {
                ContentInterval contentInterval = list2.get(i2);
                int[] nArray2 = this.getSelectionElementsIndices(authorElement, list, contentInterval.getStartOffset(), contentInterval.getEndOffset());
                if (i2 == 0) {
                    n2 = nArray2[0];
                    n3 = nArray2[1];
                    continue;
                }
                if (nArray2[0] - 1 == n3) {
                    n3 = nArray2[1];
                    continue;
                }
                bl = false;
                break;
            }
            if (bl) {
                nArray = new int[]{n2, n3};
            }
        }
        return nArray;
    }

    protected boolean forceSortAll() {
        return false;
    }

    private int[] getSelectionElementsIndices(AuthorElement authorElement, List<AuthorNode> list, int n2, int n3) {
        int n4 = -1;
        int n5 = -1;
        int n6 = list.size();
        for (int i2 = 0; i2 < n6; ++i2) {
            AuthorNode authorNode = list.get(i2);
            if (authorNode.getStartOffset() <= n2 && authorNode.getEndOffset() >= n2 || n4 == -1 && n2 <= authorNode.getStartOffset() && n3 >= authorNode.getStartOffset()) {
                n4 = i2;
            }
            if ((authorNode.getStartOffset() > n3 || authorNode.getEndOffset() < n3) && (n2 > authorNode.getEndOffset() || n3 < authorNode.getEndOffset())) continue;
            n5 = i2;
        }
        return new int[]{n4, n5};
    }

    protected List<AuthorNode> getNonIgnoredChildren(AuthorElement authorElement) {
        ArrayList<AuthorNode> arrayList = new ArrayList<AuthorNode>();
        List<AuthorNode> list = authorElement.getContentNodes();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            AuthorNode authorNode = list.get(i2);
            if (this.isIgnored(authorNode)) continue;
            arrayList.add(authorNode);
        }
        return arrayList;
    }

    public abstract AuthorElement getSortParent(int var1, AuthorAccess var2) throws AuthorOperationException;

    public abstract boolean isIgnored(AuthorNode var1);

    public abstract String[] getSortKeysValues(AuthorNode var1, SortCriteriaInformation var2) throws AuthorOperationException;

    public abstract List<CriterionInformation> getSortCriteria(AuthorElement var1) throws AuthorOperationException;

    @Override
    public ArgumentDescriptor[] getArguments() {
        return null;
    }

    protected String getTextContentToSort(AuthorNode authorNode) {
        TextContentIterator textContentIterator = this.authorAccess.getDocumentController().getTextContentIterator(authorNode.getStartOffset(), authorNode.getEndOffset());
        StringBuilder stringBuilder = new StringBuilder();
        while (textContentIterator.hasNext()) {
            TextContext textContext = textContentIterator.next();
            if (textContext.getEditableState() == 2) continue;
            stringBuilder.append(textContext.getText());
        }
        return stringBuilder.toString().trim();
    }

    private String detectXMLLangFrom(AuthorNode authorNode) {
        if (authorNode == null) {
            return null;
        }
        if (authorNode.getType() == 0) {
            String string;
            AttrValue attrValue = ((AuthorElement)authorNode).getAttribute("xml:lang");
            String string2 = string = attrValue != null ? attrValue.getValue() : null;
            if (string == null) {
                attrValue = ((AuthorElement)authorNode).getAttribute("lang");
                String string3 = string = attrValue != null ? attrValue.getValue() : null;
            }
            if (string != null) {
                return string;
            }
            String string4 = this.detectXMLLangFrom(authorNode.getParent());
            return string4;
        }
        String string = this.detectXMLLangFrom(authorNode.getParent());
        return string;
    }

    private static class SortableFragment {
        private AuthorDocumentFragment documentFragment;
        private String[] keyValues;

        private SortableFragment() {
        }

        static /* synthetic */ String[] access$002(SortableFragment sortableFragment, String[] stringArray) {
            sortableFragment.keyValues = stringArray;
            return stringArray;
        }
    }
}

