/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.operations;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.text.BadLocationException;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.UniqueAttributesProcessor;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.table.operations.AuthorTableHelper;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public abstract class AbstractTableOperation
implements AuthorOperation {
    protected AuthorTableHelper tableHelper;

    public AbstractTableOperation(AuthorTableHelper authorTableHelper) {
        this.tableHelper = authorTableHelper;
    }

    protected AuthorElement getElementAncestor(AuthorNode authorNode, int n2) {
        AuthorElement authorElement = null;
        while (authorNode != null && authorNode instanceof AuthorElement) {
            if (this.isTableElement(authorNode, n2)) {
                authorElement = (AuthorElement)authorNode;
                break;
            }
            authorNode = authorNode.getParent();
        }
        return authorElement;
    }

    protected boolean isElement(AuthorNode authorNode, String string) {
        return authorNode instanceof AuthorElement && string.equals(((AuthorElement)authorNode).getLocalName());
    }

    protected boolean isTableElement(AuthorNode authorNode, int n2) {
        boolean bl = false;
        switch (n2) {
            case 0: {
                bl = this.tableHelper.isTableCell(authorNode);
                break;
            }
            case 1: {
                bl = this.tableHelper.isTableRow(authorNode);
                break;
            }
            case 2: {
                bl = this.tableHelper.isTable(authorNode);
            }
        }
        return bl;
    }

    protected int findCellInsertionOffset(AuthorAccess authorAccess, AuthorElement authorElement, int n2, int n3) {
        int n4 = -1;
        AuthorElement authorElement2 = authorAccess.getTableAccess().getTableRow(n2, authorElement);
        if (authorElement2 != null) {
            if (n3 == 0) {
                n4 = authorElement2.getStartOffset() + 1;
            } else {
                AuthorNode authorNode = null;
                for (AuthorNode authorNode2 : authorElement2.getContentNodes()) {
                    int[] nArray;
                    if (!this.tableHelper.isTableCell(authorNode2) || (nArray = authorAccess.getTableAccess().getTableCellIndex((AuthorElement)authorNode2)) == null) continue;
                    if (nArray[1] >= n3) break;
                    authorNode = (AuthorElement)authorNode2;
                }
                n4 = authorNode != null ? authorNode.getEndOffset() + 1 : authorElement2.getStartOffset() + 1;
            }
        }
        return n4;
    }

    protected AuthorDocumentFragment createEmptyCell(AuthorAccess authorAccess, AuthorElement authorElement, String[] stringArray) throws BadLocationException {
        AuthorNode authorNode;
        AuthorDocumentFragment authorDocumentFragment = null;
        AuthorDocumentController authorDocumentController = authorAccess.getDocumentController();
        authorDocumentFragment = authorDocumentController.createDocumentFragment(authorElement, false);
        List<AuthorNode> list = authorDocumentFragment.getContentNodes();
        if (list != null && list.size() > 0 && (authorNode = list.get(0)).getType() == 0) {
            UniqueAttributesProcessor uniqueAttributesProcessor;
            AuthorElement authorElement2 = (AuthorElement)authorNode;
            HashSet<String> hashSet = new HashSet<String>();
            if (stringArray != null) {
                hashSet.addAll(Arrays.asList(stringArray));
            }
            if ((uniqueAttributesProcessor = authorDocumentController.getUniqueAttributesProcessor()) != null) {
                int n2 = authorElement2.getAttributesCount();
                for (int i2 = 0; i2 < n2; ++i2) {
                    String string = authorElement2.getAttributeAtIndex(i2);
                    if (uniqueAttributesProcessor.copyAttributeOnSplit(string, authorElement2)) continue;
                    hashSet.add(string);
                }
            }
            if (!hashSet.isEmpty()) {
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    authorElement2.removeAttribute((String)iterator.next());
                }
            }
        }
        return authorDocumentFragment;
    }
}

