/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.operations;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.text.BadLocationException;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorSelectionModel;
import ro.sync.ecss.extensions.api.AuthorTableCellSpanProvider;
import ro.sync.ecss.extensions.api.ContentInterval;
import ro.sync.ecss.extensions.api.SelectionInterpretationMode;
import ro.sync.ecss.extensions.api.access.AuthorTableAccess;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.table.operations.AbstractTableOperation;
import ro.sync.ecss.extensions.commons.table.operations.AuthorTableHelper;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public abstract class DeleteColumnOperationBase
extends AbstractTableOperation {
    protected AuthorElement tableElem = null;
    protected int deletedColumnIndex = -1;

    public DeleteColumnOperationBase(AuthorTableHelper authorTableHelper) {
        super(authorTableHelper);
    }

    public boolean performDeleteColumn(AuthorAccess authorAccess, List<ContentInterval> list, boolean bl) throws AuthorOperationException {
        boolean bl2 = false;
        this.tableElem = null;
        int n2 = -1;
        this.deletedColumnIndex = -1;
        try {
            Object object;
            Object object2;
            int n3;
            int n4;
            Iterator<ContentInterval> iterator;
            Object object3;
            Object object4;
            AuthorTableAccess authorTableAccess = authorAccess.getTableAccess();
            if (list != null && list.size() > 0) {
                object4 = list.get(0);
                this.tableElem = this.getElementAncestor(authorAccess.getDocumentController().getNodeAtOffset(((ContentInterval)object4).getStartOffset()), 2);
                if (!this.canDeleteColumn()) {
                    return false;
                }
                if (this.tableElem != null) {
                    object3 = this.tableHelper.getTableCellSpanProvider(this.tableElem);
                    iterator = list.iterator();
                    int n5 = authorTableAccess.getTableRowCount(this.tableElem);
                    int n6 = authorTableAccess.getTableNumberOfColumns(this.tableElem);
                    block2: for (n4 = 0; n4 < n5; ++n4) {
                        block3: for (n3 = 0; n3 < n6; ++n3) {
                            object2 = authorTableAccess.getTableCellAt(n4, n3, this.tableElem);
                            if (object2 == null) continue;
                            iterator = list.iterator();
                            while (iterator.hasNext()) {
                                ContentInterval contentInterval = iterator.next();
                                if (object2.getStartOffset() != contentInterval.getStartOffset() || object2.getEndOffset() != contentInterval.getEndOffset() - 1) continue;
                                object = object3.getColSpan((AuthorElement)object2);
                                if (object != null && (Integer)object > 1) {
                                    iterator.remove();
                                    continue block3;
                                }
                                authorAccess.getEditorAccess().setCaretPosition(object2.getStartOffset() + 1);
                                break block2;
                            }
                        }
                    }
                }
            }
            object4 = authorAccess.getDocumentController().getNodeAtOffset(authorAccess.getEditorAccess().getCaretOffset());
            object3 = this.getElementAncestor((AuthorNode)object4, 0);
            iterator = this.getElementAncestor((AuthorNode)object4, 1);
            this.tableElem = this.getElementAncestor((AuthorNode)object4, 2);
            if (object3 != null && this.tableElem != null) {
                AuthorElement authorElement;
                Object object5;
                int[] nArray = authorTableAccess.getTableCellIndex((AuthorElement)object3);
                n2 = nArray[0];
                this.deletedColumnIndex = nArray[1];
                ArrayList<int[]> arrayList = new ArrayList<int[]>();
                n4 = authorTableAccess.getTableRowCount(this.tableElem);
                n3 = authorTableAccess.getTableNumberOfColumns(this.tableElem);
                object2 = this.tableHelper.getTableCellSpanProvider(this.tableElem);
                for (int i2 = 0; i2 < n4; ++i2) {
                    int n7;
                    object = authorTableAccess.getTableCellAt(i2, this.deletedColumnIndex, this.tableElem);
                    if (object == null) continue;
                    int[] nArray2 = authorTableAccess.getTableColSpanIndices((AuthorElement)object);
                    object5 = object2.getColSpan((AuthorElement)object);
                    Integer n8 = object2.getRowSpan((AuthorElement)object);
                    int n9 = object5 != null ? (Integer)object5 : 1;
                    int n10 = n7 = n8 != null ? n8 : 1;
                    if (n9 == 1) {
                        arrayList.add(new int[]{object.getStartOffset(), object.getEndOffset()});
                    } else {
                        this.updateTableColSpan(authorAccess, (AuthorTableCellSpanProvider)object2, (AuthorElement)object, nArray2[0] + 1, nArray2[1] + 1);
                    }
                    if (n7 <= 1) continue;
                    i2 += n7 - 1;
                }
                if (!arrayList.isEmpty()) {
                    int[] nArray3 = new int[arrayList.size()];
                    object = new int[arrayList.size()];
                    for (int i3 = 0; i3 < nArray3.length; ++i3) {
                        object5 = (int[])arrayList.get(i3);
                        nArray3[i3] = (int)object5[0];
                        object[i3] = object5[1];
                    }
                    authorAccess.getDocumentController().multipleDelete(this.tableElem, nArray3, (int[])object);
                }
                this.tableHelper.updateTableColumnNumber(authorAccess, this.tableElem, n3 - 1);
                if (this.deletedColumnIndex != -1) {
                    this.updateAppliableColWidthsNumber(authorAccess, this.tableElem, this.deletedColumnIndex);
                }
                if ((authorElement = authorTableAccess.getTableCellAt(n2, this.deletedColumnIndex, this.tableElem)) != null) {
                    authorAccess.getEditorAccess().setCaretPosition(authorElement.getStartOffset() + (bl ? 1 : 0));
                } else {
                    authorAccess.getEditorAccess().setCaretPosition(iterator.getEndOffset());
                }
                bl2 = true;
            }
        }
        catch (BadLocationException badLocationException) {
            throw new AuthorOperationException("The operation cannot be performed due to: " + badLocationException.getMessage(), badLocationException);
        }
        return bl2;
    }

    protected void updateAppliableColWidthsNumber(AuthorAccess authorAccess, AuthorElement authorElement, int n2) {
    }

    @Override
    public final void doOperation(AuthorAccess authorAccess, ArgumentsMap argumentsMap) throws IllegalArgumentException, AuthorOperationException {
        List<ContentInterval> list = null;
        AuthorSelectionModel authorSelectionModel = authorAccess.getEditorAccess().getAuthorSelectionModel();
        SelectionInterpretationMode selectionInterpretationMode = authorSelectionModel.getSelectionInterpretationMode();
        if (selectionInterpretationMode == SelectionInterpretationMode.TABLE_COLUMN) {
            list = authorSelectionModel.getSelectionIntervals();
        }
        this.performDeleteColumn(authorAccess, list, true);
    }

    protected abstract void updateTableColSpan(AuthorAccess var1, AuthorTableCellSpanProvider var2, AuthorElement var3, int var4, int var5) throws AuthorOperationException;

    @Override
    public ArgumentDescriptor[] getArguments() {
        return null;
    }

    @Override
    public String getDescription() {
        return "Delete the current table column.";
    }

    protected boolean canDeleteColumn() {
        return true;
    }
}

