/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.operations;

import javax.swing.text.BadLocationException;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorTableCellSpanProvider;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.table.operations.AbstractTableOperation;
import ro.sync.ecss.extensions.commons.table.operations.AuthorTableHelper;
import ro.sync.ecss.extensions.commons.table.operations.DeleteRowOperationBase;
import ro.sync.ecss.extensions.commons.table.operations.SplitCellAboveBelowOperationBase;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public abstract class JoinCellAboveBelowOperationBase
extends AbstractTableOperation {
    public static final String JOIN_ABOVE = "Above";
    public static final String JOIN_BELOW = "Below";
    private static final String ARGUMENT_NAME = "Join direction";

    public JoinCellAboveBelowOperationBase(AuthorTableHelper authorTableHelper) {
        super(authorTableHelper);
    }

    @Override
    public void doOperation(AuthorAccess authorAccess, ArgumentsMap argumentsMap) throws IllegalArgumentException, AuthorOperationException {
        block17: {
            try {
                Object object;
                int n2 = authorAccess.getEditorAccess().getCaretOffset();
                AuthorNode authorNode = authorAccess.getDocumentController().getNodeAtOffset(n2);
                AuthorElement authorElement = null;
                if (authorAccess.getEditorAccess().hasSelection() && (object = authorAccess.getEditorAccess().getFullySelectedNode()) != null && this.isTableElement((AuthorNode)object, 0)) {
                    authorElement = (AuthorElement)object;
                }
                if (authorElement == null) {
                    authorElement = this.getElementAncestor(authorNode, 0);
                }
                if (authorElement != null) {
                    object = this.getElementAncestor(authorNode, 2);
                    if (object != null) {
                        DeleteRowOperationBase deleteRowOperationBase;
                        Object object2;
                        int n3;
                        int n4;
                        AuthorTableCellSpanProvider authorTableCellSpanProvider = this.tableHelper.getTableCellSpanProvider((AuthorElement)object);
                        AuthorElement authorElement2 = null;
                        AuthorElement authorElement3 = null;
                        String string = (String)argumentsMap.getArgumentValue(ARGUMENT_NAME);
                        if (JOIN_BELOW.equals(string)) {
                            authorElement2 = authorElement;
                            authorElement3 = authorAccess.getTableAccess().getTableCellBelow(authorElement);
                            if (authorElement3 == null) {
                                AuthorOperationException authorOperationException = new AuthorOperationException("There is no cell below.");
                                authorOperationException.setOperationRejectedOnPurpose(true);
                                throw authorOperationException;
                            }
                        } else {
                            authorElement2 = authorAccess.getTableAccess().getTableCellAbove(authorElement);
                            authorElement3 = authorElement;
                            if (authorElement2 == null) {
                                AuthorOperationException authorOperationException = new AuthorOperationException("There is no cell above.");
                                authorOperationException.setOperationRejectedOnPurpose(true);
                                throw authorOperationException;
                            }
                        }
                        Integer n5 = authorTableCellSpanProvider.getColSpan(authorElement2);
                        Integer n6 = authorTableCellSpanProvider.getColSpan(authorElement3);
                        int n7 = n5 != null ? n5 : 1;
                        int n8 = n4 = n6 != null ? n6 : 1;
                        if (n7 != n4) {
                            AuthorOperationException authorOperationException = new AuthorOperationException("The column spans of the involved cells are different.");
                            authorOperationException.setOperationRejectedOnPurpose(true);
                            throw authorOperationException;
                        }
                        AuthorDocumentController authorDocumentController = authorAccess.getDocumentController();
                        AuthorDocumentFragment authorDocumentFragment = null;
                        if (authorElement3.getStartOffset() + 1 < authorElement3.getEndOffset()) {
                            authorDocumentFragment = authorDocumentController.createDocumentFragment(authorElement3.getStartOffset() + 1, authorElement3.getEndOffset() - 1);
                        }
                        Object object3 = null;
                        int[] nArray = authorAccess.getTableAccess().getTableCellIndex(authorElement3);
                        if (nArray != null) {
                            n3 = nArray[0];
                            object2 = authorAccess.getTableAccess().getTableRow(n3, (AuthorElement)object);
                            if (object2 != null && object2.getContentNodes().size() == 1) {
                                object3 = object2;
                            }
                        }
                        n3 = authorDocumentController.deleteNode(authorElement3) ? 1 : 0;
                        if (authorDocumentFragment != null) {
                            authorDocumentController.insertFragment(authorElement2.getEndOffset(), authorDocumentFragment);
                        }
                        object2 = authorTableCellSpanProvider.getRowSpan(authorElement2);
                        Integer n9 = authorTableCellSpanProvider.getRowSpan(authorElement3);
                        int n10 = object2 != null ? (Integer)object2 : 1;
                        int n11 = n9 != null ? n9 : 1;
                        this.tableHelper.updateTableRowSpan(authorAccess, authorElement2, n10 + n11);
                        if (authorDocumentFragment == null) {
                            authorAccess.getEditorAccess().setCaretPosition(authorElement2.getEndOffset());
                        }
                        if (n3 != 0 && object3 != null && (deleteRowOperationBase = this.createDeleteRowOperation()) != null) {
                            deleteRowOperationBase.performDeleteRows(authorAccess, object3.getStartOffset(), object3.getEndOffset() + 1);
                            authorAccess.getEditorAccess().setCaretPosition(authorElement2.getEndOffset());
                        }
                        break block17;
                    }
                    throw new AuthorOperationException("The table cell must be inside a table element.");
                }
                object = new AuthorOperationException("The caret must be inside a table cell or a cell must be selected.");
                ((AuthorOperationException)object).setOperationRejectedOnPurpose(true);
                throw object;
            }
            catch (BadLocationException badLocationException) {
                throw new AuthorOperationException("The operation cannot be performed due to: " + badLocationException.getMessage(), badLocationException);
            }
        }
    }

    protected DeleteRowOperationBase createDeleteRowOperation() {
        return new DeleteRowOperationBase(this.tableHelper){

            @Override
            protected SplitCellAboveBelowOperationBase createSplitCellOperation() {
                return null;
            }
        };
    }

    @Override
    public ArgumentDescriptor[] getArguments() {
        return new ArgumentDescriptor[]{new ArgumentDescriptor(ARGUMENT_NAME, 3, "The join direction relative to the source cell.", new String[]{JOIN_ABOVE, JOIN_BELOW}, JOIN_ABOVE)};
    }

    @Override
    public String getDescription() {
        return "This operation joins the content of two cells from adjacent rows.";
    }
}

