/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.operations;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorTableCellSpanProvider;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.table.operations.AbstractTableOperation;
import ro.sync.ecss.extensions.commons.table.operations.AuthorTableHelper;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public abstract class JoinRowCellsOperationBase
extends AbstractTableOperation {
    public JoinRowCellsOperationBase(AuthorTableHelper authorTableHelper) {
        super(authorTableHelper);
    }

    @Override
    public void doOperation(AuthorAccess authorAccess, ArgumentsMap argumentsMap) throws IllegalArgumentException, AuthorOperationException {
        block13: {
            try {
                Object object;
                AuthorNode authorNode;
                Object object2;
                AuthorElement authorElement = null;
                AuthorElement authorElement2 = null;
                if (authorAccess.getEditorAccess().hasSelection()) {
                    authorElement = this.getFirstCell(authorAccess);
                    authorElement2 = this.getLastCell(authorAccess);
                } else {
                    object2 = authorAccess.getDocumentController().getNodeAtOffset(authorAccess.getEditorAccess().getCaretOffset());
                    if (this.tableHelper.isTableRow((AuthorNode)object2)) {
                        authorNode = authorAccess.getDocumentController().getNodeAtOffset(authorAccess.getEditorAccess().getCaretOffset() - 1);
                        if (this.tableHelper.isTableCell(authorNode)) {
                            authorElement = (AuthorElement)authorNode;
                        }
                        if (this.tableHelper.isTableCell((AuthorNode)(object = authorAccess.getDocumentController().getNodeAtOffset(authorAccess.getEditorAccess().getCaretOffset() + 1)))) {
                            authorElement2 = (AuthorElement)object;
                        }
                    }
                }
                if (authorElement != null && authorElement2 != null && authorElement != authorElement2) {
                    object2 = (AuthorElement)authorElement.getParent();
                    if (object2 == (authorNode = (AuthorElement)authorElement2.getParent())) {
                        object = this.getElementAncestor((AuthorNode)object2, 2);
                        if (object != null) {
                            AuthorTableCellSpanProvider authorTableCellSpanProvider = this.tableHelper.getTableCellSpanProvider((AuthorElement)object);
                            if (!authorTableCellSpanProvider.hasColumnSpecifications((AuthorElement)object) && authorAccess.getWorkspaceAccess().showConfirmDialog("Column specifications", "Join cells operation requires column specifications. Do you want to generate them?", new String[]{"Yes", "No"}, new int[]{0, 1}) == 0) {
                                this.generateColumnSpecifications(authorAccess, authorTableCellSpanProvider, (AuthorElement)object);
                            }
                            this.tableHelper.checkTableColSpanIsDefined(authorAccess, authorTableCellSpanProvider, authorElement);
                            this.tableHelper.checkTableColSpanIsDefined(authorAccess, authorTableCellSpanProvider, authorElement2);
                            List list = this.getCellsBetweenOffsets((AuthorElement)object2, authorElement.getEndOffset() + 1, authorElement2.getEndOffset());
                            AuthorElement authorElement3 = authorElement;
                            this.checkForSameRowSpan(authorTableCellSpanProvider, authorElement3, list);
                            this.updateColSpanForMergedCell(authorAccess, authorTableCellSpanProvider, authorElement3, list);
                            int n2 = list.size();
                            for (int i2 = 0; i2 < n2; ++i2) {
                                AuthorElement authorElement4 = (AuthorElement)list.get(i2);
                                AuthorDocumentFragment authorDocumentFragment = null;
                                if (authorElement4.getEndOffset() - authorElement4.getStartOffset() > 1) {
                                    authorDocumentFragment = authorAccess.getDocumentController().createDocumentFragment(authorElement4.getStartOffset() + 1, authorElement4.getEndOffset() - 1);
                                }
                                authorAccess.getDocumentController().deleteNode(authorElement4);
                                if (authorDocumentFragment == null) continue;
                                authorAccess.getDocumentController().insertFragment(authorElement3.getEndOffset(), authorDocumentFragment);
                            }
                            authorAccess.getEditorAccess().setCaretPosition(authorElement3.getEndOffset());
                        }
                        break block13;
                    }
                    object = new AuthorOperationException("The selected cells must be from the same table row.");
                    ((AuthorOperationException)object).setOperationRejectedOnPurpose(true);
                    throw object;
                }
                object2 = new AuthorOperationException("The operation is enabled only when there is a selection that contains at least two cells from the same row of a table or when the caret is positioned between two horizontally adjacent cells.");
                ((AuthorOperationException)object2).setOperationRejectedOnPurpose(true);
                throw object2;
            }
            catch (BadLocationException badLocationException) {
                throw new AuthorOperationException("Operation failed: " + badLocationException.getMessage());
            }
        }
    }

    private void checkForSameRowSpan(AuthorTableCellSpanProvider authorTableCellSpanProvider, AuthorElement authorElement, List list) throws AuthorOperationException {
        Integer n2 = authorTableCellSpanProvider.getRowSpan(authorElement);
        int n3 = n2 != null ? n2 : 1;
        for (AuthorElement authorElement2 : list) {
            Integer n4 = authorTableCellSpanProvider.getRowSpan(authorElement2);
            int n5 = n4 != null ? n4 : 1;
            if (n3 == n5) continue;
            AuthorOperationException authorOperationException = new AuthorOperationException("Join operation is possible only for cells with the same row span.");
            authorOperationException.setOperationRejectedOnPurpose(true);
            throw authorOperationException;
        }
    }

    protected AuthorElement getLastCell(AuthorAccess authorAccess) throws BadLocationException {
        AuthorElement authorElement = null;
        int n2 = authorAccess.getEditorAccess().getSelectionEnd();
        AuthorNode authorNode = authorAccess.getDocumentController().getNodeAtOffset(n2);
        if (this.tableHelper.isTableRow(authorNode)) {
            AuthorNode authorNode2 = authorAccess.getDocumentController().getNodeAtOffset(n2 - 1);
            if (this.tableHelper.isTableCell(authorNode2)) {
                authorElement = (AuthorElement)authorNode2;
            }
        } else {
            authorElement = this.getElementAncestor(authorNode, 0);
        }
        return authorElement;
    }

    protected AuthorElement getFirstCell(AuthorAccess authorAccess) throws BadLocationException {
        AuthorElement authorElement = null;
        int n2 = authorAccess.getEditorAccess().getSelectionStart();
        AuthorNode authorNode = authorAccess.getDocumentController().getNodeAtOffset(n2);
        if (this.tableHelper.isTableRow(authorNode)) {
            AuthorNode authorNode2 = authorAccess.getDocumentController().getNodeAtOffset(n2 + 1);
            if (this.tableHelper.isTableCell(authorNode2)) {
                authorElement = (AuthorElement)authorNode2;
            }
        } else {
            authorElement = this.getElementAncestor(authorNode, 0);
        }
        return authorElement;
    }

    @Override
    public ArgumentDescriptor[] getArguments() {
        return null;
    }

    @Override
    public String getDescription() {
        return "Join the content of the selected cells. The operation is available only if the selected cells are from the same row and they have the same column span.";
    }

    private List getCellsBetweenOffsets(AuthorElement authorElement, int n2, int n3) {
        ArrayList<AuthorNode> arrayList = new ArrayList<AuthorNode>();
        List<AuthorNode> list = authorElement.getContentNodes();
        for (AuthorNode authorNode : list) {
            if (!(authorNode.getStartOffset() <= n2 && authorNode.getEndOffset() >= n2 || authorNode.getStartOffset() > n2 && authorNode.getEndOffset() < n3) && (authorNode.getStartOffset() > n3 || authorNode.getEndOffset() < n3) || !this.tableHelper.isTableCell(authorNode)) continue;
            arrayList.add(authorNode);
        }
        return arrayList;
    }

    private void updateColSpanForMergedCell(AuthorAccess authorAccess, AuthorTableCellSpanProvider authorTableCellSpanProvider, AuthorElement authorElement, List list) throws AuthorOperationException {
        int[] nArray = authorAccess.getTableAccess().getTableColSpanIndices(authorElement);
        AuthorElement authorElement2 = (AuthorElement)list.get(list.size() - 1);
        int[] nArray2 = authorAccess.getTableAccess().getTableColSpanIndices(authorElement2);
        this.tableHelper.updateTableColSpan(authorAccess, authorTableCellSpanProvider, authorElement, nArray[0] + 1, nArray2[1] + 1);
    }

    protected abstract void generateColumnSpecifications(AuthorAccess var1, AuthorTableCellSpanProvider var2, AuthorElement var3) throws AuthorOperationException;
}

