/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.operations.cals;

import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorTableCellSpanProvider;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.commons.AbstractDocumentTypeHelper;
import ro.sync.ecss.extensions.commons.table.operations.cals.CALSConstants;
import ro.sync.ecss.extensions.commons.table.support.CALSColSpanSpec;
import ro.sync.ecss.extensions.commons.table.support.CALSColSpec;
import ro.sync.ecss.extensions.commons.table.support.CALSTableCellInfoProvider;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class CALSDocumentTypeHelper
extends AbstractDocumentTypeHelper
implements CALSConstants {
    private static final String[] ROW_ELEMENT_NAMES = new String[]{"row"};
    private static final String[] CELL_ELEMENT_NAMES = new String[]{"entry"};
    private static final String[] TABLE_ELEMENT_NAMES = new String[]{"tgroup", "informaltable"};

    @Override
    public String[] getTableCellElementNames() {
        return CELL_ELEMENT_NAMES;
    }

    @Override
    public String[] getTableRowElementNames() {
        return ROW_ELEMENT_NAMES;
    }

    @Override
    public String[] getTableElementLocalName() {
        return TABLE_ELEMENT_NAMES;
    }

    @Override
    public void checkTableColSpanIsDefined(AuthorAccess authorAccess, AuthorTableCellSpanProvider authorTableCellSpanProvider, AuthorElement authorElement) throws AuthorOperationException {
        CALSColSpanSpec cALSColSpanSpec = ((CALSTableCellInfoProvider)authorTableCellSpanProvider).getCellSpanSpec(authorAccess, authorElement);
        if (cALSColSpanSpec == null) {
            AuthorOperationException authorOperationException = new AuthorOperationException("Cannot compute the horizontal span specifications for the involved cells because there are missing 'colspec' elements.");
            authorOperationException.setOperationRejectedOnPurpose(true);
            throw authorOperationException;
        }
    }

    private CALSColSpec getTableColSpec(AuthorTableCellSpanProvider authorTableCellSpanProvider, int n2) throws AuthorOperationException {
        CALSColSpec cALSColSpec = ((CALSTableCellInfoProvider)authorTableCellSpanProvider).getColSpec(n2);
        if (cALSColSpec == null) {
            throw new AuthorOperationException("There is no column specification for column with index: " + n2);
        }
        return cALSColSpec;
    }

    @Override
    public void updateTableColSpan(AuthorAccess authorAccess, AuthorTableCellSpanProvider authorTableCellSpanProvider, AuthorElement authorElement, int n2, int n3) throws AuthorOperationException {
        CALSColSpec cALSColSpec = this.getTableColSpec(authorTableCellSpanProvider, n2);
        CALSColSpec cALSColSpec2 = this.getTableColSpec(authorTableCellSpanProvider, n3);
        AuthorDocumentController authorDocumentController = authorAccess.getDocumentController();
        if (cALSColSpec.getColumnNumber() == cALSColSpec2.getColumnNumber()) {
            authorDocumentController.removeAttribute("namest", authorElement);
            authorDocumentController.removeAttribute("nameend", authorElement);
        } else {
            authorDocumentController.setAttribute("namest", new AttrValue(cALSColSpec.getColumnName()), authorElement);
            authorDocumentController.setAttribute("nameend", new AttrValue(cALSColSpec2.getColumnName()), authorElement);
        }
        authorAccess.getDocumentController().removeAttribute("spanname", authorElement);
    }

    @Override
    public AuthorTableCellSpanProvider getTableCellSpanProvider(AuthorElement authorElement) {
        CALSTableCellInfoProvider cALSTableCellInfoProvider = new CALSTableCellInfoProvider();
        cALSTableCellInfoProvider.init(authorElement);
        return cALSTableCellInfoProvider;
    }

    @Override
    public void updateTableRowSpan(AuthorAccess authorAccess, AuthorElement authorElement, int n2) {
        if (n2 > 1) {
            authorAccess.getDocumentController().setAttribute("morerows", new AttrValue(String.valueOf(n2 - 1)), authorElement);
        } else {
            authorAccess.getDocumentController().removeAttribute("morerows", authorElement);
        }
    }

    @Override
    public void updateTableColumnNumber(AuthorAccess authorAccess, AuthorElement authorElement, int n2) {
        authorAccess.getDocumentController().setAttribute("cols", new AttrValue(String.valueOf(n2)), authorElement);
    }

    @Override
    public void updateTableRowNumber(AuthorAccess authorAccess, AuthorElement authorElement, int n2) {
    }

    @Override
    public String[] getIgnoredRowAttributes() {
        return new String[]{"morerows"};
    }

    @Override
    public String[] getIgnoredCellIDAttributes() {
        return new String[]{"xml:id", "id"};
    }

    @Override
    public String[] getIgnoredColumnAttributes() {
        return new String[]{"namest", "nameend"};
    }
}

