/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.operations.xhtml;

import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorOperationStoppedByUserException;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.commons.table.operations.AuthorTableHelper;
import ro.sync.ecss.extensions.commons.table.operations.InsertTableOperationBase;
import ro.sync.ecss.extensions.commons.table.operations.TableCustomizerConstants;
import ro.sync.ecss.extensions.commons.table.operations.TableInfo;
import ro.sync.ecss.extensions.commons.table.operations.TableOperationsUtil;
import ro.sync.ecss.extensions.commons.table.operations.xhtml.ECXHTMLTableCustomizerInvoker;
import ro.sync.ecss.extensions.commons.table.operations.xhtml.SAXHTMLTableCustomizerInvoker;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class InsertTableOperation
implements AuthorOperation,
InsertTableOperationBase {
    private static final String NAMESPACE = "http://www.w3.org/1999/xhtml";

    @Override
    public void doOperation(AuthorAccess authorAccess, ArgumentsMap argumentsMap) throws IllegalArgumentException, AuthorOperationException {
        this.insertTable(null, false, authorAccess, null, null);
    }

    @Override
    public void insertTable(AuthorDocumentFragment[] authorDocumentFragmentArray, boolean bl, AuthorAccess authorAccess, String string, AuthorTableHelper authorTableHelper) throws AuthorOperationException {
        TableInfo tableInfo = null;
        int n2 = 0;
        int n3 = 0;
        if (authorDocumentFragmentArray != null) {
            n2 = authorDocumentFragmentArray.length;
            n3 = 1;
        }
        if ((tableInfo = authorAccess.getWorkspaceAccess().isStandalone() ? SAXHTMLTableCustomizerInvoker.getInstance().customizeTable(authorAccess, n2, n3) : ECXHTMLTableCustomizerInvoker.getInstance().customizeTable(authorAccess, n2, n3)) == null) {
            throw new AuthorOperationStoppedByUserException("Cancelled by user");
        }
        authorAccess.getDocumentController().insertXMLFragmentSchemaAware(InsertTableOperation.getTableXMLFragment(tableInfo, NAMESPACE, authorDocumentFragmentArray, bl, authorAccess, authorTableHelper).toString(), authorAccess.getEditorAccess().getCaretOffset());
    }

    private static void addTableBody(StringBuilder stringBuilder, TableInfo tableInfo, AuthorDocumentFragment[] authorDocumentFragmentArray, boolean bl, AuthorAccess authorAccess, AuthorTableHelper authorTableHelper, String string) throws AuthorOperationException {
        stringBuilder.append("<tbody>");
        for (int i2 = 0; i2 < tableInfo.getRowsNumber(); ++i2) {
            stringBuilder.append("<tr>");
            for (int i3 = 0; i3 < tableInfo.getColumnsNumber(); ++i3) {
                if (authorDocumentFragmentArray != null) {
                    int n2 = i2;
                    if (tableInfo.isGenerateFooter()) {
                        ++n2;
                    }
                    if (tableInfo.isGenerateHeader()) {
                        ++n2;
                    }
                    String string2 = TableOperationsUtil.createCellXMLFragment(authorAccess, authorDocumentFragmentArray, bl, "td", n2, string, authorTableHelper, new String[0]);
                    stringBuilder.append(string2);
                    continue;
                }
                stringBuilder.append("<td></td>");
            }
            stringBuilder.append("</tr>");
        }
        stringBuilder.append("</tbody>");
    }

    private static void addTableCols(StringBuilder stringBuilder, TableInfo tableInfo) {
        TableCustomizerConstants.ColumnWidthsType columnWidthsType = tableInfo.getColumnsWidthsType();
        if (columnWidthsType != TableCustomizerConstants.ColumnWidthsType.DYNAMIC_COL_WIDTHS) {
            String string = null;
            if (columnWidthsType == TableCustomizerConstants.ColumnWidthsType.PROPORTIONAL_COL_WIDTHS) {
                float f2 = 100.0f / (float)tableInfo.getColumnsNumber();
                string = (int)((double)Math.round((double)f2 * 100.0) / 100.0) + "%";
            } else {
                string = "75pt";
            }
            for (int i2 = 1; i2 <= tableInfo.getColumnsNumber(); ++i2) {
                stringBuilder.append("<col width=\"" + string + "\"/>");
            }
        }
    }

    private static void addTableFooter(StringBuilder stringBuilder, TableInfo tableInfo, AuthorDocumentFragment[] authorDocumentFragmentArray, boolean bl, AuthorAccess authorAccess, AuthorTableHelper authorTableHelper, String string) throws AuthorOperationException {
        if (tableInfo.isGenerateFooter()) {
            stringBuilder.append("<tfoot><tr>");
            for (int i2 = 1; i2 <= tableInfo.getColumnsNumber(); ++i2) {
                if (i2 == 1 && authorDocumentFragmentArray != null && authorDocumentFragmentArray.length > 0) {
                    int n2 = tableInfo.isGenerateHeader() ? 1 : 0;
                    String string2 = TableOperationsUtil.createCellXMLFragment(authorAccess, authorDocumentFragmentArray, bl, "td", n2, string, authorTableHelper, new String[0]);
                    stringBuilder.append(string2);
                    continue;
                }
                stringBuilder.append("<td></td>");
            }
            stringBuilder.append("</tr></tfoot>");
        }
    }

    private static void addTableHeader(StringBuilder stringBuilder, TableInfo tableInfo, AuthorDocumentFragment[] authorDocumentFragmentArray, boolean bl, AuthorAccess authorAccess, AuthorTableHelper authorTableHelper, String string) throws AuthorOperationException {
        if (tableInfo.isGenerateHeader()) {
            stringBuilder.append("<thead><tr>");
            for (int i2 = 1; i2 <= tableInfo.getColumnsNumber(); ++i2) {
                if (i2 == 1 && authorDocumentFragmentArray != null && authorDocumentFragmentArray.length > 0) {
                    String string2 = TableOperationsUtil.createCellXMLFragment(authorAccess, authorDocumentFragmentArray, bl, "th", 0, string, authorTableHelper, new String[0]);
                    stringBuilder.append(string2);
                    continue;
                }
                stringBuilder.append("<th></th>");
            }
            stringBuilder.append("</tr></thead>");
        }
    }

    @Override
    public ArgumentDescriptor[] getArguments() {
        return null;
    }

    @Override
    public String getDescription() {
        return "Insert a XHTML table";
    }

    private static StringBuilder getTableXMLFragment(TableInfo tableInfo, String string, AuthorDocumentFragment[] authorDocumentFragmentArray, boolean bl, AuthorAccess authorAccess, AuthorTableHelper authorTableHelper) throws AuthorOperationException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<table");
        stringBuilder.append(" xmlns=\"").append(string).append("\"");
        if (tableInfo.getFrame() != null) {
            stringBuilder.append(" frame=\"").append(tableInfo.getFrame()).append("\"");
        }
        if (tableInfo.getAlign() != null) {
            stringBuilder.append(" align=\"").append(tableInfo.getAlign()).append("\"");
        }
        stringBuilder.append(">");
        if (tableInfo.getTitle() != null) {
            stringBuilder.append("<caption>").append(tableInfo.getTitle()).append("</caption>");
        }
        InsertTableOperation.addTableCols(stringBuilder, tableInfo);
        InsertTableOperation.addTableHeader(stringBuilder, tableInfo, authorDocumentFragmentArray, bl, authorAccess, authorTableHelper, string);
        InsertTableOperation.addTableFooter(stringBuilder, tableInfo, authorDocumentFragmentArray, bl, authorAccess, authorTableHelper, string);
        InsertTableOperation.addTableBody(stringBuilder, tableInfo, authorDocumentFragmentArray, bl, authorAccess, authorTableHelper, string);
        stringBuilder.append("</table>");
        return stringBuilder;
    }
}

