/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.support;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.text.BadLocationException;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorTableCellSepProvider;
import ro.sync.ecss.extensions.api.AuthorTableCellSpanProvider;
import ro.sync.ecss.extensions.api.AuthorTableColumnWidthProviderBase;
import ro.sync.ecss.extensions.api.WidthRepresentation;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.table.operations.cals.CALSConstants;
import ro.sync.ecss.extensions.commons.table.support.CALSColSpanSpec;
import ro.sync.ecss.extensions.commons.table.support.CALSColSpec;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class CALSTableCellInfoProvider
extends AuthorTableColumnWidthProviderBase
implements AuthorTableCellSpanProvider,
CALSConstants,
AuthorTableCellSepProvider {
    private static final WidthRepresentation DEFAULT_WIDTH_REPRESENTATION = new WidthRepresentation(0.0f, null, 1.0f, false);
    private static final String CALS_DOCBOOK_CELL_NAME = "entry";
    private Map<CALSColSpec, AuthorElement> colspecInfosMap = new TreeMap<CALSColSpec, AuthorElement>(new ColspecComparator());
    protected List<CALSColSpanSpec> spanspecInfos = new ArrayList<CALSColSpanSpec>();
    private AuthorElement tableElement;
    private static final String COLSPEC_NAME_PREFIX = "c";
    private boolean colsepAndRowSepAreVisibleByDefault = false;

    public CALSTableCellInfoProvider(boolean bl) {
        this.colsepAndRowSepAreVisibleByDefault = bl;
    }

    public CALSTableCellInfoProvider() {
        this(false);
    }

    @Override
    public Integer getColSpan(AuthorElement authorElement) {
        Integer n2 = null;
        AttrValue attrValue = authorElement.getAttribute("spanname");
        if (attrValue != null) {
            CALSColSpanSpec cALSColSpanSpec = this.getSpanSpec(attrValue.getValue());
            if (cALSColSpanSpec != null) {
                n2 = this.getColSpan(cALSColSpanSpec.getStartColumnName(), cALSColSpanSpec.getEndColumnName());
            }
        } else {
            AttrValue attrValue2 = authorElement.getAttribute("namest");
            AttrValue attrValue3 = authorElement.getAttribute("nameend");
            if (attrValue2 != null && attrValue3 != null && attrValue2.getValue() != null && attrValue3.getValue() != null) {
                n2 = this.getColSpan(attrValue2.getValue(), attrValue3.getValue());
            }
        }
        return n2;
    }

    private Integer getColSpan(String string, String string2) {
        Integer n2 = null;
        int n3 = -1;
        int n4 = -1;
        Set<CALSColSpec> set = this.colspecInfosMap.keySet();
        for (CALSColSpec cALSColSpec : set) {
            if (string.equals(cALSColSpec.getColumnName())) {
                n3 = cALSColSpec.getColumnNumber();
            }
            if (!string2.equals(cALSColSpec.getColumnName())) continue;
            n4 = cALSColSpec.getColumnNumber();
        }
        if (n3 != -1 && n4 != -1) {
            n2 = Math.abs(n4 - n3) + 1;
        }
        return n2;
    }

    @Override
    public Integer getRowSpan(AuthorElement authorElement) {
        String string;
        Integer n2 = null;
        AttrValue attrValue = authorElement.getAttribute("morerows");
        String string2 = string = attrValue != null ? attrValue.getValue() : null;
        if (string != null) {
            try {
                int n3 = Integer.parseInt(string);
                if (n3 >= 1) {
                    n2 = n3 + 1;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n2;
    }

    @Override
    public void init(AuthorElement authorElement) {
        this.tableElement = authorElement;
        this.colspecInfosMap.clear();
        this.spanspecInfos.clear();
        int n2 = 0;
        List<AuthorNode> list = authorElement.getContentNodes();
        int n3 = 0;
        for (AuthorNode authorNode : list) {
            Object object;
            Object object2;
            if (!(authorNode instanceof AuthorElement)) continue;
            AuthorElement authorElement2 = (AuthorElement)authorNode;
            if ("colspec".equals(authorElement2.getLocalName())) {
                boolean bl = false;
                object2 = authorElement2.getAttribute("colnum");
                int n4 = -1;
                if (object2 != null) {
                    try {
                        n4 = Integer.parseInt(((AttrValue)object2).getValue());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (n4 != -1) {
                    n3 = n4;
                    bl = true;
                } else {
                    ++n3;
                }
                object2 = authorElement2.getAttribute("colname");
                object = null;
                if (object2 != null) {
                    object = ((AttrValue)object2).getValue();
                }
                object2 = authorElement2.getAttribute("colwidth");
                String string = null;
                if (object2 != null) {
                    string = ((AttrValue)object2).getValue();
                }
                object2 = authorElement2.getAttribute("align");
                String string2 = null;
                if (object2 != null) {
                    string2 = ((AttrValue)object2).getValue();
                }
                object2 = authorElement2.getAttribute("colsep");
                Boolean bl2 = null;
                if (object2 != null) {
                    bl2 = "1".equals(((AttrValue)object2).getValue());
                }
                object2 = authorElement2.getAttribute("rowsep");
                Boolean bl3 = null;
                if (object2 != null) {
                    bl3 = "1".equals(((AttrValue)object2).getValue());
                }
                CALSColSpec cALSColSpec = new CALSColSpec(n2, n3, bl, (String)object, string, bl2, bl3);
                cALSColSpec.setAlign(string2);
                this.colspecInfosMap.put(cALSColSpec, authorElement2);
                ++n2;
                continue;
            }
            if (!"spanspec".equals(authorElement2.getLocalName())) continue;
            String string = null;
            object2 = null;
            String string3 = null;
            object = authorElement2.getAttribute("spanname");
            if (object != null) {
                string = ((AttrValue)object).getValue();
            }
            if ((object = authorElement2.getAttribute("namest")) != null) {
                object2 = ((AttrValue)object).getValue();
            }
            if ((object = authorElement2.getAttribute("nameend")) != null) {
                string3 = ((AttrValue)object).getValue();
            }
            if (string == null || object2 == null || string3 == null) continue;
            this.spanspecInfos.add(new CALSColSpanSpec(string, (String)object2, string3));
        }
    }

    @Override
    public String getDescription() {
        return "Provides information about the cells for a DocBook or DITA table.";
    }

    private CALSColSpanSpec getSpanSpec(String string) {
        CALSColSpanSpec cALSColSpanSpec = null;
        for (CALSColSpanSpec cALSColSpanSpec2 : this.spanspecInfos) {
            if (!string.equals(cALSColSpanSpec2.getSpanName())) continue;
            cALSColSpanSpec = cALSColSpanSpec2;
            break;
        }
        return cALSColSpanSpec;
    }

    public CALSColSpanSpec getCellSpanSpec(AuthorAccess authorAccess, AuthorElement authorElement) {
        CALSColSpanSpec cALSColSpanSpec = null;
        AttrValue attrValue = authorElement.getAttribute("spanname");
        if (attrValue != null) {
            cALSColSpanSpec = this.getSpanSpec(attrValue.getValue());
        } else {
            AttrValue attrValue2 = authorElement.getAttribute("namest");
            AttrValue attrValue3 = authorElement.getAttribute("nameend");
            if (attrValue2 != null && attrValue3 != null) {
                cALSColSpanSpec = new CALSColSpanSpec(null, attrValue2.getValue(), attrValue3.getValue());
            } else {
                CALSColSpec cALSColSpec = this.getColumnSpec(authorAccess, authorElement);
                if (cALSColSpec != null) {
                    cALSColSpanSpec = new CALSColSpanSpec(null, cALSColSpec.getColumnName(), cALSColSpec.getColumnName());
                }
            }
        }
        return cALSColSpanSpec;
    }

    CALSColSpec getColumnSpec(AuthorAccess authorAccess, AuthorElement authorElement) {
        CALSColSpec cALSColSpec = null;
        AttrValue attrValue = authorElement.getAttribute("colname");
        if (attrValue != null) {
            cALSColSpec = this.getColSpec(attrValue.getValue());
        } else {
            int[] nArray = authorAccess.getTableAccess().getTableCellIndex(authorElement);
            if (nArray != null) {
                cALSColSpec = this.getColSpec(nArray[1] + 1);
            }
        }
        return cALSColSpec;
    }

    private CALSColSpec getColumnSpec(AuthorElement authorElement, int n2) {
        CALSColSpec cALSColSpec = null;
        AttrValue attrValue = authorElement.getAttribute("colname");
        cALSColSpec = attrValue != null ? this.getColSpec(attrValue.getValue()) : this.getColSpec(n2);
        return cALSColSpec;
    }

    private CALSColSpec getColSpec(String string) {
        CALSColSpec cALSColSpec = null;
        Set<CALSColSpec> set = this.colspecInfosMap.keySet();
        for (CALSColSpec cALSColSpec2 : set) {
            if (string == null || !string.equals(cALSColSpec2.getColumnName())) continue;
            cALSColSpec = cALSColSpec2;
            break;
        }
        return cALSColSpec;
    }

    public CALSColSpec getColSpec(int n2) {
        CALSColSpec cALSColSpec = null;
        Set<CALSColSpec> set = this.colspecInfosMap.keySet();
        for (CALSColSpec cALSColSpec2 : set) {
            if (n2 != cALSColSpec2.getColumnNumber()) continue;
            cALSColSpec = cALSColSpec2;
            break;
        }
        return cALSColSpec;
    }

    public AuthorElement getColSpecElement(CALSColSpec cALSColSpec) {
        return this.colspecInfosMap.get(cALSColSpec);
    }

    public Set<CALSColSpec> getColSpecs() {
        return this.colspecInfosMap.keySet();
    }

    @Override
    public boolean hasColumnSpecifications(AuthorElement authorElement) {
        return !this.colspecInfosMap.isEmpty();
    }

    @Override
    public List<WidthRepresentation> getCellWidth(AuthorElement authorElement, int n2, int n3) {
        ArrayList<WidthRepresentation> arrayList;
        block13: {
            Set<CALSColSpec> set;
            block14: {
                Object object;
                arrayList = null;
                AttrValue attrValue = authorElement.getAttribute("spanname");
                String string = null;
                String string2 = null;
                if (attrValue != null) {
                    object = this.getSpanSpec(attrValue.getValue());
                    if (object != null) {
                        string = ((CALSColSpanSpec)object).getStartColumnName();
                        string2 = ((CALSColSpanSpec)object).getEndColumnName();
                    }
                } else {
                    object = authorElement.getAttribute("namest");
                    set = authorElement.getAttribute("nameend");
                    if (object != null && set != null) {
                        string = ((AttrValue)object).getValue();
                        string2 = ((AttrValue)((Object)set)).getValue();
                    }
                }
                if (string == null && string2 == null && (attrValue = authorElement.getAttribute("colname")) != null) {
                    string = string2 = attrValue.getValue();
                }
                if (string == null || string2 == null) break block14;
                boolean bl = false;
                set = this.colspecInfosMap.keySet();
                for (CALSColSpec cALSColSpec : set) {
                    if (string.equals(cALSColSpec.getColumnName())) {
                        bl = true;
                    }
                    if (bl) {
                        WidthRepresentation widthRepresentation = cALSColSpec.getColWidth();
                        WidthRepresentation widthRepresentation2 = widthRepresentation = widthRepresentation == null ? DEFAULT_WIDTH_REPRESENTATION : widthRepresentation;
                        if (cALSColSpec.getAlign() != null && widthRepresentation == DEFAULT_WIDTH_REPRESENTATION) {
                            widthRepresentation = new WidthRepresentation(0.0f, null, 1.0f, false);
                            widthRepresentation.setAlign(cALSColSpec.getAlign());
                        }
                        if (arrayList == null) {
                            arrayList = new ArrayList();
                        }
                        arrayList.add(widthRepresentation);
                    }
                    if (!string2.equals(cALSColSpec.getColumnName())) continue;
                    break block13;
                }
                break block13;
            }
            if (n2 < 0) break block13;
            int n4 = n2 + 1;
            set = this.colspecInfosMap.keySet();
            for (CALSColSpec cALSColSpec : set) {
                if (cALSColSpec.getColumnNumber() != n4) continue;
                WidthRepresentation widthRepresentation = cALSColSpec.getColWidth();
                WidthRepresentation widthRepresentation3 = widthRepresentation = widthRepresentation == null ? DEFAULT_WIDTH_REPRESENTATION : widthRepresentation;
                if (cALSColSpec.getAlign() != null && widthRepresentation == DEFAULT_WIDTH_REPRESENTATION) {
                    widthRepresentation = new WidthRepresentation(0.0f, null, 1.0f, false);
                    widthRepresentation.setAlign(cALSColSpec.getAlign());
                }
                if (arrayList == null) {
                    arrayList = new ArrayList<WidthRepresentation>();
                }
                arrayList.add(widthRepresentation);
            }
        }
        return arrayList;
    }

    @Override
    public void commitColumnWidthModifications(AuthorDocumentController authorDocumentController, WidthRepresentation[] widthRepresentationArray, String string) throws AuthorOperationException {
        if (this.isTableCell(string) && widthRepresentationArray != null && authorDocumentController != null && this.tableElement != null) {
            int n2 = this.tableElement.getStartOffset() + 1;
            try {
                for (int i2 = 0; i2 < widthRepresentationArray.length; ++i2) {
                    Object object;
                    String string2;
                    WidthRepresentation widthRepresentation = widthRepresentationArray[i2];
                    int n3 = i2 + 1;
                    CALSColSpec cALSColSpec = this.getColSpec(n3);
                    AuthorElement authorElement = null;
                    if (cALSColSpec == null) {
                        string2 = this.getUniqueColumnName(n3);
                        cALSColSpec = new CALSColSpec(i2, n3, true, string2, widthRepresentation);
                        object = cALSColSpec.createXMLFragment(this.tableElement.getNamespace());
                        authorDocumentController.insertXMLFragment((String)object, n2);
                        authorElement = (AuthorElement)authorDocumentController.getNodeAtOffset(n2 + 1);
                        this.colspecInfosMap.put(cALSColSpec, authorElement);
                    } else {
                        cALSColSpec.setColWidth(widthRepresentation);
                        string2 = widthRepresentation.getWidthRepresentation();
                        object = null;
                        if (string2 != null) {
                            object = new AttrValue(widthRepresentation.getWidthRepresentation());
                        }
                        authorElement = this.colspecInfosMap.get(cALSColSpec);
                        authorDocumentController.setAttribute("colwidth", (AttrValue)object, authorElement);
                    }
                    n2 = authorElement.getEndOffset() + 1;
                }
            }
            catch (AuthorOperationException authorOperationException) {
                throw authorOperationException;
            }
            catch (BadLocationException badLocationException) {
                throw new AuthorOperationException(badLocationException.getMessage(), badLocationException);
            }
        }
    }

    protected boolean isTableCell(String string) {
        return CALS_DOCBOOK_CELL_NAME.equals(string);
    }

    private String getUniqueColumnName(int n2) {
        Set<CALSColSpec> set = this.getColSpecs();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (CALSColSpec cALSColSpec : set) {
            String string = cALSColSpec.getColumnName();
            if (string == null) continue;
            arrayList.add(string);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(COLSPEC_NAME_PREFIX).append(n2);
        boolean bl = false;
        while (!bl) {
            if (arrayList.contains(stringBuilder.toString())) {
                stringBuilder.append(n2);
                continue;
            }
            bl = true;
        }
        return stringBuilder.toString();
    }

    private AuthorElement getTableElement() {
        AuthorElement authorElement = this.tableElement;
        if (authorElement != null) {
            while (!"table".equals(authorElement.getName())) {
                AuthorNode authorNode = authorElement.getParent();
                if (authorNode != null && authorNode instanceof AuthorElement) {
                    authorElement = (AuthorElement)authorNode;
                    continue;
                }
                authorElement = null;
                break;
            }
        }
        return authorElement;
    }

    @Override
    public void commitTableWidthModification(AuthorDocumentController authorDocumentController, int n2, String string) throws AuthorOperationException {
        if (this.isTableCell(string)) {
            AuthorElement authorElement = this.getTableElement();
            if (n2 > 0 && authorDocumentController != null) {
                if (authorElement != null) {
                    String string2 = String.valueOf(n2);
                    authorDocumentController.setAttribute("width", new AttrValue(string2), authorElement);
                } else {
                    throw new AuthorOperationException("Cannot find the element representing the table.");
                }
            }
        }
    }

    @Override
    public WidthRepresentation getTableWidth(String string) {
        WidthRepresentation widthRepresentation = null;
        if (this.isTableCell(string)) {
            widthRepresentation = this.getTableWidth();
        }
        return widthRepresentation;
    }

    @Override
    public boolean isTableAcceptingWidth(String string) {
        return false;
    }

    private WidthRepresentation getTableWidth() {
        String string;
        AttrValue attrValue;
        WidthRepresentation widthRepresentation = null;
        AuthorElement authorElement = this.getTableElement();
        if (authorElement != null && (attrValue = authorElement.getAttribute("width")) != null && (string = attrValue.getValue()) != null) {
            widthRepresentation = new WidthRepresentation(string, true);
        }
        return widthRepresentation;
    }

    @Override
    public boolean isTableAndColumnsResizable(String string) {
        return this.isTableCell(string);
    }

    @Override
    public boolean isAcceptingFixedColumnWidths(String string) {
        return this.isTableCell(string);
    }

    @Override
    public boolean isAcceptingPercentageColumnWidths(String string) {
        return false;
    }

    @Override
    public boolean isAcceptingProportionalColumnWidths(String string) {
        return this.isTableCell(string);
    }

    @Override
    public List<WidthRepresentation> getAllColspecWidthRepresentations() {
        Object object;
        ArrayList<WidthRepresentation> arrayList = new ArrayList<WidthRepresentation>();
        for (CALSColSpec object22 : this.colspecInfosMap.keySet()) {
            object = object22.getColWidth();
            if (object != null) {
                arrayList.add((WidthRepresentation)object);
                continue;
            }
            arrayList.add(new WidthRepresentation(0.0f, null, 1.0f, false));
        }
        AuthorElement authorElement = this.getTableElement();
        if (authorElement != null && (object = authorElement.getAttribute("colnum")) != null && ((AttrValue)object).getValue() != null) {
            try {
                int numberFormatException = Integer.parseInt(((AttrValue)object).getValue());
                int n2 = numberFormatException - arrayList.size();
                if (n2 > 0) {
                    for (int i2 = 0; i2 < n2; ++i2) {
                        arrayList.add(new WidthRepresentation(0.0f, null, 1.0f, false));
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return arrayList;
    }

    @Override
    public boolean getColSep(AuthorElement authorElement, int n2) {
        CALSColSpec cALSColSpec;
        Boolean[] booleanArray = this.getColSepOrRowSepFromAttributes(authorElement, true);
        Boolean bl = booleanArray[0];
        Boolean bl2 = booleanArray[1];
        if ((bl == null || bl2.booleanValue()) && (cALSColSpec = this.getColumnSpec(authorElement, n2)) != null && cALSColSpec.getColSep() != null) {
            bl = cALSColSpec.getColSep();
        }
        if (bl == null) {
            bl = this.colsepAndRowSepAreVisibleByDefault;
        }
        return bl;
    }

    @Override
    public boolean getRowSep(AuthorElement authorElement, int n2) {
        CALSColSpec cALSColSpec;
        Boolean[] booleanArray = this.getColSepOrRowSepFromAttributes(authorElement, false);
        Boolean bl = booleanArray[0];
        Boolean bl2 = booleanArray[1];
        if ((bl == null || bl2.booleanValue()) && (cALSColSpec = this.getColumnSpec(authorElement, n2)) != null && cALSColSpec.getRowSep() != null) {
            bl = cALSColSpec.getRowSep();
        }
        if (bl == null) {
            bl = this.colsepAndRowSepAreVisibleByDefault;
        }
        return bl;
    }

    private Boolean[] getColSepOrRowSepFromAttributes(AuthorElement authorElement, boolean bl) {
        Boolean bl2 = null;
        boolean bl3 = false;
        AuthorNode authorNode = authorElement;
        while (authorNode instanceof AuthorElement) {
            AuthorElement authorElement2 = authorNode;
            boolean bl4 = this.isTableElement(authorElement2);
            boolean bl5 = this.isTgroupElement(authorElement2);
            AttrValue attrValue = bl ? authorElement2.getAttribute("colsep") : authorElement2.getAttribute("rowsep");
            if (attrValue != null) {
                bl2 = "1".equals(attrValue.getValue());
                bl3 = bl4 || bl5;
                break;
            }
            if (bl4) break;
            authorNode = authorNode.getParent();
        }
        return new Boolean[]{bl2, bl3};
    }

    protected boolean isTableElement(AuthorElement authorElement) {
        return authorElement == this.tableElement.getParent() || "table".equals(authorElement.getLocalName());
    }

    protected boolean isTgroupElement(AuthorElement authorElement) {
        return "tgroup".equals(authorElement.getLocalName());
    }

    private static class ColspecComparator
    implements Comparator {
        private ColspecComparator() {
        }

        public int compare(Object object, Object object2) {
            int n2 = -1;
            if (object instanceof CALSColSpec && object2 instanceof CALSColSpec) {
                CALSColSpec cALSColSpec = (CALSColSpec)object;
                CALSColSpec cALSColSpec2 = (CALSColSpec)object2;
                n2 = cALSColSpec.getColumnNumber() - cALSColSpec2.getColumnNumber();
            }
            return n2;
        }
    }
}

