/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.webapp.testing;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.ParserConfigurationException;
import org.mockito.Mockito;
import org.xml.sax.SAXException;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.ecss.extensions.api.AuthorExtensionActionProvider;
import ro.sync.ecss.extensions.api.webapp.AuthorDocumentModel;
import ro.sync.ecss.extensions.api.webapp.WebappAuthorDocumentFactory;
import ro.sync.net.protocol.OxygenURLStreamHandlerFactory;
import ro.sync.util.URLUtil;

@SkipObfuscate(classes=SkipLevel.NOT_SPECIFIED, fields=SkipLevel.NOT_SPECIFIED, methods=SkipLevel.PUBLIC)
public class MockAuthorDocumentFactory {
    private static boolean b;

    public static void initForTest() {
        if (!b) {
            b = true;
            try {
                File file = new File(".");
                File file2 = new File(file, "frameworks");
                if (!file2.exists()) {
                    file = new File(file, "test/fake_editor_home/");
                }
                System.setProperty("com.oxygenxml.editor.home.url", URLUtil.correct(file).toString());
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
            try {
                URL.setURLStreamHandlerFactory(new OxygenURLStreamHandlerFactory());
            }
            catch (Error error) {
                error.printStackTrace();
            }
        }
    }

    public static AuthorDocumentModel create(String string, String string2, Map<String, Object> map) throws Exception {
        AuthorDocumentModel authorDocumentModel = MockAuthorDocumentFactory.createNoMocks(string, string2, map);
        AuthorDocumentModel authorDocumentModel2 = (AuthorDocumentModel)Mockito.spy((Object)authorDocumentModel);
        Mockito.when(authorDocumentModel2.getNodeIndexer()).thenReturn(Mockito.spy(authorDocumentModel.getNodeIndexer()));
        AuthorExtensionActionProvider authorExtensionActionProvider = authorDocumentModel.getActionsManager();
        Mockito.when((Object)authorDocumentModel2.getActionsManager()).thenReturn(Mockito.spy((Object)authorExtensionActionProvider));
        return authorDocumentModel2;
    }

    public static AuthorDocumentModel create(String string, String string2) throws Exception {
        return MockAuthorDocumentFactory.create(string, string2, Collections.<String, Object>emptyMap());
    }

    public static AuthorDocumentModel createNoMocks(String string, String string2) throws IOException, ParserConfigurationException, SAXException {
        return MockAuthorDocumentFactory.createNoMocks(string, string2, Collections.<String, Object>emptyMap());
    }

    public static AuthorDocumentModel createNoMocks(String string, String string2, Map<String, Object> map) throws IOException, ParserConfigurationException, SAXException {
        String string3 = "file:///dummy.xml";
        if (string2 != null && string2.length() != 0) {
            string = MockAuthorDocumentFactory.getCSSPi(string2) + string;
        }
        StringReader stringReader = new StringReader(string);
        AuthorDocumentModel authorDocumentModel = WebappAuthorDocumentFactory.createAuthorDocumentInfo(string3, stringReader, map);
        return authorDocumentModel;
    }

    public static int getCSSProcessingInstructionLength(String string) {
        String string2 = MockAuthorDocumentFactory.getCSSPi(string);
        return string2.length() - 2;
    }

    public static String getCSSPi(String string) {
        String string2 = "data:text/css;base64," + DatatypeConverter.printBase64Binary((byte[])string.getBytes());
        String string3 = "<?xml-stylesheet type=\"text/css\" href=\"" + string2 + "\"?>";
        return string3;
    }

    static {
        MockAuthorDocumentFactory.initForTest();
        b = false;
    }
}

