/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.addons;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.apache.xerces.jaxp.DocumentBuilderFactoryImpl;
import org.apache.xml.serializer.dom3.LSSerializerImpl;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.util.Resource;
import ro.sync.util.URLUtil;
import ro.sync.xml.ProxyNamespaceMapping;
import ro.sync.xml.XmlUtil;
import ro.sync.xml.parser.ParserCreator;

@API(type=APIType.INTERNAL, src=SourceType.PRIVATE)
public class ExtensionInfo
implements Cloneable {
    private static final Logger m = Logger.getLogger((String)ExtensionInfo.class.getName());
    public static final String EXTENSION_NAMESPACE = "http://www.oxygenxml.com/ns/extension";
    public static final String EXTENSION_INFO_FILE_NAME = "extension.xml";
    public static String RESULTS_PROBLEMS_KEY = "Extensions update errors";
    private URL f;
    private String l;
    private String g;
    private String j;
    private _b i;
    private String d;
    private String b;
    private String k;
    private String e;
    private URL h;
    private ProxyNamespaceMapping c;

    public ExtensionInfo(String string) {
        this.l = string;
    }

    public ExtensionInfo(URL uRL, String string, String string2, String string3, _b _b2, String string4, String string5, String string6, String string7, URL uRL2, ProxyNamespaceMapping proxyNamespaceMapping) {
        this.f = uRL;
        this.l = string;
        this.g = string2;
        this.j = string3;
        this.i = _b2;
        this.d = string4;
        this.b = string5;
        this.k = string6 != null ? string6 : "";
        this.e = string7 != null ? string7 : "";
        this.h = uRL2;
        this.c = proxyNamespaceMapping;
    }

    public String getExtensionId() {
        return this.l;
    }

    public String getResourceId() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.h != null) {
            stringBuilder.append(this.h.toExternalForm());
        }
        stringBuilder.append("-").append(this.l).append("-").append(this.g);
        return stringBuilder.toString();
    }

    public String getVersion() {
        return this.g;
    }

    public String getOxyVersion() {
        return this.j;
    }

    public _b getType() {
        return this.i;
    }

    public String getAuthor() {
        return this.d;
    }

    public String getName() {
        return this.b != null && this.b.length() > 0 ? this.b : "unknown";
    }

    public String getDescription() {
        return this.k;
    }

    public String getLicense() {
        return this.e;
    }

    public URL getUpdateSiteUrl() {
        return this.h;
    }

    public URL getLocation() {
        return this.f;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Archive URL: ").append(this.f).append("\n");
        stringBuilder.append("Name: ").append(this.b).append("\n");
        stringBuilder.append("Version: ").append(this.g).append("\n");
        return stringBuilder.toString();
    }

    public static ExtensionInfo[] loadExtensions(URL uRL, boolean bl) throws IOException {
        ArrayList<ExtensionInfo> arrayList = new ArrayList<ExtensionInfo>();
        try {
            Object object;
            DocumentBuilder documentBuilder = null;
            if (bl) {
                object = Resource.getResource("/builtin/extensions.xsd");
                documentBuilder = ParserCreator.newDocumentBuilder(false, false, true, (URL)object, false, true);
                documentBuilder.setErrorHandler(new ErrorHandler(){

                    @Override
                    public void warning(SAXParseException sAXParseException) throws SAXException {
                        if (m.isDebugEnabled()) {
                            m.debug((Object)sAXParseException, (Throwable)sAXParseException);
                        }
                    }

                    @Override
                    public void fatalError(SAXParseException sAXParseException) throws SAXException {
                        if (m.isDebugEnabled()) {
                            m.debug((Object)sAXParseException, (Throwable)sAXParseException);
                        }
                        throw sAXParseException;
                    }

                    @Override
                    public void error(SAXParseException sAXParseException) throws SAXException {
                        if (m.isDebugEnabled()) {
                            m.debug((Object)sAXParseException, (Throwable)sAXParseException);
                        }
                        throw sAXParseException;
                    }
                });
            } else {
                object = new DocumentBuilderFactoryImpl();
                object.setNamespaceAware(true);
                object.setXIncludeAware(true);
                object.setFeature("http://apache.org/xml/features/xinclude/fixup-base-uris", true);
                documentBuilder = object.newDocumentBuilder();
            }
            object = documentBuilder.parse(new InputSource(uRL.toExternalForm()));
            for (Node node = object.getDocumentElement().getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getNodeType() != 1 || !"extension".equals(node.getLocalName())) continue;
                Element element = (Element)node;
                ExtensionInfo extensionInfo = ExtensionInfo.createResourceFromNode(element, uRL);
                arrayList.add(extensionInfo);
            }
        }
        catch (SAXException sAXException) {
            throw new IOException("Update failed because of " + sAXException.getMessage(), sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException("Update failed because of " + parserConfigurationException.getMessage(), parserConfigurationException);
        }
        return arrayList.toArray(new ExtensionInfo[0]);
    }

    public static ExtensionInfo createResourceFromNode(Element element, URL uRL) throws IOException {
        Object object;
        ProxyNamespaceMapping proxyNamespaceMapping;
        String string;
        String string2;
        String string3;
        String string4;
        _b _b2;
        String string5;
        String string6;
        String string7;
        String string8;
        block23: {
            string8 = null;
            string7 = null;
            string6 = null;
            string5 = null;
            _b2 = null;
            string4 = null;
            string3 = null;
            string2 = null;
            string = null;
            proxyNamespaceMapping = null;
            Node node = element.getFirstChild();
            string8 = element.getAttribute("id");
            String string9 = element.getAttribute("update_site");
            if (!string9.isEmpty()) {
                uRL = new URL(string9);
            }
            URL uRL2 = uRL;
            if (element.getBaseURI() != null) {
                uRL2 = new URL(element.getBaseURI());
            }
            while (node != null) {
                if (node.getNodeType() == 1) {
                    object = (Element)node;
                    if (object.getLocalName().equals("location")) {
                        string7 = object.getAttribute("href");
                    } else if (object.getLocalName().equals("version")) {
                        string6 = object.getTextContent();
                    } else if (object.getLocalName().equals("oxy_version")) {
                        string5 = object.getTextContent();
                    } else if (object.getLocalName().equals("type")) {
                        _b2 = object.getTextContent().equals("framework") ? _b.d : _b.c;
                    } else if (object.getLocalName().equals("author")) {
                        string4 = object.getTextContent();
                    } else if (object.getLocalName().equals("name")) {
                        string3 = object.getTextContent();
                    } else if (object.getLocalName().equals("description")) {
                        proxyNamespaceMapping = new ProxyNamespaceMapping((Node)object);
                        LSSerializerImpl lSSerializerImpl = new LSSerializerImpl();
                        lSSerializerImpl.setParameter("xml-declaration", (Object)false);
                        string2 = lSSerializerImpl.writeToString((Node)object);
                        int n2 = string2.indexOf(">");
                        int n3 = string2.lastIndexOf("<");
                        string2 = n2 != -1 && n3 != -1 && n2 + 1 < n3 ? string2.substring(n2 + 1, n3) : "";
                    } else if (object.getLocalName().equals("license")) {
                        string = object.getTextContent();
                    }
                }
                node = node.getNextSibling();
            }
            object = null;
            if (string7 != null && string7.length() > 0) {
                try {
                    object = new URL(uRL2, string7);
                }
                catch (MalformedURLException malformedURLException) {
                    if (!m.isDebugEnabled()) break block23;
                    m.debug((Object)malformedURLException, (Throwable)malformedURLException);
                }
            }
        }
        if (object == null) {
            throw new IOException("Invalid add-on archive location: '" + string7 + "'");
        }
        return new ExtensionInfo((URL)object, string8, string6, string5, _b2, string4, string3, string2, string, uRL, proxyNamespaceMapping);
    }

    public boolean equals(Object object) {
        if (object instanceof ExtensionInfo) {
            ExtensionInfo extensionInfo = (ExtensionInfo)object;
            if (this.getResourceId().equals(extensionInfo.getResourceId())) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.getResourceId().hashCode();
    }

    protected Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            return null;
        }
    }

    public void writeTo(Writer writer, File file) throws IOException {
        String string = "xt";
        if (this.c != null && this.c.getProxies().contains("xt") && !this.c.getNamespaceForPrefix("xt").equals(EXTENSION_NAMESPACE)) {
            string = string + System.currentTimeMillis();
        }
        writer.append("<" + string + ":extension xmlns:" + string + "=\"").append(EXTENSION_NAMESPACE).append("\" ");
        writer.append("id=\"").append(this.getExtensionId()).append("\" ");
        writer.append("install_dir=\"").append(file.getAbsolutePath()).append("\" ");
        writer.append("update_site=\"").append(this.getUpdateSiteUrl().toExternalForm()).append("\">\n");
        writer.append("<" + string + ":location href=\"").append(URLUtil.extractFileName(this.getLocation())).append("\"/>\n");
        writer.append("<" + string + ":version>").append(this.getVersion()).append("</" + string + ":version>\n");
        writer.append("<" + string + ":oxy_version>").append(this.getOxyVersion()).append("</" + string + ":oxy_version>\n");
        writer.append("<" + string + ":type>").append(this.getType().toString()).append("</" + string + ":type>\n");
        writer.append("<" + string + ":author>").append(XmlUtil.escape(this.getAuthor())).append("</" + string + ":author>\n");
        writer.append("<" + string + ":name>").append(XmlUtil.escape(this.getName())).append("</" + string + ":name>\n");
        writer.append("<" + string + ":description");
        if (this.c != null) {
            Set<String> set = this.c.getNamespaces();
            for (String string2 : set) {
                String string3 = this.c.getPrefixForNamespace(string2);
                if (string3.equals("")) {
                    writer.append(" xmlns ");
                } else {
                    writer.append(" xmlns:" + string3);
                }
                writer.append("=\"").append(string2).append("\"");
            }
        }
        writer.append(">").append(this.getDescription()).append("</" + string + ":description>\n");
        writer.append("<" + string + ":license><![CDATA[").append(this.getLicense()).append("]]></" + string + ":license>\n");
        writer.append("</" + string + ":extension>");
    }

    public ProxyNamespaceMapping getProxyNamespaceMapping() {
        return this.c;
    }

    public static enum _b {
        d,
        c;


        public String toString() {
            return super.toString().toLowerCase();
        }
    }
}

