/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.editor.persistance;

import ro.sync.annotations.dt.PersistentObjectField;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.options.PersistentObject;
import ro.sync.options.f;
import ro.sync.util.Equaler;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class DocumentTypeRulePO
implements PersistentObject {
    @PersistentObjectField(hasEditorVariables=false)
    private String namespace;
    @PersistentObjectField(hasEditorVariables=false)
    private String rootElem;
    @PersistentObjectField(hasEditorVariables=false)
    private String fileName;
    @PersistentObjectField(hasEditorVariables=false)
    private String publicID;
    @PersistentObjectField(hasEditorVariables=false)
    private String javaRuleClass;
    private static final String OLD_ANY = "<ANY>";
    private static final String OLD_ANY_VALUE = "ANY_VALUE";
    public static final String ANY = "*";
    @PersistentObjectField(hasEditorVariables=false)
    private String attributeLocalName = "*";
    @PersistentObjectField(hasEditorVariables=false)
    private String attributeNamespace = "*";
    @PersistentObjectField(hasEditorVariables=false)
    private String attributeValue = "*";

    public DocumentTypeRulePO() {
    }

    public DocumentTypeRulePO(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        this.namespace = string;
        this.rootElem = string2;
        this.fileName = string3;
        this.publicID = string4;
        this.attributeLocalName = string5;
        this.attributeNamespace = string6;
        this.attributeValue = string7;
        this.javaRuleClass = string8;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getRootElem() {
        return this.rootElem;
    }

    public String getAttributeLocalName() {
        return this.attributeLocalName;
    }

    public String getAttributeNamespace() {
        return this.attributeNamespace;
    }

    public String getAttributeValue() {
        return this.attributeValue;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof DocumentTypeRulePO) {
            DocumentTypeRulePO documentTypeRulePO = (DocumentTypeRulePO)object;
            bl = Equaler.verifyEquals(this.namespace, documentTypeRulePO.namespace) && Equaler.verifyEquals(this.rootElem, documentTypeRulePO.rootElem) && Equaler.verifyEquals(this.fileName, documentTypeRulePO.fileName) && Equaler.verifyEquals(this.publicID, documentTypeRulePO.publicID) && Equaler.verifyEquals(this.attributeLocalName, documentTypeRulePO.attributeLocalName) && Equaler.verifyEquals(this.attributeNamespace, documentTypeRulePO.attributeNamespace) && Equaler.verifyEquals(this.attributeValue, documentTypeRulePO.attributeValue) && Equaler.verifyEquals(this.javaRuleClass, documentTypeRulePO.javaRuleClass);
        }
        return bl;
    }

    public int hashCode() {
        int n2 = this.namespace.hashCode() + this.rootElem.hashCode() + this.fileName.hashCode();
        if (this.publicID != null) {
            n2 += this.publicID.hashCode();
        }
        if (this.attributeLocalName != null) {
            n2 += this.attributeLocalName.hashCode();
        }
        if (this.attributeNamespace != null) {
            n2 += this.attributeNamespace.hashCode();
        }
        if (this.attributeValue != null) {
            n2 += this.attributeValue.hashCode();
        }
        if (this.javaRuleClass != null) {
            n2 += this.javaRuleClass.hashCode();
        }
        return n2;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            return null;
        }
    }

    public String toString() {
        return "Namespace : " + this.namespace + " Root : " + this.rootElem + " fileName : " + this.fileName + " publicID: " + this.publicID + " attributeLocalName: " + this.attributeLocalName + " attributeNamespace: " + this.attributeNamespace + " attributeValue: " + this.attributeValue + " javaRuleClass: " + this.javaRuleClass;
    }

    private String correctAnyValue(String string) {
        if (OLD_ANY.equals(string) || OLD_ANY_VALUE.equals(string)) {
            string = ANY;
        }
        return string;
    }

    @Override
    public void checkValid() throws f {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.namespace == null) {
            stringBuffer.append(" namespace");
        } else {
            this.namespace = this.correctAnyValue(this.namespace);
        }
        if (this.rootElem == null) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("root element");
        } else {
            this.rootElem = this.correctAnyValue(this.rootElem);
        }
        if (this.fileName == null) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("file name");
        } else {
            this.fileName = this.correctAnyValue(this.fileName);
        }
        if (this.publicID == null) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("public ID");
        } else {
            this.publicID = this.correctAnyValue(this.publicID);
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.insert(0, "Invalid Schema Mapping because:");
            stringBuffer.append(" are missing.");
            throw new f(stringBuffer.toString());
        }
    }

    @Override
    public String[] getNotPersistentFieldNames() {
        return null;
    }

    public String getPublicID() {
        return this.publicID;
    }

    public String getJavaRuleClass() {
        return this.javaRuleClass;
    }
}

