/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.editor.validate;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import ro.sync.annotations.dt.PersistentObjectField;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.exml.editor.scenario.BaseScenarioImpl;
import ro.sync.exml.editor.validate.ValidationUnit;
import ro.sync.options.db;
import ro.sync.options.f;
import ro.sync.util.Equaler;
import ro.sync.util.URLUtil;
import ro.sync.util.t;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class ValidationScenario
extends BaseScenarioImpl {
    public static final String DEFAULT_MASTER_FILE_VALIDATION = "Default validation";
    public static final String DEFAULT_ENGINE_SCENARIO_NAME = "Default_engine_scenario_name_1254902349626";
    public static final String DEFAULT_ENGINE_SCENARIO_TYPE = "Default_engine_scenario_type_1254902349626";
    public static final String VALIDATION_SCENARIO = "Validation_scenario";
    private db<ValidationUnit> pairs = new db();
    @PersistentObjectField(hasEditorVariables=false)
    private String type = "Validation_scenario";
    @PersistentObjectField(hasEditorVariables=false, isIDTypeVariables=true)
    private String name;

    public ValidationScenario() {
    }

    public ValidationScenario(String string) {
        this.name = string;
        this.type = VALIDATION_SCENARIO;
    }

    @Override
    public void checkValid() throws f {
        if (this.name == null) {
            throw new f("Invalid name in scenario association");
        }
        if (this.type == null) {
            throw new f("Invalid type in scenario association");
        }
        if (!DEFAULT_ENGINE_SCENARIO_TYPE.equals(this.type) && !VALIDATION_SCENARIO.equals(this.type)) {
            this.type = VALIDATION_SCENARIO;
        }
        if (!(this.pairs != null && !this.pairs.isEmpty() || DEFAULT_ENGINE_SCENARIO_NAME.equals(this.name) && DEFAULT_ENGINE_SCENARIO_TYPE.equals(this.type))) {
            throw new f("Invalid url/engine pairs in scenario association");
        }
    }

    public List<ValidationUnit> getValidationUnits() {
        return this.pairs;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        this.name = string;
        this.id = null;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String string) {
        this.type = string;
    }

    @Override
    public void decryptURLs() {
        for (ValidationUnit validationUnit : this.pairs) {
            try {
                validationUnit.setUrl(t.h(new URL(validationUnit.getUrl())).toString());
            }
            catch (MalformedURLException malformedURLException) {}
        }
    }

    @Override
    public void prepareURLsForSerialization(boolean bl) {
        for (ValidationUnit validationUnit : this.pairs) {
            String string = validationUnit.getUrl();
            string = URLUtil.replaceBackSlash(string);
            try {
                URL uRL = new URL(string);
                string = bl ? URLUtil.clearUserInfo(uRL).toString() : t.e(uRL).toString();
            }
            catch (MalformedURLException malformedURLException) {}
        }
    }

    @Override
    public Object clone() {
        ValidationScenario validationScenario = (ValidationScenario)super.clone();
        if (validationScenario != null && this.pairs != null) {
            validationScenario.pairs = (db)this.pairs.clone();
        }
        return validationScenario;
    }

    public boolean equals(Object object) {
        if (object instanceof ValidationScenario) {
            boolean bl;
            ValidationScenario validationScenario = (ValidationScenario)object;
            boolean bl2 = bl = Equaler.verifyEquals(validationScenario.name, this.name) && Equaler.verifyEquals(validationScenario.type, this.type) && validationScenario.getStorage() == this.getStorage();
            if (bl && validationScenario.getStorage() == 3) {
                bl = Equaler.verifyEquals(this.getDocumentTypeID(), validationScenario.getDocumentTypeID());
            }
            return bl;
        }
        return false;
    }

    public int hashCode() {
        int n2 = 1;
        if (this.name != null) {
            n2 += this.name.hashCode();
        }
        if (this.type != null) {
            n2 += this.type.hashCode();
        }
        return n2;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String[] getNotPersistentFieldNames() {
        return null;
    }
}

