/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.editor.welcomescreen.content;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.exml.editor.welcomescreen.content.b;
import ro.sync.exml.editor.welcomescreen.content.c;
import ro.sync.util.URLUtil;
import ro.sync.util.fb;
import ro.sync.util.rc;

@XmlAccessorType(value=XmlAccessType.FIELD)
@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class VideoTutorial
implements b {
    private static final File VIDEOS_IMG_FOLDER = new File(c.j, "videos");
    public static final Comparator<VideoTutorial> VIDEO_TUTORIALS_SORTER_BY_VERSION_DESCENDING = new Comparator<VideoTutorial>(){

        public int b(VideoTutorial videoTutorial, VideoTutorial videoTutorial2) {
            int n2 = -1;
            try {
                n2 = Float.compare(rc.l(videoTutorial2.getVersion()).floatValue(), rc.l(videoTutorial.getVersion()).floatValue());
            }
            catch (fb fb2) {
                // empty catch block
            }
            return n2;
        }
    };
    @XmlElement(name="name", namespace="http://www.w3.org/1999/xhtml")
    private String videoName;
    @XmlElement(name="url", namespace="http://www.w3.org/1999/xhtml")
    private String videoURL;
    @XmlAttribute(name="products")
    private String[] availableProducts;
    @XmlAttribute(name="version")
    private String version;
    @XmlAttribute(name="img")
    private String videoImageURL;
    @XmlElement(name="description", namespace="http://www.w3.org/1999/xhtml")
    private String videoDescription;
    private URL videoLocalImageURL;

    VideoTutorial() {
    }

    public String getVideoName() {
        return this.videoName.replaceAll("\\s+", " ").trim();
    }

    public String getVideoURL() {
        return this.videoURL;
    }

    public String getVersion() {
        return this.version;
    }

    public List<c._b> getAvailableProducts() {
        ArrayList<c._b> arrayList = new ArrayList<c._b>();
        for (String string : this.availableProducts) {
            arrayList.add(c._b.b(string));
        }
        return arrayList;
    }

    public String getVideoDescription() {
        return this.videoDescription;
    }

    @Override
    public String getImageURLAsString() {
        return this.videoImageURL;
    }

    public URL getLocalVideoImageURL() {
        if (this.videoLocalImageURL == null && this.videoImageURL != null) {
            String string = URLUtil.extractFileName(this.videoImageURL);
            try {
                File file = new File(VIDEOS_IMG_FOLDER, string);
                if (file.exists()) {
                    this.videoLocalImageURL = URLUtil.correct(file);
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return this.videoLocalImageURL;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Video name: ").append(this.videoName);
        stringBuilder.append("\n url: ").append(this.videoURL);
        stringBuilder.append("\n version: ").append(this.version);
        stringBuilder.append("\n products: ").append(Arrays.asList(this.availableProducts));
        stringBuilder.append("\n img url: ").append(this.videoImageURL);
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof VideoTutorial) {
            VideoTutorial videoTutorial = (VideoTutorial)object;
            return this.videoName.equals(videoTutorial.getVideoName()) && this.videoURL.equals(videoTutorial.getVideoURL());
        }
        return false;
    }

    public int hashCode() {
        return this.videoName.hashCode() + this.videoURL.hashCode();
    }
}

