/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.editor.xmleditor.transform;

import java.util.Arrays;
import java.util.List;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.exml.editor.xmleditor.transform.Scenario;
import ro.sync.options.PersistentObject;
import ro.sync.options.db;
import ro.sync.options.f;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class ScenarioAssociation
implements PersistentObject {
    private String name;
    private String type;
    private String url;
    private db<String> scenarioIds = new db();
    private db<String> scenarioTypes = new db();

    public ScenarioAssociation() {
    }

    public ScenarioAssociation(List<String> list, List<String> list2, String string) {
        this.url = string;
        this.scenarioIds.addAll(list);
        this.scenarioTypes.addAll(list2);
    }

    @Override
    public void checkValid() throws f {
        boolean bl = false;
        if (this.name == null) {
            if (this.scenarioIds == null || this.scenarioIds.size() == 0) {
                throw new f("Invalid names in scenario association");
            }
        } else {
            if (this.scenarioIds == null) {
                this.scenarioIds = new db();
            }
            if (!this.scenarioIds.contains(this.name)) {
                this.scenarioIds.add(this.name);
                bl = true;
            }
        }
        if (this.type == null) {
            if (this.scenarioTypes == null || this.scenarioTypes.isEmpty()) {
                throw new f("Invalid type in scenario association");
            }
            List<String> list = Arrays.asList(Scenario.ALL_SCENARIO_TYPES);
            db<String> db2 = new db<String>(this.scenarioTypes.size());
            for (String string : this.scenarioTypes) {
                if (!("Validation_scenario".equals(string) || "Default_engine_scenario_type_1254902349626".equals(string) || list.contains(string))) {
                    string = "Validation_scenario";
                }
                db2.add(string);
            }
            this.scenarioTypes = db2;
        } else {
            List<String> list = Arrays.asList(Scenario.ALL_SCENARIO_TYPES);
            if (!("Validation_scenario".equals(this.type) || "Default_engine_scenario_type_1254902349626".equals(this.type) || list.contains(this.type))) {
                this.type = "Validation_scenario";
            }
            if (this.scenarioTypes == null) {
                this.scenarioTypes = new db();
            }
            if (bl) {
                this.scenarioTypes.add(this.type);
            }
        }
        if (this.url == null) {
            throw new f("Invalid url in scenario association");
        }
        if (this.scenarioIds.size() != this.scenarioTypes.size()) {
            throw new f("The scenario names list and scenario types list have a different number of entries for URL: " + this.url + " IDs count = " + this.scenarioIds.size() + " Types count = " + this.scenarioTypes.size());
        }
    }

    public List<String> getScenarioIds() {
        return this.scenarioIds;
    }

    public List<String> getScenarioTypes() {
        return this.scenarioTypes;
    }

    public String getUrl() {
        return this.url;
    }

    public String toString() {
        return "Scenario IDs = " + this.scenarioIds + " types = " + this.scenarioTypes + " url = " + this.url;
    }

    @Override
    public String[] getNotPersistentFieldNames() {
        return new String[]{"name", "type"};
    }

    @Override
    public Object clone() {
        ScenarioAssociation scenarioAssociation = null;
        try {
            scenarioAssociation = (ScenarioAssociation)super.clone();
            if (this.scenarioIds != null) {
                scenarioAssociation.scenarioIds = (db)this.scenarioIds.clone();
            }
            if (this.scenarioTypes != null) {
                scenarioAssociation.scenarioTypes = (db)this.scenarioTypes.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        return scenarioAssociation;
    }
}

