/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.editor.xmleditor.transform.ant;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import ro.sync.annotations.dt.PersistentObjectField;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.exml.editor.xmleditor.transform.Scenario;
import ro.sync.exml.editor.xmleditor.transform.ant.parameter.ANTParameter;
import ro.sync.options.db;
import ro.sync.options.f;
import ro.sync.util.Equaler;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class ANTScenario
extends Scenario {
    @PersistentObjectField(hasEditorVariables=false)
    private String additionalAntArgs;
    @PersistentObjectField(hasEditorVariables=false)
    private String buildTarget;
    @PersistentObjectField(hasEditorVariables=true)
    private String buildFilePath;
    private db<ANTParameter> ditaParams = new db();
    @PersistentObjectField(hasEditorVariables=false)
    private String jvmArgs;
    private boolean useCustomJavaHome;
    @PersistentObjectField(hasEditorVariables=false)
    private String customJavaHomeDir;
    private boolean useCustomANTHome;
    @PersistentObjectField(hasEditorVariables=false)
    private String customANTHomeDir;
    @PersistentObjectField(hasEditorVariables=true)
    private String workingDir;
    @PersistentObjectField(hasEditorVariables=false)
    protected boolean showConsoleAlways = true;

    public ANTScenario() {
    }

    public ANTScenario(String string) {
        super(string);
        this.setType("ANT");
    }

    public String getBuildTarget() {
        return this.buildTarget;
    }

    public void setBuildTarget(String string) {
        this.buildTarget = string;
    }

    public String getAdditionalAntArgs() {
        return this.additionalAntArgs;
    }

    public void setAdditionalAntArgs(String string) {
        this.additionalAntArgs = string;
    }

    public String getBuildFilePath() {
        return this.buildFilePath;
    }

    public void setBuildFilePath(String string) {
        this.buildFilePath = string;
    }

    public String getParameterValue(String string) {
        Object object;
        ANTParameter aNTParameter = null;
        if (this.ditaParams != null) {
            object = this.ditaParams.iterator();
            while (object.hasNext()) {
                ANTParameter aNTParameter2 = (ANTParameter)object.next();
                if (!aNTParameter2.getName().equals(string)) continue;
                aNTParameter = aNTParameter2;
                break;
            }
        }
        if (aNTParameter == null && (object = this.getAllPredefinedParameters()) != null) {
            for (int i2 = 0; i2 < object.size(); ++i2) {
                ANTParameter aNTParameter3 = (ANTParameter)object.get(i2);
                if (!Equaler.verifyEquals(aNTParameter3.getName(), string)) continue;
                aNTParameter = (ANTParameter)aNTParameter3.clone();
                break;
            }
        }
        return aNTParameter != null ? aNTParameter.getValue() : null;
    }

    @Override
    public void checkValid() throws f {
        int n2;
        super.checkValid();
        HashSet<String> hashSet = new HashSet<String>();
        List<ANTParameter> list = this.getAllPredefinedParameters();
        if (list != null && !list.isEmpty()) {
            for (n2 = 0; n2 < list.size(); ++n2) {
                hashSet.add(list.get(n2).getName());
            }
        }
        if (this.ditaParams != null) {
            for (n2 = 0; n2 < this.ditaParams.size(); ++n2) {
                ANTParameter aNTParameter = (ANTParameter)this.ditaParams.get(n2);
                if (!aNTParameter.isPredefined() || hashSet.contains(aNTParameter.getName())) continue;
                this.handleOldPredefinedParameter(aNTParameter);
            }
        }
    }

    protected void handleOldPredefinedParameter(ANTParameter aNTParameter) {
        aNTParameter.setPredefined(false);
    }

    @Override
    public Object clone() {
        ANTScenario aNTScenario = (ANTScenario)super.clone();
        if (this.ditaParams != null) {
            aNTScenario.ditaParams = (db)this.ditaParams.clone();
        }
        return aNTScenario;
    }

    public void setANTParams(db db2) {
        this.ditaParams.clear();
        if (db2 != null) {
            for (int i2 = 0; i2 < db2.size(); ++i2) {
                ANTParameter aNTParameter = (ANTParameter)db2.get(i2);
                if (aNTParameter.isPredefined()) {
                    if (this.hasPredefinedValue(aNTParameter)) continue;
                    aNTParameter.setDescription(null);
                    this.ditaParams.add(aNTParameter);
                    continue;
                }
                this.ditaParams.add(aNTParameter);
            }
        }
    }

    public db getANTParams() {
        List<ANTParameter> list = this.getAllPredefinedParameters();
        if (list != null) {
            ArrayList<ANTParameter> arrayList = new ArrayList<ANTParameter>();
            ArrayList<ANTParameter> arrayList2 = new ArrayList<ANTParameter>(this.ditaParams);
            for (int i2 = 0; i2 < list.size(); ++i2) {
                ANTParameter aNTParameter = (ANTParameter)list.get(i2).clone();
                for (int i3 = 0; i3 < arrayList2.size(); ++i3) {
                    ANTParameter aNTParameter2 = (ANTParameter)arrayList2.get(i3);
                    if (!Equaler.verifyEquals(aNTParameter2.getName(), aNTParameter.getName())) continue;
                    aNTParameter.setValue(aNTParameter2.getValue());
                    arrayList2.remove(i3);
                    break;
                }
                arrayList.add(aNTParameter);
            }
            arrayList.addAll(arrayList2);
            return new db(arrayList);
        }
        return this.ditaParams;
    }

    public String getJVMArgs() {
        return this.jvmArgs;
    }

    public void setJVMArgs(String string) {
        this.jvmArgs = string;
    }

    public boolean isUseCustomJavaHome() {
        return this.useCustomJavaHome;
    }

    public void setUseCustomJavaHome(boolean bl) {
        this.useCustomJavaHome = bl;
    }

    public String getCustomJavaHomeDir() {
        return this.customJavaHomeDir;
    }

    public void setCustomJavaHomeDir(String string) {
        this.customJavaHomeDir = string;
    }

    public String getCustomANTHomeDir() {
        return this.customANTHomeDir;
    }

    public void setCustomANTHomeDir(String string) {
        this.customANTHomeDir = string;
    }

    public boolean isUseCustomANTHome() {
        return this.useCustomANTHome;
    }

    public void setUseCustomANTHome(boolean bl) {
        this.useCustomANTHome = bl;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public void setWorkingDir(String string) {
        this.workingDir = string;
    }

    protected List<ANTParameter> getAllPredefinedParameters() {
        return null;
    }

    private boolean hasPredefinedValue(ANTParameter aNTParameter) {
        List<ANTParameter> list = this.getAllPredefinedParameters();
        if (list != null) {
            for (ANTParameter aNTParameter2 : list) {
                if (!Equaler.verifyEquals(aNTParameter2.getName(), aNTParameter.getName()) || !Equaler.verifyEquals(aNTParameter.getValue(), aNTParameter2.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    public db getInternalParamsListForTests() {
        return this.ditaParams;
    }

    public boolean getShowConsoleAlways() {
        return this.showConsoleAlways;
    }

    public void setShowConsoleAlways(boolean bl) {
        this.showConsoleAlways = bl;
    }
}

