/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.project.resourcecache;

import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringTokenizer;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.exml.editor.ef;
import ro.sync.exml.project.resourcecache.PathNode;
import ro.sync.exml.project.resourcecache.ProjectResource;
import ro.sync.exml.project.resourcecache.Resource;
import ro.sync.io.pb;
import ro.sync.util.URLUtil;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class ProjectResources
implements Serializable {
    public static final long serialVersionUID = 1293675984564936543L;
    private PathNode projectPathsRoot;
    private final ProjectResourcesList resources = new ProjectResourcesList();
    private String projectSysId;
    private transient HashMap<String, ArrayList<Resource>> contentTypeToResourcesMap;

    public ProjectResources() {
    }

    public ProjectResources(String string, Iterator<URL> iterator) {
        this.projectSysId = string;
        this.createProjectResources(iterator);
    }

    public PathNode getProjectPathsRoot() {
        return this.projectPathsRoot;
    }

    public ArrayList<Resource> getResources() {
        return new ArrayList<Resource>(this.resources);
    }

    public String getProjectSysID() {
        return this.projectSysId;
    }

    private void createProjectResources(Iterator<URL> iterator) {
        this.projectPathsRoot = new PathNode("", null);
        this.resources.clear();
        this.addURLResources(iterator);
    }

    public void addURLResources(Iterator<URL> iterator) {
        LinkedHashSet<PathNode> linkedHashSet = new LinkedHashSet<PathNode>();
        if (iterator == null) {
            return;
        }
        while (iterator.hasNext()) {
            this.addResourceInternal(iterator.next(), linkedHashSet);
        }
        for (PathNode pathNode : linkedHashSet) {
            pathNode.updateTimestamp();
        }
    }

    public boolean addURLResource(URL uRL) {
        LinkedHashSet<PathNode> linkedHashSet = new LinkedHashSet<PathNode>();
        boolean bl = false;
        if (uRL != null) {
            bl = this.addResourceInternal(uRL, linkedHashSet);
            for (PathNode pathNode : linkedHashSet) {
                pathNode.updateTimestamp();
            }
        }
        return bl;
    }

    boolean addResourceInternal(URL uRL, Set<PathNode> set) {
        Serializable serializable;
        String string;
        String string2;
        String string3;
        boolean bl = false;
        String string4 = this.getURLInfoString(uRL);
        PathNode pathNode = this.projectPathsRoot.getChildWithName(string4);
        if (pathNode == null) {
            pathNode = this.projectPathsRoot.createChildWithName(string4);
            bl = true;
        }
        if ((string3 = uRL.getPath()).endsWith(string2 = URLUtil.extractFileName(string3))) {
            string3 = string3.substring(0, string3.lastIndexOf(string2));
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3, "/", false);
        boolean bl2 = stringTokenizer.hasMoreTokens();
        while (bl2) {
            string = stringTokenizer.nextToken();
            PathNode pathNode2 = serializable = bl ? null : pathNode.getChildWithName(string);
            if (serializable == null) {
                serializable = pathNode.createChildWithName(string);
                bl = true;
            }
            if (bl) {
                set.add(pathNode);
            }
            pathNode = serializable;
            bl2 = stringTokenizer.hasMoreTokens();
        }
        String string5 = string = bl ? null : pathNode.getResource(string2, uRL.getRef(), uRL.getQuery());
        if (string != null) {
            ((ProjectResource)((Object)string)).increaseUsageCount();
        } else {
            serializable = new ProjectResource(string2, pathNode, uRL.getRef(), uRL.getQuery());
            pathNode.addResource((ProjectResource)serializable);
            this.resources.add((ProjectResource)serializable);
            set.add(pathNode);
        }
        return string != null;
    }

    private String getURLInfoString(URL uRL) {
        String string = uRL.toExternalForm();
        String string2 = uRL.getPath();
        String string3 = "".equals(string2) ? string : string.substring(0, string.indexOf(string2));
        return string3;
    }

    public void removeFoldersAndResources(Iterator<URL> iterator, pb pb2) {
        HashSet<Object> hashSet = new HashSet<Object>();
        while (iterator.hasNext()) {
            Object object;
            if (pb2 != null && pb2.olc()) {
                return;
            }
            URL uRL = iterator.next();
            Object object2 = uRL.getPath();
            StringTokenizer stringTokenizer = new StringTokenizer((String)object2, "/", false);
            ProjectResource projectResource = null;
            PathNode pathNode = this.projectPathsRoot;
            pathNode = pathNode.getChildWithName(this.getURLInfoString(uRL));
            boolean bl = stringTokenizer.hasMoreTokens();
            String string = uRL.getQuery();
            String string2 = uRL.getRef();
            while (pathNode != null && bl) {
                if (pb2 != null && pb2.olc()) {
                    return;
                }
                object = stringTokenizer.nextToken();
                bl = stringTokenizer.hasMoreTokens();
                PathNode pathNode2 = pathNode.getChildWithName((String)object);
                if (pathNode2 == null && !bl) {
                    projectResource = pathNode.getResource((String)object, string2, string);
                    pathNode = null;
                    break;
                }
                pathNode = pathNode2;
            }
            if (bl) continue;
            object = null;
            if (projectResource != null) {
                object = this.removeResource(projectResource, true, false);
            } else if (pathNode != null) {
                object = this.removeFolder(pathNode, true, false, pb2);
            }
            if (object == null) continue;
            hashSet.add(object);
        }
        for (Object object2 : hashSet) {
            ((PathNode)object2).updateTimestamp();
        }
    }

    final PathNode removeResource(ProjectResource projectResource, boolean bl, boolean bl2) {
        PathNode pathNode = null;
        if (bl2 || projectResource.getUsageCount() <= 1) {
            this.resources.remove(projectResource);
            PathNode pathNode2 = projectResource.getParent();
            pathNode2.removeResource(projectResource);
            if (bl) {
                this.removeEmptyParents(pathNode2);
            }
            if (!pathNode2.isEmpty()) {
                pathNode = pathNode2;
            }
        } else {
            projectResource.decreaseUsageCount();
        }
        return pathNode;
    }

    final PathNode removeFolder(PathNode pathNode, boolean bl, boolean bl2, pb pb2) {
        this.removeFolderRecursively(pathNode, bl2, pb2);
        PathNode pathNode2 = pathNode.getParent();
        if (bl) {
            pathNode2 = this.removeEmptyParents(pathNode);
        }
        PathNode pathNode3 = null;
        if (pathNode2 != null && pathNode.isEmpty()) {
            pathNode3 = pathNode2;
        }
        return pathNode3;
    }

    private void removeFolderRecursively(PathNode pathNode, boolean bl, pb pb2) {
        Object object;
        if (pb2 != null && pb2.olc()) {
            return;
        }
        Iterator<ProjectResource> iterator = pathNode.getChildrenResources();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (bl || ((ProjectResource)object).getUsageCount() <= 1) {
                iterator.remove();
                this.resources.remove(object);
                continue;
            }
            ((ProjectResource)object).decreaseUsageCount();
        }
        object = pathNode.getChildren();
        while (object.hasNext()) {
            PathNode pathNode2 = (PathNode)object.next();
            this.removeFolderRecursively(pathNode2, bl, pb2);
            if (!pathNode2.isEmpty()) continue;
            object.remove();
        }
    }

    private PathNode removeEmptyParents(PathNode pathNode) {
        while (pathNode != null && pathNode.isEmpty()) {
            PathNode pathNode2 = pathNode.getParent();
            if (pathNode2 != null) {
                pathNode2.removeChildNode(pathNode);
            }
            pathNode = pathNode2;
        }
        return pathNode;
    }

    public ArrayList<Resource> getResources(String string, pb pb2) {
        ArrayList<Resource> arrayList = new ArrayList<Resource>();
        if (this.contentTypeToResourcesMap == null) {
            this.contentTypeToResourcesMap = new HashMap();
        }
        if (this.contentTypeToResourcesMap.get(string) == null) {
            ArrayList<Resource> arrayList2 = new ArrayList<Resource>();
            Iterator iterator = this.resources.iterator();
            while (iterator.hasNext() && !pb2.olc()) {
                String string2;
                Resource resource = (Resource)iterator.next();
                String string3 = URLUtil.getExtension(resource.getName());
                if (string3 == null || (string2 = ef.v(string3)) == null || !string2.equals(string)) continue;
                arrayList2.add(resource);
                arrayList.add(resource);
            }
            if (!pb2.olc()) {
                this.contentTypeToResourcesMap.put(string, arrayList2);
            } else {
                arrayList.clear();
            }
        } else {
            arrayList = new ArrayList(this.contentTypeToResourcesMap.get(string));
        }
        return arrayList;
    }

    public String toString() {
        return "Project: " + this.projectSysId + " Resources: " + this.resources.size();
    }

    public PathNode getPathNode(URL uRL) {
        String string = uRL.getPath();
        PathNode pathNode = this.projectPathsRoot;
        if ((pathNode = pathNode.getChildWithName(this.getURLInfoString(uRL))) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/", false);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                PathNode pathNode2 = pathNode.getChildWithName(string2);
                if (pathNode2 == null) {
                    pathNode = null;
                    break;
                }
                pathNode = pathNode2;
            }
        }
        return pathNode;
    }

    public ProjectResource getResourceNode(URL uRL) {
        String string = uRL.getPath();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/", false);
        ProjectResource projectResource = null;
        PathNode pathNode = this.projectPathsRoot;
        pathNode = pathNode.getChildWithName(this.getURLInfoString(uRL));
        boolean bl = stringTokenizer.hasMoreTokens();
        String string2 = uRL.getQuery();
        String string3 = uRL.getRef();
        while (pathNode != null && bl) {
            String string4 = stringTokenizer.nextToken();
            bl = stringTokenizer.hasMoreTokens();
            PathNode pathNode2 = pathNode.getChildWithName(string4);
            if (pathNode2 == null) {
                if (bl) break;
                projectResource = pathNode.getResource(string4, string3, string2);
                break;
            }
            pathNode = pathNode2;
        }
        return projectResource;
    }

    @SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
    private static class ProjectResourcesList
    extends ArrayList<ProjectResource> {
        private ProjectResourcesList() {
        }

        @Override
        public synchronized boolean add(ProjectResource projectResource) {
            projectResource.setIndex(this.size());
            return super.add(projectResource);
        }

        @Override
        public void add(int n2, ProjectResource projectResource) {
            throw new UnsupportedOperationException("Use add(ProjectResource) instead");
        }

        @Override
        public boolean addAll(Collection<? extends ProjectResource> collection) {
            throw new UnsupportedOperationException("Use add(ProjectResource) instead");
        }

        @Override
        public boolean addAll(int n2, Collection<? extends ProjectResource> collection) {
            throw new UnsupportedOperationException("Use add(ProjectResource) instead");
        }

        @Override
        public ProjectResource set(int n2, ProjectResource projectResource) {
            throw new UnsupportedOperationException("operation not allowed.");
        }

        @Override
        public synchronized ProjectResource remove(int n2) {
            ProjectResource projectResource = (ProjectResource)super.remove(n2);
            if (projectResource != null) {
                for (int i2 = n2; i2 < this.size(); ++i2) {
                    ((ProjectResource)this.get(i2)).setIndex(i2);
                }
            }
            return projectResource;
        }

        @Override
        public synchronized boolean remove(Object object) {
            if (object instanceof ProjectResource) {
                ProjectResource projectResource = (ProjectResource)object;
                int n2 = projectResource.getIndex();
                if (n2 >= 0 && n2 < this.size()) {
                    return this.remove(n2) != null;
                }
                throw new UnsupportedOperationException("Project resource not synchronized: index = " + n2 + " [0, " + this.size() + ")");
            }
            throw new UnsupportedOperationException("Operation allowed only on ProjectResource");
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            throw new UnsupportedOperationException("operation not allowed.");
        }

        @Override
        public int indexOf(Object object) {
            ProjectResource projectResource;
            int n2;
            if (object instanceof ProjectResource && (n2 = (projectResource = (ProjectResource)object).getIndex()) >= 0 && n2 < this.size()) {
                return n2;
            }
            return -1;
        }
    }
}

