/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.view.graphics;

import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.exml.view.graphics.Rectangle;
import ro.sync.exml.view.graphics.Shape;

@API(type=APIType.EXTENDABLE, src=SourceType.PRIVATE)
@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class Polygon
implements Shape {
    public int npoints;
    public int[] xpoints;
    public int[] ypoints;

    public Polygon() {
        this.xpoints = new int[4];
        this.ypoints = new int[4];
    }

    public Polygon(int[] nArray, int[] nArray2, int n2) {
        if (n2 > nArray.length || n2 > nArray2.length) {
            throw new IndexOutOfBoundsException("npoints > xpoints.length || npoints > ypoints.length");
        }
        this.npoints = n2;
        this.xpoints = new int[n2];
        this.ypoints = new int[n2];
        System.arraycopy(nArray, 0, this.xpoints, 0, n2);
        System.arraycopy(nArray2, 0, this.ypoints, 0, n2);
    }

    public void addPoint(int n2, int n3) {
        if (this.npoints == this.xpoints.length) {
            int[] nArray = new int[this.npoints * 2];
            System.arraycopy(this.xpoints, 0, nArray, 0, this.npoints);
            this.xpoints = nArray;
            nArray = new int[this.npoints * 2];
            System.arraycopy(this.ypoints, 0, nArray, 0, this.npoints);
            this.ypoints = nArray;
        }
        this.xpoints[this.npoints] = n2;
        this.ypoints[this.npoints] = n3;
        ++this.npoints;
    }

    @Override
    public Rectangle getBounds() {
        if (this.npoints == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        return this.calculateBounds(this.xpoints, this.ypoints, this.npoints);
    }

    @Override
    public Shape translate(int n2, int n3) {
        int[] nArray = new int[this.xpoints.length];
        int[] nArray2 = new int[this.ypoints.length];
        for (int i2 = 0; i2 < this.npoints; ++i2) {
            nArray[i2] = this.xpoints[i2] + n2;
            nArray2[i2] = this.ypoints[i2] + n3;
        }
        return new Polygon(nArray, nArray2, this.npoints);
    }

    private Rectangle calculateBounds(int[] nArray, int[] nArray2, int n2) {
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MAX_VALUE;
        int n5 = Integer.MIN_VALUE;
        int n6 = Integer.MIN_VALUE;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n7 = nArray[i2];
            n3 = Math.min(n3, n7);
            n5 = Math.max(n5, n7);
            int n8 = nArray2[i2];
            n4 = Math.min(n4, n8);
            n6 = Math.max(n6, n8);
        }
        return new Rectangle(n3, n4, n5 - n3, n6 - n4);
    }
}

