/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.workspace.api.standalone.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.exml.ic;
import ro.sync.exml.r;
import ro.sync.ui.wb;
import ro.sync.util.PlatformDetector;

@API(type=APIType.EXTENDABLE, src=SourceType.PUBLIC)
public class OKCancelDialog
extends JDialog {
    public static final int RESULT_CANCEL = 0;
    public static final int RESULT_OK = 1;
    private int result = 0;
    private JButton okButton = new JButton();
    private JButton cancelButton = new JButton();
    private JPanel contentPanel = new JPanel(new BorderLayout());
    private Dimension buttonsSize = new Dimension(PlatformDetector.isMacOS() ? 80 : 75, PlatformDetector.isMacOS() ? 26 : 23);
    protected static final ic messages = r.e();

    public OKCancelDialog(JFrame jFrame, String string, boolean bl) {
        this((Frame)jFrame, string, bl);
    }

    public OKCancelDialog(Frame frame, String string, boolean bl) {
        super(frame, string, bl);
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OKCancelDialog.this.enterKeyPressed();
            }
        }, KeyStroke.getKeyStroke(10, 0), 2);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\n') {
                    OKCancelDialog.this.enterKeyPressed();
                }
            }
        });
        this.okButton.setName("Ok button");
        this.setOkButtonText(messages.b("Ok"));
        this.getRootPane().setDefaultButton(this.okButton);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (OKCancelDialog.this.cancelButton.isEnabled()) {
                    OKCancelDialog.this.doCancel();
                }
            }
        };
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), abstractAction);
        this.getRootPane().getActionMap().put(abstractAction, abstractAction);
        int n2 = PlatformDetector.isMacOS() ? 24 : 11;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(n2, n2, n2, n2));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 2;
        jPanel.add((Component)this.contentPanel, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OKCancelDialog.this.doOK();
            }
        });
        this.setCancelButtonText(messages.b("Cancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OKCancelDialog.this.doCancel();
            }
        });
        jPanel2.add(Box.createHorizontalGlue());
        if (PlatformDetector.isMacOS()) {
            jPanel2.add(this.cancelButton);
            jPanel2.add(Box.createHorizontalStrut(12));
            jPanel2.add(this.okButton);
        } else {
            jPanel2.add(this.okButton);
            jPanel2.add(Box.createHorizontalStrut(7));
            jPanel2.add(this.cancelButton);
        }
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        this.setContentPane(jPanel);
        this.pack();
        this.setResizable(false);
    }

    protected void doOK() {
        this.result = 1;
        this.setVisible(false);
    }

    protected void enterKeyPressed() {
        if (this.okButton.isEnabled() && this.okButton.isVisible() && this.okButton.getParent() != null) {
            this.doOK();
        }
    }

    protected void doCancel() {
        this.result = 0;
        this.setVisible(false);
    }

    public int getResult() {
        return this.result;
    }

    public void setOkButtonText(String string) {
        this.setButtonText(this.okButton, string);
    }

    public void setCancelButtonText(String string) {
        this.setButtonText(this.cancelButton, string);
    }

    @Override
    public Container getContentPane() {
        return this.contentPanel;
    }

    private void setButtonText(JButton jButton, String string) {
        if (string != null && string.length() > 0) {
            int n2 = jButton.getFontMetrics(jButton.getFont()).stringWidth(string);
            int n3 = jButton.getFontMetrics(jButton.getFont()).getHeight();
            int n4 = this.buttonsSize.width - jButton.getMargin().left - jButton.getMargin().right;
            int n5 = this.buttonsSize.height - jButton.getMargin().top - jButton.getMargin().bottom;
            if (PlatformDetector.isMacOS()) {
                n4 -= 15;
                n5 -= 4;
            }
            if (n2 <= n4 - 4 && n3 <= n5) {
                jButton.setPreferredSize(this.buttonsSize);
            } else {
                jButton.setPreferredSize(null);
            }
            jButton.setText(string);
        }
    }

    public JButton getOkButton() {
        return this.okButton;
    }

    public JButton getCancelButton() {
        return this.cancelButton;
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            wb.cb(this);
        }
        super.setVisible(bl);
    }

    public static void main(String[] stringArray) throws Exception {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        OKCancelDialog oKCancelDialog = new OKCancelDialog(null, "Titlu", false);
        oKCancelDialog.setSize(400, 150);
        JLabel jLabel = new JLabel("Ok Cancel Dialog");
        oKCancelDialog.getContentPane().add((Component)jLabel, "Center");
        oKCancelDialog.setDefaultCloseOperation(3);
        oKCancelDialog.setVisible(true);
    }
}

