/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.fsv.sharepoint.webservice.lists;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyAttribute;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.namespace.QName;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.fsv.sharepoint.webservice.lists.ListField;
import ro.sync.fsv.sharepoint.webservice.lists.ListProperty;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="List", namespace="http://schemas.microsoft.com/sharepoint/soap/")
@SkipObfuscate(fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE, classes=SkipLevel.PRIVATE)
public class ListInfo {
    @XmlAttribute(name="Title", namespace="")
    private final String title;
    @XmlAttribute(name="ID", namespace="")
    private final String id;
    @XmlAttribute(name="Description", namespace="")
    private final String description;
    @XmlAttribute(name="RootFolder", namespace="")
    private final String rootFolder;
    @XmlAnyAttribute
    private final Map<QName, String> properties = new HashMap<QName, String>();
    @XmlElementWrapper(name="Fields", namespace="http://schemas.microsoft.com/sharepoint/soap/")
    @XmlElement(name="Field", namespace="http://schemas.microsoft.com/sharepoint/soap/")
    private List<ListField> fields = new ArrayList<ListField>();
    private boolean hasFieldsInfo;

    public ListInfo() {
        this.title = null;
        this.id = null;
        this.description = null;
        this.rootFolder = null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ListInfo [title=");
        stringBuilder.append(this.title);
        stringBuilder.append(", id=");
        stringBuilder.append(this.id);
        stringBuilder.append(", description=");
        stringBuilder.append(this.description);
        stringBuilder.append(",\nproperties=[\n");
        Set<QName> set = this.properties.keySet();
        for (QName object : set) {
            stringBuilder.append("      - " + object.getLocalPart() + " = " + this.properties.get(object));
            stringBuilder.append("\n");
        }
        stringBuilder.append("],\nfields=[\n");
        for (ListField listField : this.fields) {
            stringBuilder.append("   ").append(listField).append("\n");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public String getProperty(ListProperty listProperty) {
        return this.properties.get(listProperty.qname);
    }

    public boolean hasFieldsInfo() {
        return this.hasFieldsInfo;
    }

    public void setHasFieldsInfo(boolean bl) {
        this.hasFieldsInfo = bl;
    }

    public void setFields(List<ListField> list) {
        this.fields = list;
        this.hasFieldsInfo = true;
    }

    public List<ListField> getFields() {
        return this.fields;
    }

    public boolean isHidden() {
        return Boolean.valueOf(this.getProperty(ListProperty.HIDDEN));
    }

    public String getTitle() {
        return this.title;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public String getRootFolder() {
        return this.rootFolder;
    }

    public Map<QName, String> getProperties() {
        return this.properties;
    }

    public int hashCode() {
        int n2 = 1;
        n2 = 31 * n2 + (this.id == null ? 0 : this.id.hashCode());
        n2 = 31 * n2 + (this.rootFolder == null ? 0 : this.rootFolder.hashCode());
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ListInfo listInfo = (ListInfo)object;
        if (this.id == null ? listInfo.id != null : !this.id.equals(listInfo.id)) {
            return false;
        }
        return !(this.rootFolder == null ? listInfo.rootFolder != null : !this.rootFolder.equals(listInfo.rootFolder));
    }
}

