/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.licensemanager.server;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.exml.k.k;
import ro.sync.exml.n;
import ro.sync.io.b.b;
import ro.sync.licensemanager.d;
import ro.sync.licensemanager.j;
import ro.sync.licensemanager.s;
import ro.sync.ui.application.hb;
import ro.sync.util.BasicEqualer;
import ro.sync.util.fb;
import ro.sync.util.pc;
import ro.sync.util.rc;

@SkipObfuscate(classes=SkipLevel.NOT_SPECIFIED, fields=SkipLevel.NOT_SPECIFIED, methods=SkipLevel.PUBLIC)
public class LicenseServer
implements s {
    private static Logger mb = Logger.getLogger((String)LicenseServer.class.getName());
    public static final int hb = 12346;
    private static final String ib = "license";
    private ServerSocket lb = null;
    private List<_b> fb = new ArrayList<_b>();
    private int kb = 0;
    private int gb = 0;
    private String nb = null;
    private static String eb = n.c().getVersion();
    private boolean jb = false;

    public LicenseServer(int n2, File file) throws IOException {
        this.lb = new ServerSocket(n2);
        this.nb = this.x(file);
        if (this.nb == null) {
            mb.fatal((Object)("No license or empty file was found in: " + file.getAbsolutePath()));
            this.kb = 1;
            return;
        }
        new _d().start();
        new _c().start();
    }

    private void ab() {
        mb.info((Object)"Starting the server loop.");
        this.u();
        while (!this.jb) {
            try {
                final Socket socket = this.lb.accept();
                mb.info((Object)("Client connected from: " + socket.getInetAddress()));
                hb hb2 = new hb("License Server Socket Processor"){

                    @Override
                    protected void plc() {
                        try {
                            LicenseServer.this.z(socket);
                        }
                        catch (IOException iOException) {
                            mb.fatal((Object)iOException, (Throwable)iOException);
                        }
                    }
                };
                hb2.setDaemon(true);
                ((Thread)hb2).start();
            }
            catch (IOException iOException) {
                mb.fatal((Object)iOException, (Throwable)iOException);
            }
        }
    }

    private synchronized void z(Socket socket) throws IOException {
        socket.setSoTimeout(20000);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new b(socket.getInputStream()), "UTF8"));
        String string = bufferedReader.readLine();
        boolean bl = false;
        if (string != null) {
            if (string.startsWith("LIC_REQUEST")) {
                mb.info((Object)"Received license request.");
                PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new ro.sync.io.b.d(socket.getOutputStream()), "UTF8"));
                StringTokenizer stringTokenizer = new StringTokenizer(string, "\t", false);
                stringTokenizer.nextToken();
                String string2 = stringTokenizer.nextToken();
                String string3 = null;
                if (stringTokenizer.hasMoreTokens()) {
                    string3 = stringTokenizer.nextToken();
                }
                _b _b2 = new _b(string2, string3, socket);
                this.fb.add(_b2);
                int n2 = this.getDeservedLicensesCount();
                if (n2 <= this.gb) {
                    StringBuffer stringBuffer = new StringBuffer("LIC_GRANTED").append('\t');
                    stringBuffer.append(this.nb.replace('\n', '\u000b'));
                    StringBuilder stringBuilder = new StringBuilder("License granted to user: ").append(string2);
                    stringBuilder.append(" connected from: ").append(socket.getInetAddress());
                    if (string3 != null && string3.trim().length() > 0) {
                        stringBuilder.append('/').append(string3);
                    }
                    mb.info((Object)stringBuilder.toString());
                    printWriter.println(stringBuffer);
                    printWriter.flush();
                    _b2.e();
                } else {
                    this.fb.remove(_b2);
                    StringBuffer stringBuffer = new StringBuffer("LIC_REJECTED").append('\t');
                    List<_b> list = this.w();
                    Iterator<_b> iterator = list.iterator();
                    while (iterator.hasNext()) {
                        _b _b3 = iterator.next();
                        stringBuffer.append(_b3.d);
                        if (!iterator.hasNext()) continue;
                        stringBuffer.append('\u000b');
                    }
                    stringBuffer.append('\t').append(this.gb);
                    mb.info((Object)("No more licenses to grant to: " + string2));
                    printWriter.println(stringBuffer.toString());
                    printWriter.flush();
                    printWriter.close();
                    bl = true;
                }
            } else if (string.startsWith("LIC_REQ")) {
                PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new ro.sync.io.b.d(socket.getOutputStream()), "UTF8"));
                StringBuffer stringBuffer = new StringBuffer("LIC_REJECT").append('\t');
                stringBuffer.append("This server accepts requests only from version 10 or higher.");
                mb.warn((Object)stringBuffer.toString());
                printWriter.println(stringBuffer.toString());
                printWriter.flush();
                printWriter.close();
                bl = true;
            }
        }
        if (bl) {
            bufferedReader.close();
            socket.close();
        }
        this.u();
    }

    private synchronized List<_b> w() {
        ArrayList<_b> arrayList = new ArrayList<_b>();
        if (!this.fb.isEmpty()) {
            Map<_b, Integer> map = this.y();
            for (_b _b2 : map.keySet()) {
                int n2 = map.get(_b2);
                n2 = (int)Math.ceil((double)n2 / 2.0);
                for (int i2 = 0; i2 < n2; ++i2) {
                    arrayList.add(_b2);
                }
            }
        }
        return arrayList;
    }

    private Map<_b, Integer> y() {
        HashMap<_b, Integer> hashMap = new HashMap<_b, Integer>();
        if (!this.fb.isEmpty()) {
            for (_b _b2 : this.fb) {
                Integer n2 = (Integer)hashMap.get(_b2);
                n2 = n2 == null ? rc.i(1) : rc.i(n2 + 1);
                hashMap.put(_b2, n2);
            }
        }
        return hashMap;
    }

    public synchronized int getDeservedLicensesCount() {
        Map<_b, Integer> map = this.y();
        int n2 = 0;
        for (int n3 : map.values()) {
            n3 = (int)Math.ceil((double)n3 / 2.0);
            n2 += n3;
        }
        return n2;
    }

    private String x(File file) {
        String string;
        block10: {
            string = null;
            mb.info((Object)"Reading the license file.");
            if (file.isDirectory()) {
                File file2 = new File(file, "license.txt");
                if (file2.exists()) {
                    mb.info((Object)("Checking file: " + file2));
                    try {
                        string = k.b(new FileInputStream(file2));
                        if (string != null && !string.trim().isEmpty()) {
                            Properties properties = new Properties();
                            properties.load(new ByteArrayInputStream(string.getBytes()));
                            j j2 = new j(properties);
                            if (j2.j().toLowerCase().indexOf("floating") != -1) {
                                this.gb = j2.i();
                            } else {
                                mb.fatal((Object)"No floating licenses found.");
                                string = null;
                            }
                            break block10;
                        }
                        mb.fatal((Object)"The license file is empty!");
                        string = null;
                    }
                    catch (IOException iOException) {
                        mb.fatal((Object)("Could not read license file: " + iOException.getMessage()), (Throwable)iOException);
                        string = null;
                    }
                    catch (d d2) {
                        mb.fatal((Object)("No valid licenses found: " + d2.getMessage()), (Throwable)d2);
                        string = null;
                    }
                } else {
                    mb.fatal((Object)("No valid licenses found: " + file));
                }
            } else {
                mb.fatal((Object)("The specified file is not a directory: " + file));
            }
        }
        return string;
    }

    public void start() {
        this.ab();
    }

    public void stop() {
        this.jb = true;
        if (this.lb != null) {
            try {
                this.lb.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private synchronized void v() {
        boolean bl = false;
        try {
            Iterator<_b> iterator = this.fb.iterator();
            while (iterator.hasNext()) {
                _b _b2 = iterator.next();
                Socket socket = _b2.c();
                if (!_b2.b() || !socket.isClosed()) continue;
                mb.info((Object)("Remove inactive user: " + _b2));
                iterator.remove();
                bl = true;
            }
        }
        catch (Throwable throwable) {
            mb.warn((Object)throwable, throwable);
        }
        if (bl) {
            this.u();
        }
    }

    private void u() {
        mb.info((Object)("License server version: " + eb));
        mb.info((Object)("Maximum licenses available on this server: " + this.gb));
        int n2 = this.getDeservedLicensesCount();
        mb.info((Object)("Licenses in use: " + n2));
        mb.info((Object)("Licenses available: " + (this.gb - n2)));
        if (!this.fb.isEmpty()) {
            mb.info((Object)"\n\n********************* Licenses in use **************************\n");
            for (_b _b2 : this.w()) {
                mb.info((Object)_b2);
            }
            mb.info((Object)"\n\n****************************************************************\n\n\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        int n2;
        String string;
        String string2;
        mb.info((Object)("License server version: " + eb));
        String string3 = ib;
        int n3 = 12346;
        if (stringArray.length > 0 && (stringArray[0].equals("-help") || stringArray[0].equals("-h"))) {
            System.out.println("USAGE: licenseServer [options]");
            System.out.println("Options:");
            System.out.println("  -help        this help message");
            System.out.println("  -licenseDir  path to the directory where the license files are located");
            System.out.println("  -port        port number used for communication with <oXygen/>");
            return;
        }
        if (!pc.f()) {
            mb.fatal((Object)"License Server requires JRE 1.6 or later.\n");
            System.err.println("License Server requires JRE 1.6 or later.\n");
            return;
        }
        if (!pc.i()) {
            mb.warn((Object)("The Java Virtual Machine used to launch License Server is not supported.\n JAVA_HOME=" + System.getProperty("java.home") + "\n" + "Problems may occur when running the application with an unsupported Java Virtual Machine.\n\n" + "Please download a Java Runtime Environment (JRE) from Sun Microsystems Inc.: \n\n" + "http://java.sun.com/"));
            System.out.println("The Java Virtual Machine used to launch License Server is not supported.\n JAVA_HOME=" + System.getProperty("java.home") + "\n" + "Problems may occur when running the application with an unsupported Java Virtual Machine.\n\n" + "Please download a Java Runtime Environment (JRE) from Sun Microsystems Inc.: \n\n" + "http://java.sun.com/\n");
        }
        if ((string2 = System.getProperty("com.oxygenxml.licenseserver.dir")) != null) {
            string3 = string2;
        }
        if ((string = System.getProperty("com.oxygenxml.licenseserver.port")) != null) {
            try {
                n3 = rc.g(string);
            }
            catch (fb fb2) {
                // empty catch block
            }
        }
        for (n2 = 0; n2 < stringArray.length - 1; n2 += 2) {
            if (stringArray[n2].equals("-licenseDir")) {
                string3 = stringArray[n2 + 1];
                continue;
            }
            if (stringArray[n2].equals("-port")) {
                try {
                    n3 = rc.g(stringArray[n2 + 1]);
                }
                catch (fb fb3) {}
                continue;
            }
            System.out.println(stringArray[n2] + ": unknown parameter. Type licenseServer -help for usage information.");
            return;
        }
        n2 = -1;
        try {
            mb.info((Object)("Starting the license server on port: " + n3 + " - dir: " + string3));
            LicenseServer licenseServer = new LicenseServer(n3, new File(string3));
            if (licenseServer.kb == 0) {
                licenseServer.start();
            }
            n2 = licenseServer.kb;
        }
        catch (IOException iOException) {
            mb.error((Object)iOException, (Throwable)iOException);
        }
        finally {
            mb.info((Object)"Exiting.");
        }
        System.exit(n2);
    }

    static {
        try {
            String string = LicenseServer.class.getResource("/ro/sync/licensemanager/server/LicenseServer.class").toString();
            string = string.replace("/ro/sync/licensemanager/server/LicenseServer.class", "/META-INF/MANIFEST.MF");
            Properties properties = new Properties();
            InputStream inputStream = new URL(string).openStream();
            properties.load(inputStream);
            inputStream.close();
            String string2 = (String)properties.get("Build-Number");
            if (string2 != null && !string2.trim().equals("")) {
                eb = eb + "." + string2;
            }
        }
        catch (Throwable throwable) {
            mb.error((Object)"Could not determine build number of license server", throwable);
        }
    }

    private static class _b {
        private String d;
        private String f;
        private Socket c = null;
        private PrintWriter g = null;
        private BufferedReader b = null;
        private boolean e = false;

        public _b(String string, String string2, Socket socket) {
            this.d = string;
            this.f = string2;
            this.c = socket;
        }

        public boolean b() {
            return this.e;
        }

        public void e() {
            this.e = true;
        }

        public boolean equals(Object object) {
            if (object instanceof _b) {
                if (this == object) {
                    return true;
                }
                _b _b2 = (_b)object;
                if (this.f == null || _b2.f == null) {
                    return false;
                }
                return BasicEqualer.verifyEquals(this.f, _b2.f) && BasicEqualer.verifyEquals(this.d, _b2.d);
            }
            return false;
        }

        public int hashCode() {
            return this.d.hashCode();
        }

        public synchronized Socket c() {
            return this.c;
        }

        public synchronized BufferedReader f() throws IOException {
            if (this.b == null) {
                this.b = new BufferedReader(new InputStreamReader((InputStream)new b(this.c.getInputStream()), "UTF8"));
            }
            return this.b;
        }

        public synchronized PrintWriter d() throws IOException {
            if (this.g == null) {
                this.g = new PrintWriter(new OutputStreamWriter((OutputStream)new ro.sync.io.b.d(this.c.getOutputStream()), "UTF8"));
            }
            return this.g;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("User: ").append(this.d);
            if (this.c != null && this.c.getInetAddress() != null) {
                stringBuilder.append(" on: ");
                stringBuilder.append(this.c.getInetAddress().getHostAddress());
            }
            if (this.f != null && this.f.trim().length() > 0) {
                stringBuilder.append(" - ").append(this.f);
            }
            return stringBuilder.toString();
        }
    }

    class _d
    extends hb {
        public _d() {
            super("Server - keep alive.");
            this.setDaemon(true);
        }

        @Override
        public void plc() {
            while (!LicenseServer.this.jb) {
                boolean bl = false;
                ArrayList arrayList = new ArrayList(LicenseServer.this.fb);
                for (_b _b2 : arrayList) {
                    try {
                        if (!_b2.b() || _b2.c().isClosed()) continue;
                        PrintWriter printWriter = _b2.d();
                        printWriter.println("Ping");
                        printWriter.flush();
                        String string = _b2.f().readLine();
                        if (string != null && string.equals("Pong")) continue;
                        _b2.c().close();
                        mb.info((Object)("Connection closed by server with - " + _b2));
                        bl = true;
                    }
                    catch (IOException iOException) {
                        mb.debug((Object)iOException, (Throwable)iOException);
                        mb.info((Object)("Connection closed by " + _b2));
                        bl = true;
                        try {
                            _b2.c().close();
                        }
                        catch (IOException iOException2) {
                            mb.error((Object)("Cannot close socket: " + iOException2.getMessage()), (Throwable)iOException2);
                        }
                    }
                }
                if (bl) {
                    LicenseServer.this.v();
                }
                try {
                    _d.sleep(700L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    class _c
    extends hb {
        public _c() {
            super("License Server Closed Socket Checker");
            this.setDaemon(true);
        }

        @Override
        protected void plc() {
            while (!LicenseServer.this.jb) {
                try {
                    LicenseServer.this.v();
                }
                catch (Exception exception) {
                    mb.debug((Object)"Could not finish remove closed sockets", (Throwable)exception);
                }
                try {
                    _c.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

