/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.print;

import java.awt.print.PageFormat;
import java.awt.print.Paper;
import org.apache.log4j.Logger;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.options.PersistentObject;
import ro.sync.options.f;
import ro.sync.util.Equaler;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class PageFormatPO
implements PersistentObject {
    private static final Logger logger = Logger.getLogger((String)PageFormatPO.class.getName());
    private int orientation;
    private double paperWidth;
    private double paperHeight;
    private double paperIAX;
    private double paperIAY;
    private double paperIAWidth;
    private double paperIAHeight;

    public PageFormatPO() {
        PageFormat pageFormat = new PageFormat();
        this.setPageFormat(pageFormat);
    }

    public PageFormatPO(PageFormat pageFormat) {
        this.setPageFormat(pageFormat);
    }

    public void setPageFormat(PageFormat pageFormat) {
        if (pageFormat == null) {
            pageFormat = new PageFormat();
        }
        this.orientation = pageFormat.getOrientation();
        Paper paper = pageFormat.getPaper();
        this.paperWidth = paper.getWidth();
        this.paperHeight = paper.getHeight();
        this.paperIAX = paper.getImageableX();
        this.paperIAY = paper.getImageableY();
        this.paperIAWidth = paper.getImageableWidth();
        this.paperIAHeight = paper.getImageableHeight();
    }

    public PageFormat getPageFormat() {
        Paper paper = new Paper();
        paper.setSize(this.paperWidth, this.paperHeight);
        paper.setImageableArea(this.paperIAX, this.paperIAY, this.paperIAWidth, this.paperIAHeight);
        PageFormat pageFormat = new PageFormat();
        pageFormat.setOrientation(this.orientation);
        pageFormat.setPaper(paper);
        return pageFormat;
    }

    @Override
    public void checkValid() throws f {
        if (this.paperHeight == 0.0 || this.paperWidth == 0.0 || this.paperIAX >= this.paperWidth || this.paperIAY >= this.paperHeight) {
            throw new f("Invalid Page Settings");
        }
    }

    @Override
    public String[] getNotPersistentFieldNames() {
        return null;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            logger.info((Object)cloneNotSupportedException, (Throwable)cloneNotSupportedException);
            return null;
        }
    }

    public boolean equals(Object object) {
        PageFormatPO pageFormatPO = (PageFormatPO)object;
        return Equaler.verifyEquals(this.getPageFormat(), pageFormatPO.getPageFormat());
    }
}

