/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.print.header;

import org.apache.log4j.Logger;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.exml.view.graphics.Color;
import ro.sync.exml.view.graphics.Font;
import ro.sync.options.PersistentObject;
import ro.sync.options.f;
import ro.sync.ui.qb;
import ro.sync.util.Equaler;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class HFBlock
implements PersistentObject {
    private static final Logger logger = Logger.getLogger((String)HFBlock.class.getName());
    private static final Font DEFAULT_HEADER_FONT = new Font("SansSerif", 0, 11);
    public static final HFBlock DEFAULT_HEADER_BLOCK = new HFBlock("", "${currentFileURL}", "", DEFAULT_HEADER_FONT, Color.COLOR_BLACK);
    public static final HFBlock DEFAULT_FOOTER_BLOCK = new HFBlock("", "${cp}", "", DEFAULT_HEADER_FONT, Color.COLOR_BLACK);
    public static final HFBlock EMPTY_BLOCK = new HFBlock("", "", "");
    private String left;
    private String middle;
    private String right;
    private String font;
    private String color;
    private boolean useHorizontalLine = true;

    public HFBlock() {
        this.left = "";
        this.middle = "";
        this.right = "";
        this.font = Font.encodeFont(DEFAULT_HEADER_FONT);
        Color color = Color.COLOR_BLACK;
        this.color = qb.b(new int[]{color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()});
    }

    public HFBlock(String string, String string2, String string3, Font font, Color color) {
        this.left = string;
        this.middle = string2;
        this.right = string3;
        this.font = Font.encodeFont(font);
        this.color = qb.b(new int[]{color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()});
    }

    public HFBlock(String string, String string2, String string3) {
        this.left = string;
        this.middle = string2;
        this.right = string3;
        this.font = Font.encodeFont(DEFAULT_HEADER_FONT);
        Color color = Color.COLOR_BLACK;
        this.color = qb.b(new int[]{color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()});
    }

    public void setLeft(String string) {
        this.left = string;
    }

    public void setMiddle(String string) {
        this.middle = string;
    }

    public void setRight(String string) {
        this.right = string;
    }

    public void setFont(Font font) {
        this.font = Font.encodeFont(font);
    }

    public void setColor(Color color) {
        this.color = qb.b(new int[]{color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()});
    }

    public String getLeft() {
        return this.left;
    }

    public String getMiddle() {
        return this.middle;
    }

    public String getRight() {
        return this.right;
    }

    public Font getFont() {
        return Font.decodeFont(this.font);
    }

    public Color getColor() {
        return Color.decodeColor(this.color);
    }

    @Override
    public void checkValid() throws f {
        if (this.getFont() == null) {
            throw new f("Invalid Font");
        }
    }

    @Override
    public String[] getNotPersistentFieldNames() {
        return null;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            logger.info((Object)cloneNotSupportedException, (Throwable)cloneNotSupportedException);
            return null;
        }
    }

    public boolean equals(Object object) {
        HFBlock hFBlock = (HFBlock)object;
        return Equaler.verifyEquals(this.getLeft(), hFBlock.getLeft()) && Equaler.verifyEquals(this.getMiddle(), hFBlock.getMiddle()) && Equaler.verifyEquals(this.getRight(), hFBlock.getRight()) && Equaler.verifyEquals(this.getFont(), hFBlock.getFont()) && Equaler.verifyEquals(this.getColor(), hFBlock.getColor());
    }

    public boolean hasContent() {
        return this.left != null && this.left.length() > 0 || this.middle != null && this.middle.length() > 0 || this.right != null && this.right.length() > 0;
    }

    public boolean isUseHorizontalLine() {
        return this.useHorizontalLine;
    }

    public void setUseHorizontalLine(boolean bl) {
        this.useHorizontalLine = bl;
    }
}

