/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.svn.trees.wc;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.wc2.SvnWcGeneration;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNTreeConflictDescription;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.exml.options.Options;
import ro.sync.svn.SVNLockInfo;
import ro.sync.svn.b;
import ro.sync.svn.f.tb;
import ro.sync.svn.p;
import ro.sync.svn.trees.wc.c;
import ro.sync.svn.trees.wc.f;
import ro.sync.svn.wc.d;
import ro.sync.svn.wc.i;
import ro.sync.util.Equaler;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class VCItemStatus
implements Cloneable,
Serializable {
    private static final Logger logger = Logger.getLogger((String)VCItemStatus.class.getName());
    private static final long serialVersionUID = 8654786888943203926L;
    private static final short WC_FORMAT_MASK = 24576;
    private static final short WC_FORMAT_RESET_MASK = 8191;
    private static final short IS_AGAINST_REPOSITORY_TRUE = 4096;
    private static final short IS_AGAINST_REPOSITORY_FALSE = 28671;
    private static final short IS_DIRECTORY_TRUE = 2048;
    private static final short IS_DIRECTORY_FALSE = 30719;
    private static final short IS_SVN_LOCKED_TRUE = 1024;
    private static final short IS_SVN_LOCKED_FALSE = 31743;
    private static final short IS_COPIED_TRUE = 64;
    private static final short IS_COPIED_FALSE = 32703;
    private static final short IS_EXTERNAL_FILE_TRUE = 32;
    private static final short IS_EXTERNAL_FILE_FALSE = 32735;
    private static final short IS_SWITCHED_TRUE = 16;
    private static final short IS_SWITCHED_FALSE = 32751;
    private static final short DEPTH_MASK = 896;
    private static final short DEPTH_RESET_MASK = 31871;
    private static final SVNDepth[] DEPTHS = new SVNDepth[]{SVNDepth.UNKNOWN, SVNDepth.EMPTY, SVNDepth.FILES, SVNDepth.IMMEDIATES, SVNDepth.INFINITY};
    private static final HashMap<SVNDepth, Short> DEPTH_TO_BITS_MAPPING = new HashMap();
    private File file;
    private short flags;
    private transient p localFileStatus;
    private transient p localPropertiesStatus;
    private transient SVNRevision revision;
    private transient SVNRevision lastChangedRevision;
    private transient Date lastChangedDate;
    private String lastChangedAuthor;
    private String copyFromURL;
    private long copyFromRevision;
    private SVNLockInfo localLockInfo;
    private long timestamp;
    private long fileSize;
    private transient _b remoteInfo;
    private ConflictInfo conflictInfo;

    private static final SVNDepth getDepth(boolean bl, p p2, SVNDepth sVNDepth) {
        if (!bl) {
            sVNDepth = SVNDepth.UNKNOWN;
        } else {
            String string = null;
            if (p2 == p.j) {
                string = "svn.wc.show.unversioned.dirs.content";
            } else if (p2 == p.b) {
                string = "svn.wc.show.ignored.dirs.content";
            }
            if (string != null) {
                sVNDepth = Options.getInstance().getBooleanProperty(string) ? SVNDepth.INFINITY : SVNDepth.EMPTY;
            } else if (sVNDepth == null || sVNDepth == SVNDepth.UNKNOWN || sVNDepth == SVNDepth.EXCLUDE) {
                sVNDepth = SVNDepth.INFINITY;
            }
        }
        return sVNDepth;
    }

    public VCItemStatus(File file, boolean bl, int n2, SVNDepth sVNDepth, p p2, p p3, p p4, p p5, SVNURL sVNURL, SVNURL sVNURL2, SVNRevision sVNRevision, SVNRevision sVNRevision2, SVNRevision sVNRevision3, Date date, Date date2, String string, String string2, boolean bl2, String string3, SVNRevision sVNRevision4, boolean bl3, boolean bl4, boolean bl5, SVNLock sVNLock, SVNLock sVNLock2, File file2, File file3, File file4, File file5, SVNTreeConflictDescription sVNTreeConflictDescription, boolean bl6, boolean bl7) {
        block11: {
            this.copyFromRevision = -1L;
            if (file == null) {
                logger.error((Object)"Building a new status without a file attached!", (Throwable)new Exception());
            }
            this.file = file;
            sVNDepth = VCItemStatus.getDepth(bl, p2, sVNDepth);
            this.setFlags(n2, bl6, bl, bl5, sVNDepth, bl2, bl3, bl4);
            this.localFileStatus = p2;
            this.localPropertiesStatus = p3;
            this.revision = sVNRevision;
            this.lastChangedRevision = sVNRevision3;
            this.lastChangedAuthor = string == null ? null : string.intern();
            this.lastChangedDate = date;
            this.localLockInfo = SVNLockInfo.getLockInfo(sVNLock, true);
            if (string3 != null) {
                try {
                    string3 = SVNURL.parseURIEncoded((String)string3).toDecodedString();
                }
                catch (SVNException sVNException) {
                    if (!logger.isDebugEnabled()) break block11;
                    logger.debug((Object)("Cannot parse copy from URL: " + string3));
                }
            }
        }
        this.copyFromURL = string3;
        this.copyFromRevision = string3 != null && sVNRevision4 != null && sVNRevision4.getNumber() > -1L ? sVNRevision4.getNumber() : -1L;
        Boolean[] booleanArray = new Boolean[]{null};
        if (p4 != null && p4 != p.s || p5 != null && p5 != p.s || sVNRevision2 != null || string2 != null || sVNURL2 != null && this.useRemoteURL(sVNURL, sVNURL2, booleanArray, p2) || sVNLock2 != null) {
            if (booleanArray[0] == null) {
                if (!this.useRemoteURL(sVNURL, sVNURL2, booleanArray, p2)) {
                    sVNURL2 = null;
                }
            } else if (booleanArray[0] == Boolean.TRUE) {
                sVNURL2 = null;
            }
            this.remoteInfo = new _b(sVNURL2, p4, p5, sVNRevision2, date2, string2, sVNLock2);
        }
        if (file2 != null || file3 != null || file4 != null || file5 != null || sVNTreeConflictDescription != null) {
            this.conflictInfo = new ConflictInfo(file2, file3, file4, file5, sVNTreeConflictDescription);
        }
        if (bl7) {
            this.updateTimestamp();
        }
    }

    private boolean useRemoteURL(SVNURL sVNURL, SVNURL sVNURL2, Boolean[] booleanArray, p p2) {
        if (p2 == null || p2 == p.s || p2 == p.j || p2 == p.b) {
            return true;
        }
        if (Equaler.verifyEquals(sVNURL, sVNURL2)) {
            booleanArray[0] = Boolean.TRUE;
            return false;
        }
        booleanArray[0] = Boolean.FALSE;
        return true;
    }

    private VCItemStatus(VCItemStatus vCItemStatus) {
        this.copyFromRevision = -1L;
        this.file = vCItemStatus.file;
        this.flags = vCItemStatus.flags;
        this.localFileStatus = vCItemStatus.localFileStatus;
        this.localPropertiesStatus = vCItemStatus.localPropertiesStatus;
        this.revision = vCItemStatus.revision;
        this.lastChangedRevision = vCItemStatus.lastChangedRevision;
        this.lastChangedDate = vCItemStatus.lastChangedDate;
        this.lastChangedAuthor = vCItemStatus.lastChangedAuthor;
        this.localLockInfo = vCItemStatus.localLockInfo;
        this.copyFromURL = vCItemStatus.copyFromURL;
        this.copyFromRevision = vCItemStatus.copyFromRevision;
        this.timestamp = vCItemStatus.timestamp;
        this.fileSize = vCItemStatus.fileSize;
        this.remoteInfo = vCItemStatus.remoteInfo;
        this.conflictInfo = vCItemStatus.conflictInfo;
    }

    public File getFile() {
        return this.file;
    }

    private void setFlags(int n2, boolean bl, boolean bl2, boolean bl3, SVNDepth sVNDepth, boolean bl4, boolean bl5, boolean bl6) {
        this.setWCGeneration(n2);
        this.flags = bl ? (short)(this.flags | 0x1000) : (short)(this.flags & 0x6FFF);
        this.flags = bl2 ? (short)(this.flags | 0x800) : (short)(this.flags & 0x77FF);
        this.flags = bl3 ? (short)(this.flags | 0x400) : (short)(this.flags & 0x7BFF);
        this.setDepth(sVNDepth);
        this.flags = bl4 ? (short)(this.flags | 0x40) : (short)(this.flags & 0x7FBF);
        this.setFileExternal(bl5);
        this.setSwitched(bl6);
    }

    public SvnWcGeneration getWCGeneration() {
        SvnWcGeneration svnWcGeneration = SvnWcGeneration.NOT_DETECTED;
        short s2 = (short)((short)(this.flags & 0x6000) >> 13);
        switch (s2) {
            case 1: {
                svnWcGeneration = SvnWcGeneration.V16;
                break;
            }
            case 2: {
                svnWcGeneration = SvnWcGeneration.V17;
                break;
            }
            default: {
                logger.warn((Object)("Unknown working copy generation (bits): " + s2));
            }
            case 0: {
                svnWcGeneration = SvnWcGeneration.NOT_DETECTED;
            }
        }
        return svnWcGeneration;
    }

    private void setWCGeneration(int n2) {
        int n3 = 0;
        SvnWcGeneration svnWcGeneration = ro.sync.svn.wc.c.h(n2);
        switch (svnWcGeneration) {
            case V16: {
                n3 = 8192;
                break;
            }
            case V17: {
                n3 = 16384;
                break;
            }
            default: {
                logger.warn((Object)("Unknown working copy generation (set): " + svnWcGeneration));
            }
            case NOT_DETECTED: 
        }
        this.flags = (short)(this.flags & 0x1FFF);
        this.flags = (short)(this.flags | n3);
    }

    public boolean isAgainstRepository() {
        return (this.flags & 0x1000) != 0;
    }

    public void setAgainstRepository(boolean bl) {
        this.flags = bl ? (short)(this.flags | 0x1000) : (short)(this.flags & 0x6FFF);
    }

    public boolean isDirectory() {
        return (this.flags & 0x800) != 0;
    }

    public boolean isSVNInternalLocked() {
        return (this.flags & 0x400) != 0;
    }

    private void setDepth(SVNDepth sVNDepth) {
        this.flags = (short)(this.flags & 0x7C7F);
        this.flags = (short)(this.flags | DEPTH_TO_BITS_MAPPING.get(sVNDepth));
    }

    public SVNDepth getDepth() {
        return DEPTHS[(short)((short)(this.flags & 0x380) >> 7)];
    }

    public void updateDepth() {
        this.setDepth(VCItemStatus.getDepth(this.isDirectory(), this.localFileStatus, this.getDepth()));
    }

    public boolean isCopied() {
        return (this.flags & 0x40) != 0;
    }

    public boolean isFileExternal() {
        return (this.flags & 0x20) != 0;
    }

    public void setFileExternal(boolean bl) {
        this.flags = bl ? (short)(this.flags | 0x20) : (short)(this.flags & 0x7FDF);
    }

    public boolean isSwitched() {
        return (this.flags & 0x10) != 0;
    }

    public void setSwitched(boolean bl) {
        this.flags = bl ? (short)(this.flags | 0x10) : (short)(this.flags & 0x7FEF);
    }

    public p getLocalFileStatus() {
        return this.localFileStatus;
    }

    public void setLocalFileStatus(p p2) {
        this.localFileStatus = p2;
        this.setDepth(VCItemStatus.getDepth(this.isDirectory(), p2, this.getDepth()));
        if (!i.c(p2)) {
            this.setWCGeneration(-1);
        }
    }

    public p getLocalPropertiesStatus() {
        return this.localPropertiesStatus;
    }

    public SVNRevision getRevision() {
        return this.revision;
    }

    public SVNRevision getLastChangedRevision() {
        return this.lastChangedRevision;
    }

    public Date getLastChangedDate() {
        return this.lastChangedDate;
    }

    public String getLastChangedAuthor() {
        return this.lastChangedAuthor;
    }

    public String getCopyFromURL() {
        return this.copyFromURL;
    }

    public long getCopyFromRevision() {
        return this.copyFromRevision;
    }

    private boolean useRemoteLockInformation(b b2) {
        return b2 == b.h || b2 == b.f;
    }

    public f getLockInformation() {
        SVNLockInfo sVNLockInfo;
        b b2;
        f f2 = null;
        f2 = this.isSVNInternalLocked() ? new f(b.i, null) : (this.isAgainstRepository() ? (this.useRemoteLockInformation(b2 = d.c(this.localLockInfo == null ? null : this.localLockInfo.getLockID(), (sVNLockInfo = this.remoteInfo == null ? null : this.remoteInfo.d) == null ? null : sVNLockInfo.getLockID())) ? new f(b2, sVNLockInfo) : new f(b2, this.localLockInfo)) : (this.localLockInfo != null ? new f(b.g, this.localLockInfo) : new f(b.j, null)));
        return f2;
    }

    public void setLocalLockInfo(SVNLockInfo sVNLockInfo) {
        this.localLockInfo = sVNLockInfo;
    }

    private void checkRemoteInfo() {
        if (this.remoteInfo == null) {
            this.remoteInfo = new _b();
        }
    }

    public SVNURL getRemoteURL() {
        return this.remoteInfo == null ? null : this.remoteInfo.c;
    }

    public void setRemoteURL(SVNURL sVNURL) {
        if (sVNURL != null) {
            this.checkRemoteInfo();
            this.remoteInfo.c = sVNURL;
        } else if (this.remoteInfo != null) {
            if (this.remoteInfo.h(false, true, true, true, true, true, true)) {
                this.remoteInfo = null;
            } else {
                this.remoteInfo.c = sVNURL;
            }
        }
    }

    public p getRemoteFileStatus() {
        return this.remoteInfo == null ? p.s : this.remoteInfo.i();
    }

    public void setRemoteFileStatus(p p2) {
        if (p2 != null && p2 != p.s) {
            this.checkRemoteInfo();
            this.remoteInfo.h = p2;
        } else if (this.remoteInfo != null) {
            if (this.remoteInfo.h(true, false, true, true, true, true, true)) {
                this.remoteInfo = null;
            } else {
                this.remoteInfo.h = p2;
            }
        }
    }

    public p getRemotePropertiesStatus() {
        return this.remoteInfo == null ? p.s : this.remoteInfo.g();
    }

    public void setRemotePropertiesStatus(p p2) {
        if (p2 != null && p2 != p.s) {
            this.checkRemoteInfo();
            this.remoteInfo.e = p2;
        } else if (this.remoteInfo != null) {
            if (this.remoteInfo.h(true, true, false, true, true, true, true)) {
                this.remoteInfo = null;
            } else {
                this.remoteInfo.e = p2;
            }
        }
    }

    public SVNRevision getRemoteRevision() {
        return this.remoteInfo == null ? null : this.remoteInfo.b;
    }

    public void setRemoteRevision(SVNRevision sVNRevision) {
        if (sVNRevision != null) {
            this.checkRemoteInfo();
            this.remoteInfo.b = sVNRevision;
        } else if (this.remoteInfo != null) {
            if (this.remoteInfo.h(true, true, true, false, true, true, true)) {
                this.remoteInfo = null;
            } else {
                this.remoteInfo.b = sVNRevision;
            }
        }
    }

    public Date getRemoteDate() {
        return this.remoteInfo == null ? null : this.remoteInfo.g;
    }

    public void setRemoteDate(Date date) {
        if (date != null) {
            this.checkRemoteInfo();
            this.remoteInfo.g = date;
        } else if (this.remoteInfo != null) {
            if (this.remoteInfo.h(true, true, true, true, false, true, true)) {
                this.remoteInfo = null;
            } else {
                this.remoteInfo.g = date;
            }
        }
    }

    public String getRemoteAuthor() {
        return this.remoteInfo == null ? null : this.remoteInfo.f;
    }

    public void setRemoteAuthor(String string) {
        if (string != null) {
            this.checkRemoteInfo();
            this.remoteInfo.f = string.intern();
        } else if (this.remoteInfo != null) {
            if (this.remoteInfo.h(true, true, true, true, true, false, true)) {
                this.remoteInfo = null;
            } else {
                this.remoteInfo.f = string;
            }
        }
    }

    public SVNLockInfo getRemoteLockInfo() {
        return this.remoteInfo == null ? null : this.remoteInfo.d;
    }

    public void setRemoteLockInfo(SVNLockInfo sVNLockInfo) {
        if (sVNLockInfo != null) {
            this.checkRemoteInfo();
            this.remoteInfo.d = sVNLockInfo;
        } else if (this.remoteInfo != null) {
            if (this.remoteInfo.h(true, true, true, true, true, true, false)) {
                this.remoteInfo = null;
            } else {
                this.remoteInfo.d = sVNLockInfo;
            }
        }
    }

    public boolean hasRemoteInformation() {
        return this.remoteInfo != null && !this.remoteInfo.h(true, true, true, true, true, true, true);
    }

    public void clearRemoteInformation() {
        this.remoteInfo = null;
        this.setAgainstRepository(false);
    }

    public File getConflictOldFile() {
        return this.conflictInfo == null ? null : this.conflictInfo.conflictOldFile;
    }

    public File getConflictWrkFile() {
        return this.conflictInfo == null ? null : this.conflictInfo.conflictWrkFile;
    }

    public File getConflictNewFile() {
        return this.conflictInfo == null ? null : this.conflictInfo.conflictNewFile;
    }

    public File getPropRejectFile() {
        return this.conflictInfo == null ? null : this.conflictInfo.propRejectFile;
    }

    public SVNTreeConflictDescription getTreeConflictDescription() {
        return this.conflictInfo == null ? null : this.conflictInfo.treeConflictDescription;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof VCItemStatus) {
            VCItemStatus vCItemStatus = (VCItemStatus)object;
            if (Equaler.verifyEquals(this.file, vCItemStatus.file) && this.flags == vCItemStatus.flags && this.localFileStatus == vCItemStatus.localFileStatus && this.localPropertiesStatus == vCItemStatus.localPropertiesStatus && Equaler.verifyEquals(this.revision, vCItemStatus.revision) && Equaler.verifyEquals(this.lastChangedRevision, vCItemStatus.lastChangedRevision) && Equaler.verifyEquals(this.lastChangedDate, vCItemStatus.lastChangedDate) && Equaler.verifyEquals(this.lastChangedAuthor, vCItemStatus.lastChangedAuthor) && Equaler.verifyEquals(this.copyFromURL, vCItemStatus.copyFromURL) && this.copyFromRevision == vCItemStatus.copyFromRevision && _b.b(this.remoteInfo, vCItemStatus.remoteInfo)) {
                bl = true;
            }
        }
        return bl;
    }

    public int hashCode() {
        int n2 = this.flags;
        if (this.revision != null) {
            n2 = (int)((long)n2 + this.revision.getNumber());
        }
        if (this.file != null) {
            n2 += this.file.hashCode();
        }
        return n2;
    }

    public Object clone() {
        return new VCItemStatus(this);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.file.getName());
        stringBuilder.append("[local:").append((Object)this.localFileStatus);
        stringBuilder.append(",").append((Object)this.localPropertiesStatus);
        stringBuilder.append(" - remote:").append((Object)this.getRemoteFileStatus());
        stringBuilder.append(",").append((Object)this.getRemotePropertiesStatus());
        stringBuilder.append(" -- ").append("isCopied: ").append(this.isCopied());
        stringBuilder.append(", isDir: ").append(this.isDirectory()).append("]");
        return stringBuilder.toString();
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getSize() {
        if (this.isDirectory() || this.localFileStatus == p.s || this.localFileStatus == p.f || this.localFileStatus == p.u || this.localFileStatus == p.g) {
            return -1L;
        }
        return this.fileSize;
    }

    public void updateTimestamp() {
        if (this.isDirectory()) {
            File file = new File(this.file, ro.sync.svn.wc.c.b(Options.getInstance()));
            if (file.isDirectory()) {
                SvnWcGeneration svnWcGeneration = this.getWCGeneration();
                switch (svnWcGeneration) {
                    case V16: {
                        this.timestamp = new File(file, "entries").lastModified();
                        File file2 = new File(file, "lock");
                        if (!file2.isFile()) break;
                        this.timestamp += file2.lastModified();
                        break;
                    }
                    case V17: {
                        this.timestamp = new File(file, "wc.db").lastModified();
                        break;
                    }
                    default: {
                        logger.warn((Object)("Unknown working copy generation (update): " + svnWcGeneration));
                    }
                    case NOT_DETECTED: 
                }
            } else {
                this.timestamp = -1L;
            }
            this.fileSize = -1L;
        } else {
            boolean bl = this.file.isFile();
            this.timestamp = bl ? this.file.lastModified() : -1L;
            this.fileSize = bl ? this.file.length() : -1L;
        }
    }

    public tb._b isModified() {
        boolean bl = false;
        boolean bl2 = false;
        if (this.isDirectory()) {
            bl2 = true;
            File file = new File(this.file, ro.sync.svn.wc.c.b(Options.getInstance()));
            if (file.isDirectory()) {
                SvnWcGeneration svnWcGeneration = this.getWCGeneration();
                switch (svnWcGeneration) {
                    case V16: {
                        long l2 = new File(file, "entries").lastModified();
                        long l3 = new File(file, "lock").lastModified();
                        bl = this.timestamp != l2 + l3;
                        break;
                    }
                    case V17: {
                        long l4 = new File(file, "wc.db").lastModified();
                        bl = this.timestamp != l4;
                        break;
                    }
                    default: {
                        logger.warn((Object)("Unknown working copy generation (check): " + svnWcGeneration));
                    }
                    case NOT_DETECTED: {
                        bl = false;
                        break;
                    }
                }
            } else {
                bl = this.timestamp != -1L;
            }
        } else {
            boolean bl3 = this.file.isFile();
            boolean bl4 = bl = this.timestamp != (bl3 ? this.file.lastModified() : -1L);
            bl = bl || this.fileSize != (bl3 ? this.file.length() : -1L);
        }
        return bl ? new tb._b(this.file, bl2) : null;
    }

    String dumpInformation() {
        StringBuilder stringBuilder = new StringBuilder("File: ").append(this.file.getAbsolutePath());
        stringBuilder.append("\ngeneration = ").append(this.getWCGeneration());
        stringBuilder.append("\nisAgainstRepository = ").append(this.isAgainstRepository());
        stringBuilder.append("\nisDir = ").append(this.isDirectory());
        stringBuilder.append("\ndepth = ").append(this.getDepth());
        stringBuilder.append("\nlocalFileStatus = ").append((Object)this.localFileStatus);
        stringBuilder.append("\nlocalPropStatus = ").append((Object)this.localPropertiesStatus);
        stringBuilder.append("\nremoteFileStatus = ").append((Object)this.getRemoteFileStatus());
        stringBuilder.append("\nremotePropStatus = ").append((Object)this.getRemotePropertiesStatus());
        SVNURL sVNURL = this.getRemoteURL();
        stringBuilder.append("\nremoteURL = ").append(sVNURL != null ? sVNURL.toString() : null);
        stringBuilder.append("\nrevision = ").append(this.revision);
        stringBuilder.append("\nremoteRevision = ").append(this.getRemoteRevision());
        stringBuilder.append("\nlastChangedRevision = ").append(this.lastChangedRevision);
        stringBuilder.append("\nlastChangedDate = ").append(this.lastChangedDate);
        stringBuilder.append("\nlastChangedAuthor = ").append(this.lastChangedAuthor);
        stringBuilder.append("\nremoteAuthor = ").append(this.getRemoteAuthor());
        stringBuilder.append("\nisCopied = ").append(this.isCopied());
        stringBuilder.append("\ncopyFromURL = ").append(this.copyFromURL);
        stringBuilder.append("\ncopyFromRevision = ").append(this.copyFromRevision);
        stringBuilder.append("\nisSwitched = ").append(this.isSwitched());
        stringBuilder.append("\nisFileExternal = ").append(this.isFileExternal());
        stringBuilder.append("\nisSVNLocked = ").append(this.isSVNInternalLocked());
        stringBuilder.append("\nlockStatus = ").append(this.getLockInformation());
        stringBuilder.append("\nconflictOld = ").append(this.getConflictOldFile());
        stringBuilder.append("\nconflictWrk = ").append(this.getConflictWrkFile());
        stringBuilder.append("\nconflictNew = ").append(this.getConflictNewFile());
        stringBuilder.append("\npropRej = ").append(this.getPropRejectFile());
        stringBuilder.append("\ntreeConflict = ");
        this.dumpTreeConflict(stringBuilder, this.getTreeConflictDescription());
        return stringBuilder.toString();
    }

    private void dumpTreeConflict(StringBuilder stringBuilder, SVNTreeConflictDescription sVNTreeConflictDescription) {
        if (sVNTreeConflictDescription != null) {
            stringBuilder.append("\n+++++ TREE CONFLICT +++++\n");
            stringBuilder.append("path:").append(sVNTreeConflictDescription.getPath());
            stringBuilder.append("\nkind:").append(sVNTreeConflictDescription.getNodeKind()).append(" ");
            stringBuilder.append("operation:").append(sVNTreeConflictDescription.getOperation()).append(" ");
            stringBuilder.append("action:").append(sVNTreeConflictDescription.getConflictAction()).append(" ");
            stringBuilder.append("reason:").append(sVNTreeConflictDescription.getConflictReason());
            stringBuilder.append("\nleft:").append(sVNTreeConflictDescription.getSourceLeftVersion());
            stringBuilder.append("\nright:").append(sVNTreeConflictDescription.getSourceRightVersion());
            stringBuilder.append("\nmergeFileSet:").append(sVNTreeConflictDescription.getMergeFiles() != null).append(" ");
            stringBuilder.append("\n----- TREE CONFLICT -----");
        } else {
            stringBuilder.append(sVNTreeConflictDescription);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = false;
        objectOutputStream.writeObject(this.file);
        this.flags = (short)(this.flags & 0x6FFF);
        objectOutputStream.writeShort(this.flags);
        objectOutputStream.writeByte(this.localFileStatus.c());
        objectOutputStream.writeByte(this.localPropertiesStatus.c());
        bl = this.revision == null;
        objectOutputStream.writeBoolean(bl);
        if (!bl) {
            c.b(objectOutputStream, this.revision);
        }
        bl = this.lastChangedRevision == null;
        objectOutputStream.writeBoolean(bl);
        if (!bl) {
            c.b(objectOutputStream, this.lastChangedRevision);
        }
        bl = this.lastChangedDate == null;
        objectOutputStream.writeBoolean(bl);
        if (!bl) {
            objectOutputStream.writeLong(this.lastChangedDate.getTime());
        }
        bl = this.lastChangedAuthor == null;
        objectOutputStream.writeBoolean(bl);
        if (!bl) {
            objectOutputStream.writeUTF(this.lastChangedAuthor);
        }
        bl = this.copyFromURL == null;
        objectOutputStream.writeBoolean(bl);
        if (!bl) {
            objectOutputStream.writeUTF(this.copyFromURL);
        }
        objectOutputStream.writeLong(this.copyFromRevision);
        bl = this.localLockInfo == null;
        objectOutputStream.writeBoolean(bl);
        if (!bl) {
            objectOutputStream.writeObject(this.localLockInfo);
        }
        objectOutputStream.writeLong(this.timestamp);
        objectOutputStream.writeLong(this.fileSize);
        bl = this.conflictInfo == null;
        objectOutputStream.writeBoolean(bl);
        if (!bl) {
            objectOutputStream.writeObject(this.conflictInfo);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (ro.sync.svn.wc.cache.b.b()) {
            throw new ro.sync.svn.wc.cache.c();
        }
        boolean bl = false;
        this.file = (File)objectInputStream.readObject();
        this.flags = objectInputStream.readShort();
        this.localFileStatus = p.b(objectInputStream.readByte());
        this.localPropertiesStatus = p.b(objectInputStream.readByte());
        bl = objectInputStream.readBoolean();
        if (!bl) {
            this.revision = c.d(objectInputStream);
        }
        if (!(bl = objectInputStream.readBoolean())) {
            this.lastChangedRevision = c.d(objectInputStream);
        }
        if (!(bl = objectInputStream.readBoolean())) {
            this.lastChangedDate = new Date(objectInputStream.readLong());
        }
        if (!(bl = objectInputStream.readBoolean())) {
            this.lastChangedAuthor = objectInputStream.readUTF().intern();
        }
        if (!(bl = objectInputStream.readBoolean())) {
            this.copyFromURL = objectInputStream.readUTF();
        }
        this.copyFromRevision = objectInputStream.readLong();
        bl = objectInputStream.readBoolean();
        if (!bl) {
            this.localLockInfo = (SVNLockInfo)objectInputStream.readObject();
        }
        this.timestamp = objectInputStream.readLong();
        this.fileSize = objectInputStream.readLong();
        bl = objectInputStream.readBoolean();
        if (!bl) {
            this.conflictInfo = (ConflictInfo)objectInputStream.readObject();
        }
    }

    static {
        for (int n2 = 0; n2 < DEPTHS.length; n2 = (int)((short)(n2 + 1))) {
            DEPTH_TO_BITS_MAPPING.put(DEPTHS[n2], (short)(n2 << 7));
        }
    }

    @SkipObfuscate(classes=SkipLevel.NOT_SPECIFIED, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
    private static class ConflictInfo
    implements Serializable {
        private static final long serialVersionUID = 5580953404108720907L;
        private File conflictOldFile;
        private File conflictWrkFile;
        private File conflictNewFile;
        private File propRejectFile;
        private transient SVNTreeConflictDescription treeConflictDescription;

        private ConflictInfo(File file, File file2, File file3, File file4, SVNTreeConflictDescription sVNTreeConflictDescription) {
            this.conflictOldFile = file;
            this.conflictWrkFile = file2;
            this.conflictNewFile = file3;
            this.propRejectFile = file4;
            this.treeConflictDescription = sVNTreeConflictDescription;
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.writeObject(this.conflictOldFile);
            objectOutputStream.writeObject(this.conflictWrkFile);
            objectOutputStream.writeObject(this.conflictNewFile);
            objectOutputStream.writeObject(this.propRejectFile);
            boolean bl = this.treeConflictDescription == null;
            objectOutputStream.writeBoolean(bl);
            if (!bl) {
                c.e(objectOutputStream, this.treeConflictDescription);
            }
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            this.conflictOldFile = (File)objectInputStream.readObject();
            this.conflictWrkFile = (File)objectInputStream.readObject();
            this.conflictNewFile = (File)objectInputStream.readObject();
            this.propRejectFile = (File)objectInputStream.readObject();
            boolean bl = objectInputStream.readBoolean();
            if (!bl) {
                this.treeConflictDescription = c.g(objectInputStream);
            }
        }
    }

    private static class _b {
        private SVNURL c;
        private p h;
        private p e;
        private SVNRevision b;
        private Date g;
        private String f;
        private SVNLockInfo d;

        private _b() {
        }

        private _b(SVNURL sVNURL, p p2, p p3, SVNRevision sVNRevision, Date date, String string, SVNLock sVNLock) {
            this.c = sVNURL;
            this.h = p2;
            this.e = p3;
            this.b = sVNRevision;
            this.g = date;
            this.f = string == null ? null : string.intern();
            this.d = SVNLockInfo.getLockInfo(sVNLock, true);
        }

        private p i() {
            return this.h != null ? this.h : p.s;
        }

        private p g() {
            return this.e != null ? this.e : p.s;
        }

        private boolean h(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7) {
            if (bl && this.c != null) {
                return false;
            }
            if (bl2 && this.h != null && this.h != p.s) {
                return false;
            }
            if (bl3 && this.e != null && this.e != p.s) {
                return false;
            }
            if (bl4 && this.b != null) {
                return false;
            }
            if (bl5 && this.g != null) {
                return false;
            }
            if (bl6 && this.f != null) {
                return false;
            }
            return !bl7 || this.d == null;
        }

        private static boolean b(_b _b2, _b _b3) {
            boolean bl = false;
            if (_b2 == _b3) {
                bl = true;
            } else if (_b2 == null && _b3 != null) {
                bl = _b3.h(true, true, true, true, true, true, true);
            } else if (_b2 != null && _b3 == null) {
                bl = _b2.h(true, true, true, true, true, true, true);
            } else {
                boolean bl2 = _b2.h == null || _b2.h == p.s;
                boolean bl3 = _b3.h == null || _b3.h == p.s;
                bl = Equaler.verifyEquals(_b2.c, _b3.c) && (_b2.h == _b3.h || bl2 == bl3) && _b2.e == _b3.e && Equaler.verifyEquals(_b2.b, _b3.b) && Equaler.verifyEquals(_b2.g, _b3.g) && Equaler.verifyEquals(_b2.f, _b3.f) && Equaler.verifyEquals(_b2.d, _b3.d);
            }
            return bl;
        }
    }
}

