/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ui.tree.state;

import java.net.URL;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.options.PersistentObject;
import ro.sync.options.db;
import ro.sync.options.f;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class TreeStateInfo
implements PersistentObject {
    private URL systemID;
    private db<Integer> currentSelectionPath;
    private db<db<Integer>> expandedPaths;

    public TreeStateInfo() {
    }

    public TreeStateInfo(URL uRL, db<Integer> db2, db<db<Integer>> db3) {
        this.systemID = uRL;
        this.currentSelectionPath = new db(db2);
        this.expandedPaths = db3;
    }

    public URL getSystemID() {
        return this.systemID;
    }

    @Override
    public void checkValid() throws f {
        if (this.systemID == null) {
            throw new f("Missing system ID in the mark location.");
        }
    }

    @Override
    public String[] getNotPersistentFieldNames() {
        return null;
    }

    @Override
    public Object clone() {
        try {
            TreeStateInfo treeStateInfo = (TreeStateInfo)super.clone();
            if (this.currentSelectionPath != null) {
                treeStateInfo.currentSelectionPath = (db)this.currentSelectionPath.clone();
            }
            if (this.expandedPaths != null) {
                treeStateInfo.expandedPaths = (db)this.expandedPaths.clone();
            }
            return treeStateInfo;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            return null;
        }
    }

    public String toString() {
        return "Opened file: " + this.systemID;
    }

    public db<Integer> getCurrentSelectionPath() {
        return this.currentSelectionPath;
    }

    public db<db<Integer>> getExpandedPaths() {
        return this.expandedPaths;
    }
}

